/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.sched;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.jpa.model.sched.IHapiScheduler;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.sched.AutowiringSpringBeanJobFactory;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public abstract class BaseHapiScheduler
implements IHapiScheduler {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseHapiScheduler.class);
    private static final AtomicInteger ourNextSchedulerId = new AtomicInteger();
    private final String myThreadNamePrefix;
    private final AutowiringSpringBeanJobFactory mySpringBeanJobFactory;
    private final SchedulerFactoryBean myFactory = new SchedulerFactoryBean();
    private final Properties myProperties = new Properties();
    private Scheduler myScheduler;
    private String myInstanceName;

    public BaseHapiScheduler(String theThreadNamePrefix, AutowiringSpringBeanJobFactory theSpringBeanJobFactory) {
        this.myThreadNamePrefix = theThreadNamePrefix;
        this.mySpringBeanJobFactory = theSpringBeanJobFactory;
    }

    void setInstanceName(String theInstanceName) {
        this.myInstanceName = theInstanceName;
    }

    int nextSchedulerId() {
        return ourNextSchedulerId.getAndIncrement();
    }

    public void init() throws SchedulerException {
        this.setProperties();
        this.myFactory.setQuartzProperties(this.myProperties);
        this.myFactory.setBeanName(this.myInstanceName);
        this.myFactory.setSchedulerName(this.myThreadNamePrefix);
        this.myFactory.setJobFactory((JobFactory)this.mySpringBeanJobFactory);
        this.massageJobFactory(this.myFactory);
        try {
            Validate.notBlank((CharSequence)this.myInstanceName, (String)"No instance name supplied", (Object[])new Object[0]);
            this.myFactory.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
        this.myScheduler = this.myFactory.getScheduler();
        this.myScheduler.standby();
    }

    protected void massageJobFactory(SchedulerFactoryBean theFactory) {
    }

    protected void setProperties() {
        this.addProperty("org.quartz.threadPool.threadCount", "4");
        this.myProperties.setProperty("org.quartz.scheduler.instanceName", this.myInstanceName + "-" + this.nextSchedulerId());
        this.addProperty("org.quartz.threadPool.threadNamePrefix", this.getThreadPrefix());
    }

    @Nonnull
    private String getThreadPrefix() {
        return this.myThreadNamePrefix + "-" + this.myInstanceName;
    }

    protected void addProperty(String key, String value) {
        this.myProperties.put(key, value);
    }

    public void start() {
        if (this.myScheduler == null) {
            throw new ConfigurationException("Attempt to start uninitialized scheduler");
        }
        try {
            ourLog.info("Starting scheduler {}", (Object)this.getThreadPrefix());
            this.myScheduler.start();
        }
        catch (SchedulerException e) {
            ourLog.error("Failed to start up scheduler", (Throwable)e);
            throw new ConfigurationException("Failed to start up scheduler", (Throwable)e);
        }
    }

    public void shutdown() {
        if (this.myScheduler == null) {
            return;
        }
        try {
            this.myScheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            ourLog.error("Failed to shut down scheduler", (Throwable)e);
            throw new ConfigurationException("Failed to shut down scheduler", (Throwable)e);
        }
    }

    public boolean isStarted() {
        try {
            return this.myScheduler != null && this.myScheduler.isStarted();
        }
        catch (SchedulerException e) {
            ourLog.error("Failed to determine scheduler status", (Throwable)e);
            return false;
        }
    }

    public void clear() throws SchedulerException {
        this.myScheduler.clear();
    }

    public void logStatusForUnitTest() {
        try {
            Set keys = this.myScheduler.getJobKeys(GroupMatcher.anyGroup());
            String keysString = keys.stream().map(t -> t.getName()).collect(Collectors.joining(", "));
            ourLog.info("Local scheduler has jobs: {}", (Object)keysString);
        }
        catch (SchedulerException e) {
            ourLog.error("Failed to get log status for scheduler", (Throwable)e);
            throw new InternalErrorException("Failed to get log status for scheduler", (Throwable)e);
        }
    }

    public void scheduleJob(long theIntervalMillis, ScheduledJobDefinition theJobDefinition) {
        Validate.isTrue((theIntervalMillis >= 100L ? 1 : 0) != 0);
        Validate.notNull((Object)theJobDefinition);
        Validate.notNull((Object)theJobDefinition.getJobClass());
        Validate.notBlank((CharSequence)theJobDefinition.getId());
        JobKey jobKey = new JobKey(theJobDefinition.getId(), theJobDefinition.getGroup());
        TriggerKey triggerKey = new TriggerKey(theJobDefinition.getId(), theJobDefinition.getGroup());
        NonConcurrentJobDetailImpl jobDetail = new NonConcurrentJobDetailImpl();
        jobDetail.setJobClass(theJobDefinition.getJobClass());
        jobDetail.setKey(jobKey);
        jobDetail.setJobDataMap(new JobDataMap(theJobDefinition.getJobData()));
        SimpleScheduleBuilder schedule = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(theIntervalMillis).repeatForever();
        Trigger trigger = TriggerBuilder.newTrigger().forJob((JobDetail)jobDetail).withIdentity(triggerKey).startNow().withSchedule((ScheduleBuilder)schedule).build();
        HashSet triggers = Sets.newHashSet((Object[])new Trigger[]{trigger});
        try {
            this.myScheduler.scheduleJob((JobDetail)jobDetail, (Set)triggers, true);
        }
        catch (SchedulerException e) {
            ourLog.error("Failed to schedule job", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    @VisibleForTesting
    public Set<JobKey> getJobKeysForUnitTest() throws SchedulerException {
        return this.myScheduler.getJobKeys(GroupMatcher.anyGroup());
    }

    private static class NonConcurrentJobDetailImpl
    extends JobDetailImpl {
        private static final long serialVersionUID = 5716197221121989740L;

        private NonConcurrentJobDetailImpl() {
        }

        public boolean isConcurrentExectionDisallowed() {
            return true;
        }
    }
}

