/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.StopFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilterFactory;
import org.apache.lucene.analysis.ngram.EdgeNGramFilterFactory;
import org.apache.lucene.analysis.ngram.NGramFilterFactory;
import org.apache.lucene.analysis.pattern.PatternTokenizerFactory;
import org.apache.lucene.analysis.phonetic.PhoneticFilterFactory;
import org.apache.lucene.analysis.snowball.SnowballPorterFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.hibernate.search.backend.lucene.analysis.LuceneAnalysisConfigurationContext;
import org.hibernate.search.backend.lucene.analysis.LuceneAnalysisConfigurer;
import org.springframework.stereotype.Component;

@Component
public class HapiLuceneAnalysisConfigurer
implements LuceneAnalysisConfigurer {
    public void configure(LuceneAnalysisConfigurationContext theLuceneCtx) {
        theLuceneCtx.analyzer("autocompleteEdgeAnalyzer").custom().tokenizer(PatternTokenizerFactory.class).param("pattern", "(.*)").param("group", "1").tokenFilter(LowerCaseFilterFactory.class).tokenFilter(StopFilterFactory.class).tokenFilter(EdgeNGramFilterFactory.class).param("minGramSize", "3").param("maxGramSize", "50");
        theLuceneCtx.analyzer("autocompletePhoneticAnalyzer").custom().tokenizer(StandardTokenizerFactory.class).tokenFilter(StopFilterFactory.class).tokenFilter(PhoneticFilterFactory.class).param("encoder", "DoubleMetaphone").tokenFilter(SnowballPorterFilterFactory.class).param("language", "English");
        theLuceneCtx.analyzer("autocompleteNGramAnalyzer").custom().tokenizer(StandardTokenizerFactory.class).tokenFilter(WordDelimiterFilterFactory.class).tokenFilter(LowerCaseFilterFactory.class).tokenFilter(NGramFilterFactory.class).param("minGramSize", "3").param("maxGramSize", "20");
        theLuceneCtx.analyzer("autocompleteWordEdgeAnalyzer").custom().tokenizer(StandardTokenizerFactory.class).tokenFilter(LowerCaseFilterFactory.class).tokenFilter(StopFilterFactory.class).tokenFilter(EdgeNGramFilterFactory.class).param("minGramSize", "3").param("maxGramSize", "20");
        theLuceneCtx.analyzer("standardAnalyzer").custom().tokenizer(StandardTokenizerFactory.class).tokenFilter(LowerCaseFilterFactory.class);
        theLuceneCtx.analyzer("exactAnalyzer").custom().tokenizer(KeywordTokenizerFactory.class);
        theLuceneCtx.analyzer("conceptParentPidsAnalyzer").custom().tokenizer(WhitespaceTokenizerFactory.class);
        theLuceneCtx.analyzer("termConceptPropertyAnalyzer").custom().tokenizer(WhitespaceTokenizerFactory.class);
    }
}

