/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.ISearchCoordinatorSvc;
import ca.uhn.fhir.jpa.dao.HistoryBuilder;
import ca.uhn.fhir.jpa.dao.HistoryBuilderFactory;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.entity.Search;
import ca.uhn.fhir.jpa.entity.SearchTypeEnum;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.partition.RequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.search.SearchCoordinatorSvcImpl;
import ca.uhn.fhir.jpa.search.cache.ISearchCacheSvc;
import ca.uhn.fhir.jpa.search.cache.SearchCacheStatusEnum;
import ca.uhn.fhir.jpa.util.InterceptorUtil;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class PersistedJpaBundleProvider
implements IBundleProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(PersistedJpaBundleProvider.class);
    private final RequestDetails myRequest;
    @Autowired
    protected PlatformTransactionManager myTxManager;
    @PersistenceContext
    private EntityManager myEntityManager;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private SearchBuilderFactory mySearchBuilderFactory;
    @Autowired
    private HistoryBuilderFactory myHistoryBuilderFactory;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private ISearchCoordinatorSvc mySearchCoordinatorSvc;
    @Autowired
    private ISearchCacheSvc mySearchCacheSvc;
    @Autowired
    private RequestPartitionHelperSvc myRequestPartitionHelperSvc;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private MemoryCacheService myMemoryCacheService;
    private Search mySearchEntity;
    private String myUuid;
    private SearchCacheStatusEnum myCacheStatus;
    private RequestPartitionId myRequestPartitionId;

    public PersistedJpaBundleProvider(RequestDetails theRequest, String theSearchUuid) {
        this.myRequest = theRequest;
        this.myUuid = theSearchUuid;
    }

    public PersistedJpaBundleProvider(RequestDetails theRequest, Search theSearch) {
        this.myRequest = theRequest;
        this.mySearchEntity = theSearch;
    }

    public void clearCachedDataForUnitTest() {
        this.mySearchEntity = null;
    }

    private List<IBaseResource> doHistoryInTransaction(Integer theOffset, int theFromIndex, int theToIndex) {
        HistoryBuilder historyBuilder = this.myHistoryBuilderFactory.newHistoryBuilder(this.mySearchEntity.getResourceType(), this.mySearchEntity.getResourceId(), this.mySearchEntity.getLastUpdatedLow(), this.mySearchEntity.getLastUpdatedHigh());
        RequestPartitionId partitionId = this.getRequestPartitionIdForHistory();
        List<ResourceHistoryTable> results = historyBuilder.fetchEntities(partitionId, theOffset, theFromIndex, theToIndex);
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        Iterator<ResourceHistoryTable> iterator = results.iterator();
        while (iterator.hasNext()) {
            ResourceHistoryTable next;
            ResourceHistoryTable resource = next = iterator.next();
            IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(next.getResourceType());
            retVal.add(dao.toResource((BaseHasResource)resource, true));
        }
        SimplePreResourceAccessDetails accessDetails = new SimplePreResourceAccessDetails(retVal);
        HookParams params = new HookParams().add(IPreResourceAccessDetails.class, (Object)accessDetails).add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (HookParams)params);
        for (int i = retVal.size() - 1; i >= 0; --i) {
            if (!accessDetails.isDontReturnResourceAtIndex(i)) continue;
            retVal.remove(i);
        }
        SimplePreResourceShowDetails showDetails = new SimplePreResourceShowDetails(retVal);
        params = new HookParams().add(IPreResourceShowDetails.class, (Object)showDetails).add(RequestDetails.class, (Object)this.myRequest).addIfMatchesType(ServletRequestDetails.class, (Object)this.myRequest);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)this.myRequest, (Pointcut)Pointcut.STORAGE_PRESHOW_RESOURCES, (HookParams)params);
        retVal = showDetails.toList();
        return retVal;
    }

    @Nonnull
    private RequestPartitionId getRequestPartitionIdForHistory() {
        if (this.myRequestPartitionId == null) {
            this.myRequestPartitionId = this.mySearchEntity.getResourceId() != null ? RequestPartitionId.allPartitions() : this.myRequestPartitionHelperSvc.determineReadPartitionForRequest(this.myRequest, this.mySearchEntity.getResourceType(), null);
        }
        return this.myRequestPartitionId;
    }

    protected List<IBaseResource> doSearchOrEverything(int theFromIndex, int theToIndex) {
        if (this.mySearchEntity.getTotalCount() != null && this.mySearchEntity.getNumFound() <= 0) {
            return Collections.emptyList();
        }
        String resourceName = this.mySearchEntity.getResourceType();
        Class resourceType = this.myContext.getResourceDefinition(resourceName).getImplementingClass();
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceName);
        ISearchBuilder sb = this.mySearchBuilderFactory.newSearchBuilder((IDao)dao, resourceName, resourceType);
        List pidsSubList = this.mySearchCoordinatorSvc.getResources(this.myUuid, theFromIndex, theToIndex, this.myRequest);
        TransactionTemplate template = new TransactionTemplate(this.myTxManager);
        template.setPropagationBehavior(0);
        return (List)template.execute(theStatus -> this.toResourceList(sb, pidsSubList));
    }

    public boolean ensureSearchEntityLoaded() {
        if (this.mySearchEntity == null) {
            Optional<Search> searchOpt = this.mySearchCacheSvc.fetchByUuid(this.myUuid);
            if (!searchOpt.isPresent()) {
                return false;
            }
            this.setSearchEntity(searchOpt.get());
            ourLog.trace("Retrieved search with version {} and total {}", (Object)this.mySearchEntity.getVersion(), (Object)this.mySearchEntity.getTotalCount());
            return true;
        }
        if (this.mySearchEntity.getSearchType() == SearchTypeEnum.HISTORY && this.mySearchEntity.getTotalCount() == null) {
            this.calculateHistoryCount();
        }
        return true;
    }

    private void calculateHistoryCount() {
        MemoryCacheService.HistoryCountKey key = this.mySearchEntity.getResourceId() != null ? MemoryCacheService.HistoryCountKey.forInstance(this.mySearchEntity.getResourceId()) : (this.mySearchEntity.getResourceType() != null ? MemoryCacheService.HistoryCountKey.forType(this.mySearchEntity.getResourceType()) : MemoryCacheService.HistoryCountKey.forSystem());
        Function<MemoryCacheService.HistoryCountKey, Integer> supplier = k -> (Integer)new TransactionTemplate(this.myTxManager).execute(t -> {
            HistoryBuilder historyBuilder = this.myHistoryBuilderFactory.newHistoryBuilder(this.mySearchEntity.getResourceType(), this.mySearchEntity.getResourceId(), this.mySearchEntity.getLastUpdatedLow(), this.mySearchEntity.getLastUpdatedHigh());
            Long count = historyBuilder.fetchCount(this.getRequestPartitionIdForHistory());
            return count.intValue();
        });
        boolean haveOffset = this.mySearchEntity.getLastUpdatedLow() != null || this.mySearchEntity.getLastUpdatedHigh() != null;
        switch (this.myDaoConfig.getHistoryCountMode()) {
            case COUNT_ACCURATE: {
                int count = supplier.apply(key);
                this.mySearchEntity.setTotalCount(count);
                break;
            }
            case CACHED_ONLY_WITHOUT_OFFSET: {
                if (haveOffset) break;
                int count = this.myMemoryCacheService.get(MemoryCacheService.CacheEnum.HISTORY_COUNT, key, supplier);
                this.mySearchEntity.setTotalCount(count);
                break;
            }
        }
    }

    public InstantDt getPublished() {
        this.ensureSearchEntityLoaded();
        return new InstantDt(this.mySearchEntity.getCreated());
    }

    @Nonnull
    public List<IBaseResource> getResources(int theFromIndex, int theToIndex) {
        TransactionTemplate template = new TransactionTemplate(this.myTxManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(@Nonnull TransactionStatus theStatus) {
                boolean entityLoaded = PersistedJpaBundleProvider.this.ensureSearchEntityLoaded();
                assert (entityLoaded);
            }
        });
        assert (this.mySearchEntity != null);
        assert (this.mySearchEntity.getSearchType() != null);
        switch (this.mySearchEntity.getSearchType()) {
            case HISTORY: {
                return (List)template.execute(theStatus -> this.doHistoryInTransaction(this.mySearchEntity.getOffset(), theFromIndex, theToIndex));
            }
        }
        List<IBaseResource> retVal = this.doSearchOrEverything(theFromIndex, theToIndex);
        if (retVal.size() < theToIndex - theFromIndex) {
            this.mySearchEntity = null;
        }
        return retVal;
    }

    public String getUuid() {
        return this.myUuid;
    }

    public SearchCacheStatusEnum getCacheStatus() {
        return this.myCacheStatus;
    }

    void setCacheStatus(SearchCacheStatusEnum theSearchCacheStatusEnum) {
        this.myCacheStatus = theSearchCacheStatusEnum;
    }

    public Integer preferredPageSize() {
        this.ensureSearchEntityLoaded();
        return this.mySearchEntity.getPreferredPageSize();
    }

    public void setContext(FhirContext theContext) {
        this.myContext = theContext;
    }

    public void setEntityManager(EntityManager theEntityManager) {
        this.myEntityManager = theEntityManager;
    }

    @VisibleForTesting
    public void setSearchCoordinatorSvcForUnitTest(ISearchCoordinatorSvc theSearchCoordinatorSvc) {
        this.mySearchCoordinatorSvc = theSearchCoordinatorSvc;
    }

    @VisibleForTesting
    public void setTxManagerForUnitTest(PlatformTransactionManager theTxManager) {
        this.myTxManager = theTxManager;
    }

    protected void setSearchEntity(Search theSearchEntity) {
        this.mySearchEntity = theSearchEntity;
    }

    public Integer size() {
        this.ensureSearchEntityLoaded();
        SearchCoordinatorSvcImpl.verifySearchHasntFailedOrThrowInternalErrorException(this.mySearchEntity);
        Integer size = this.mySearchEntity.getTotalCount();
        if (size != null) {
            return Math.max(0, size);
        }
        if (this.mySearchEntity.getSearchType() == SearchTypeEnum.HISTORY) {
            return null;
        }
        return this.mySearchCoordinatorSvc.getSearchTotal(this.myUuid).orElse(null);
    }

    protected boolean hasIncludes() {
        this.ensureSearchEntityLoaded();
        return !this.mySearchEntity.getIncludes().isEmpty();
    }

    protected List<IBaseResource> toResourceList(ISearchBuilder theSearchBuilder, List<ResourcePersistentId> thePids) {
        HashSet<ResourcePersistentId> includedPids = new HashSet<ResourcePersistentId>();
        if (this.mySearchEntity.getSearchType() == SearchTypeEnum.SEARCH) {
            Integer maxIncludes = this.myDaoConfig.getMaximumIncludesToLoadPerPage();
            includedPids.addAll(theSearchBuilder.loadIncludes(this.myContext, this.myEntityManager, thePids, this.mySearchEntity.toRevIncludesList(), true, this.mySearchEntity.getLastUpdated(), this.myUuid, this.myRequest, maxIncludes));
            if (maxIncludes != null) {
                maxIncludes = maxIncludes - includedPids.size();
            }
            includedPids.addAll(theSearchBuilder.loadIncludes(this.myContext, this.myEntityManager, thePids, this.mySearchEntity.toIncludesList(), false, this.mySearchEntity.getLastUpdated(), this.myUuid, this.myRequest, maxIncludes));
        }
        ArrayList<ResourcePersistentId> includedPidList = new ArrayList<ResourcePersistentId>(includedPids);
        thePids.addAll(includedPidList);
        List<IBaseResource> resources = new ArrayList<IBaseResource>();
        theSearchBuilder.loadResourcesByPid(thePids, includedPidList, resources, false, this.myRequest);
        resources = InterceptorUtil.fireStoragePreshowResource(resources, this.myRequest, this.myInterceptorBroadcaster);
        return resources;
    }

    public void setInterceptorBroadcaster(IInterceptorBroadcaster theInterceptorBroadcaster) {
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
    }

    @VisibleForTesting
    public void setSearchCacheSvcForUnitTest(ISearchCacheSvc theSearchCacheSvc) {
        this.mySearchCacheSvc = theSearchCacheSvc;
    }

    @VisibleForTesting
    public void setDaoRegistryForUnitTest(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
    }

    @VisibleForTesting
    public void setDaoConfigForUnitTest(DaoConfig theDaoConfig) {
        this.myDaoConfig = theDaoConfig;
    }

    @VisibleForTesting
    public void setSearchBuilderFactoryForUnitTest(SearchBuilderFactory theSearchBuilderFactory) {
        this.mySearchBuilderFactory = theSearchBuilderFactory;
    }
}

