/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search;

import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.entity.Search;
import ca.uhn.fhir.jpa.model.search.SearchStatusEnum;
import ca.uhn.fhir.jpa.search.PersistedJpaBundleProvider;
import ca.uhn.fhir.jpa.search.SearchCoordinatorSvcImpl;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionTemplate;

public class PersistedJpaSearchFirstPageBundleProvider
extends PersistedJpaBundleProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(PersistedJpaSearchFirstPageBundleProvider.class);
    private SearchCoordinatorSvcImpl.SearchTask mySearchTask;
    private ISearchBuilder mySearchBuilder;
    private Search mySearch;

    public PersistedJpaSearchFirstPageBundleProvider(Search theSearch, SearchCoordinatorSvcImpl.SearchTask theSearchTask, ISearchBuilder theSearchBuilder, RequestDetails theRequest) {
        super(theRequest, theSearch.getUuid());
        this.setSearchEntity(theSearch);
        this.mySearchTask = theSearchTask;
        this.mySearchBuilder = theSearchBuilder;
        this.mySearch = theSearch;
    }

    @Override
    @Nonnull
    public List<IBaseResource> getResources(int theFromIndex, int theToIndex) {
        SearchCoordinatorSvcImpl.verifySearchHasntFailedOrThrowInternalErrorException(this.mySearch);
        this.mySearchTask.awaitInitialSync();
        ourLog.trace("Fetching search resource PIDs from task: {}", this.mySearchTask.getClass());
        List<ResourcePersistentId> pids = this.mySearchTask.getResourcePids(theFromIndex, theToIndex);
        ourLog.trace("Done fetching search resource PIDs");
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTxManager);
        txTemplate.setPropagationBehavior(0);
        List retVal = (List)txTemplate.execute(theStatus -> this.toResourceList(this.mySearchBuilder, pids));
        long totalCountWanted = theToIndex - theFromIndex;
        long totalCountMatch = (int)retVal.stream().filter(t -> !this.isInclude((IBaseResource)t)).count();
        if (totalCountMatch < totalCountWanted && this.mySearch.getStatus() == SearchStatusEnum.PASSCMPLET) {
            Set existingIds = retVal.stream().map(t -> t.getIdElement().getValue()).filter(t -> t != null).collect(Collectors.toSet());
            long remainingWanted = totalCountWanted - totalCountMatch;
            long fromIndex = (long)theToIndex - remainingWanted;
            List<IBaseResource> remaining = super.getResources((int)fromIndex, theToIndex);
            remaining.forEach(t -> {
                if (!existingIds.contains(t.getIdElement().getValue())) {
                    retVal.add(t);
                }
            });
        }
        ourLog.trace("Loaded resources to return");
        return retVal;
    }

    private boolean isInclude(IBaseResource theResource) {
        if (theResource instanceof IAnyResource) {
            return "include".equals(ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.get((IAnyResource)theResource));
        }
        BundleEntrySearchModeEnum searchMode = (BundleEntrySearchModeEnum)ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.get((IResource)theResource);
        return BundleEntrySearchModeEnum.INCLUDE.equals((Object)searchMode);
    }

    @Override
    public Integer size() {
        ourLog.trace("Waiting for initial sync");
        Integer size = this.mySearchTask.awaitInitialSync();
        ourLog.trace("Finished waiting for local sync");
        SearchCoordinatorSvcImpl.verifySearchHasntFailedOrThrowInternalErrorException(this.mySearch);
        if (size != null) {
            return size;
        }
        return super.size();
    }
}

