/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.LegacySearchBuilder;
import ca.uhn.fhir.jpa.dao.predicate.PredicateBuilderToken;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.NormalizedQuantitySearchLevel;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import ca.uhn.fhir.jpa.model.util.UcumServiceUtil;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ComboNonUniqueSearchParameterPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ComboUniqueSearchParameterPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.CoordsPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.DatePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ForcedIdPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.NumberPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.QuantityBasePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.QuantityPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceIdPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceLinkPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.ResourceTablePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.SearchParamPresentPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.SourcePredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.StringPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.TagPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.TokenPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.predicate.UriPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.extractor.BaseSearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.jpa.searchparam.util.SourceParam;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.CompositeParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.HasParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import com.google.common.collect.Lists;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.Subquery;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.collections4.bidimap.UnmodifiableBidiMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStack {
    private static final Logger ourLog = LoggerFactory.getLogger(QueryStack.class);
    private static final BidiMap<SearchFilterParser.CompareOperation, ParamPrefixEnum> ourCompareOperationToParamPrefix;
    private final ModelConfig myModelConfig;
    private final FhirContext myFhirContext;
    private final SearchQueryBuilder mySqlBuilder;
    private final SearchParameterMap mySearchParameters;
    private final ISearchParamRegistry mySearchParamRegistry;
    private final PartitionSettings myPartitionSettings;
    private final DaoConfig myDaoConfig;
    private final EnumSet<PredicateBuilderTypeEnum> myReusePredicateBuilderTypes;
    private Map<PredicateBuilderCacheKey, BaseJoiningPredicateBuilder> myJoinMap;

    public QueryStack(SearchParameterMap theSearchParameters, DaoConfig theDaoConfig, ModelConfig theModelConfig, FhirContext theFhirContext, SearchQueryBuilder theSqlBuilder, ISearchParamRegistry theSearchParamRegistry, PartitionSettings thePartitionSettings) {
        this(theSearchParameters, theDaoConfig, theModelConfig, theFhirContext, theSqlBuilder, theSearchParamRegistry, thePartitionSettings, EnumSet.of(PredicateBuilderTypeEnum.DATE));
    }

    private QueryStack(SearchParameterMap theSearchParameters, DaoConfig theDaoConfig, ModelConfig theModelConfig, FhirContext theFhirContext, SearchQueryBuilder theSqlBuilder, ISearchParamRegistry theSearchParamRegistry, PartitionSettings thePartitionSettings, EnumSet<PredicateBuilderTypeEnum> theReusePredicateBuilderTypes) {
        this.myPartitionSettings = thePartitionSettings;
        assert (theSearchParameters != null);
        assert (theDaoConfig != null);
        assert (theModelConfig != null);
        assert (theFhirContext != null);
        assert (theSqlBuilder != null);
        this.mySearchParameters = theSearchParameters;
        this.myDaoConfig = theDaoConfig;
        this.myModelConfig = theModelConfig;
        this.myFhirContext = theFhirContext;
        this.mySqlBuilder = theSqlBuilder;
        this.mySearchParamRegistry = theSearchParamRegistry;
        this.myReusePredicateBuilderTypes = theReusePredicateBuilderTypes;
    }

    public void addSortOnDate(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        DatePredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addDatePredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        Condition hashIdentityPredicate = sortPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.mySqlBuilder.addPredicate(hashIdentityPredicate);
        this.mySqlBuilder.addSortDate(sortPredicateBuilder.getColumnValueLow(), theAscending);
    }

    public void addSortOnLastUpdated(boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        ResourceTablePredicateBuilder resourceTablePredicateBuilder = firstPredicateBuilder instanceof ResourceTablePredicateBuilder ? (ResourceTablePredicateBuilder)firstPredicateBuilder : this.mySqlBuilder.addResourceTablePredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        this.mySqlBuilder.addSortDate(resourceTablePredicateBuilder.getColumnLastUpdated(), theAscending);
    }

    public void addSortOnNumber(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        NumberPredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addNumberPredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        Condition hashIdentityPredicate = sortPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.mySqlBuilder.addPredicate(hashIdentityPredicate);
        this.mySqlBuilder.addSortNumeric(sortPredicateBuilder.getColumnValue(), theAscending);
    }

    public void addSortOnQuantity(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        QuantityPredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addQuantityPredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        Condition hashIdentityPredicate = sortPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.mySqlBuilder.addPredicate(hashIdentityPredicate);
        this.mySqlBuilder.addSortNumeric(sortPredicateBuilder.getColumnValue(), theAscending);
    }

    public void addSortOnResourceId(boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        ForcedIdPredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addForcedIdPredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        if (!theAscending) {
            this.mySqlBuilder.addSortString(sortPredicateBuilder.getColumnForcedId(), false, OrderObject.NullOrder.FIRST);
        } else {
            this.mySqlBuilder.addSortString(sortPredicateBuilder.getColumnForcedId(), true);
        }
        this.mySqlBuilder.addSortNumeric(firstPredicateBuilder.getResourceIdColumn(), theAscending);
    }

    public void addSortOnResourceLink(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        ResourceLinkPredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addReferencePredicateBuilder(this, firstPredicateBuilder.getResourceIdColumn());
        Condition pathPredicate = sortPredicateBuilder.createPredicateSourcePaths(theResourceName, theParamName, new ArrayList<String>());
        this.mySqlBuilder.addPredicate(pathPredicate);
        this.mySqlBuilder.addSortNumeric(sortPredicateBuilder.getColumnTargetResourceId(), theAscending);
    }

    public void addSortOnString(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        StringPredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addStringPredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        Condition hashIdentityPredicate = sortPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.mySqlBuilder.addPredicate(hashIdentityPredicate);
        this.mySqlBuilder.addSortString(sortPredicateBuilder.getColumnValueNormalized(), theAscending);
    }

    public void addSortOnToken(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        TokenPredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addTokenPredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        Condition hashIdentityPredicate = sortPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.mySqlBuilder.addPredicate(hashIdentityPredicate);
        this.mySqlBuilder.addSortString(sortPredicateBuilder.getColumnSystem(), theAscending);
        this.mySqlBuilder.addSortString(sortPredicateBuilder.getColumnValue(), theAscending);
    }

    public void addSortOnUri(String theResourceName, String theParamName, boolean theAscending) {
        BaseJoiningPredicateBuilder firstPredicateBuilder = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
        UriPredicateBuilder sortPredicateBuilder = this.mySqlBuilder.addUriPredicateBuilder(firstPredicateBuilder.getResourceIdColumn());
        Condition hashIdentityPredicate = sortPredicateBuilder.createHashIdentityPredicate(theResourceName, theParamName);
        this.mySqlBuilder.addPredicate(hashIdentityPredicate);
        this.mySqlBuilder.addSortString(sortPredicateBuilder.getColumnValue(), theAscending);
    }

    private <T extends BaseJoiningPredicateBuilder> PredicateBuilderCacheLookupResult<T> createOrReusePredicateBuilder(PredicateBuilderTypeEnum theType, DbColumn theSourceJoinColumn, String theParamName, Supplier<T> theFactoryMethod) {
        BaseJoiningPredicateBuilder retVal;
        boolean cacheHit = false;
        if (this.myReusePredicateBuilderTypes.contains((Object)theType)) {
            PredicateBuilderCacheKey key = new PredicateBuilderCacheKey(theSourceJoinColumn, theType, theParamName);
            if (this.myJoinMap == null) {
                this.myJoinMap = new HashMap<PredicateBuilderCacheKey, BaseJoiningPredicateBuilder>();
            }
            if ((retVal = this.myJoinMap.get(key)) != null) {
                cacheHit = true;
            } else {
                retVal = (BaseJoiningPredicateBuilder)theFactoryMethod.get();
                this.myJoinMap.put(key, retVal);
            }
        } else {
            retVal = (BaseJoiningPredicateBuilder)theFactoryMethod.get();
        }
        return new PredicateBuilderCacheLookupResult(cacheHit, retVal, null);
    }

    private Condition createPredicateComposite(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theParamDef, List<? extends IQueryParameterType> theNextAnd, RequestPartitionId theRequestPartitionId) {
        Condition orCondidtion = null;
        for (IQueryParameterType iQueryParameterType : theNextAnd) {
            if (!(iQueryParameterType instanceof CompositeParam)) {
                throw new InvalidRequestException("Invalid type for composite param (must be " + CompositeParam.class.getSimpleName() + ": " + iQueryParameterType.getClass());
            }
            CompositeParam cp = (CompositeParam)iQueryParameterType;
            List componentParams = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)theParamDef);
            RuntimeSearchParam left = (RuntimeSearchParam)componentParams.get(0);
            IQueryParameterType leftValue = cp.getLeftValue();
            Condition leftPredicate = this.createPredicateCompositePart(theSourceJoinColumn, theResourceName, theSpnamePrefix, left, leftValue, theRequestPartitionId);
            RuntimeSearchParam right = (RuntimeSearchParam)componentParams.get(1);
            IQueryParameterType rightValue = cp.getRightValue();
            Condition rightPredicate = this.createPredicateCompositePart(theSourceJoinColumn, theResourceName, theSpnamePrefix, right, rightValue, theRequestPartitionId);
            Condition andCondition = QueryStack.toAndPredicate(leftPredicate, rightPredicate);
            if (orCondidtion == null) {
                orCondidtion = QueryStack.toOrPredicate(andCondition);
                continue;
            }
            orCondidtion = QueryStack.toOrPredicate(orCondidtion, andCondition);
        }
        return orCondidtion;
    }

    private Condition createPredicateCompositePart(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theParam, IQueryParameterType theParamValue, RequestPartitionId theRequestPartitionId) {
        switch (theParam.getParamType()) {
            case STRING: {
                return this.createPredicateString(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParam, Collections.singletonList(theParamValue), null, theRequestPartitionId);
            }
            case TOKEN: {
                return this.createPredicateToken(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParam, Collections.singletonList(theParamValue), null, theRequestPartitionId);
            }
            case DATE: {
                return this.createPredicateDate(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParam, Collections.singletonList(theParamValue), QueryStack.toOperation(((DateParam)theParamValue).getPrefix()), theRequestPartitionId);
            }
            case QUANTITY: {
                return this.createPredicateQuantity(theSourceJoinColumn, theResourceName, theSpnamePrefix, theParam, Collections.singletonList(theParamValue), null, theRequestPartitionId);
            }
        }
        throw new InvalidRequestException("Don't know how to handle composite parameter with type of " + theParam.getParamType());
    }

    public Condition createPredicateCoords(@Nullable DbColumn theSourceJoinColumn, String theResourceName, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, RequestPartitionId theRequestPartitionId) {
        CoordsPredicateBuilder predicateBuilder = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.COORDS, theSourceJoinColumn, theSearchParam.getName(), () -> this.mySqlBuilder.addCoordsPredicateBuilder(theSourceJoinColumn)).getResult();
        if (theList.get(0).getMissing() != null) {
            return predicateBuilder.createPredicateParamMissingForNonReference(theResourceName, theSearchParam.getName(), theList.get(0).getMissing(), theRequestPartitionId);
        }
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (IQueryParameterType iQueryParameterType : theList) {
            Condition singleCode = predicateBuilder.createPredicateCoords(this.mySearchParameters, iQueryParameterType, theResourceName, theSearchParam, predicateBuilder, theRequestPartitionId);
            codePredicates.add(singleCode);
        }
        return predicateBuilder.combineWithRequestPartitionIdPredicate(theRequestPartitionId, (Condition)ComboCondition.or((Condition[])codePredicates.toArray(new Condition[0])));
    }

    public Condition createPredicateDate(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        String paramName = QueryStack.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        PredicateBuilderCacheLookupResult<DatePredicateBuilder> predicateBuilderLookupResult = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.DATE, theSourceJoinColumn, paramName, () -> this.mySqlBuilder.addDatePredicateBuilder(theSourceJoinColumn));
        DatePredicateBuilder predicateBuilder = predicateBuilderLookupResult.getResult();
        boolean cacheHit = predicateBuilderLookupResult.isCacheHit();
        if (theList.get(0).getMissing() != null) {
            Boolean missing = theList.get(0).getMissing();
            return predicateBuilder.createPredicateParamMissingForNonReference(theResourceName, paramName, missing, theRequestPartitionId);
        }
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (IQueryParameterType iQueryParameterType : theList) {
            Condition p = predicateBuilder.createPredicateDateWithoutIdentityPredicate(iQueryParameterType, predicateBuilder, theOperation);
            codePredicates.add(p);
        }
        Condition predicate = QueryStack.toOrPredicate(codePredicates);
        if (!cacheHit) {
            predicate = predicateBuilder.combineWithHashIdentityPredicate(theResourceName, paramName, predicate);
            predicate = predicateBuilder.combineWithRequestPartitionIdPredicate(theRequestPartitionId, predicate);
        }
        return predicate;
    }

    private Condition createPredicateFilter(QueryStack theQueryStack3, SearchFilterParser.Filter theFilter, String theResourceName, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        if (theFilter instanceof SearchFilterParser.FilterParameter) {
            return this.createPredicateFilter(theQueryStack3, (SearchFilterParser.FilterParameter)theFilter, theResourceName, theRequest, theRequestPartitionId);
        }
        if (theFilter instanceof SearchFilterParser.FilterLogical) {
            Condition xPredicate = this.createPredicateFilter(theQueryStack3, ((SearchFilterParser.FilterLogical)theFilter).getFilter1(), theResourceName, theRequest, theRequestPartitionId);
            Condition yPredicate = this.createPredicateFilter(theQueryStack3, ((SearchFilterParser.FilterLogical)theFilter).getFilter2(), theResourceName, theRequest, theRequestPartitionId);
            if (((SearchFilterParser.FilterLogical)theFilter).getOperation() == SearchFilterParser.FilterLogicalOperation.and) {
                return ComboCondition.and((Condition[])new Condition[]{xPredicate, yPredicate});
            }
            if (((SearchFilterParser.FilterLogical)theFilter).getOperation() == SearchFilterParser.FilterLogicalOperation.or) {
                return ComboCondition.or((Condition[])new Condition[]{xPredicate, yPredicate});
            }
            throw new InvalidRequestException("Don't know how to handle operation " + (Object)((Object)((SearchFilterParser.FilterLogical)theFilter).getOperation()));
        }
        return this.createPredicateFilter(theQueryStack3, ((SearchFilterParser.FilterParameterGroup)theFilter).getContained(), theResourceName, theRequest, theRequestPartitionId);
    }

    private Condition createPredicateFilter(QueryStack theQueryStack3, SearchFilterParser.FilterParameter theFilter, String theResourceName, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        String paramName;
        switch (paramName = theFilter.getParamPath().getName()) {
            case "_id": {
                TokenParam param = new TokenParam();
                param.setValueAsQueryToken(null, null, null, theFilter.getValue());
                return theQueryStack3.createPredicateResourceId(null, Collections.singletonList(Collections.singletonList(param)), theResourceName, theFilter.getOperation(), theRequestPartitionId);
            }
            case "_language": {
                return theQueryStack3.createPredicateLanguage(Collections.singletonList(Collections.singletonList(new StringParam(theFilter.getValue()))), (Object)theFilter.getOperation());
            }
            case "_source": {
                TokenParam param = new TokenParam();
                param.setValueAsQueryToken(null, null, null, theFilter.getValue());
                return this.createPredicateSource(null, Collections.singletonList(param));
            }
        }
        RuntimeSearchParam searchParam = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, paramName);
        if (searchParam == null) {
            Collection validNames = this.mySearchParamRegistry.getValidSearchParameterNamesIncludingMeta(theResourceName);
            String msg = this.myFhirContext.getLocalizer().getMessageSanitized(BaseHapiFhirResourceDao.class, "invalidSearchParameter", new Object[]{paramName, theResourceName, validNames});
            throw new InvalidRequestException(msg);
        }
        RestSearchParameterTypeEnum typeEnum = searchParam.getParamType();
        if (typeEnum == RestSearchParameterTypeEnum.URI) {
            return theQueryStack3.createPredicateUri(null, theResourceName, null, searchParam, Collections.singletonList(new UriParam(theFilter.getValue())), theFilter.getOperation(), theRequest, theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.STRING) {
            return theQueryStack3.createPredicateString(null, theResourceName, null, searchParam, Collections.singletonList(new StringParam(theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.DATE) {
            return theQueryStack3.createPredicateDate(null, theResourceName, null, searchParam, Collections.singletonList(new DateParam(QueryStack.fromOperation(theFilter.getOperation()), theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.NUMBER) {
            return theQueryStack3.createPredicateNumber(null, theResourceName, null, searchParam, Collections.singletonList(new NumberParam(theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.REFERENCE) {
            SearchFilterParser.CompareOperation operation = theFilter.getOperation();
            String resourceType = null;
            String chain = theFilter.getParamPath().getNext() != null ? theFilter.getParamPath().getNext().toString() : null;
            String value = theFilter.getValue();
            ReferenceParam referenceParam = new ReferenceParam(resourceType, chain, value);
            return theQueryStack3.createPredicateReference(null, theResourceName, paramName, new ArrayList<String>(), Collections.singletonList(referenceParam), operation, theRequest, theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.QUANTITY) {
            return theQueryStack3.createPredicateQuantity(null, theResourceName, null, searchParam, Collections.singletonList(new QuantityParam(theFilter.getValue())), theFilter.getOperation(), theRequestPartitionId);
        }
        if (typeEnum == RestSearchParameterTypeEnum.COMPOSITE) {
            throw new InvalidRequestException("Composite search parameters not currently supported with _filter clauses");
        }
        if (typeEnum == RestSearchParameterTypeEnum.TOKEN) {
            TokenParam param = new TokenParam();
            param.setValueAsQueryToken(null, null, null, theFilter.getValue());
            return theQueryStack3.createPredicateToken(null, theResourceName, null, searchParam, Collections.singletonList(param), theFilter.getOperation(), theRequestPartitionId);
        }
        return null;
    }

    private Condition createPredicateHas(@Nullable DbColumn theSourceJoinColumn, String theResourceType, List<List<IQueryParameterType>> theHasParameters, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        ArrayList<Condition> andPredicates = new ArrayList<Condition>();
        for (List<IQueryParameterType> nextOrList : theHasParameters) {
            int colonIndex;
            String targetResourceType = null;
            String paramReference = null;
            String parameterName = null;
            String paramName = null;
            ArrayList<QualifiedParamList> parameters = new ArrayList<QualifiedParamList>();
            for (IQueryParameterType nextParam : nextOrList) {
                HasParam next = (HasParam)nextParam;
                targetResourceType = next.getTargetResourceType();
                paramReference = next.getReferenceFieldName();
                parameterName = next.getParameterName();
                paramName = parameterName.replaceAll("\\..*", "");
                parameters.add(QualifiedParamList.singleton(null, (String)next.getValueAsQueryToken(this.myFhirContext)));
            }
            if (paramName == null) continue;
            try {
                this.myFhirContext.getResourceDefinition(targetResourceType);
            }
            catch (DataFormatException e) {
                throw new InvalidRequestException("Invalid resource type: " + targetResourceType);
            }
            ArrayList orValues = Lists.newArrayList();
            if (paramName.startsWith("_has:")) {
                ourLog.trace("Handing double _has query: {}", (Object)paramName);
                String qualifier = paramName.substring(4);
                for (IQueryParameterType next : nextOrList) {
                    HasParam nextHasParam = new HasParam();
                    nextHasParam.setValueAsQueryToken(this.myFhirContext, "_has", qualifier, next.getValueAsQueryToken(this.myFhirContext));
                    orValues.add(nextHasParam);
                }
            } else {
                RuntimeSearchParam owningParameterDef = this.mySearchParamRegistry.getActiveSearchParam(targetResourceType, paramName);
                if (owningParameterDef == null) {
                    throw new InvalidRequestException("Unknown parameter name: " + targetResourceType + ':' + parameterName);
                }
                RuntimeSearchParam joiningParameterDef = this.mySearchParamRegistry.getActiveSearchParam(targetResourceType, paramReference);
                if (joiningParameterDef == null) {
                    throw new InvalidRequestException("Unknown parameter name: " + targetResourceType + ':' + paramReference);
                }
                IQueryParameterAnd parsedParam = JpaParamUtil.parseQueryParams((ISearchParamRegistry)this.mySearchParamRegistry, (FhirContext)this.myFhirContext, (RuntimeSearchParam)owningParameterDef, (String)paramName, parameters);
                for (IQueryParameterOr next : parsedParam.getValuesAsQueryTokens()) {
                    orValues.addAll(next.getValuesAsQueryTokens());
                }
            }
            if (parameterName.contains(".")) {
                String chainedPartOfParameter = QueryStack.getChainedPart(parameterName);
                orValues.stream().filter(qp -> qp instanceof ReferenceParam).map(qp -> (ReferenceParam)qp).forEach(rp -> rp.setChain(QueryStack.getChainedPart(chainedPartOfParameter)));
                parameterName = parameterName.substring(0, parameterName.indexOf(46));
            }
            if ((colonIndex = parameterName.indexOf(58)) != -1) {
                parameterName = parameterName.substring(0, colonIndex);
            }
            ResourceLinkPredicateBuilder join = this.mySqlBuilder.addReferencePredicateBuilderReversed(this, theSourceJoinColumn);
            Condition partitionPredicate = join.createPartitionIdPredicate(theRequestPartitionId);
            List<String> paths = join.createResourceLinkPaths(targetResourceType, paramReference, new ArrayList<String>());
            BinaryCondition typePredicate = BinaryCondition.equalTo((Object)join.getColumnTargetResourceType(), (Object)this.mySqlBuilder.generatePlaceholder(theResourceType));
            Condition pathPredicate = QueryStack.toEqualToOrInPredicate(join.getColumnSourcePath(), this.mySqlBuilder.generatePlaceholders(paths));
            Condition linkedPredicate = this.searchForIdsWithAndOr(join.getColumnSrcResourceId(), targetResourceType, parameterName, Collections.singletonList(orValues), theRequest, theRequestPartitionId, SearchContainedModeEnum.FALSE);
            andPredicates.add(QueryStack.toAndPredicate(new Condition[]{partitionPredicate, pathPredicate, typePredicate, linkedPredicate}));
        }
        return QueryStack.toAndPredicate(andPredicates);
    }

    public Condition createPredicateLanguage(List<List<IQueryParameterType>> theList, Object theOperation) {
        ResourceTablePredicateBuilder rootTable = this.mySqlBuilder.getOrCreateResourceTablePredicateBuilder();
        ArrayList<Condition> predicates = new ArrayList<Condition>();
        for (List<IQueryParameterType> nextList : theList) {
            HashSet<String> values = new HashSet<String>();
            for (IQueryParameterType next : nextList) {
                if (next instanceof StringParam) {
                    String nextValue = ((StringParam)next).getValue();
                    if (StringUtils.isBlank((CharSequence)nextValue)) continue;
                    values.add(nextValue);
                    continue;
                }
                throw new InternalErrorException("Language parameter must be of type " + StringParam.class.getCanonicalName() + " - Got " + next.getClass().getCanonicalName());
            }
            if (values.isEmpty()) continue;
            if (theOperation == null || theOperation == SearchFilterParser.CompareOperation.eq) {
                predicates.add(rootTable.createLanguagePredicate(values, false));
                continue;
            }
            if (theOperation == SearchFilterParser.CompareOperation.ne) {
                predicates.add(rootTable.createLanguagePredicate(values, true));
                continue;
            }
            throw new InvalidRequestException("Unsupported operator specified in language query, only \"eq\" and \"ne\" are supported");
        }
        return QueryStack.toAndPredicate(predicates);
    }

    public Condition createPredicateNumber(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        String paramName = QueryStack.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        NumberPredicateBuilder join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.NUMBER, theSourceJoinColumn, paramName, () -> this.mySqlBuilder.addNumberPredicateBuilder(theSourceJoinColumn)).getResult();
        if (theList.get(0).getMissing() != null) {
            return join.createPredicateParamMissingForNonReference(theResourceName, paramName, theList.get(0).getMissing(), theRequestPartitionId);
        }
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (IQueryParameterType iQueryParameterType : theList) {
            if (iQueryParameterType instanceof NumberParam) {
                NumberParam param = (NumberParam)iQueryParameterType;
                BigDecimal value = param.getValue();
                if (value == null) continue;
                SearchFilterParser.CompareOperation operation = theOperation;
                if (operation == null) {
                    operation = QueryStack.toOperation(param.getPrefix());
                }
                Condition predicate = join.createPredicateNumeric(theResourceName, paramName, operation, value, theRequestPartitionId, iQueryParameterType);
                codePredicates.add(predicate);
                continue;
            }
            throw new IllegalArgumentException("Invalid token type: " + iQueryParameterType.getClass());
        }
        return join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, (Condition)ComboCondition.or((Condition[])codePredicates.toArray(new Condition[0])));
    }

    public Condition createPredicateQuantity(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        List normalizedQuantityParams;
        String paramName = QueryStack.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        if (theList.get(0).getMissing() != null) {
            QuantityBasePredicateBuilder join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.QUANTITY, theSourceJoinColumn, theSearchParam.getName(), () -> this.mySqlBuilder.addQuantityPredicateBuilder(theSourceJoinColumn)).getResult();
            return join.createPredicateParamMissingForNonReference(theResourceName, paramName, theList.get(0).getMissing(), theRequestPartitionId);
        }
        List quantityParams = theList.stream().map(t -> QuantityParam.toQuantityParam((IQueryParameterType)t)).collect(Collectors.toList());
        QuantityBasePredicateBuilder join = null;
        boolean normalizedSearchEnabled = this.myModelConfig.getNormalizedQuantitySearchLevel().equals((Object)NormalizedQuantitySearchLevel.NORMALIZED_QUANTITY_SEARCH_SUPPORTED);
        if (normalizedSearchEnabled && (normalizedQuantityParams = quantityParams.stream().map(t -> UcumServiceUtil.toCanonicalQuantityOrNull((QuantityParam)t)).filter(t -> t != null).collect(Collectors.toList())).size() == quantityParams.size()) {
            join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.QUANTITY, theSourceJoinColumn, paramName, () -> this.mySqlBuilder.addQuantityNormalizedPredicateBuilder(theSourceJoinColumn)).getResult();
            quantityParams = normalizedQuantityParams;
        }
        if (join == null) {
            join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.QUANTITY, theSourceJoinColumn, paramName, () -> this.mySqlBuilder.addQuantityPredicateBuilder(theSourceJoinColumn)).getResult();
        }
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (QuantityParam nextOr : quantityParams) {
            Condition singleCode = join.createPredicateQuantity(nextOr, theResourceName, paramName, null, join, theOperation, theRequestPartitionId);
            codePredicates.add(singleCode);
        }
        return join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, (Condition)ComboCondition.or((Condition[])codePredicates.toArray(new Condition[0])));
    }

    public Condition createPredicateReference(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theParamName, List<String> theQualifiers, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        if (theOperation != null && theOperation != SearchFilterParser.CompareOperation.eq && theOperation != SearchFilterParser.CompareOperation.ne) {
            throw new InvalidRequestException("Invalid operator specified for reference predicate.  Supported operators for reference predicate are \"eq\" and \"ne\".");
        }
        if (theList.get(0).getMissing() != null) {
            SearchParamPresentPredicateBuilder join = this.mySqlBuilder.addSearchParamPresentPredicateBuilder(theSourceJoinColumn);
            return join.createPredicateParamMissingForReference(theResourceName, theParamName, theList.get(0).getMissing(), theRequestPartitionId);
        }
        ResourceLinkPredicateBuilder predicateBuilder = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.REFERENCE, theSourceJoinColumn, theParamName, () -> this.mySqlBuilder.addReferencePredicateBuilder(this, theSourceJoinColumn)).getResult();
        return predicateBuilder.createPredicate(theRequest, theResourceName, theParamName, theQualifiers, theList, theOperation, theRequestPartitionId);
    }

    public Condition createPredicateReferenceForContainedResource(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theParamName, List<String> theQualifiers, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        String spnamePrefix = theParamName;
        String targetChain = null;
        String targetParamName = null;
        String headQualifier = null;
        String targetQualifier = null;
        String targetValue = null;
        RuntimeSearchParam targetParamDefinition = null;
        ArrayList orValues = Lists.newArrayList();
        ArrayList trimmedParameters = Lists.newArrayList();
        IQueryParameterType qp = null;
        for (int orIdx = 0; orIdx < theList.size(); ++orIdx) {
            int qualifierIndex;
            IQueryParameterType nextOr = theList.get(orIdx);
            if (!(nextOr instanceof ReferenceParam)) continue;
            ReferenceParam referenceParam = (ReferenceParam)nextOr;
            targetParamName = targetChain = referenceParam.getChain();
            targetValue = nextOr.getValueAsQueryToken(this.myFhirContext);
            headQualifier = referenceParam.getResourceType();
            String targetNextChain = null;
            int linkIndex = targetChain.indexOf(46);
            if (linkIndex != -1) {
                targetParamName = targetChain.substring(0, linkIndex);
                targetNextChain = targetChain.substring(linkIndex + 1);
            }
            if ((qualifierIndex = targetParamName.indexOf(58)) != -1) {
                targetParamName = targetParamName.substring(0, qualifierIndex);
                targetQualifier = targetParamName.substring(qualifierIndex);
            }
            trimmedParameters.add(new ReferenceParam(targetQualifier, targetNextChain, referenceParam.getValue()));
            if (targetParamDefinition == null) {
                for (String nextTarget : theSearchParam.getTargets()) {
                    if (!referenceParam.hasResourceType() || referenceParam.getResourceType().equals(nextTarget)) {
                        targetParamDefinition = this.mySearchParamRegistry.getActiveSearchParam(nextTarget, targetParamName);
                    }
                    if (targetParamDefinition == null) continue;
                    break;
                }
            }
            if (targetParamDefinition == null) {
                throw new InvalidRequestException("Unknown search parameter name: " + theSearchParam.getName() + '.' + targetParamName + ".");
            }
            if (RestSearchParameterTypeEnum.REFERENCE.equals((Object)targetParamDefinition.getParamType())) continue;
            qp = this.toParameterType(targetParamDefinition);
            qp.setValueAsQueryToken(this.myFhirContext, targetParamName, targetQualifier, targetValue);
            orValues.add(qp);
        }
        if (targetParamDefinition == null) {
            throw new InvalidRequestException("Unknown search parameter name: " + theSearchParam.getName() + ".");
        }
        theQualifiers.add(headQualifier);
        Condition containedCondition = null;
        switch (targetParamDefinition.getParamType()) {
            case DATE: {
                containedCondition = this.createPredicateDate(theSourceJoinColumn, theResourceName, spnamePrefix, targetParamDefinition, orValues, theOperation, theRequestPartitionId);
                break;
            }
            case NUMBER: {
                containedCondition = this.createPredicateNumber(theSourceJoinColumn, theResourceName, spnamePrefix, targetParamDefinition, orValues, theOperation, theRequestPartitionId);
                break;
            }
            case QUANTITY: {
                containedCondition = this.createPredicateQuantity(theSourceJoinColumn, theResourceName, spnamePrefix, targetParamDefinition, orValues, theOperation, theRequestPartitionId);
                break;
            }
            case STRING: {
                containedCondition = this.createPredicateString(theSourceJoinColumn, theResourceName, spnamePrefix, targetParamDefinition, orValues, theOperation, theRequestPartitionId);
                break;
            }
            case TOKEN: {
                containedCondition = this.createPredicateToken(theSourceJoinColumn, theResourceName, spnamePrefix, targetParamDefinition, orValues, theOperation, theRequestPartitionId);
                break;
            }
            case COMPOSITE: {
                containedCondition = this.createPredicateComposite(theSourceJoinColumn, theResourceName, spnamePrefix, targetParamDefinition, orValues, theRequestPartitionId);
                break;
            }
            case URI: {
                containedCondition = this.createPredicateUri(theSourceJoinColumn, theResourceName, spnamePrefix, targetParamDefinition, orValues, theOperation, theRequest, theRequestPartitionId);
                break;
            }
            case REFERENCE: {
                String chainedParamName = theParamName + "." + targetParamName;
                containedCondition = this.createPredicateReference(theSourceJoinColumn, theResourceName, chainedParamName, theQualifiers, trimmedParameters, theOperation, theRequest, theRequestPartitionId);
                if (!this.myModelConfig.isIndexOnContainedResourcesRecursively()) break;
                containedCondition = QueryStack.toOrPredicate(containedCondition, this.createPredicateReferenceForContainedResource(theSourceJoinColumn, theResourceName, chainedParamName, theQualifiers, theSearchParam, trimmedParameters, theOperation, theRequest, theRequestPartitionId));
                break;
            }
            default: {
                throw new InvalidRequestException("The search type:" + targetParamDefinition.getParamType() + " is not supported.");
            }
        }
        return containedCondition;
    }

    @Nullable
    public Condition createPredicateResourceId(@Nullable DbColumn theSourceJoinColumn, List<List<IQueryParameterType>> theValues, String theResourceName, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        ResourceIdPredicateBuilder builder = this.mySqlBuilder.newResourceIdBuilder();
        return builder.createPredicateResourceId(theSourceJoinColumn, theResourceName, theValues, theOperation, theRequestPartitionId);
    }

    private Condition createPredicateSourceForAndList(@Nullable DbColumn theSourceJoinColumn, List<List<IQueryParameterType>> theAndOrParams) {
        ArrayList<Condition> andPredicates = new ArrayList<Condition>(theAndOrParams.size());
        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
            andPredicates.add(this.createPredicateSource(theSourceJoinColumn, nextAnd));
        }
        return QueryStack.toAndPredicate(andPredicates);
    }

    private Condition createPredicateSource(@Nullable DbColumn theSourceJoinColumn, List<? extends IQueryParameterType> theList) {
        if (this.myDaoConfig.getStoreMetaSourceInformation() == DaoConfig.StoreMetaSourceInformationEnum.NONE) {
            String msg = this.myFhirContext.getLocalizer().getMessage(LegacySearchBuilder.class, "sourceParamDisabled", new Object[0]);
            throw new InvalidRequestException(msg);
        }
        SourcePredicateBuilder join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.SOURCE, theSourceJoinColumn, "_source", () -> this.mySqlBuilder.addSourcePredicateBuilder(theSourceJoinColumn)).getResult();
        ArrayList<Condition> orPredicates = new ArrayList<Condition>();
        for (IQueryParameterType iQueryParameterType : theList) {
            SourceParam sourceParameter = new SourceParam(iQueryParameterType.getValueAsQueryToken(this.myFhirContext));
            String sourceUri = sourceParameter.getSourceUri();
            String requestId = sourceParameter.getRequestId();
            if (StringUtils.isNotBlank((CharSequence)sourceUri) && StringUtils.isNotBlank((CharSequence)requestId)) {
                orPredicates.add(QueryStack.toAndPredicate(join.createPredicateSourceUri(sourceUri), join.createPredicateRequestId(requestId)));
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)sourceUri)) {
                orPredicates.add(join.createPredicateSourceUri(sourceUri));
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)requestId)) continue;
            orPredicates.add(join.createPredicateRequestId(requestId));
        }
        return QueryStack.toOrPredicate(orPredicates);
    }

    public Condition createPredicateString(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        String paramName = QueryStack.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        StringPredicateBuilder join = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.STRING, theSourceJoinColumn, paramName, () -> this.mySqlBuilder.addStringPredicateBuilder(theSourceJoinColumn)).getResult();
        if (theList.get(0).getMissing() != null) {
            return join.createPredicateParamMissingForNonReference(theResourceName, paramName, theList.get(0).getMissing(), theRequestPartitionId);
        }
        ArrayList<Condition> codePredicates = new ArrayList<Condition>();
        for (IQueryParameterType iQueryParameterType : theList) {
            Condition singleCode = join.createPredicateString(iQueryParameterType, theResourceName, theSpnamePrefix, theSearchParam, join, theOperation);
            codePredicates.add(singleCode);
        }
        return join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, QueryStack.toOrPredicate(codePredicates));
    }

    public Condition createPredicateTag(@Nullable DbColumn theSourceJoinColumn, List<List<IQueryParameterType>> theList, String theParamName, RequestPartitionId theRequestPartitionId) {
        TagTypeEnum tagType;
        if ("_tag".equals(theParamName)) {
            tagType = TagTypeEnum.TAG;
        } else if ("_profile".equals(theParamName)) {
            tagType = TagTypeEnum.PROFILE;
        } else if ("_security".equals(theParamName)) {
            tagType = TagTypeEnum.SECURITY_LABEL;
        } else {
            throw new IllegalArgumentException("Param name: " + theParamName);
        }
        ArrayList<Condition> andPredicates = new ArrayList<Condition>();
        for (List<IQueryParameterType> nextAndParams : theList) {
            Condition tagPredicate;
            BaseJoiningPredicateBuilder join;
            boolean haveTags = false;
            for (IQueryParameterType nextParamUncasted : nextAndParams) {
                TokenParam nextParam;
                if (nextParamUncasted instanceof TokenParam) {
                    nextParam = (TokenParam)nextParamUncasted;
                    if (StringUtils.isNotBlank((CharSequence)nextParam.getValue())) {
                        haveTags = true;
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)nextParam.getSystem())) continue;
                    throw new InvalidRequestException("Invalid " + theParamName + " parameter (must supply a value/code and not just a system): " + nextParam.getValueAsQueryToken(this.myFhirContext));
                }
                nextParam = (UriParam)nextParamUncasted;
                if (!StringUtils.isNotBlank((CharSequence)nextParam.getValue())) continue;
                haveTags = true;
            }
            if (!haveTags) continue;
            boolean paramInverted = false;
            ArrayList tokens = Lists.newArrayList();
            for (IQueryParameterType nextOrParams : nextAndParams) {
                String system;
                String code;
                TokenParam nextParam;
                if (nextOrParams instanceof TokenParam) {
                    nextParam = (TokenParam)nextOrParams;
                    code = nextParam.getValue();
                    system = nextParam.getSystem();
                    if (nextParam.getModifier() == TokenParamModifier.NOT) {
                        paramInverted = true;
                    }
                } else {
                    nextParam = (UriParam)nextOrParams;
                    code = nextParam.getValue();
                    system = null;
                }
                if (!StringUtils.isNotBlank((CharSequence)code)) continue;
                tokens.add(Pair.of((Object)system, (Object)code));
            }
            if (tokens.isEmpty()) continue;
            if (paramInverted) {
                SearchQueryBuilder sqlBuilder = this.mySqlBuilder.newChildSqlBuilder();
                TagPredicateBuilder tagSelector = sqlBuilder.addTagPredicateBuilder(null);
                sqlBuilder.addPredicate(tagSelector.createPredicateTag(tagType, tokens, theParamName, theRequestPartitionId));
                SelectQuery sql = sqlBuilder.getSelect();
                join = this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
                Subquery subSelect = new Subquery((Object)sql);
                tagPredicate = new InCondition((Object)join.getResourceIdColumn(), new Object[]{subSelect}).setNegate(true);
            } else {
                this.mySqlBuilder.getOrCreateFirstPredicateBuilder();
                TagPredicateBuilder tagJoin = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.TAG, theSourceJoinColumn, theParamName, () -> this.mySqlBuilder.addTagPredicateBuilder(theSourceJoinColumn)).getResult();
                tagPredicate = tagJoin.createPredicateTag(tagType, tokens, theParamName, theRequestPartitionId);
                join = tagJoin;
            }
            andPredicates.add(join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, tagPredicate));
        }
        return QueryStack.toAndPredicate(andPredicates);
    }

    public Condition createPredicateToken(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        ArrayList<IQueryParameterType> tokens = new ArrayList<IQueryParameterType>();
        for (IQueryParameterType iQueryParameterType : theList) {
            if (iQueryParameterType instanceof TokenParam) {
                if (((TokenParam)iQueryParameterType).isEmpty()) continue;
                TokenParam id = (TokenParam)iQueryParameterType;
                if (id.isText()) {
                    boolean tokenTextIndexingEnabled = BaseSearchParamExtractor.tokenTextIndexingEnabledForSearchParam((ModelConfig)this.myModelConfig, (RuntimeSearchParam)theSearchParam);
                    if (!tokenTextIndexingEnabled) {
                        String msg = this.myModelConfig.isSuppressStringIndexingInTokens() ? this.myFhirContext.getLocalizer().getMessage(PredicateBuilderToken.class, "textModifierDisabledForServer", new Object[0]) : this.myFhirContext.getLocalizer().getMessage(PredicateBuilderToken.class, "textModifierDisabledForSearchParam", new Object[0]);
                        throw new MethodNotAllowedException(msg);
                    }
                    return this.createPredicateString(theSourceJoinColumn, theResourceName, theSpnamePrefix, theSearchParam, theList, null, theRequestPartitionId);
                }
                tokens.add(iQueryParameterType);
                continue;
            }
            tokens.add(iQueryParameterType);
        }
        if (tokens.isEmpty()) {
            return null;
        }
        String paramName = QueryStack.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        TokenPredicateBuilder tokenPredicateBuilder = this.createOrReusePredicateBuilder(PredicateBuilderTypeEnum.TOKEN, theSourceJoinColumn, paramName, () -> this.mySqlBuilder.addTokenPredicateBuilder(theSourceJoinColumn)).getResult();
        if (theList.get(0).getMissing() != null) {
            return tokenPredicateBuilder.createPredicateParamMissingForNonReference(theResourceName, paramName, theList.get(0).getMissing(), theRequestPartitionId);
        }
        Condition predicate = tokenPredicateBuilder.createPredicateToken(tokens, theResourceName, theSpnamePrefix, theSearchParam, theOperation, theRequestPartitionId);
        return tokenPredicateBuilder.combineWithRequestPartitionIdPredicate(theRequestPartitionId, predicate);
    }

    public Condition createPredicateUri(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theSpnamePrefix, RuntimeSearchParam theSearchParam, List<? extends IQueryParameterType> theList, SearchFilterParser.CompareOperation theOperation, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        String paramName = QueryStack.getParamNameWithPrefix(theSpnamePrefix, theSearchParam.getName());
        UriPredicateBuilder join = this.mySqlBuilder.addUriPredicateBuilder(theSourceJoinColumn);
        if (theList.get(0).getMissing() != null) {
            return join.createPredicateParamMissingForNonReference(theResourceName, paramName, theList.get(0).getMissing(), theRequestPartitionId);
        }
        Condition predicate = join.addPredicate(theList, paramName, theOperation, theRequestDetails);
        return join.combineWithRequestPartitionIdPredicate(theRequestPartitionId, predicate);
    }

    public QueryStack newChildQueryFactoryWithFullBuilderReuse() {
        return new QueryStack(this.mySearchParameters, this.myDaoConfig, this.myModelConfig, this.myFhirContext, this.mySqlBuilder, this.mySearchParamRegistry, this.myPartitionSettings, EnumSet.allOf(PredicateBuilderTypeEnum.class));
    }

    @Nullable
    public Condition searchForIdsWithAndOr(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theParamName, List<List<IQueryParameterType>> theAndOrParams, RequestDetails theRequest, RequestPartitionId theRequestPartitionId, SearchContainedModeEnum theSearchContainedMode) {
        if (theAndOrParams.isEmpty()) {
            return null;
        }
        switch (theParamName) {
            case "_id": {
                return this.createPredicateResourceId(theSourceJoinColumn, theAndOrParams, theResourceName, null, theRequestPartitionId);
            }
            case "_language": {
                return this.createPredicateLanguage(theAndOrParams, null);
            }
            case "_has": {
                return this.createPredicateHas(theSourceJoinColumn, theResourceName, theAndOrParams, theRequest, theRequestPartitionId);
            }
            case "_tag": 
            case "_profile": 
            case "_security": {
                if (this.myDaoConfig.getTagStorageMode() == DaoConfig.TagStorageModeEnum.INLINE) {
                    return this.createPredicateSearchParameter(theSourceJoinColumn, theResourceName, theParamName, theAndOrParams, theRequest, theRequestPartitionId, theSearchContainedMode);
                }
                return this.createPredicateTag(theSourceJoinColumn, theAndOrParams, theParamName, theRequestPartitionId);
            }
            case "_source": {
                return this.createPredicateSourceForAndList(theSourceJoinColumn, theAndOrParams);
            }
        }
        return this.createPredicateSearchParameter(theSourceJoinColumn, theResourceName, theParamName, theAndOrParams, theRequest, theRequestPartitionId, theSearchContainedMode);
    }

    @Nullable
    private Condition createPredicateSearchParameter(@Nullable DbColumn theSourceJoinColumn, String theResourceName, String theParamName, List<List<IQueryParameterType>> theAndOrParams, RequestDetails theRequest, RequestPartitionId theRequestPartitionId, SearchContainedModeEnum theSearchContainedMode) {
        ArrayList<Condition> andPredicates;
        block35: {
            block34: {
                andPredicates = new ArrayList<Condition>();
                RuntimeSearchParam nextParamDef = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, theParamName);
                if (nextParamDef == null) break block34;
                if (this.myPartitionSettings.isPartitioningEnabled() && this.myPartitionSettings.isIncludePartitionInSearchHashes() && theRequestPartitionId.isAllPartitions()) {
                    throw new PreconditionFailedException("This server is not configured to support search against all partitions");
                }
                switch (nextParamDef.getParamType()) {
                    case DATE: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            SearchFilterParser.CompareOperation operation = null;
                            if (nextAnd.size() > 0) {
                                DateParam param = (DateParam)nextAnd.get(0);
                                operation = QueryStack.toOperation(param.getPrefix());
                            }
                            andPredicates.add(this.createPredicateDate(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, operation, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case QUANTITY: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            SearchFilterParser.CompareOperation operation = null;
                            if (nextAnd.size() > 0) {
                                QuantityParam param = (QuantityParam)nextAnd.get(0);
                                operation = QueryStack.toOperation(param.getPrefix());
                            }
                            andPredicates.add(this.createPredicateQuantity(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, operation, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case REFERENCE: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            if (this.isEligibleForContainedResourceSearch(nextAnd)) {
                                andPredicates.add(QueryStack.toOrPredicate(this.createPredicateReference(theSourceJoinColumn, theResourceName, theParamName, new ArrayList<String>(), nextAnd, null, theRequest, theRequestPartitionId), this.createPredicateReferenceForContainedResource(theSourceJoinColumn, theResourceName, theParamName, new ArrayList<String>(), nextParamDef, nextAnd, null, theRequest, theRequestPartitionId)));
                                continue;
                            }
                            andPredicates.add(this.createPredicateReference(theSourceJoinColumn, theResourceName, theParamName, new ArrayList<String>(), nextAnd, null, theRequest, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case STRING: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            andPredicates.add(this.createPredicateString(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, SearchFilterParser.CompareOperation.sw, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case TOKEN: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            if ("Location.position".equals(nextParamDef.getPath())) {
                                andPredicates.add(this.createPredicateCoords(theSourceJoinColumn, theResourceName, nextParamDef, nextAnd, theRequestPartitionId));
                                continue;
                            }
                            andPredicates.add(this.createPredicateToken(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, null, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case NUMBER: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            andPredicates.add(this.createPredicateNumber(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, null, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case COMPOSITE: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            andPredicates.add(this.createPredicateComposite(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case URI: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            andPredicates.add(this.createPredicateUri(theSourceJoinColumn, theResourceName, null, nextParamDef, nextAnd, SearchFilterParser.CompareOperation.eq, theRequest, theRequestPartitionId));
                        }
                        break block35;
                    }
                    case HAS: 
                    case SPECIAL: {
                        for (List<IQueryParameterType> nextAnd : theAndOrParams) {
                            if (!"Location.position".equals(nextParamDef.getPath())) continue;
                            andPredicates.add(this.createPredicateCoords(theSourceJoinColumn, theResourceName, nextParamDef, nextAnd, theRequestPartitionId));
                        }
                        break;
                    }
                }
                break block35;
            }
            if (!"_content".equals(theParamName) && !"_text".equals(theParamName)) {
                if ("_filter".equals(theParamName)) {
                    if (theAndOrParams.get(0).get(0) instanceof StringParam) {
                        SearchFilterParser.Filter filter;
                        String filterString = ((StringParam)theAndOrParams.get(0).get(0)).getValue();
                        try {
                            filter = SearchFilterParser.parse(filterString);
                        }
                        catch (SearchFilterParser.FilterSyntaxException theE) {
                            throw new InvalidRequestException("Error parsing _filter syntax: " + theE.getMessage());
                        }
                        if (filter != null) {
                            if (!this.myDaoConfig.isFilterParameterEnabled()) {
                                throw new InvalidRequestException("_filter parameter is disabled on this server");
                            }
                            Condition predicate = this.createPredicateFilter(this, filter, theResourceName, theRequest, theRequestPartitionId);
                            if (predicate != null) {
                                this.mySqlBuilder.addPredicate(predicate);
                            }
                        }
                    }
                } else {
                    String msg = this.myFhirContext.getLocalizer().getMessageSanitized(BaseHapiFhirResourceDao.class, "invalidSearchParameter", new Object[]{theParamName, theResourceName, this.mySearchParamRegistry.getValidSearchParameterNamesIncludingMeta(theResourceName)});
                    throw new InvalidRequestException(msg);
                }
            }
        }
        return QueryStack.toAndPredicate(andPredicates);
    }

    private boolean isEligibleForContainedResourceSearch(List<? extends IQueryParameterType> nextAnd) {
        return this.myModelConfig.isIndexOnContainedResources() && nextAnd.stream().filter(t -> t instanceof ReferenceParam).map(t -> ((ReferenceParam)t).getChain()).anyMatch(StringUtils::isNotBlank);
    }

    public void addPredicateCompositeUnique(String theIndexString, RequestPartitionId theRequestPartitionId) {
        ComboUniqueSearchParameterPredicateBuilder predicateBuilder = this.mySqlBuilder.addComboUniquePredicateBuilder();
        Condition predicate = predicateBuilder.createPredicateIndexString(theRequestPartitionId, theIndexString);
        this.mySqlBuilder.addPredicate(predicate);
    }

    public void addPredicateCompositeNonUnique(String theIndexString, RequestPartitionId theRequestPartitionId) {
        ComboNonUniqueSearchParameterPredicateBuilder predicateBuilder = this.mySqlBuilder.addComboNonUniquePredicateBuilder();
        Condition predicate = predicateBuilder.createPredicateHashComplete(theRequestPartitionId, theIndexString);
        this.mySqlBuilder.addPredicate(predicate);
    }

    public void addPredicateEverythingOperation(String theResourceName, Long theTargetPid) {
        ResourceLinkPredicateBuilder table = this.mySqlBuilder.addReferencePredicateBuilder(this, null);
        Condition predicate = table.createEverythingPredicate(theResourceName, theTargetPid);
        this.mySqlBuilder.addPredicate(predicate);
    }

    private IQueryParameterType toParameterType(RuntimeSearchParam theParam) {
        DateParam qp;
        switch (theParam.getParamType()) {
            case DATE: {
                qp = new DateParam();
                break;
            }
            case NUMBER: {
                qp = new NumberParam();
                break;
            }
            case QUANTITY: {
                qp = new QuantityParam();
                break;
            }
            case STRING: {
                qp = new StringParam();
                break;
            }
            case TOKEN: {
                qp = new TokenParam();
                break;
            }
            case COMPOSITE: {
                List compositeOf = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)theParam);
                if (compositeOf.size() != 2) {
                    throw new InternalErrorException("Parameter " + theParam.getName() + " has " + compositeOf.size() + " composite parts. Don't know how handlt this.");
                }
                IQueryParameterType leftParam = this.toParameterType((RuntimeSearchParam)compositeOf.get(0));
                IQueryParameterType rightParam = this.toParameterType((RuntimeSearchParam)compositeOf.get(1));
                qp = new CompositeParam(leftParam, rightParam);
                break;
            }
            case URI: {
                qp = new UriParam();
                break;
            }
            default: {
                throw new InvalidRequestException("The search type: " + theParam.getParamType() + " is not supported.");
            }
        }
        return qp;
    }

    @Nullable
    public static Condition toAndPredicate(List<Condition> theAndPredicates) {
        List<Condition> andPredicates = theAndPredicates.stream().filter(t -> t != null).collect(Collectors.toList());
        if (andPredicates.size() == 0) {
            return null;
        }
        if (andPredicates.size() == 1) {
            return (Condition)andPredicates.get(0);
        }
        return ComboCondition.and((Condition[])andPredicates.toArray(new Condition[0]));
    }

    @Nullable
    public static Condition toOrPredicate(List<Condition> theOrPredicates) {
        List<Condition> orPredicates = theOrPredicates.stream().filter(t -> t != null).collect(Collectors.toList());
        if (orPredicates.size() == 0) {
            return null;
        }
        if (orPredicates.size() == 1) {
            return (Condition)orPredicates.get(0);
        }
        return ComboCondition.or((Condition[])orPredicates.toArray(new Condition[0]));
    }

    @Nullable
    public static Condition toOrPredicate(Condition ... theOrPredicates) {
        return QueryStack.toOrPredicate(Arrays.asList(theOrPredicates));
    }

    @Nullable
    public static Condition toAndPredicate(Condition ... theAndPredicates) {
        return QueryStack.toAndPredicate(Arrays.asList(theAndPredicates));
    }

    @Nonnull
    public static Condition toEqualToOrInPredicate(DbColumn theColumn, List<String> theValuePlaceholders, boolean theInverse) {
        if (theInverse) {
            return QueryStack.toNotEqualToOrNotInPredicate(theColumn, theValuePlaceholders);
        }
        return QueryStack.toEqualToOrInPredicate(theColumn, theValuePlaceholders);
    }

    @Nonnull
    public static Condition toEqualToOrInPredicate(DbColumn theColumn, List<String> theValuePlaceholders) {
        if (theValuePlaceholders.size() == 1) {
            return BinaryCondition.equalTo((Object)theColumn, (Object)theValuePlaceholders.get(0));
        }
        return new InCondition((Object)theColumn, theValuePlaceholders);
    }

    @Nonnull
    public static Condition toNotEqualToOrNotInPredicate(DbColumn theColumn, List<String> theValuePlaceholders) {
        if (theValuePlaceholders.size() == 1) {
            return BinaryCondition.notEqualTo((Object)theColumn, (Object)theValuePlaceholders.get(0));
        }
        return new InCondition((Object)theColumn, theValuePlaceholders).setNegate(true);
    }

    public static SearchFilterParser.CompareOperation toOperation(ParamPrefixEnum thePrefix) {
        SearchFilterParser.CompareOperation retVal = null;
        if (thePrefix != null && ourCompareOperationToParamPrefix.containsValue((Object)thePrefix)) {
            retVal = (SearchFilterParser.CompareOperation)((Object)ourCompareOperationToParamPrefix.getKey((Object)thePrefix));
        }
        return (SearchFilterParser.CompareOperation)((Object)ObjectUtils.defaultIfNull(retVal, (Object)((Object)SearchFilterParser.CompareOperation.eq)));
    }

    public static ParamPrefixEnum fromOperation(SearchFilterParser.CompareOperation thePrefix) {
        ParamPrefixEnum retVal = null;
        if (thePrefix != null && ourCompareOperationToParamPrefix.containsKey((Object)thePrefix)) {
            retVal = (ParamPrefixEnum)ourCompareOperationToParamPrefix.get((Object)thePrefix);
        }
        return (ParamPrefixEnum)ObjectUtils.defaultIfNull(retVal, (Object)ParamPrefixEnum.EQUAL);
    }

    private static String getChainedPart(String parameter) {
        return parameter.substring(parameter.indexOf(".") + 1);
    }

    public static String getParamNameWithPrefix(String theSpnamePrefix, String theParamName) {
        if (StringUtils.isBlank((CharSequence)theSpnamePrefix)) {
            return theParamName;
        }
        return theSpnamePrefix + "." + theParamName;
    }

    static {
        DualHashBidiMap compareOperationToParamPrefix = new DualHashBidiMap();
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.ap, (Object)ParamPrefixEnum.APPROXIMATE);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.eq, (Object)ParamPrefixEnum.EQUAL);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.gt, (Object)ParamPrefixEnum.GREATERTHAN);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.ge, (Object)ParamPrefixEnum.GREATERTHAN_OR_EQUALS);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.lt, (Object)ParamPrefixEnum.LESSTHAN);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.le, (Object)ParamPrefixEnum.LESSTHAN_OR_EQUALS);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.ne, (Object)ParamPrefixEnum.NOT_EQUAL);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.eb, (Object)ParamPrefixEnum.ENDS_BEFORE);
        compareOperationToParamPrefix.put((Object)SearchFilterParser.CompareOperation.sa, (Object)ParamPrefixEnum.STARTS_AFTER);
        ourCompareOperationToParamPrefix = UnmodifiableBidiMap.unmodifiableBidiMap((BidiMap)compareOperationToParamPrefix);
    }

    private static enum PredicateBuilderTypeEnum {
        DATE,
        COORDS,
        NUMBER,
        QUANTITY,
        REFERENCE,
        SOURCE,
        STRING,
        TOKEN,
        TAG;

    }

    private static class PredicateBuilderCacheKey {
        private final DbColumn myDbColumn;
        private final PredicateBuilderTypeEnum myType;
        private final String myParamName;
        private final int myHashCode;

        private PredicateBuilderCacheKey(DbColumn theDbColumn, PredicateBuilderTypeEnum theType, String theParamName) {
            this.myDbColumn = theDbColumn;
            this.myType = theType;
            this.myParamName = theParamName;
            this.myHashCode = new HashCodeBuilder().append((Object)this.myDbColumn).append((Object)this.myType).append((Object)this.myParamName).toHashCode();
        }

        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (theO == null || this.getClass() != theO.getClass()) {
                return false;
            }
            PredicateBuilderCacheKey that = (PredicateBuilderCacheKey)theO;
            return new EqualsBuilder().append((Object)this.myDbColumn, (Object)that.myDbColumn).append((Object)this.myType, (Object)that.myType).append((Object)this.myParamName, (Object)that.myParamName).isEquals();
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }

    private static class PredicateBuilderCacheLookupResult<T extends BaseJoiningPredicateBuilder> {
        private final boolean myCacheHit;
        private final T myResult;

        private PredicateBuilderCacheLookupResult(boolean theCacheHit, T theResult) {
            this.myCacheHit = theCacheHit;
            this.myResult = theResult;
        }

        public boolean isCacheHit() {
            return this.myCacheHit;
        }

        public T getResult() {
            return this.myResult;
        }

        /* synthetic */ PredicateBuilderCacheLookupResult(boolean x0, BaseJoiningPredicateBuilder x1, 1 x2) {
            this(x0, x1);
        }
    }
}

