/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.LegacySearchBuilder;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.dao.predicate.SearchFuzzUtil;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseSearchParamPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.math.BigDecimal;
import java.math.MathContext;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class NumberPredicateBuilder
extends BaseSearchParamPredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(NumberPredicateBuilder.class);
    private final DbColumn myColumnValue = this.getTable().addColumn("SP_VALUE");
    @Autowired
    private FhirContext myFhirContext;

    public NumberPredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_SPIDX_NUMBER"));
    }

    public Condition createPredicateNumeric(String theResourceName, String theParamName, SearchFilterParser.CompareOperation theOperation, BigDecimal theValue, RequestPartitionId theRequestPartitionId, IQueryParameterType theActualParam) {
        Condition numericPredicate = NumberPredicateBuilder.createPredicateNumeric(this, theOperation, theValue, this.myColumnValue, "invalidNumberPrefix", this.myFhirContext, theActualParam);
        return this.combineWithHashIdentityPredicate(theResourceName, theParamName, numericPredicate);
    }

    public DbColumn getColumnValue() {
        return this.myColumnValue;
    }

    static Condition createPredicateNumeric(BaseSearchParamPredicateBuilder theIndexTable, SearchFilterParser.CompareOperation theOperation, BigDecimal theValue, DbColumn theColumn, String theInvalidValueKey, FhirContext theFhirContext, IQueryParameterType theActualParam) {
        BinaryCondition num;
        SearchFilterParser.CompareOperation operation = (SearchFilterParser.CompareOperation)((Object)ObjectUtils.defaultIfNull((Object)((Object)theOperation), (Object)((Object)SearchFilterParser.CompareOperation.eq)));
        switch (operation) {
            case gt: {
                num = BinaryCondition.greaterThan((Object)theColumn, (Object)theIndexTable.generatePlaceholder(theValue));
                break;
            }
            case ge: {
                num = BinaryCondition.greaterThanOrEq((Object)theColumn, (Object)theIndexTable.generatePlaceholder(theValue));
                break;
            }
            case lt: {
                num = BinaryCondition.lessThan((Object)theColumn, (Object)theIndexTable.generatePlaceholder(theValue));
                break;
            }
            case le: {
                num = BinaryCondition.lessThanOrEq((Object)theColumn, (Object)theIndexTable.generatePlaceholder(theValue));
                break;
            }
            case eq: {
                num = BinaryCondition.equalTo((Object)theColumn, (Object)theIndexTable.generatePlaceholder(theValue));
                break;
            }
            case ne: {
                num = BinaryCondition.notEqualTo((Object)theColumn, (Object)theIndexTable.generatePlaceholder(theValue));
                break;
            }
            case ap: {
                BigDecimal mul = SearchFuzzUtil.calculateFuzzAmount(ParamPrefixEnum.APPROXIMATE, theValue);
                BigDecimal low = theValue.subtract(mul, MathContext.DECIMAL64);
                BigDecimal high = theValue.add(mul, MathContext.DECIMAL64);
                BinaryCondition lowPred = BinaryCondition.greaterThanOrEq((Object)theColumn, (Object)theIndexTable.generatePlaceholder(low));
                BinaryCondition highPred = BinaryCondition.lessThanOrEq((Object)theColumn, (Object)theIndexTable.generatePlaceholder(high));
                num = ComboCondition.and((Condition[])new Condition[]{lowPred, highPred});
                ourLog.trace("Searching for {} <= val <= {}", (Object)low, (Object)high);
                break;
            }
            default: {
                String paramValue = theActualParam.getValueAsQueryToken(theFhirContext);
                String msg = theIndexTable.getFhirContext().getLocalizer().getMessage(LegacySearchBuilder.class, theInvalidValueKey, new Object[]{operation, paramValue});
                throw new InvalidRequestException(msg);
            }
        }
        return num;
    }
}

