/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildResourceDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.index.IdHelperService;
import ca.uhn.fhir.jpa.dao.predicate.PredicateBuilderReference;
import ca.uhn.fhir.jpa.dao.predicate.SearchFilterParser;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.jpa.search.builder.QueryStack;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.ResourceMetaParams;
import ca.uhn.fhir.jpa.searchparam.util.JpaParamUtil;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.CompositeParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.SpecialParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import com.google.common.collect.Lists;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ResourceLinkPredicateBuilder
extends BaseJoiningPredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceLinkPredicateBuilder.class);
    private final DbColumn myColumnSrcType;
    private final DbColumn myColumnSrcPath;
    private final DbColumn myColumnTargetResourceId;
    private final DbColumn myColumnTargetResourceUrl;
    private final DbColumn myColumnSrcResourceId = this.getTable().addColumn("SRC_RESOURCE_ID");
    private final DbColumn myColumnTargetResourceType;
    private final QueryStack myQueryStack;
    private final boolean myReversed;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    private IdHelperService myIdHelperService;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private MatchUrlService myMatchUrlService;

    public ResourceLinkPredicateBuilder(QueryStack theQueryStack, SearchQueryBuilder theSearchSqlBuilder, boolean theReversed) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_RES_LINK"));
        this.myColumnSrcType = this.getTable().addColumn("SOURCE_RESOURCE_TYPE");
        this.myColumnSrcPath = this.getTable().addColumn("SRC_PATH");
        this.myColumnTargetResourceId = this.getTable().addColumn("TARGET_RESOURCE_ID");
        this.myColumnTargetResourceUrl = this.getTable().addColumn("TARGET_RESOURCE_URL");
        this.myColumnTargetResourceType = this.getTable().addColumn("TARGET_RESOURCE_TYPE");
        this.myReversed = theReversed;
        this.myQueryStack = theQueryStack;
    }

    public DbColumn getColumnSourcePath() {
        return this.myColumnSrcPath;
    }

    public DbColumn getColumnTargetResourceId() {
        return this.myColumnTargetResourceId;
    }

    public DbColumn getColumnSrcResourceId() {
        return this.myColumnSrcResourceId;
    }

    public DbColumn getColumnTargetResourceType() {
        return this.myColumnTargetResourceType;
    }

    @Override
    public DbColumn getResourceIdColumn() {
        if (this.myReversed) {
            return this.myColumnTargetResourceId;
        }
        return this.myColumnSrcResourceId;
    }

    public Condition createPredicate(RequestDetails theRequest, String theResourceType, String theParamName, List<String> theQualifiers, List<? extends IQueryParameterType> theReferenceOrParamList, SearchFilterParser.CompareOperation theOperation, RequestPartitionId theRequestPartitionId) {
        ArrayList<IIdType> targetIds = new ArrayList<IIdType>();
        ArrayList<String> targetQualifiedUrls = new ArrayList<String>();
        for (int orIdx = 0; orIdx < theReferenceOrParamList.size(); ++orIdx) {
            IQueryParameterType nextOr = theReferenceOrParamList.get(orIdx);
            if (nextOr instanceof ReferenceParam) {
                ReferenceParam ref = (ReferenceParam)nextOr;
                if (StringUtils.isBlank((CharSequence)ref.getChain())) {
                    IdDt dt = new IdDt(ref.getBaseUrl(), ref.getResourceType(), ref.getIdPart(), null);
                    if (dt.hasBaseUrl()) {
                        if (this.myDaoConfig.getTreatBaseUrlsAsLocal().contains(dt.getBaseUrl())) {
                            dt = dt.toUnqualified();
                            targetIds.add((IIdType)dt);
                            continue;
                        }
                        targetQualifiedUrls.add(dt.getValue());
                        continue;
                    }
                    targetIds.add((IIdType)dt);
                    continue;
                }
                return this.addPredicateReferenceWithChain(theResourceType, theParamName, theQualifiers, theReferenceOrParamList, ref, theRequest, theRequestPartitionId);
            }
            throw new IllegalArgumentException("Invalid token type (expecting ReferenceParam): " + nextOr.getClass());
        }
        for (IIdType next : targetIds) {
            if (next.hasResourceType()) continue;
            this.warnAboutPerformanceOnUnqualifiedResources(theParamName, theRequest, null);
        }
        List<String> pathsToMatch = this.createResourceLinkPaths(theResourceType, theParamName, theQualifiers);
        boolean inverse = theOperation != null && theOperation != SearchFilterParser.CompareOperation.eq;
        List<ResourcePersistentId> targetPids = this.myIdHelperService.resolveResourcePersistentIdsWithCache(theRequestPartitionId, targetIds);
        List targetPidList = ResourcePersistentId.toLongList(targetPids);
        if (targetPidList.isEmpty() && targetQualifiedUrls.isEmpty()) {
            this.setMatchNothing();
            return null;
        }
        Condition retVal = this.createPredicateReference(inverse, pathsToMatch, targetPidList, targetQualifiedUrls);
        return this.combineWithRequestPartitionIdPredicate(this.getRequestPartitionId(), retVal);
    }

    private Condition createPredicateReference(boolean theInverse, List<String> thePathsToMatch, List<Long> theTargetPidList, List<String> theTargetQualifiedUrls) {
        Condition targetPidCondition = null;
        if (!theTargetPidList.isEmpty()) {
            List<String> placeholders = this.generatePlaceholders(theTargetPidList);
            targetPidCondition = QueryStack.toEqualToOrInPredicate(this.myColumnTargetResourceId, placeholders, theInverse);
        }
        Condition targetUrlsCondition = null;
        if (!theTargetQualifiedUrls.isEmpty()) {
            List<String> placeholders = this.generatePlaceholders(theTargetQualifiedUrls);
            targetUrlsCondition = QueryStack.toEqualToOrInPredicate(this.myColumnTargetResourceUrl, placeholders, theInverse);
        }
        Object joinedCondition = targetPidCondition != null && targetUrlsCondition != null ? ComboCondition.or((Condition[])new Condition[]{targetPidCondition, targetUrlsCondition}) : (targetPidCondition != null ? targetPidCondition : targetUrlsCondition);
        Condition pathPredicate = this.createPredicateSourcePaths(thePathsToMatch);
        joinedCondition = ComboCondition.and((Condition[])new Condition[]{pathPredicate, joinedCondition});
        return joinedCondition;
    }

    @Nonnull
    private Condition createPredicateSourcePaths(List<String> thePathsToMatch) {
        return QueryStack.toEqualToOrInPredicate(this.myColumnSrcPath, this.generatePlaceholders(thePathsToMatch));
    }

    public Condition createPredicateSourcePaths(String theResourceName, String theParamName, List<String> theQualifiers) {
        List<String> pathsToMatch = this.createResourceLinkPaths(theResourceName, theParamName, theQualifiers);
        return this.createPredicateSourcePaths(pathsToMatch);
    }

    private void warnAboutPerformanceOnUnqualifiedResources(String theParamName, RequestDetails theRequest, @Nullable List<String> theCandidateTargetTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append("This search uses an unqualified resource(a parameter in a chain without a resource type). ");
        builder.append("This is less efficient than using a qualified type. ");
        if (theCandidateTargetTypes != null) {
            builder.append("[" + theParamName + "] resolves to [" + theCandidateTargetTypes.stream().collect(Collectors.joining(",")) + "].");
            builder.append("If you know what you're looking for, try qualifying it using the form ");
            builder.append(theCandidateTargetTypes.stream().map(cls -> "[" + cls + ":" + theParamName + "]").collect(Collectors.joining(" or ")));
        } else {
            builder.append("If you know what you're looking for, try qualifying it using the form: '");
            builder.append(theParamName).append(":[resourceType]");
            builder.append("'");
        }
        String message = builder.toString();
        StorageProcessingMessage msg = new StorageProcessingMessage().setMessage(message);
        HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(StorageProcessingMessage.class, (Object)msg);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.JPA_PERFTRACE_WARNING, (HookParams)params);
    }

    private Condition addPredicateReferenceWithChain(String theResourceName, String theParamName, List<String> theQualifiers, List<? extends IQueryParameterType> theList, ReferenceParam theReferenceParam, RequestDetails theRequest, RequestPartitionId theRequestPartitionId) {
        List<String> resourceTypes = this.determineCandidateResourceTypesForChain(theResourceName, theParamName, theReferenceParam);
        if ("_type".equals(theReferenceParam.getChain())) {
            List<String> pathsToMatch = this.createResourceLinkPaths(theResourceName, theParamName, theQualifiers);
            Condition typeCondition = this.createPredicateSourcePaths(pathsToMatch);
            String typeValue = theReferenceParam.getValue();
            try {
                this.getFhirContext().getResourceDefinition(typeValue).getImplementingClass();
            }
            catch (DataFormatException e) {
                throw this.newInvalidResourceTypeException(typeValue);
            }
            if (!resourceTypes.contains(typeValue)) {
                throw this.newInvalidTargetTypeForChainException(theResourceName, theParamName, typeValue);
            }
            BinaryCondition condition = BinaryCondition.equalTo((Object)this.myColumnTargetResourceType, (Object)this.generatePlaceholder(theReferenceParam.getValue()));
            return QueryStack.toAndPredicate(new Condition[]{typeCondition, condition});
        }
        boolean foundChainMatch = false;
        ArrayList<String> candidateTargetTypes = new ArrayList<String>();
        ArrayList<Condition> orPredicates = new ArrayList<Condition>();
        boolean paramInverted = false;
        QueryStack childQueryFactory = this.myQueryStack.newChildQueryFactoryWithFullBuilderReuse();
        String chain = theReferenceParam.getChain();
        String remainingChain = null;
        int chainDotIndex = chain.indexOf(46);
        if (chainDotIndex != -1) {
            remainingChain = chain.substring(chainDotIndex + 1);
            chain = chain.substring(0, chainDotIndex);
        }
        int qualifierIndex = chain.indexOf(58);
        String qualifier = null;
        if (qualifierIndex != -1) {
            qualifier = chain.substring(qualifierIndex);
            chain = chain.substring(0, qualifierIndex);
        }
        boolean isMeta = ResourceMetaParams.RESOURCE_META_PARAMS.containsKey(chain);
        for (String nextType : resourceTypes) {
            RuntimeResourceDefinition typeDef = this.getFhirContext().getResourceDefinition(nextType);
            String subResourceName = typeDef.getName();
            IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(nextType);
            if (dao == null) {
                ourLog.debug("Don't have a DAO for type {}", (Object)nextType);
                continue;
            }
            RuntimeSearchParam param = null;
            if (!isMeta && (param = this.mySearchParamRegistry.getActiveSearchParam(nextType, chain)) == null) {
                ourLog.debug("Type {} doesn't have search param {}", (Object)nextType, (Object)param);
                continue;
            }
            ArrayList orValues = Lists.newArrayList();
            for (IQueryParameterType iQueryParameterType : theList) {
                String nextValue = iQueryParameterType.getValueAsQueryToken(this.getFhirContext());
                IQueryParameterType chainValue = this.mapReferenceChainToRawParamType(remainingChain, param, theParamName, qualifier, nextType, chain, isMeta, nextValue);
                if (chainValue == null) continue;
                if (!paramInverted && chainValue instanceof TokenParam && ((TokenParam)chainValue).getModifier() == TokenParamModifier.NOT) {
                    paramInverted = true;
                }
                foundChainMatch = true;
                orValues.add(chainValue);
            }
            if (!foundChainMatch) {
                throw new InvalidRequestException(this.getFhirContext().getLocalizer().getMessage(BaseHapiFhirResourceDao.class, "invalidParameterChain", new Object[]{theParamName + '.' + theReferenceParam.getChain()}));
            }
            candidateTargetTypes.add(nextType);
            ArrayList<Condition> andPredicates = new ArrayList<Condition>();
            List<List<IQueryParameterType>> list = Collections.singletonList(orValues);
            andPredicates.add(childQueryFactory.searchForIdsWithAndOr(this.myColumnTargetResourceId, subResourceName, chain, list, theRequest, theRequestPartitionId, SearchContainedModeEnum.FALSE));
            orPredicates.add(QueryStack.toAndPredicate(andPredicates));
        }
        if (candidateTargetTypes.isEmpty()) {
            throw new InvalidRequestException(this.getFhirContext().getLocalizer().getMessage(BaseHapiFhirResourceDao.class, "invalidParameterChain", new Object[]{theParamName + '.' + theReferenceParam.getChain()}));
        }
        if (candidateTargetTypes.size() > 1) {
            this.warnAboutPerformanceOnUnqualifiedResources(theParamName, theRequest, candidateTargetTypes);
        }
        Condition multiTypePredicate = paramInverted ? QueryStack.toAndPredicate(orPredicates) : QueryStack.toOrPredicate(orPredicates);
        List<String> pathsToMatch = this.createResourceLinkPaths(theResourceName, theParamName, theQualifiers);
        Condition pathPredicate = this.createPredicateSourcePaths(pathsToMatch);
        return QueryStack.toAndPredicate(pathPredicate, multiTypePredicate);
    }

    @Nonnull
    private List<String> determineCandidateResourceTypesForChain(String theResourceName, String theParamName, ReferenceParam theReferenceParam) {
        List<Class<? extends IBaseResource>> resourceTypes;
        block14: {
            block13: {
                if (theReferenceParam.hasResourceType()) break block13;
                resourceTypes = this.determineResourceTypes(Collections.singleton(theResourceName), theParamName);
                if (resourceTypes.isEmpty()) {
                    RuntimeSearchParam searchParamByName = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, theParamName);
                    if (searchParamByName == null) {
                        throw new InternalErrorException("Could not find parameter " + theParamName);
                    }
                    String paramPath = searchParamByName.getPath();
                    if (paramPath.endsWith(".as(Reference)")) {
                        paramPath = paramPath.substring(0, paramPath.length() - ".as(Reference)".length()) + "Reference";
                    }
                    if (paramPath.contains(".extension(")) {
                        int startIdx = paramPath.indexOf(".extension(");
                        int endIdx = paramPath.indexOf(41, startIdx);
                        if (startIdx != -1 && endIdx != -1) {
                            paramPath = paramPath.substring(0, startIdx + 10) + paramPath.substring(endIdx + 1);
                        }
                    }
                    Class resourceType = this.getFhirContext().getResourceDefinition(theResourceName).getImplementingClass();
                    BaseRuntimeChildDefinition def = this.getFhirContext().newTerser().getDefinition(resourceType, paramPath);
                    if (def instanceof RuntimeChildChoiceDefinition) {
                        RuntimeChildChoiceDefinition choiceDef = (RuntimeChildChoiceDefinition)def;
                        resourceTypes.addAll(choiceDef.getResourceTypes());
                    } else if (def instanceof RuntimeChildResourceDefinition) {
                        RuntimeChildResourceDefinition resDef = (RuntimeChildResourceDefinition)def;
                        resourceTypes.addAll(resDef.getResourceTypes());
                        if (resourceTypes.size() == 1 && resourceTypes.get(0).isInterface()) {
                            throw new InvalidRequestException("Unable to perform search for unqualified chain '" + theParamName + "' as this SearchParameter does not declare any target types. Add a qualifier of the form '" + theParamName + ":[ResourceType]' to perform this search.");
                        }
                    } else {
                        throw new ConfigurationException("Property " + paramPath + " of type " + this.getResourceType() + " is not a resource: " + def.getClass());
                    }
                }
                if (!resourceTypes.isEmpty()) break block14;
                for (BaseRuntimeElementDefinition next : this.getFhirContext().getElementDefinitions()) {
                    if (!(next instanceof RuntimeResourceDefinition)) continue;
                    RuntimeResourceDefinition nextResDef = (RuntimeResourceDefinition)next;
                    resourceTypes.add(nextResDef.getImplementingClass());
                }
                break block14;
            }
            try {
                RuntimeResourceDefinition resDef = this.getFhirContext().getResourceDefinition(theReferenceParam.getResourceType());
                resourceTypes = new ArrayList<Class<? extends IBaseResource>>(1);
                resourceTypes.add(resDef.getImplementingClass());
            }
            catch (DataFormatException e) {
                throw this.newInvalidResourceTypeException(theReferenceParam.getResourceType());
            }
        }
        return resourceTypes.stream().map(t -> this.getFhirContext().getResourceType(t)).collect(Collectors.toList());
    }

    private List<Class<? extends IBaseResource>> determineResourceTypes(Set<String> theResourceNames, String theParamNameChain) {
        int linkIndex = theParamNameChain.indexOf(46);
        if (linkIndex == -1) {
            HashSet<Class> resourceTypes = new HashSet<Class>();
            for (String resourceName : theResourceNames) {
                RuntimeSearchParam param = this.mySearchParamRegistry.getActiveSearchParam(resourceName, theParamNameChain);
                if (param == null || !param.hasTargets()) continue;
                Set targetTypes = param.getTargets();
                for (String next : targetTypes) {
                    resourceTypes.add(this.getFhirContext().getResourceDefinition(next).getImplementingClass());
                }
            }
            return new ArrayList<Class<? extends IBaseResource>>(resourceTypes);
        }
        String paramNameHead = theParamNameChain.substring(0, linkIndex);
        String paramNameTail = theParamNameChain.substring(linkIndex + 1);
        HashSet<String> targetResourceTypeNames = new HashSet<String>();
        for (String resourceName : theResourceNames) {
            RuntimeSearchParam param = this.mySearchParamRegistry.getActiveSearchParam(resourceName, paramNameHead);
            if (param == null || !param.hasTargets()) continue;
            targetResourceTypeNames.addAll(param.getTargets());
        }
        return this.determineResourceTypes(targetResourceTypeNames, paramNameTail);
    }

    public List<String> createResourceLinkPaths(String theResourceName, String theParamName, List<String> theParamQualifiers) {
        int linkIndex = theParamName.indexOf(46);
        if (linkIndex == -1) {
            RuntimeSearchParam param = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, theParamName);
            if (param == null) {
                return new ArrayList<String>();
            }
            ArrayList<String> path = param.getPathsSplit();
            path = new ArrayList<String>(path);
            ListIterator iter = path.listIterator();
            while (iter.hasNext()) {
                String nextPath = StringUtils.trim((String)((String)iter.next()));
                if (nextPath.contains(theResourceName + ".")) continue;
                iter.remove();
            }
            return path;
        }
        String paramNameHead = theParamName.substring(0, linkIndex);
        String paramNameTail = theParamName.substring(linkIndex + 1);
        String qualifier = theParamQualifiers.get(0);
        RuntimeSearchParam param = this.mySearchParamRegistry.getActiveSearchParam(theResourceName, paramNameHead);
        if (param == null) {
            return new ArrayList<String>();
        }
        Set tailPaths = param.getTargets().stream().filter(t -> StringUtils.isBlank((CharSequence)qualifier) || qualifier.equals(t)).map(t -> this.createResourceLinkPaths((String)t, paramNameTail, theParamQualifiers.subList(1, theParamQualifiers.size()))).flatMap(Collection::stream).map(t -> t.substring(t.indexOf(46) + 1)).collect(Collectors.toSet());
        List path = param.getPathsSplit();
        return path.stream().map(String::trim).filter(t -> t.startsWith(theResourceName + ".")).map(head -> tailPaths.stream().map(tail -> head + "." + tail).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private IQueryParameterType mapReferenceChainToRawParamType(String remainingChain, RuntimeSearchParam param, String theParamName, String qualifier, String nextType, String chain, boolean isMeta, String resourceId) {
        IQueryParameterType chainValue;
        if (remainingChain != null) {
            if (param == null || param.getParamType() != RestSearchParameterTypeEnum.REFERENCE) {
                ourLog.debug("Type {} parameter {} is not a reference, can not chain {}", new Object[]{nextType, chain, remainingChain});
                return null;
            }
            chainValue = new ReferenceParam();
            chainValue.setValueAsQueryToken(this.getFhirContext(), theParamName, qualifier, resourceId);
            ((ReferenceParam)chainValue).setChain(remainingChain);
        } else if (isMeta) {
            IQueryParameterType type = this.myMatchUrlService.newInstanceType(chain);
            type.setValueAsQueryToken(this.getFhirContext(), theParamName, qualifier, resourceId);
            chainValue = type;
        } else {
            chainValue = this.toParameterType(param, qualifier, resourceId);
        }
        return chainValue;
    }

    private IQueryParameterType toParameterType(RuntimeSearchParam theParam) {
        DateParam qp;
        switch (theParam.getParamType()) {
            case DATE: {
                qp = new DateParam();
                break;
            }
            case NUMBER: {
                qp = new NumberParam();
                break;
            }
            case QUANTITY: {
                qp = new QuantityParam();
                break;
            }
            case STRING: {
                qp = new StringParam();
                break;
            }
            case TOKEN: {
                qp = new TokenParam();
                break;
            }
            case COMPOSITE: {
                List compositeOf = JpaParamUtil.resolveComponentParameters((ISearchParamRegistry)this.mySearchParamRegistry, (RuntimeSearchParam)theParam);
                if (compositeOf.size() != 2) {
                    throw new InternalErrorException("Parameter " + theParam.getName() + " has " + compositeOf.size() + " composite parts. Don't know how handlt this.");
                }
                IQueryParameterType leftParam = this.toParameterType((RuntimeSearchParam)compositeOf.get(0));
                IQueryParameterType rightParam = this.toParameterType((RuntimeSearchParam)compositeOf.get(1));
                qp = new CompositeParam(leftParam, rightParam);
                break;
            }
            case REFERENCE: {
                qp = new ReferenceParam();
                break;
            }
            case SPECIAL: {
                if ("Location.position".equals(theParam.getPath())) {
                    qp = new SpecialParam();
                    break;
                }
                throw new InternalErrorException("Don't know how to convert param type: " + theParam.getParamType());
            }
            case URI: {
                qp = new UriParam();
                break;
            }
            default: {
                throw new InternalErrorException("Don't know how to convert param type: " + theParam.getParamType());
            }
        }
        return qp;
    }

    @Nonnull
    private InvalidRequestException newInvalidTargetTypeForChainException(String theResourceName, String theParamName, String theTypeValue) {
        String searchParamName = theResourceName + ":" + theParamName;
        String msg = this.getFhirContext().getLocalizer().getMessage(PredicateBuilderReference.class, "invalidTargetTypeForChain", new Object[]{theTypeValue, searchParamName});
        return new InvalidRequestException(msg);
    }

    private IQueryParameterType toParameterType(RuntimeSearchParam theParam, String theQualifier, String theValueAsQueryToken) {
        IQueryParameterType qp = this.toParameterType(theParam);
        qp.setValueAsQueryToken(this.getFhirContext(), theParam.getName(), theQualifier, theValueAsQueryToken);
        return qp;
    }

    @Nonnull
    private InvalidRequestException newInvalidResourceTypeException(String theResourceType) {
        String msg = this.getFhirContext().getLocalizer().getMessageSanitized(PredicateBuilderReference.class, "invalidResourceType", new Object[]{theResourceType});
        throw new InvalidRequestException(msg);
    }

    @Nonnull
    public Condition createEverythingPredicate(String theResourceName, Long theTargetPid) {
        if (theTargetPid != null) {
            return BinaryCondition.equalTo((Object)this.myColumnTargetResourceId, (Object)this.generatePlaceholder(theTargetPid));
        }
        return BinaryCondition.equalTo((Object)this.myColumnTargetResourceType, (Object)this.generatePlaceholder(theResourceName));
    }
}

