/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.SearchParamPresent;
import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchParamPresentPredicateBuilder
extends BaseJoiningPredicateBuilder {
    private final DbColumn myColumnResourceId = this.getTable().addColumn("RES_ID");
    private final DbColumn myColumnHashPresence = this.getTable().addColumn("HASH_PRESENCE");
    @Autowired
    private PartitionSettings myPartitionSettings;

    public SearchParamPresentPredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_RES_PARAM_PRESENT"));
    }

    @Override
    public DbColumn getResourceIdColumn() {
        return this.myColumnResourceId;
    }

    public Condition createPredicateParamMissingForReference(String theResourceName, String theParamName, boolean theMissing, RequestPartitionId theRequestPartitionId) {
        Long hash = SearchParamPresent.calculateHashPresence((PartitionSettings)this.myPartitionSettings, (RequestPartitionId)theRequestPartitionId, (String)theResourceName, (String)theParamName, (Boolean)(!theMissing ? 1 : 0));
        BinaryCondition predicate = BinaryCondition.equalTo((Object)this.myColumnHashPresence, (Object)this.generatePlaceholder(hash));
        return this.combineWithRequestPartitionIdPredicate(theRequestPartitionId, (Condition)predicate);
    }
}

