/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.builder.predicate;

import ca.uhn.fhir.jpa.search.builder.predicate.BaseJoiningPredicateBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SearchQueryBuilder;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourcePredicateBuilder
extends BaseJoiningPredicateBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(SourcePredicateBuilder.class);
    private final DbColumn myColumnSourceUri;
    private final DbColumn myColumnRequestId;
    private final DbColumn myResourceIdColumn = this.getTable().addColumn("RES_PID");

    public SourcePredicateBuilder(SearchQueryBuilder theSearchSqlBuilder) {
        super(theSearchSqlBuilder, theSearchSqlBuilder.addTable("HFJ_RES_VER_PROV"));
        this.myColumnSourceUri = this.getTable().addColumn("SOURCE_URI");
        this.myColumnRequestId = this.getTable().addColumn("REQUEST_ID");
    }

    @Override
    public DbColumn getResourceIdColumn() {
        return this.myResourceIdColumn;
    }

    public Condition createPredicateSourceUri(String theSourceUri) {
        return BinaryCondition.equalTo((Object)this.myColumnSourceUri, (Object)this.generatePlaceholder(theSourceUri));
    }

    public Condition createPredicateRequestId(String theRequestId) {
        return BinaryCondition.equalTo((Object)this.myColumnRequestId, (Object)this.generatePlaceholder(theRequestId));
    }
}

