/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.cache;

import ca.uhn.fhir.jpa.dao.data.ISearchResultDao;
import ca.uhn.fhir.jpa.entity.Search;
import ca.uhn.fhir.jpa.entity.SearchResult;
import ca.uhn.fhir.jpa.search.SearchCoordinatorSvcImpl;
import ca.uhn.fhir.jpa.search.cache.ISearchResultCacheSvc;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;

public class DatabaseSearchResultCacheSvcImpl
implements ISearchResultCacheSvc {
    private static final Logger ourLog = LoggerFactory.getLogger(DatabaseSearchResultCacheSvcImpl.class);
    @Autowired
    private ISearchResultDao mySearchResultDao;

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public List<ResourcePersistentId> fetchResultPids(Search theSearch, int theFrom, int theTo) {
        Pageable page = SearchCoordinatorSvcImpl.toPage(theFrom, theTo);
        if (page == null) {
            return Collections.emptyList();
        }
        List retVal = this.mySearchResultDao.findWithSearchPid(theSearch.getId(), page).getContent();
        ourLog.debug("fetchResultPids for range {}-{} returned {} pids", new Object[]{theFrom, theTo, retVal.size()});
        return ResourcePersistentId.fromLongList((List)retVal);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public List<ResourcePersistentId> fetchAllResultPids(Search theSearch) {
        List<Long> retVal = this.mySearchResultDao.findWithSearchPidOrderIndependent(theSearch.getId());
        ourLog.trace("fetchAllResultPids returned {} pids", (Object)retVal.size());
        return ResourcePersistentId.fromLongList(retVal);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void storeResults(Search theSearch, List<ResourcePersistentId> thePreviouslyStoredResourcePids, List<ResourcePersistentId> theNewResourcePids) {
        ArrayList resultsToSave = Lists.newArrayList();
        ourLog.trace("Storing {} results with {} previous for search", (Object)theNewResourcePids.size(), (Object)thePreviouslyStoredResourcePids.size());
        int order = thePreviouslyStoredResourcePids.size();
        for (ResourcePersistentId nextPid : theNewResourcePids) {
            SearchResult nextResult = new SearchResult(theSearch);
            nextResult.setResourcePid(nextPid.getIdAsLong());
            nextResult.setOrder(order);
            resultsToSave.add(nextResult);
            ourLog.trace("Saving ORDER[{}] Resource {}", (Object)order, (Object)nextResult.getResourcePid());
            ++order;
        }
        this.mySearchResultDao.saveAll(resultsToSave);
    }
}

