/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.elastic;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.jpa.search.elastic.HapiElasticsearchAnalysisConfigurer;
import ca.uhn.fhir.jpa.search.lastn.ElasticsearchRestClientFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.common.settings.Settings;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.engine.cfg.BackendSettings;
import org.hibernate.search.mapper.orm.schema.management.SchemaManagementStrategyName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchHibernatePropertiesBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(ElasticsearchHibernatePropertiesBuilder.class);
    private IndexStatus myRequiredIndexStatus = IndexStatus.YELLOW;
    private SchemaManagementStrategyName myIndexSchemaManagementStrategy = SchemaManagementStrategyName.CREATE;
    private String myRestUrl;
    private String myUsername;
    private String myPassword;
    private long myIndexManagementWaitTimeoutMillis = 10000L;
    private String myDebugSyncStrategy = "async";
    private boolean myDebugPrettyPrintJsonLog = false;
    private String myProtocol;

    public ElasticsearchHibernatePropertiesBuilder setUsername(String theUsername) {
        this.myUsername = theUsername;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setPassword(String thePassword) {
        this.myPassword = thePassword;
        return this;
    }

    public void apply(Properties theProperties) {
        theProperties.put(BackendSettings.backendKey((String)"type"), "elasticsearch");
        theProperties.put(BackendSettings.backendKey((String)"analysis.configurer"), HapiElasticsearchAnalysisConfigurer.class.getName());
        theProperties.put(BackendSettings.backendKey((String)"hosts"), this.myRestUrl);
        theProperties.put(BackendSettings.backendKey((String)"protocol"), this.myProtocol);
        if (StringUtils.isNotBlank((CharSequence)this.myUsername)) {
            theProperties.put(BackendSettings.backendKey((String)"username"), this.myUsername);
        }
        if (StringUtils.isNotBlank((CharSequence)this.myPassword)) {
            theProperties.put(BackendSettings.backendKey((String)"password"), this.myPassword);
        }
        theProperties.put("hibernate.search.schema_management.strategy", this.myIndexSchemaManagementStrategy.externalRepresentation());
        theProperties.put(BackendSettings.backendKey((String)"schema_management.minimal_required_status_wait_timeout"), Long.toString(this.myIndexManagementWaitTimeoutMillis));
        theProperties.put(BackendSettings.backendKey((String)"schema_management.minimal_required_status"), this.myRequiredIndexStatus.externalRepresentation());
        theProperties.put(BackendSettings.backendKey((String)"dynamic_mapping"), "true");
        theProperties.put("hibernate.search.automatic_indexing.synchronization.strategy", this.myDebugSyncStrategy);
        theProperties.put(BackendSettings.backendKey((String)"log.json_pretty_printing"), Boolean.toString(this.myDebugPrettyPrintJsonLog));
        this.injectStartupTemplate(this.myProtocol, this.myRestUrl, this.myUsername, this.myPassword);
    }

    public ElasticsearchHibernatePropertiesBuilder setRequiredIndexStatus(IndexStatus theRequiredIndexStatus) {
        this.myRequiredIndexStatus = theRequiredIndexStatus;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setRestUrl(String theRestUrl) {
        if (theRestUrl.contains("://")) {
            throw new ConfigurationException("Elasticsearch URL cannot include a protocol, that is a separate property. Remove http:// or https:// from this URL.");
        }
        this.myRestUrl = theRestUrl;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setProtocol(String theProtocol) {
        this.myProtocol = theProtocol;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setIndexSchemaManagementStrategy(SchemaManagementStrategyName theIndexSchemaManagementStrategy) {
        this.myIndexSchemaManagementStrategy = theIndexSchemaManagementStrategy;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setIndexManagementWaitTimeoutMillis(long theIndexManagementWaitTimeoutMillis) {
        this.myIndexManagementWaitTimeoutMillis = theIndexManagementWaitTimeoutMillis;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setDebugIndexSyncStrategy(String theSyncStrategy) {
        this.myDebugSyncStrategy = theSyncStrategy;
        return this;
    }

    public ElasticsearchHibernatePropertiesBuilder setDebugPrettyPrintJsonLog(boolean theDebugPrettyPrintJsonLog) {
        this.myDebugPrettyPrintJsonLog = theDebugPrettyPrintJsonLog;
        return this;
    }

    void injectStartupTemplate(String theProtocol, String theHostAndPort, String theUsername, String thePassword) {
        PutIndexTemplateRequest ngramTemplate = new PutIndexTemplateRequest("ngram-template").patterns(Arrays.asList("resourcetable-*", "termconcept-*")).settings(Settings.builder().put("index.max_ngram_diff", 50));
        int colonIndex = theHostAndPort.indexOf(":");
        String host = theHostAndPort.substring(0, colonIndex);
        Integer port = Integer.valueOf(theHostAndPort.substring(colonIndex + 1));
        String qualifiedHost = theProtocol + "://" + host;
        try {
            RestHighLevelClient elasticsearchHighLevelRestClient = ElasticsearchRestClientFactory.createElasticsearchHighLevelRestClient(qualifiedHost, port, theUsername, thePassword);
            ourLog.info("Adding starter template for large ngram diffs");
            AcknowledgedResponse acknowledgedResponse = elasticsearchHighLevelRestClient.indices().putTemplate(ngramTemplate, RequestOptions.DEFAULT);
            assert (acknowledgedResponse.isAcknowledged());
        }
        catch (IOException theE) {
            theE.printStackTrace();
            throw new ConfigurationException("Couldn't connect to the elasticsearch server to create necessary templates. Ensure the Elasticsearch user has permissions to create templates.");
        }
    }
}

