/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.helper;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchParamHelper {
    @Autowired
    private FhirContext myFhirContext;

    public Collection<RuntimeSearchParam> getPatientSearchParamsForResourceType(String theResourceType) {
        RuntimeSearchParam subjectSearchParam;
        RuntimeResourceDefinition runtimeResourceDefinition = this.myFhirContext.getResourceDefinition(theResourceType);
        HashMap<String, RuntimeSearchParam> searchParams = new HashMap<String, RuntimeSearchParam>();
        RuntimeSearchParam patientSearchParam = runtimeResourceDefinition.getSearchParam("patient");
        if (patientSearchParam != null) {
            searchParams.put(patientSearchParam.getName(), patientSearchParam);
        }
        if ((subjectSearchParam = runtimeResourceDefinition.getSearchParam("subject")) != null) {
            searchParams.put(subjectSearchParam.getName(), subjectSearchParam);
        }
        List<RuntimeSearchParam> compartmentSearchParams = this.getPatientCompartmentRuntimeSearchParams(runtimeResourceDefinition);
        compartmentSearchParams.forEach(param -> searchParams.put(param.getName(), (RuntimeSearchParam)param));
        return searchParams.values();
    }

    public List<RuntimeSearchParam> getPatientCompartmentRuntimeSearchParams(RuntimeResourceDefinition runtimeResourceDefinition) {
        ArrayList patientSearchParam = new ArrayList();
        List searchParams = runtimeResourceDefinition.getSearchParamsForCompartmentName("Patient");
        return searchParams;
    }
}

