/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.lastn;

import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticsearchRestClientFactory {
    private static String determineScheme(String theHostname) {
        int schemeIdx = theHostname.indexOf("://");
        if (schemeIdx > 0) {
            return theHostname.substring(0, schemeIdx);
        }
        return "http";
    }

    private static String stripHostOfScheme(String theHostname) {
        int schemeIdx = theHostname.indexOf("://");
        if (schemeIdx > 0) {
            return theHostname.substring(schemeIdx + 3);
        }
        return theHostname;
    }

    public static RestHighLevelClient createElasticsearchHighLevelRestClient(String theHostname, int thePort, String theUsername, String thePassword) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(theUsername, thePassword));
        RestClientBuilder clientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(ElasticsearchRestClientFactory.stripHostOfScheme(theHostname), thePort, ElasticsearchRestClientFactory.determineScheme(theHostname))}).setHttpClientConfigCallback(arg_0 -> ElasticsearchRestClientFactory.lambda$createElasticsearchHighLevelRestClient$0((CredentialsProvider)credentialsProvider, arg_0));
        Header[] defaultHeaders = new Header[]{new BasicHeader("Content-Type", "application/json")};
        clientBuilder.setDefaultHeaders(defaultHeaders);
        return new RestHighLevelClient(clientBuilder);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createElasticsearchHighLevelRestClient$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

