/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.lastn.json;

import ca.uhn.fhir.jpa.search.lastn.json.CodeJson;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ObservationJson {
    @JsonProperty(value="identifier", required=true)
    private String myIdentifier;
    @JsonProperty(value="subject", required=true)
    private String mySubject;
    @JsonProperty(value="categoryconcepttext", required=false)
    private List<String> myCategory_concept_text = new ArrayList<String>();
    @JsonProperty(value="categoryconceptcodingcode", required=false)
    private List<List<String>> myCategory_coding_code = new ArrayList<List<String>>();
    @JsonProperty(value="categoryconceptcodingcode_system_hash", required=false)
    private List<List<String>> myCategory_coding_code_system_hash = new ArrayList<List<String>>();
    @JsonProperty(value="categoryconceptcodingdisplay", required=false)
    private List<List<String>> myCategory_coding_display = new ArrayList<List<String>>();
    @JsonProperty(value="categoryconceptcodingsystem", required=false)
    private List<List<String>> myCategory_coding_system = new ArrayList<List<String>>();
    @JsonProperty(value="codeconceptid", required=false)
    private String myCode_concept_id;
    @JsonProperty(value="codeconcepttext", required=false)
    private String myCode_concept_text;
    @JsonProperty(value="codeconceptcodingcode", required=false)
    private String myCode_coding_code;
    @JsonProperty(value="codeconceptcodingcode_system_hash", required=false)
    private String myCode_coding_code_system_hash;
    @JsonProperty(value="codeconceptcodingdisplay", required=false)
    private String myCode_coding_display;
    @JsonProperty(value="codeconceptcodingsystem", required=false)
    private String myCode_coding_system;
    @JsonProperty(value="effectivedtm", required=true)
    private Date myEffectiveDtm;

    public void setIdentifier(String theIdentifier) {
        this.myIdentifier = theIdentifier;
    }

    public void setSubject(String theSubject) {
        this.mySubject = theSubject;
    }

    public void setCategories(List<CodeJson> theCategories) {
        for (CodeJson theConcept : theCategories) {
            this.myCategory_concept_text.add(theConcept.getCodeableConceptText());
            ArrayList<String> coding_code_system_hashes = new ArrayList<String>();
            ArrayList<String> coding_codes = new ArrayList<String>();
            ArrayList<String> coding_displays = new ArrayList<String>();
            ArrayList<String> coding_systems = new ArrayList<String>();
            for (String theCategoryCoding_code : theConcept.getCoding_code()) {
                coding_codes.add(theCategoryCoding_code);
            }
            for (String theCategoryCoding_system : theConcept.getCoding_system()) {
                coding_systems.add(theCategoryCoding_system);
            }
            for (String theCategoryCoding_code_system_hash : theConcept.getCoding_code_system_hash()) {
                coding_code_system_hashes.add(theCategoryCoding_code_system_hash);
            }
            for (String theCategoryCoding_display : theConcept.getCoding_display()) {
                coding_displays.add(theCategoryCoding_display);
            }
            this.myCategory_coding_code_system_hash.add(coding_code_system_hashes);
            this.myCategory_coding_code.add(coding_codes);
            this.myCategory_coding_display.add(coding_displays);
            this.myCategory_coding_system.add(coding_systems);
        }
    }

    public List<String> getCategory_concept_text() {
        return this.myCategory_concept_text;
    }

    public List<List<String>> getCategory_coding_code_system_hash() {
        return this.myCategory_coding_code_system_hash;
    }

    public List<List<String>> getCategory_coding_code() {
        return this.myCategory_coding_code;
    }

    public List<List<String>> getCategory_coding_display() {
        return this.myCategory_coding_display;
    }

    public List<List<String>> getCategory_coding_system() {
        return this.myCategory_coding_system;
    }

    public void setCode(CodeJson theCode) {
        this.myCode_concept_text = theCode.getCodeableConceptText();
        this.myCode_coding_code_system_hash = theCode.getCoding_code_system_hash().get(0);
        this.myCode_coding_code = theCode.getCoding_code().get(0);
        this.myCode_coding_display = theCode.getCoding_display().get(0);
        this.myCode_coding_system = theCode.getCoding_system().get(0);
    }

    public String getCode_concept_text() {
        return this.myCode_concept_text;
    }

    public String getCode_coding_code_system_hash() {
        return this.myCode_coding_code_system_hash;
    }

    public String getCode_coding_code() {
        return this.myCode_coding_code;
    }

    public String getCode_coding_display() {
        return this.myCode_coding_display;
    }

    public String getCode_coding_system() {
        return this.myCode_coding_system;
    }

    public void setCode_concept_id(String theCodeId) {
        this.myCode_concept_id = theCodeId;
    }

    public String getCode_concept_id() {
        return this.myCode_concept_id;
    }

    public void setEffectiveDtm(Date theEffectiveDtm) {
        this.myEffectiveDtm = theEffectiveDtm;
    }

    public Date getEffectiveDtm() {
        return this.myEffectiveDtm;
    }

    public String getSubject() {
        return this.mySubject;
    }

    public String getIdentifier() {
        return this.myIdentifier;
    }
}

