/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.reindex;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.dao.data.IForcedIdDao;
import ca.uhn.fhir.jpa.dao.data.IResourceHistoryTableDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.model.entity.ForcedId;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceReindexer {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceReindexer.class);
    @Autowired
    private IResourceHistoryTableDao myResourceHistoryTableDao;
    @Autowired
    private IForcedIdDao myForcedIdDao;
    @Autowired
    private IResourceTableDao myResourceTableDao;
    @Autowired
    private DaoRegistry myDaoRegistry;
    private final FhirContext myFhirContext;

    public ResourceReindexer(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    public void readAndReindexResourceByPid(Long theResourcePid) {
        ResourceTable resourceTable = (ResourceTable)this.myResourceTableDao.findById(theResourcePid).orElseThrow(IllegalStateException::new);
        this.reindexResourceEntity(resourceTable);
    }

    public void reindexResourceEntity(ResourceTable theResourceTable) {
        ForcedId forcedId = theResourceTable.getForcedId();
        if (forcedId != null && StringUtils.isBlank((CharSequence)forcedId.getResourceType())) {
            ourLog.info("Updating resource {} forcedId type to {}", (Object)forcedId.getForcedId(), (Object)theResourceTable.getResourceType());
            forcedId.setResourceType(theResourceTable.getResourceType());
            this.myForcedIdDao.save(forcedId);
        }
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(theResourceTable.getResourceType());
        long expectedVersion = theResourceTable.getVersion();
        IBaseResource resource = dao.readByPid(new ResourcePersistentId((Object)theResourceTable.getId()), true);
        if (resource == null) {
            throw new InternalErrorException("Could not find resource version " + theResourceTable.getIdDt().toUnqualified().getValue() + " in database");
        }
        Long actualVersion = resource.getIdElement().getVersionIdPartAsLong();
        if (actualVersion < expectedVersion) {
            ourLog.warn("Resource {} version {} does not exist, renumbering version {}", new Object[]{resource.getIdElement().toUnqualifiedVersionless().getValue(), resource.getIdElement().getVersionIdPart(), expectedVersion});
            this.myResourceHistoryTableDao.updateVersion(theResourceTable.getId(), actualVersion, expectedVersion);
        }
        this.doReindex(theResourceTable, resource);
    }

    <T extends IBaseResource> void doReindex(ResourceTable theResourceTable, T theResource) {
        RuntimeResourceDefinition resourceDefinition = this.myFhirContext.getResourceDefinition(theResource.getClass());
        Class resourceClass = resourceDefinition.getImplementingClass();
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceClass);
        dao.reindex(theResource, theResourceTable);
    }
}

