/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.search.reindex;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.dao.data.IForcedIdDao;
import ca.uhn.fhir.jpa.dao.data.IResourceReindexJobDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.entity.ResourceReindexJobEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.search.reindex.IResourceReindexingSvc;
import ca.uhn.fhir.jpa.search.reindex.ResourceReindexer;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.StopWatch;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.time.DateUtils;
import org.hl7.fhir.r4.model.InstantType;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Deprecated
public class ResourceReindexingSvcImpl
implements IResourceReindexingSvc {
    private static final Date BEGINNING_OF_TIME = new Date(0L);
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceReindexingSvcImpl.class);
    private static final int PASS_SIZE = 25000;
    private final ReentrantLock myIndexingLock = new ReentrantLock();
    @Autowired
    private IResourceReindexJobDao myReindexJobDao;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private PlatformTransactionManager myTxManager;
    private TransactionTemplate myTxTemplate;
    private final ThreadFactory myReindexingThreadFactory = new BasicThreadFactory.Builder().namingPattern("ResourceReindex-%d").build();
    private ThreadPoolExecutor myTaskExecutor;
    @Autowired
    private IResourceTableDao myResourceTableDao;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IForcedIdDao myForcedIdDao;
    @Autowired
    private FhirContext myContext;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    private EntityManager myEntityManager;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    private ISchedulerService mySchedulerService;
    @Autowired
    private ResourceReindexer myResourceReindexer;

    @VisibleForTesting
    void setDaoConfigForUnitTest(DaoConfig theDaoConfig) {
        this.myDaoConfig = theDaoConfig;
    }

    @VisibleForTesting
    void setContextForUnitTest(FhirContext theContext) {
        this.myContext = theContext;
    }

    @PostConstruct
    public void start() {
        this.myTxTemplate = new TransactionTemplate(this.myTxManager);
        this.initExecutor();
        this.scheduleJob();
    }

    public void initExecutor() {
        int reindexThreadCount = this.myDaoConfig.getReindexThreadCount();
        BlockPolicy rejectHandler = new BlockPolicy();
        this.myTaskExecutor = new ThreadPoolExecutor(0, reindexThreadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), this.myReindexingThreadFactory, rejectHandler);
    }

    public void scheduleJob() {
        ScheduledJobDefinition jobDetail = new ScheduledJobDefinition();
        jobDetail.setId(this.getClass().getName());
        jobDetail.setJobClass(Job.class);
        this.mySchedulerService.scheduleClusteredJob(10000L, jobDetail);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public Long markAllResourcesForReindexing() {
        return this.markAllResourcesForReindexing(null);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public Long markAllResourcesForReindexing(String theType) {
        String typeDesc;
        if (StringUtils.isNotBlank((CharSequence)theType)) {
            try {
                this.myContext.getResourceType(theType);
            }
            catch (DataFormatException e) {
                throw new InvalidRequestException("Unknown resource type: " + theType);
            }
            this.myReindexJobDao.markAllOfTypeAsDeleted(theType);
            typeDesc = theType;
        } else {
            this.myReindexJobDao.markAllOfTypeAsDeleted();
            typeDesc = "(any)";
        }
        ResourceReindexJobEntity job = new ResourceReindexJobEntity();
        job.setResourceType(theType);
        job.setThresholdHigh(DateUtils.addMinutes((Date)new Date(), (int)5));
        job = (ResourceReindexJobEntity)this.myReindexJobDao.saveAndFlush(job);
        ourLog.info("Marking all resources of type {} for reindexing - Got job ID[{}]", (Object)typeDesc, (Object)job.getId());
        return job.getId();
    }

    @VisibleForTesting
    ReentrantLock getIndexingLockForUnitTest() {
        return this.myIndexingLock;
    }

    @Override
    @Transactional(value=Transactional.TxType.NEVER)
    public Integer runReindexingPass() {
        if (this.myDaoConfig.isSchedulingDisabled() || !this.myDaoConfig.isEnableTaskPreExpandValueSets()) {
            return null;
        }
        if (this.myIndexingLock.tryLock()) {
            try {
                Integer n = this.doReindexingPassInsideLock();
                return n;
            }
            finally {
                this.myIndexingLock.unlock();
            }
        }
        return null;
    }

    private int doReindexingPassInsideLock() {
        this.expungeJobsMarkedAsDeleted();
        return this.runReindexJobs();
    }

    @Override
    public int forceReindexingPass() {
        this.myIndexingLock.lock();
        try {
            int n = this.doReindexingPassInsideLock();
            return n;
        }
        finally {
            this.myIndexingLock.unlock();
        }
    }

    @Override
    public void cancelAndPurgeAllJobs() {
        ourLog.info("Cancelling and purging all resource reindexing jobs");
        this.myIndexingLock.lock();
        try {
            this.myTxTemplate.execute(t -> {
                this.myReindexJobDao.markAllOfTypeAsDeleted();
                return null;
            });
            this.myTaskExecutor.shutdown();
            this.initExecutor();
            this.expungeJobsMarkedAsDeleted();
        }
        finally {
            this.myIndexingLock.unlock();
        }
    }

    private int runReindexJobs() {
        Collection<ResourceReindexJobEntity> jobs = this.getResourceReindexJobEntities();
        if (jobs.size() <= 0) {
            ourLog.debug("Running {} reindex jobs: {}", (Object)jobs.size(), jobs);
            return 0;
        }
        ourLog.info("Running {} reindex jobs: {}", (Object)jobs.size(), jobs);
        int count = 0;
        for (ResourceReindexJobEntity next : jobs) {
            if (next.getThresholdLow() != null && next.getThresholdLow().getTime() >= next.getThresholdHigh().getTime()) {
                this.markJobAsDeleted(next);
                continue;
            }
            count += this.runReindexJob(next);
        }
        return count;
    }

    @Override
    public int countReindexJobs() {
        return this.getResourceReindexJobEntities().size();
    }

    private Collection<ResourceReindexJobEntity> getResourceReindexJobEntities() {
        Collection jobs = (Collection)this.myTxTemplate.execute(t -> this.myReindexJobDao.findAll((Pageable)PageRequest.of((int)0, (int)10), false));
        assert (jobs != null);
        return jobs;
    }

    private void markJobAsDeleted(ResourceReindexJobEntity theJob) {
        ourLog.info("Marking reindexing job ID[{}] as deleted", (Object)theJob.getId());
        this.myTxTemplate.execute(t -> {
            this.myReindexJobDao.markAsDeletedById(theJob.getId());
            return null;
        });
    }

    @VisibleForTesting
    public void setResourceReindexerForUnitTest(ResourceReindexer theResourceReindexer) {
        this.myResourceReindexer = theResourceReindexer;
    }

    private int runReindexJob(ResourceReindexJobEntity theJob) {
        Date newLow;
        if (theJob.getSuspendedUntil() != null && theJob.getSuspendedUntil().getTime() > System.currentTimeMillis()) {
            return 0;
        }
        ourLog.info("Performing reindex pass for JOB[{}]", (Object)theJob.getId());
        StopWatch sw = new StopWatch();
        AtomicInteger counter = new AtomicInteger();
        if (theJob.getThresholdLow() == null) {
            this.mySearchParamRegistry.forceRefresh();
        }
        Date low = theJob.getThresholdLow() != null ? theJob.getThresholdLow() : BEGINNING_OF_TIME;
        Date high = theJob.getThresholdHigh();
        StopWatch pageSw = new StopWatch();
        Slice range = (Slice)this.myTxTemplate.execute(t -> {
            PageRequest page = PageRequest.of((int)0, (int)25000);
            if (StringUtils.isNotBlank((CharSequence)theJob.getResourceType())) {
                return this.myResourceTableDao.findIdsOfResourcesWithinUpdatedRangeOrderedFromOldest((Pageable)page, theJob.getResourceType(), low, high);
            }
            return this.myResourceTableDao.findIdsOfResourcesWithinUpdatedRangeOrderedFromOldest((Pageable)page, low, high);
        });
        Validate.notNull((Object)range);
        int count = range.getNumberOfElements();
        ourLog.info("Loaded {} resources for reindexing in {}", (Object)count, (Object)pageSw);
        if (count == 0) {
            this.markJobAsDeleted(theJob);
            return 0;
        }
        List futures = range.stream().map(t -> this.myTaskExecutor.submit(new ResourceReindexingTask((Long)t, counter))).collect(Collectors.toList());
        Date latestDate = null;
        for (Future next : futures) {
            Date nextDate;
            try {
                nextDate = (Date)next.get();
            }
            catch (Exception e) {
                ourLog.error("Failure reindexing", (Throwable)e);
                Date suspendedUntil = DateUtils.addMinutes((Date)new Date(), (int)1);
                this.myTxTemplate.execute(t -> {
                    this.myReindexJobDao.setSuspendedUntil(suspendedUntil);
                    return null;
                });
                return counter.get();
            }
            if (nextDate == null || latestDate != null && latestDate.getTime() >= nextDate.getTime()) continue;
            latestDate = new Date(nextDate.getTime());
        }
        Validate.notNull(latestDate);
        if (latestDate.getTime() == low.getTime()) {
            if (count == 25000) {
                ourLog.error("Final pass time for reindex JOB[{}] has same ending low value: {}", (Object)theJob.getId(), (Object)latestDate);
            }
            newLow = new Date(latestDate.getTime() + 1L);
        } else {
            newLow = latestDate;
        }
        this.myTxTemplate.execute(t -> {
            this.myReindexJobDao.setThresholdLow(theJob.getId(), newLow);
            Integer existingCount = this.myReindexJobDao.getReindexCount(theJob.getId()).orElse(0);
            int newCount = existingCount + counter.get();
            this.myReindexJobDao.setReindexCount(theJob.getId(), newCount);
            return null;
        });
        ourLog.info("Completed pass of reindex JOB[{}] - Indexed {} resources in {} ({} / sec) - Have indexed until: {}", new Object[]{theJob.getId(), count, sw, sw.formatThroughput((long)count, TimeUnit.SECONDS), new InstantType(newLow)});
        return counter.get();
    }

    private void expungeJobsMarkedAsDeleted() {
        this.myTxTemplate.execute(t -> {
            List<ResourceReindexJobEntity> toDelete = this.myReindexJobDao.findAll((Pageable)PageRequest.of((int)0, (int)10), true);
            toDelete.forEach(job -> {
                ourLog.info("Purging deleted job[{}]", (Object)job.getId());
                this.myReindexJobDao.deleteById(job.getId());
            });
            return null;
        });
    }

    private void markResourceAsIndexingFailed(long theId) {
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTxManager);
        txTemplate.setPropagationBehavior(3);
        txTemplate.execute(theStatus -> {
            ourLog.info("Marking resource with PID {} as indexing_failed", (Object)theId);
            this.myResourceTableDao.updateIndexStatus(theId, 2L);
            Query q = this.myEntityManager.createQuery("DELETE FROM ResourceTag t WHERE t.myResourceId = :id");
            q.setParameter("id", (Object)theId);
            q.executeUpdate();
            q = this.myEntityManager.createQuery("DELETE FROM ResourceIndexedSearchParamCoords t WHERE t.myResourcePid = :id");
            q.setParameter("id", (Object)theId);
            q.executeUpdate();
            q = this.myEntityManager.createQuery("DELETE FROM ResourceIndexedSearchParamDate t WHERE t.myResourcePid = :id");
            q.setParameter("id", (Object)theId);
            q.executeUpdate();
            q = this.myEntityManager.createQuery("DELETE FROM ResourceIndexedSearchParamNumber t WHERE t.myResourcePid = :id");
            q.setParameter("id", (Object)theId);
            q.executeUpdate();
            q = this.myEntityManager.createQuery("DELETE FROM ResourceIndexedSearchParamQuantity t WHERE t.myResourcePid = :id");
            q.setParameter("id", (Object)theId);
            q.executeUpdate();
            q = this.myEntityManager.createQuery("DELETE FROM ResourceIndexedSearchParamQuantityNormalized t WHERE t.myResourcePid = :id");
            q.setParameter("id", (Object)theId);
            q.executeUpdate();
            q = this.myEntityManager.createQuery("DELETE FROM ResourceIndexedSearchParamString t WHERE t.myResourcePid = :id");
            q.setParameter("id", (Object)theId);
            q.executeUpdate();
            q = this.myEntityManager.createQuery("DELETE FROM ResourceIndexedSearchParamToken t WHERE t.myResourcePid = :id");
            q.setParameter("id", (Object)theId);
            q.executeUpdate();
            q = this.myEntityManager.createQuery("DELETE FROM ResourceIndexedSearchParamUri t WHERE t.myResourcePid = :id");
            q.setParameter("id", (Object)theId);
            q.executeUpdate();
            q = this.myEntityManager.createQuery("DELETE FROM ResourceLink t WHERE t.mySourceResourcePid = :id");
            q.setParameter("id", (Object)theId);
            q.executeUpdate();
            q = this.myEntityManager.createQuery("DELETE FROM ResourceLink t WHERE t.myTargetResourcePid = :id");
            q.setParameter("id", (Object)theId);
            q.executeUpdate();
            return null;
        });
    }

    public static class BlockPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            try {
                e.getQueue().put(r);
            }
            catch (InterruptedException e1) {
                ourLog.error("Interrupted Execption for task: {}", (Object)r, (Object)e1);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static class Job
    implements HapiJob {
        @Autowired
        private IResourceReindexingSvc myTarget;

        public void execute(JobExecutionContext theContext) {
            this.myTarget.runReindexingPass();
        }
    }

    private class ResourceReindexingTask
    implements Callable<Date> {
        private final Long myNextId;
        private final AtomicInteger myCounter;
        private Date myUpdated;

        ResourceReindexingTask(Long theNextId, AtomicInteger theCounter) {
            this.myNextId = theNextId;
            this.myCounter = theCounter;
        }

        @Override
        public Date call() {
            Throwable reindexFailure;
            try {
                reindexFailure = this.readResourceAndReindex();
            }
            catch (ResourceVersionConflictException e) {
                ourLog.info("Failed to reindex because of a version conflict. Leaving in unindexed state: {}", (Object)e.getMessage());
                reindexFailure = null;
            }
            if (reindexFailure != null) {
                ourLog.info("Setting resource PID[{}] status to ERRORED", (Object)this.myNextId);
                ResourceReindexingSvcImpl.this.markResourceAsIndexingFailed(this.myNextId);
            }
            return this.myUpdated;
        }

        @Nullable
        private Throwable readResourceAndReindex() {
            Throwable reindexFailure = (Throwable)ResourceReindexingSvcImpl.this.myTxTemplate.execute(t -> {
                ResourceTable resourceTable = (ResourceTable)ResourceReindexingSvcImpl.this.myResourceTableDao.findById(this.myNextId).orElseThrow(IllegalStateException::new);
                this.myUpdated = resourceTable.getUpdatedDate();
                try {
                    ResourceReindexingSvcImpl.this.myResourceReindexer.reindexResourceEntity(resourceTable);
                    this.myCounter.incrementAndGet();
                    return null;
                }
                catch (Exception e) {
                    ourLog.error("Failed to index resource {}: {}", new Object[]{resourceTable.getIdDt(), e, e});
                    t.setRollbackOnly();
                    return e;
                }
            });
            return reindexFailure;
        }
    }
}

