/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.sp;

import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.dao.data.ISearchParamPresentDao;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.SearchParamPresent;
import ca.uhn.fhir.jpa.sp.ISearchParamPresenceSvc;
import ca.uhn.fhir.jpa.util.AddRemoveCount;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchParamPresenceSvcImpl
implements ISearchParamPresenceSvc {
    @Autowired
    private ISearchParamPresentDao mySearchParamPresentDao;
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired
    private DaoConfig myDaoConfig;

    @VisibleForTesting
    public void setDaoConfig(DaoConfig theDaoConfig) {
        this.myDaoConfig = theDaoConfig;
    }

    @Override
    public AddRemoveCount updatePresence(ResourceTable theResource, Map<String, Boolean> theParamNameToPresence) {
        AddRemoveCount retVal = new AddRemoveCount();
        if (this.myDaoConfig.getIndexMissingFields() == DaoConfig.IndexEnabledEnum.DISABLED) {
            return retVal;
        }
        HashMap<String, Boolean> presenceMap = new HashMap<String, Boolean>(theParamNameToPresence);
        List<SearchParamPresent> existing = this.mySearchParamPresentDao.findAllForResource(theResource);
        HashMap<Long, SearchParamPresent> existingHashToPresence = new HashMap<Long, SearchParamPresent>();
        for (SearchParamPresent searchParamPresent : existing) {
            existingHashToPresence.put(searchParamPresent.getHashPresence(), searchParamPresent);
        }
        HashMap<Long, SearchParamPresent> newHashToPresence = new HashMap<Long, SearchParamPresent>();
        for (Map.Entry entry : presenceMap.entrySet()) {
            String string = (String)entry.getKey();
            SearchParamPresent present = new SearchParamPresent();
            present.setPartitionSettings(this.myPartitionSettings);
            present.setResource(theResource);
            present.setParamName(string);
            present.setPresent(((Boolean)entry.getValue()).booleanValue());
            present.setPartitionId(theResource.getPartitionId());
            present.calculateHashes();
            newHashToPresence.put(present.getHashPresence(), present);
        }
        ArrayList<SearchParamPresent> arrayList = new ArrayList<SearchParamPresent>();
        for (Map.Entry entry : existingHashToPresence.entrySet()) {
            if (newHashToPresence.containsKey(entry.getKey())) continue;
            arrayList.add((SearchParamPresent)entry.getValue());
        }
        this.mySearchParamPresentDao.deleteAll(arrayList);
        retVal.addToRemoveCount(arrayList.size());
        ArrayList<SearchParamPresent> arrayList2 = new ArrayList<SearchParamPresent>();
        for (Map.Entry nextEntry : newHashToPresence.entrySet()) {
            if (existingHashToPresence.containsKey(nextEntry.getKey())) continue;
            arrayList2.add((SearchParamPresent)nextEntry.getValue());
        }
        this.mySearchParamPresentDao.saveAll(arrayList2);
        retVal.addToRemoveCount(arrayList2.size());
        return retVal;
    }
}

