/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoCodeSystem;
import ca.uhn.fhir.jpa.config.HibernatePropertiesProvider;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.data.ITermCodeSystemDao;
import ca.uhn.fhir.jpa.dao.data.ITermCodeSystemVersionDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptDesignationDao;
import ca.uhn.fhir.jpa.dao.data.ITermConceptPropertyDao;
import ca.uhn.fhir.jpa.dao.data.ITermValueSetConceptDao;
import ca.uhn.fhir.jpa.dao.data.ITermValueSetConceptDesignationDao;
import ca.uhn.fhir.jpa.dao.data.ITermValueSetConceptViewDao;
import ca.uhn.fhir.jpa.dao.data.ITermValueSetConceptViewOracleDao;
import ca.uhn.fhir.jpa.dao.data.ITermValueSetDao;
import ca.uhn.fhir.jpa.entity.ITermValueSetConceptView;
import ca.uhn.fhir.jpa.entity.TermCodeSystem;
import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptDesignation;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.jpa.entity.TermConceptProperty;
import ca.uhn.fhir.jpa.entity.TermConceptPropertyTypeEnum;
import ca.uhn.fhir.jpa.entity.TermValueSet;
import ca.uhn.fhir.jpa.entity.TermValueSetConcept;
import ca.uhn.fhir.jpa.entity.TermValueSetPreExpansionStatusEnum;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.jpa.search.builder.SearchBuilder;
import ca.uhn.fhir.jpa.term.ExpansionFilter;
import ca.uhn.fhir.jpa.term.IValueSetConceptAccumulator;
import ca.uhn.fhir.jpa.term.ValueSetConceptAccumulator;
import ca.uhn.fhir.jpa.term.ValueSetExpansionComponentWithConceptAccumulator;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermConceptMappingSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermReadSvc;
import ca.uhn.fhir.jpa.term.ex.ExpansionTooCostlyException;
import ca.uhn.fhir.jpa.util.LogicUtil;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.util.CoverageIgnore;
import ca.uhn.fhir.util.FhirVersionIndependentConcept;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.UrlUtil;
import ca.uhn.fhir.util.ValidateUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ArrayListMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.hibernate.dialect.Oracle12cDialect;
import org.hibernate.search.backend.elasticsearch.ElasticsearchExtension;
import org.hibernate.search.backend.elasticsearch.search.predicate.dsl.ElasticsearchSearchPredicateFactory;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.search.predicate.dsl.LuceneSearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.BooleanPredicateClausesStep;
import org.hibernate.search.engine.search.predicate.dsl.PhrasePredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactoryExtension;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.mapper.orm.Search;
import org.hibernate.search.mapper.orm.session.SearchSession;
import org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService;
import org.hl7.fhir.common.hapi.validation.support.InMemoryTerminologyServerValidationSupport;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.model.codesystems.ConceptSubsumptionOutcome;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.comparator.Comparators;

public abstract class BaseTermReadSvcImpl
implements ITermReadSvc {
    public static final int DEFAULT_FETCH_SIZE = 250;
    private static final int SINGLE_FETCH_SIZE = 1;
    private static final Logger ourLog = LoggerFactory.getLogger(BaseTermReadSvcImpl.class);
    private static final ValueSetExpansionOptions DEFAULT_EXPANSION_OPTIONS = new ValueSetExpansionOptions();
    private static final TermCodeSystemVersion NO_CURRENT_VERSION = new TermCodeSystemVersion().setId(-1L);
    private static Runnable myInvokeOnNextCallForUnitTest;
    private final Cache<String, TermCodeSystemVersion> myCodeSystemCurrentVersionCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    @Autowired
    protected DaoRegistry myDaoRegistry;
    @Autowired
    protected ITermCodeSystemDao myCodeSystemDao;
    @Autowired
    protected ITermConceptDao myConceptDao;
    @Autowired
    protected ITermConceptPropertyDao myConceptPropertyDao;
    @Autowired
    protected ITermConceptDesignationDao myConceptDesignationDao;
    @Autowired
    protected ITermValueSetDao myValueSetDao;
    @Autowired
    protected ITermValueSetConceptDao myValueSetConceptDao;
    @Autowired
    protected ITermValueSetConceptDesignationDao myValueSetConceptDesignationDao;
    @Autowired
    protected FhirContext myContext;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    private ITermCodeSystemVersionDao myCodeSystemVersionDao;
    @Autowired
    private DaoConfig myDaoConfig;
    private TransactionTemplate myTxTemplate;
    @Autowired
    private PlatformTransactionManager myTransactionManager;
    @Autowired(required=false)
    private IFulltextSearchSvc myFulltextSearchSvc;
    @Autowired
    private PlatformTransactionManager myTxManager;
    @Autowired
    private ITermValueSetConceptViewDao myTermValueSetConceptViewDao;
    @Autowired
    private ITermValueSetConceptViewOracleDao myTermValueSetConceptViewOracleDao;
    @Autowired
    private ISchedulerService mySchedulerService;
    @Autowired(required=false)
    private ITermDeferredStorageSvc myDeferredStorageSvc;
    @Autowired(required=false)
    private ITermCodeSystemStorageSvc myConceptStorageSvc;
    @Autowired
    private ApplicationContext myApplicationContext;
    @Autowired
    private ITermConceptMappingSvc myTermConceptMappingSvc;
    private volatile IValidationSupport myJpaValidationSupport;
    private volatile IValidationSupport myValidationSupport;
    @Autowired
    private HibernatePropertiesProvider myHibernatePropertiesProvider;

    private boolean isFullTextSetToUseElastic() {
        return "elasticsearch".equalsIgnoreCase(this.myHibernatePropertiesProvider.getHibernateSearchBackend());
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        TermCodeSystemVersion cs = this.getCurrentCodeSystemVersion(theSystem);
        return cs != null;
    }

    private boolean addCodeIfNotAlreadyAdded(IValueSetConceptAccumulator theValueSetCodeAccumulator, Set<String> theAddedCodes, TermConcept theConcept, boolean theAdd, String theValueSetIncludeVersion) {
        String codeSystem = theConcept.getCodeSystemVersion().getCodeSystem().getCodeSystemUri();
        String code = theConcept.getCode();
        String display = theConcept.getDisplay();
        Long sourceConceptPid = theConcept.getId();
        String directParentPids = theConcept.getParents().stream().map(t -> t.getParent().getId().toString()).collect(Collectors.joining(" "));
        Collection<TermConceptDesignation> designations = theConcept.getDesignations();
        if (StringUtils.isNotEmpty((CharSequence)theValueSetIncludeVersion)) {
            return this.addCodeIfNotAlreadyAdded(theValueSetCodeAccumulator, theAddedCodes, designations, theAdd, codeSystem + "|" + theValueSetIncludeVersion, code, display, sourceConceptPid, directParentPids);
        }
        return this.addCodeIfNotAlreadyAdded(theValueSetCodeAccumulator, theAddedCodes, designations, theAdd, codeSystem, code, display, sourceConceptPid, directParentPids);
    }

    private void addCodeIfNotAlreadyAdded(IValueSetConceptAccumulator theValueSetCodeAccumulator, Set<String> theAddedCodes, boolean theAdd, String theCodeSystem, String theCodeSystemVersion, String theCode, String theDisplay, Long theSourceConceptPid, String theSourceConceptDirectParentPids) {
        if (StringUtils.isNotEmpty((CharSequence)theCodeSystemVersion)) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{theCodeSystem, theCode})) {
                if (theAdd && theAddedCodes.add(theCodeSystem + "|" + theCode)) {
                    theValueSetCodeAccumulator.includeConceptWithDesignations(theCodeSystem + "|" + theCodeSystemVersion, theCode, theDisplay, null, theSourceConceptPid, theSourceConceptDirectParentPids);
                }
                if (!theAdd && theAddedCodes.remove(theCodeSystem + "|" + theCode)) {
                    theValueSetCodeAccumulator.excludeConcept(theCodeSystem + "|" + theCodeSystemVersion, theCode);
                }
            }
        } else {
            if (theAdd && theAddedCodes.add(theCodeSystem + "|" + theCode)) {
                theValueSetCodeAccumulator.includeConceptWithDesignations(theCodeSystem, theCode, theDisplay, null, theSourceConceptPid, theSourceConceptDirectParentPids);
            }
            if (!theAdd && theAddedCodes.remove(theCodeSystem + "|" + theCode)) {
                theValueSetCodeAccumulator.excludeConcept(theCodeSystem, theCode);
            }
        }
    }

    private boolean addCodeIfNotAlreadyAdded(IValueSetConceptAccumulator theValueSetCodeAccumulator, Set<String> theAddedCodes, Collection<TermConceptDesignation> theDesignations, boolean theAdd, String theCodeSystem, String theCode, String theDisplay, Long theSourceConceptPid, String theSourceConceptDirectParentPids) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{theCodeSystem, theCode})) {
            if (theAdd && theAddedCodes.add(theCodeSystem + "|" + theCode)) {
                theValueSetCodeAccumulator.includeConceptWithDesignations(theCodeSystem, theCode, theDisplay, theDesignations, theSourceConceptPid, theSourceConceptDirectParentPids);
                return true;
            }
            if (!theAdd && theAddedCodes.remove(theCodeSystem + "|" + theCode)) {
                theValueSetCodeAccumulator.excludeConcept(theCodeSystem, theCode);
                return true;
            }
        }
        return false;
    }

    private void addConceptsToList(IValueSetConceptAccumulator theValueSetCodeAccumulator, Set<String> theAddedCodes, String theSystem, List<CodeSystem.ConceptDefinitionComponent> theConcept, boolean theAdd, @Nonnull ExpansionFilter theExpansionFilter) {
        for (CodeSystem.ConceptDefinitionComponent next : theConcept) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{theSystem, next.getCode()}) && (!theExpansionFilter.hasCode() || theExpansionFilter.getCode().equals(next.getCode()))) {
                this.addOrRemoveCode(theValueSetCodeAccumulator, theAddedCodes, theAdd, theSystem, next.getCode(), next.getDisplay());
            }
            this.addConceptsToList(theValueSetCodeAccumulator, theAddedCodes, theSystem, next.getConcept(), theAdd, theExpansionFilter);
        }
    }

    private boolean addToSet(Set<TermConcept> theSetToPopulate, TermConcept theConcept) {
        boolean retVal = theSetToPopulate.add(theConcept);
        if (retVal && theSetToPopulate.size() >= this.myDaoConfig.getMaximumExpansionSize()) {
            String msg = this.myContext.getLocalizer().getMessage(BaseTermReadSvcImpl.class, "expansionTooLarge", new Object[]{this.myDaoConfig.getMaximumExpansionSize()});
            throw new ExpansionTooCostlyException(msg);
        }
        return retVal;
    }

    @VisibleForTesting
    public void clearCaches() {
        this.myCodeSystemCurrentVersionCache.invalidateAll();
    }

    public void deleteValueSetForResource(ResourceTable theResourceTable) {
        Optional<TermValueSet> optionalExistingTermValueSetById = this.myValueSetDao.findByResourcePid(theResourceTable.getId());
        if (optionalExistingTermValueSetById.isPresent()) {
            TermValueSet existingTermValueSet = optionalExistingTermValueSetById.get();
            ourLog.info("Deleting existing TermValueSet[{}] and its children...", (Object)existingTermValueSet.getId());
            this.myValueSetConceptDesignationDao.deleteByTermValueSetId(existingTermValueSet.getId());
            this.myValueSetConceptDao.deleteByTermValueSetId(existingTermValueSet.getId());
            this.myValueSetDao.deleteById(existingTermValueSet.getId());
            ourLog.info("Done deleting existing TermValueSet[{}] and its children.", (Object)existingTermValueSet.getId());
        }
    }

    @Override
    @Transactional
    public void deleteValueSetAndChildren(ResourceTable theResourceTable) {
        this.deleteValueSetForResource(theResourceTable);
    }

    @Override
    @Transactional
    public List<FhirVersionIndependentConcept> expandValueSetIntoConceptList(@Nullable ValueSetExpansionOptions theExpansionOptions, @Nonnull String theValueSetCanonicalUrl) {
        ValueSet expanded = this.expandValueSet(theExpansionOptions, theValueSetCanonicalUrl);
        ArrayList<FhirVersionIndependentConcept> retVal = new ArrayList<FhirVersionIndependentConcept>();
        for (ValueSet.ValueSetExpansionContainsComponent nextContains : expanded.getExpansion().getContains()) {
            retVal.add(new FhirVersionIndependentConcept(nextContains.getSystem(), nextContains.getCode(), nextContains.getDisplay(), nextContains.getVersion()));
        }
        return retVal;
    }

    @Override
    @Transactional
    public ValueSet expandValueSet(@Nullable ValueSetExpansionOptions theExpansionOptions, @Nonnull String theValueSetCanonicalUrl) {
        ValueSet valueSet = this.fetchCanonicalValueSetFromCompleteContext(theValueSetCanonicalUrl);
        if (valueSet == null) {
            throw new ResourceNotFoundException("Unknown ValueSet: " + UrlUtil.escapeUrlParam((String)theValueSetCanonicalUrl));
        }
        return this.expandValueSet(theExpansionOptions, valueSet);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ValueSet expandValueSet(@Nullable ValueSetExpansionOptions theExpansionOptions, @Nonnull ValueSet theValueSetToExpand) {
        String filter = null;
        if (theExpansionOptions != null) {
            filter = theExpansionOptions.getFilter();
        }
        return this.expandValueSet(theExpansionOptions, theValueSetToExpand, ExpansionFilter.fromFilterString(filter));
    }

    private ValueSet expandValueSet(@Nullable ValueSetExpansionOptions theExpansionOptions, ValueSet theValueSetToExpand, ExpansionFilter theFilter) {
        ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)theValueSetToExpand, (String)"ValueSet to expand can not be null", (Object[])new Object[0]);
        ValueSetExpansionOptions expansionOptions = this.provideExpansionOptions(theExpansionOptions);
        int offset = expansionOptions.getOffset();
        int count = expansionOptions.getCount();
        ValueSetExpansionComponentWithConceptAccumulator accumulator = new ValueSetExpansionComponentWithConceptAccumulator(this.myContext, count, expansionOptions.isIncludeHierarchy());
        accumulator.setHardExpansionMaximumSize(this.myDaoConfig.getMaximumExpansionSize());
        accumulator.setSkipCountRemaining(offset);
        accumulator.setIdentifier(UUID.randomUUID().toString());
        accumulator.setTimestamp(new Date());
        accumulator.setOffset(offset);
        if (theExpansionOptions != null && this.isHibernateSearchEnabled()) {
            accumulator.addParameter().setName("offset").setValue((Type)new IntegerType(offset));
            accumulator.addParameter().setName("count").setValue((Type)new IntegerType(count));
        }
        this.expandValueSetIntoAccumulator(theValueSetToExpand, theExpansionOptions, accumulator, theFilter, true);
        if (accumulator.getTotalConcepts() != null) {
            accumulator.setTotal(accumulator.getTotalConcepts());
        }
        ValueSet valueSet = new ValueSet();
        valueSet.setId(theValueSetToExpand.getId());
        valueSet.setStatus(Enumerations.PublicationStatus.ACTIVE);
        valueSet.setCompose(theValueSetToExpand.getCompose());
        valueSet.setExpansion((ValueSet.ValueSetExpansionComponent)accumulator);
        for (String next : accumulator.getMessages()) {
            valueSet.getMeta().addExtension().setUrl("http://hapifhir.io/fhir/StructureDefinition/valueset-expansion-message").setValue((Type)new StringType(next));
        }
        if (expansionOptions.isIncludeHierarchy()) {
            accumulator.applyHierarchy();
        }
        return valueSet;
    }

    private void expandValueSetIntoAccumulator(ValueSet theValueSetToExpand, ValueSetExpansionOptions theExpansionOptions, IValueSetConceptAccumulator theAccumulator, ExpansionFilter theFilter, boolean theAdd) {
        List<TermValueSet> termValueSets;
        Optional<Object> optionalTermValueSet = theValueSetToExpand.hasUrl() ? (theValueSetToExpand.hasVersion() ? this.myValueSetDao.findTermValueSetByUrlAndVersion(theValueSetToExpand.getUrl(), theValueSetToExpand.getVersion()) : ((termValueSets = this.myValueSetDao.findTermValueSetByUrl((Pageable)PageRequest.of((int)0, (int)1), theValueSetToExpand.getUrl())).size() > 0 ? Optional.of(termValueSets.get(0)) : Optional.empty())) : Optional.empty();
        if (!optionalTermValueSet.isPresent()) {
            ourLog.debug("ValueSet is not present in terminology tables. Will perform in-memory expansion without parameters. {}", (Object)this.getValueSetInfo(theValueSetToExpand));
            this.expandValueSet(theExpansionOptions, theValueSetToExpand, theAccumulator, theFilter);
            return;
        }
        TermValueSet termValueSet = (TermValueSet)optionalTermValueSet.get();
        if (termValueSet.getExpansionStatus() != TermValueSetPreExpansionStatusEnum.EXPANDED) {
            String msg = this.myContext.getLocalizer().getMessage(BaseTermReadSvcImpl.class, "valueSetNotYetExpanded", new Object[]{this.getValueSetInfo(theValueSetToExpand), termValueSet.getExpansionStatus().name(), termValueSet.getExpansionStatus().getDescription()});
            theAccumulator.addMessage(msg);
            this.expandValueSet(theExpansionOptions, theValueSetToExpand, theAccumulator, theFilter);
            return;
        }
        String msg = this.myContext.getLocalizer().getMessage(BaseTermReadSvcImpl.class, "valueSetExpandedUsingPreExpansion", new Object[0]);
        theAccumulator.addMessage(msg);
        this.expandConcepts(theAccumulator, termValueSet, theFilter, theAdd, this.isOracleDialect());
    }

    private boolean isOracleDialect() {
        return this.myHibernatePropertiesProvider.getDialect() instanceof Oracle12cDialect;
    }

    private void expandConcepts(IValueSetConceptAccumulator theAccumulator, TermValueSet theTermValueSet, ExpansionFilter theFilter, boolean theAdd, boolean theOracle) {
        List<Serializable> conceptViews;
        Integer offset = theAccumulator.getSkipCountRemaining();
        offset = (Integer)ObjectUtils.defaultIfNull((Object)offset, (Object)0);
        offset = Math.min(offset, theTermValueSet.getTotalConcepts().intValue());
        Integer count = theAccumulator.getCapacityRemaining();
        count = (Integer)ObjectUtils.defaultIfNull((Object)count, (Object)this.myDaoConfig.getMaximumExpansionSize());
        int conceptsExpanded = 0;
        int designationsExpanded = 0;
        int toIndex = offset + count;
        boolean wasFilteredResult = false;
        String filterDisplayValue = null;
        if (!theFilter.getFilters().isEmpty() && "display".equals(theFilter.getFilters().get(0).getProperty()) && theFilter.getFilters().get(0).getOp() == ValueSet.FilterOperator.EQUAL) {
            filterDisplayValue = StringUtils.lowerCase((String)theFilter.getFilters().get(0).getValue().replace("%", "[%]"));
            String displayValue = "%" + StringUtils.lowerCase((String)filterDisplayValue) + "%";
            conceptViews = theOracle ? this.myTermValueSetConceptViewOracleDao.findByTermValueSetId(theTermValueSet.getId(), displayValue) : this.myTermValueSetConceptViewDao.findByTermValueSetId(theTermValueSet.getId(), displayValue);
            wasFilteredResult = true;
        } else {
            conceptViews = theOracle ? this.myTermValueSetConceptViewOracleDao.findByTermValueSetId(offset, toIndex, theTermValueSet.getId()) : this.myTermValueSetConceptViewDao.findByTermValueSetId(offset, toIndex, theTermValueSet.getId());
            theAccumulator.consumeSkipCount(offset);
            if (theAdd) {
                theAccumulator.incrementOrDecrementTotalConcepts(true, theTermValueSet.getTotalConcepts().intValue());
            }
        }
        if (conceptViews.isEmpty()) {
            this.logConceptsExpanded("No concepts to expand. ", theTermValueSet, conceptsExpanded);
            return;
        }
        LinkedHashMap<Long, FhirVersionIndependentConcept> pidToConcept = new LinkedHashMap<Long, FhirVersionIndependentConcept>();
        ArrayListMultimap pidToDesignations = ArrayListMultimap.create();
        HashMap<Long, Long> pidToSourcePid = new HashMap<Long, Long>();
        HashMap<Long, String> pidToSourceDirectParentPids = new HashMap<Long, String>();
        for (ITermValueSetConceptView iTermValueSetConceptView : conceptViews) {
            String system = iTermValueSetConceptView.getConceptSystemUrl();
            String code = iTermValueSetConceptView.getConceptCode();
            String display = iTermValueSetConceptView.getConceptDisplay();
            if (!this.applyFilter(display, filterDisplayValue)) continue;
            Long conceptPid = iTermValueSetConceptView.getConceptPid();
            if (!pidToConcept.containsKey(conceptPid)) {
                FhirVersionIndependentConcept concept = new FhirVersionIndependentConcept(system, code, display);
                pidToConcept.put(conceptPid, concept);
            }
            if (iTermValueSetConceptView.getDesignationPid() != null) {
                TermConceptDesignation designation = new TermConceptDesignation();
                designation.setUseSystem(iTermValueSetConceptView.getDesignationUseSystem());
                designation.setUseCode(iTermValueSetConceptView.getDesignationUseCode());
                designation.setUseDisplay(iTermValueSetConceptView.getDesignationUseDisplay());
                designation.setValue(iTermValueSetConceptView.getDesignationVal());
                designation.setLanguage(iTermValueSetConceptView.getDesignationLang());
                pidToDesignations.put((Object)conceptPid, (Object)designation);
                if (++designationsExpanded % 250 == 0) {
                    this.logDesignationsExpanded("Expansion of designations in progress. ", theTermValueSet, designationsExpanded);
                }
            }
            if (theAccumulator.isTrackingHierarchy()) {
                pidToSourcePid.put(conceptPid, iTermValueSetConceptView.getSourceConceptPid());
                pidToSourceDirectParentPids.put(conceptPid, iTermValueSetConceptView.getSourceConceptDirectParentPids());
            }
            if (++conceptsExpanded % 250 != 0) continue;
            this.logConceptsExpanded("Expansion of concepts in progress. ", theTermValueSet, conceptsExpanded);
        }
        for (Long l : pidToConcept.keySet()) {
            FhirVersionIndependentConcept concept = (FhirVersionIndependentConcept)pidToConcept.get(l);
            List designations = pidToDesignations.get((Object)l);
            String system = concept.getSystem();
            String code = concept.getCode();
            String display = concept.getDisplay();
            if (theAdd) {
                if (theAccumulator.getCapacityRemaining() != null && theAccumulator.getCapacityRemaining() == 0) break;
                Long sourceConceptPid = (Long)pidToSourcePid.get(l);
                String sourceConceptDirectParentPids = (String)pidToSourceDirectParentPids.get(l);
                theAccumulator.includeConceptWithDesignations(system, code, display, designations, sourceConceptPid, sourceConceptDirectParentPids);
                continue;
            }
            boolean removed = theAccumulator.excludeConcept(system, code);
            if (!removed) continue;
            theAccumulator.incrementOrDecrementTotalConcepts(false, 1);
        }
        if (wasFilteredResult && theAdd) {
            theAccumulator.incrementOrDecrementTotalConcepts(true, pidToConcept.size());
        }
        this.logDesignationsExpanded("Finished expanding designations. ", theTermValueSet, designationsExpanded);
        this.logConceptsExpanded("Finished expanding concepts. ", theTermValueSet, conceptsExpanded);
    }

    private void logConceptsExpanded(String theLogDescriptionPrefix, TermValueSet theTermValueSet, int theConceptsExpanded) {
        if (theConceptsExpanded > 0) {
            ourLog.debug("{}Have expanded {} concepts in ValueSet[{}]", new Object[]{theLogDescriptionPrefix, theConceptsExpanded, theTermValueSet.getUrl()});
        }
    }

    private void logDesignationsExpanded(String theLogDescriptionPrefix, TermValueSet theTermValueSet, int theDesignationsExpanded) {
        if (theDesignationsExpanded > 0) {
            ourLog.debug("{}Have expanded {} designations in ValueSet[{}]", new Object[]{theLogDescriptionPrefix, theDesignationsExpanded, theTermValueSet.getUrl()});
        }
    }

    public boolean applyFilter(String theDisplay, String theFilterDisplay) {
        if (theDisplay == null || theFilterDisplay == null) {
            return true;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)theDisplay, (CharSequence)theFilterDisplay)) {
            return true;
        }
        return this.startsWithByWordBoundaries(theDisplay, theFilterDisplay);
    }

    private boolean startsWithByWordBoundaries(String theDisplay, String theFilterDisplay) {
        StringTokenizer tok = new StringTokenizer(theDisplay);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (StringUtils.startsWithIgnoreCase((CharSequence)token, (CharSequence)theFilterDisplay)) {
                return true;
            }
            tokens.add(token);
        }
        for (int start = 0; start <= tokens.size() - 1; ++start) {
            for (int end = start + 1; end <= tokens.size(); ++end) {
                String sublist = String.join((CharSequence)" ", tokens.subList(start, end));
                if (!StringUtils.startsWithIgnoreCase((CharSequence)sublist, (CharSequence)theFilterDisplay)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void expandValueSet(ValueSetExpansionOptions theExpansionOptions, ValueSet theValueSetToExpand, IValueSetConceptAccumulator theValueSetCodeAccumulator) {
        this.expandValueSet(theExpansionOptions, theValueSetToExpand, theValueSetCodeAccumulator, ExpansionFilter.NO_FILTER);
    }

    private void expandValueSet(ValueSetExpansionOptions theExpansionOptions, ValueSet theValueSetToExpand, IValueSetConceptAccumulator theValueSetCodeAccumulator, @Nonnull ExpansionFilter theExpansionFilter) {
        int queryIndex;
        Boolean shouldContinue;
        int i;
        HashSet addedCodes = new HashSet();
        StopWatch sw = new StopWatch();
        String valueSetInfo = this.getValueSetInfo(theValueSetToExpand);
        ourLog.debug("Working with {}", (Object)valueSetInfo);
        Integer skipCountRemaining = theValueSetCodeAccumulator.getSkipCountRemaining();
        if (skipCountRemaining != null && skipCountRemaining > 0 && theValueSetToExpand.getCompose().getExclude().size() > 0) {
            String msg = this.myContext.getLocalizer().getMessage(BaseTermReadSvcImpl.class, "valueSetNotYetExpanded_OffsetNotAllowed", new Object[]{valueSetInfo});
            throw new InvalidRequestException(msg);
        }
        ourLog.debug("Handling includes");
        for (ValueSet.ConceptSetComponent include : theValueSetToExpand.getCompose().getInclude()) {
            i = 0;
            while ((shouldContinue = this.executeInNewTransactionIfNeeded(() -> this.lambda$expandValueSet$1(theExpansionOptions, theValueSetCodeAccumulator, addedCodes, include, queryIndex = i++, theExpansionFilter))).booleanValue()) {
            }
        }
        ourLog.debug("Handling excludes");
        for (ValueSet.ConceptSetComponent exclude : theValueSetToExpand.getCompose().getExclude()) {
            i = 0;
            while ((shouldContinue = this.executeInNewTransactionIfNeeded(() -> this.lambda$expandValueSet$2(theExpansionOptions, theValueSetCodeAccumulator, addedCodes, exclude, queryIndex = i++))).booleanValue()) {
            }
        }
        if (theValueSetCodeAccumulator instanceof ValueSetConceptAccumulator) {
            this.myTxTemplate.execute(t -> ((ValueSetConceptAccumulator)theValueSetCodeAccumulator).removeGapsFromConceptOrder());
        }
        ourLog.debug("Done working with {} in {}ms", (Object)valueSetInfo, (Object)sw.getMillis());
    }

    private <T> T executeInNewTransactionIfNeeded(Supplier<T> theAction) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            return theAction.get();
        }
        return (T)this.myTxTemplate.execute(t -> theAction.get());
    }

    private String getValueSetInfo(ValueSet theValueSet) {
        StringBuilder sb = new StringBuilder();
        boolean isIdentified = false;
        if (theValueSet.hasUrl()) {
            isIdentified = true;
            sb.append("ValueSet.url[").append(theValueSet.getUrl()).append("]");
        } else if (theValueSet.hasId()) {
            isIdentified = true;
            sb.append("ValueSet.id[").append(theValueSet.getId()).append("]");
        }
        if (!isIdentified) {
            sb.append("Unidentified ValueSet");
        }
        return sb.toString();
    }

    private Boolean expandValueSetHandleIncludeOrExclude(@Nullable ValueSetExpansionOptions theExpansionOptions, IValueSetConceptAccumulator theValueSetCodeAccumulator, Set<String> theAddedCodes, ValueSet.ConceptSetComponent theIncludeOrExclude, boolean theAdd, int theQueryIndex, @Nonnull ExpansionFilter theExpansionFilter) {
        boolean hasValueSet;
        String system = theIncludeOrExclude.getSystem();
        boolean hasSystem = StringUtils.isNotBlank((CharSequence)system);
        boolean bl = hasValueSet = theIncludeOrExclude.getValueSet().size() > 0;
        if (hasSystem) {
            if (theExpansionFilter.hasCode() && theExpansionFilter.getSystem() != null && !system.equals(theExpansionFilter.getSystem())) {
                return false;
            }
            ourLog.debug("Starting {} expansion around CodeSystem: {}", (Object)(theAdd ? "inclusion" : "exclusion"), (Object)system);
            TermCodeSystem cs = this.myCodeSystemDao.findByCodeSystemUri(system);
            if (cs != null) {
                return this.expandValueSetHandleIncludeOrExcludeUsingDatabase(theValueSetCodeAccumulator, theAddedCodes, theIncludeOrExclude, theAdd, theQueryIndex, theExpansionFilter, system, cs);
            }
            if (theIncludeOrExclude.getConcept().size() > 0 && theExpansionFilter.hasCode() && StringUtils.defaultString((String)theIncludeOrExclude.getSystem()).equals(theExpansionFilter.getSystem()) && theIncludeOrExclude.getConcept().stream().noneMatch(t -> t.getCode().equals(theExpansionFilter.getCode()))) {
                return false;
            }
            CodeSystem codeSystemFromContext = this.fetchCanonicalCodeSystemFromCompleteContext(system);
            if (codeSystemFromContext == null) {
                List<Object> includedConcepts = null;
                if (theExpansionFilter.hasCode()) {
                    includedConcepts = new ArrayList<FhirVersionIndependentConcept>();
                    includedConcepts.add(theExpansionFilter.toFhirVersionIndependentConcept());
                } else if (!theIncludeOrExclude.getConcept().isEmpty()) {
                    includedConcepts = theIncludeOrExclude.getConcept().stream().map(t -> new FhirVersionIndependentConcept(theIncludeOrExclude.getSystem(), t.getCode())).collect(Collectors.toList());
                }
                if (includedConcepts != null) {
                    int foundCount = 0;
                    for (FhirVersionIndependentConcept fhirVersionIndependentConcept : includedConcepts) {
                        IValidationSupport.LookupCodeResult lookup;
                        String nextSystem = fhirVersionIndependentConcept.getSystem();
                        if (nextSystem == null) {
                            nextSystem = system;
                        }
                        if ((lookup = this.myValidationSupport.lookupCode(new ValidationSupportContext(this.provideValidationSupport()), nextSystem, fhirVersionIndependentConcept.getCode())) == null || !lookup.isFound()) continue;
                        this.addOrRemoveCode(theValueSetCodeAccumulator, theAddedCodes, theAdd, nextSystem, fhirVersionIndependentConcept.getCode(), lookup.getCodeDisplay());
                        ++foundCount;
                    }
                    if (foundCount == includedConcepts.size()) {
                        return false;
                    }
                }
                String msg = this.myContext.getLocalizer().getMessage(BaseTermReadSvcImpl.class, "expansionRefersToUnknownCs", new Object[]{system});
                if (this.provideExpansionOptions(theExpansionOptions).isFailOnMissingCodeSystem()) {
                    throw new PreconditionFailedException(msg);
                }
                ourLog.warn(msg);
                theValueSetCodeAccumulator.addMessage(msg);
                return false;
            }
            if (!theIncludeOrExclude.getConcept().isEmpty()) {
                for (ValueSet.ConceptReferenceComponent next : theIncludeOrExclude.getConcept()) {
                    CodeSystem.ConceptDefinitionComponent conceptDefinitionComponent;
                    String nextCode = next.getCode();
                    if (theExpansionFilter.hasCode() && !theExpansionFilter.getCode().equals(nextCode) || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{system, nextCode}) || theAddedCodes.contains(system + "|" + nextCode) || (conceptDefinitionComponent = this.findCode(codeSystemFromContext.getConcept(), nextCode)) == null) continue;
                    String display = conceptDefinitionComponent.getDisplay();
                    this.addOrRemoveCode(theValueSetCodeAccumulator, theAddedCodes, theAdd, system, nextCode, display);
                }
            } else {
                List concept = codeSystemFromContext.getConcept();
                this.addConceptsToList(theValueSetCodeAccumulator, theAddedCodes, system, concept, theAdd, theExpansionFilter);
            }
            return false;
        }
        if (hasValueSet) {
            for (CanonicalType nextValueSet : theIncludeOrExclude.getValueSet()) {
                String valueSetUrl = nextValueSet.getValueAsString();
                ourLog.debug("Starting {} expansion around ValueSet: {}", (Object)(theAdd ? "inclusion" : "exclusion"), (Object)valueSetUrl);
                ExpansionFilter subExpansionFilter = new ExpansionFilter(theExpansionFilter, theIncludeOrExclude.getFilter(), theValueSetCodeAccumulator.getCapacityRemaining());
                ValueSet valueSet = this.fetchCanonicalValueSetFromCompleteContext(valueSetUrl);
                if (valueSet == null) {
                    throw new ResourceNotFoundException("Unknown ValueSet: " + UrlUtil.escapeUrlParam((String)valueSetUrl));
                }
                this.expandValueSetIntoAccumulator(valueSet, theExpansionOptions, theValueSetCodeAccumulator, subExpansionFilter, theAdd);
            }
            return false;
        }
        throw new InvalidRequestException("ValueSet contains " + (theAdd ? "include" : "exclude") + " criteria with no system defined");
    }

    private boolean isHibernateSearchEnabled() {
        return this.myFulltextSearchSvc != null;
    }

    @Nonnull
    private Boolean expandValueSetHandleIncludeOrExcludeUsingDatabase(IValueSetConceptAccumulator theValueSetCodeAccumulator, Set<String> theAddedCodes, ValueSet.ConceptSetComponent theIncludeOrExclude, boolean theAdd, int theQueryIndex, @Nonnull ExpansionFilter theExpansionFilter, String theSystem, TermCodeSystem theCs) {
        String includeOrExcludeVersion = theIncludeOrExclude.getVersion();
        TermCodeSystemVersion csv = StringUtils.isEmpty((CharSequence)includeOrExcludeVersion) ? theCs.getCurrentVersion() : this.myCodeSystemVersionDao.findByCodeSystemPidAndVersion(theCs.getPid(), includeOrExcludeVersion);
        SearchSession searchSession = Search.session((EntityManager)this.myEntityManager);
        if (!this.isHibernateSearchEnabled()) {
            this.expandWithoutHibernateSearch(theValueSetCodeAccumulator, csv, theAddedCodes, theIncludeOrExclude, theSystem, theAdd);
            return false;
        }
        SearchPredicateFactory predicate = searchSession.scope(TermConcept.class).predicate();
        PredicateFinalStep step = predicate.bool(b -> {
            b.must((PredicateFinalStep)predicate.match().field("myCodeSystemVersionPid").matching((Object)csv.getPid()));
            if (theExpansionFilter.hasCode()) {
                b.must((PredicateFinalStep)predicate.match().field("myCode").matching((Object)theExpansionFilter.getCode()));
            }
            String codeSystemUrlAndVersion = this.buildCodeSystemUrlAndVersion(theSystem, includeOrExcludeVersion);
            for (ValueSet.ConceptSetFilterComponent nextFilter : theIncludeOrExclude.getFilter()) {
                this.handleFilter(codeSystemUrlAndVersion, predicate, (BooleanPredicateClausesStep<?>)b, nextFilter);
            }
            for (ValueSet.ConceptSetFilterComponent nextFilter : theExpansionFilter.getFilters()) {
                this.handleFilter(codeSystemUrlAndVersion, predicate, (BooleanPredicateClausesStep<?>)b, nextFilter);
            }
        });
        List<String> codes = theIncludeOrExclude.getConcept().stream().filter(Objects::nonNull).map(ValueSet.ConceptReferenceComponent::getCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        PredicateFinalStep expansionStep = this.buildExpansionPredicate(codes, predicate);
        Object finishedQuery = expansionStep == null ? step : predicate.bool().must(step).must(expansionStep);
        StopWatch sw = new StopWatch();
        AtomicInteger count = new AtomicInteger(0);
        int maxResultsPerBatch = SearchBuilder.getMaximumPageSize();
        if (theAdd) {
            Integer accumulatorCapacityRemaining = theValueSetCodeAccumulator.getCapacityRemaining();
            if (accumulatorCapacityRemaining != null) {
                maxResultsPerBatch = Math.min(maxResultsPerBatch, accumulatorCapacityRemaining + 1);
            }
            if (maxResultsPerBatch <= 0) {
                return false;
            }
        }
        ourLog.debug("Beginning batch expansion for {} with max results per batch: {}", (Object)(theAdd ? "inclusion" : "exclusion"), (Object)maxResultsPerBatch);
        StopWatch swForBatch = new StopWatch();
        AtomicInteger countForBatch = new AtomicInteger(0);
        SearchQuery termConceptsQuery = searchSession.search(TermConcept.class).where(arg_0 -> BaseTermReadSvcImpl.lambda$expandValueSetHandleIncludeOrExcludeUsingDatabase$8((PredicateFinalStep)finishedQuery, arg_0)).toQuery();
        ourLog.trace("About to query: {}", (Object)termConceptsQuery.queryString());
        ArrayList termConcepts = termConceptsQuery.fetchHits(Integer.valueOf(theQueryIndex * maxResultsPerBatch), Integer.valueOf(maxResultsPerBatch));
        if (codes.size() > 1) {
            termConcepts = new ArrayList(termConcepts);
            HashMap<String, Integer> codeToIndex = new HashMap<String, Integer>(codes.size());
            for (int i = 0; i < codes.size(); ++i) {
                codeToIndex.put(codes.get(i), i);
            }
            termConcepts.sort((o1, o2) -> {
                Integer idx1 = (Integer)codeToIndex.get(o1.getCode());
                Integer idx2 = (Integer)codeToIndex.get(o2.getCode());
                return Comparators.nullsHigh().compare(idx1, idx2);
            });
        }
        int resultsInBatch = termConcepts.size();
        int firstResult = theQueryIndex * maxResultsPerBatch;
        int delta = 0;
        for (TermConcept concept : termConcepts) {
            boolean added;
            ValueSet.ConceptReferenceComponent theIncludeConcept;
            count.incrementAndGet();
            countForBatch.incrementAndGet();
            if (theAdd && expansionStep != null && (theIncludeConcept = this.getMatchedConceptIncludedInValueSet(theIncludeOrExclude, concept)) != null && StringUtils.isNotBlank((CharSequence)theIncludeConcept.getDisplay())) {
                concept.setDisplay(theIncludeConcept.getDisplay());
            }
            if (!(added = this.addCodeIfNotAlreadyAdded(theValueSetCodeAccumulator, theAddedCodes, concept, theAdd, includeOrExcludeVersion))) continue;
            ++delta;
        }
        ourLog.debug("Batch expansion for {} with starting index of {} produced {} results in {}ms", new Object[]{theAdd ? "inclusion" : "exclusion", firstResult, countForBatch, swForBatch.getMillis()});
        theValueSetCodeAccumulator.incrementOrDecrementTotalConcepts(theAdd, delta);
        if (resultsInBatch < maxResultsPerBatch) {
            ourLog.debug("Expansion for {} produced {} results in {}ms", new Object[]{theAdd ? "inclusion" : "exclusion", count, sw.getMillis()});
            return false;
        }
        return true;
    }

    private ValueSet.ConceptReferenceComponent getMatchedConceptIncludedInValueSet(ValueSet.ConceptSetComponent theIncludeOrExclude, TermConcept concept) {
        ValueSet.ConceptReferenceComponent theIncludeConcept = theIncludeOrExclude.getConcept().stream().filter(includedConcept -> includedConcept.getCode().equalsIgnoreCase(concept.getCode())).findFirst().orElse(null);
        return theIncludeConcept;
    }

    private PredicateFinalStep buildExpansionPredicate(List<String> theCodes, SearchPredicateFactory thePredicate) {
        List codes = theCodes.stream().map(t -> new Term("myCode", t)).collect(Collectors.toList());
        if (codes.size() > 0) {
            PredicateFinalStep expansionStep = thePredicate.bool(b -> {
                b.minimumShouldMatchNumber(1);
                for (Term code : codes) {
                    b.should((PredicateFinalStep)thePredicate.match().field(code.field()).matching((Object)code.text()));
                }
            });
            return expansionStep;
        }
        return null;
    }

    private String buildCodeSystemUrlAndVersion(String theSystem, String theIncludeOrExcludeVersion) {
        String codeSystemUrlAndVersion = theIncludeOrExcludeVersion != null ? theSystem + "|" + theIncludeOrExcludeVersion : theSystem;
        return codeSystemUrlAndVersion;
    }

    @Nonnull
    private ValueSetExpansionOptions provideExpansionOptions(@Nullable ValueSetExpansionOptions theExpansionOptions) {
        if (theExpansionOptions != null) {
            return theExpansionOptions;
        }
        return DEFAULT_EXPANSION_OPTIONS;
    }

    private void addOrRemoveCode(IValueSetConceptAccumulator theValueSetCodeAccumulator, Set<String> theAddedCodes, boolean theAdd, String theSystem, String theCode, String theDisplay) {
        if (theAdd && theAddedCodes.add(theSystem + "|" + theCode)) {
            theValueSetCodeAccumulator.includeConcept(theSystem, theCode, theDisplay, null, null);
        }
        if (!theAdd && theAddedCodes.remove(theSystem + "|" + theCode)) {
            theValueSetCodeAccumulator.excludeConcept(theSystem, theCode);
        }
    }

    private void handleFilter(String theCodeSystemIdentifier, SearchPredicateFactory theF, BooleanPredicateClausesStep<?> theB, ValueSet.ConceptSetFilterComponent theFilter) {
        if (StringUtils.isBlank((CharSequence)theFilter.getValue()) && theFilter.getOp() == null && StringUtils.isBlank((CharSequence)theFilter.getProperty())) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)theFilter.getValue()) || theFilter.getOp() == null || StringUtils.isBlank((CharSequence)theFilter.getProperty())) {
            throw new InvalidRequestException("Invalid filter, must have fields populated: property op value");
        }
        switch (theFilter.getProperty()) {
            case "display:exact": 
            case "display": {
                this.handleFilterDisplay(theF, theB, theFilter);
                break;
            }
            case "concept": 
            case "code": {
                this.handleFilterConceptAndCode(theCodeSystemIdentifier, theF, theB, theFilter);
                break;
            }
            case "parent": 
            case "child": {
                this.isCodeSystemLoincOrThrowInvalidRequestException(theCodeSystemIdentifier, theFilter.getProperty());
                this.handleFilterLoincParentChild(theF, theB, theFilter);
                break;
            }
            case "ancestor": {
                this.isCodeSystemLoincOrThrowInvalidRequestException(theCodeSystemIdentifier, theFilter.getProperty());
                this.handleFilterLoincAncestor2(theCodeSystemIdentifier, theF, theB, theFilter);
                break;
            }
            case "descendant": {
                this.isCodeSystemLoincOrThrowInvalidRequestException(theCodeSystemIdentifier, theFilter.getProperty());
                this.handleFilterLoincDescendant(theCodeSystemIdentifier, theF, theB, theFilter);
                break;
            }
            case "copyright": {
                this.isCodeSystemLoincOrThrowInvalidRequestException(theCodeSystemIdentifier, theFilter.getProperty());
                this.handleFilterLoincCopyright(theF, theB, theFilter);
                break;
            }
            default: {
                this.handleFilterRegex(theF, theB, theFilter);
            }
        }
    }

    private void handleFilterRegex(SearchPredicateFactory theF, BooleanPredicateClausesStep<?> theB, ValueSet.ConceptSetFilterComponent theFilter) {
        if (theFilter.getOp() == ValueSet.FilterOperator.REGEX) {
            String value = theFilter.getValue();
            if (value.endsWith("$")) {
                value = value.substring(0, value.length() - 1);
            } else if (!value.endsWith(".*")) {
                value = value + ".*";
            }
            if (!value.startsWith("^") && !value.startsWith(".*")) {
                value = ".*" + value;
            } else if (value.startsWith("^")) {
                value = value.substring(1);
            }
            Term term = new Term("PROP" + theFilter.getProperty(), value);
            if (this.isFullTextSetToUseElastic()) {
                String regexpQuery = "{'regexp':{'" + term.field() + "':{'value':'" + term.text() + "'}}}";
                ourLog.debug("Build Elasticsearch Regexp Query: {}", (Object)regexpQuery);
                theB.must(((ElasticsearchSearchPredicateFactory)theF.extension((SearchPredicateFactoryExtension)ElasticsearchExtension.get())).fromJson(regexpQuery));
            } else {
                RegexpQuery query = new RegexpQuery(term);
                theB.must(((LuceneSearchPredicateFactory)theF.extension((SearchPredicateFactoryExtension)LuceneExtension.get())).fromLuceneQuery((Query)query));
            }
        } else {
            String value = theFilter.getValue();
            Term term = new Term("PROP" + theFilter.getProperty(), value);
            theB.must((PredicateFinalStep)theF.match().field(term.field()).matching((Object)term.text()));
        }
    }

    private void handleFilterLoincCopyright(SearchPredicateFactory theF, BooleanPredicateClausesStep<?> theB, ValueSet.ConceptSetFilterComponent theFilter) {
        if (theFilter.getOp() == ValueSet.FilterOperator.EQUAL) {
            String copyrightFilterValue;
            switch (copyrightFilterValue = StringUtils.defaultString((String)theFilter.getValue()).toLowerCase()) {
                case "3rdparty": {
                    this.logFilteringValueOnProperty(theFilter.getValue(), theFilter.getProperty());
                    this.addFilterLoincCopyright3rdParty(theF, theB);
                    break;
                }
                case "loinc": {
                    this.logFilteringValueOnProperty(theFilter.getValue(), theFilter.getProperty());
                    this.addFilterLoincCopyrightLoinc(theF, theB);
                    break;
                }
                default: {
                    this.throwInvalidRequestForValueOnProperty(theFilter.getValue(), theFilter.getProperty());
                    break;
                }
            }
        } else {
            this.throwInvalidRequestForOpOnProperty(theFilter.getOp(), theFilter.getProperty());
        }
    }

    private void addFilterLoincCopyrightLoinc(SearchPredicateFactory thePredicateFactory, BooleanPredicateClausesStep<?> theBooleanClause) {
        theBooleanClause.mustNot((PredicateFinalStep)thePredicateFactory.exists().field("PROPEXTERNAL_COPYRIGHT_NOTICE"));
    }

    private void addFilterLoincCopyright3rdParty(SearchPredicateFactory thePredicateFactory, BooleanPredicateClausesStep<?> theBooleanClause) {
        theBooleanClause.must((PredicateFinalStep)thePredicateFactory.exists().field("PROPEXTERNAL_COPYRIGHT_NOTICE"));
    }

    private void handleFilterLoincAncestor2(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        switch (theFilter.getOp()) {
            case EQUAL: {
                this.addLoincFilterAncestorEqual(theSystem, f, b, theFilter);
                break;
            }
            case IN: {
                this.addLoincFilterAncestorIn(theSystem, f, b, theFilter);
                break;
            }
            default: {
                throw new InvalidRequestException("Don't know how to handle op=" + theFilter.getOp() + " on property " + theFilter.getProperty());
            }
        }
    }

    private void addLoincFilterAncestorEqual(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        this.addLoincFilterAncestorEqual(theSystem, f, b, theFilter.getProperty(), theFilter.getValue());
    }

    private void addLoincFilterAncestorEqual(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, String theProperty, String theValue) {
        List<Term> terms = this.getAncestorTerms(theSystem, theProperty, theValue);
        b.must(f.bool(innerB -> terms.forEach(term -> innerB.should((PredicateFinalStep)f.match().field(term.field()).matching((Object)term.text())))));
    }

    private void addLoincFilterAncestorIn(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        String[] values = theFilter.getValue().split(",");
        ArrayList<Term> terms = new ArrayList<Term>();
        for (String value : values) {
            terms.addAll(this.getAncestorTerms(theSystem, theFilter.getProperty(), value));
        }
        b.must(f.bool(innerB -> terms.forEach(term -> innerB.should((PredicateFinalStep)f.match().field(term.field()).matching((Object)term.text())))));
    }

    private void handleFilterLoincParentChild(SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        switch (theFilter.getOp()) {
            case EQUAL: {
                this.addLoincFilterParentChildEqual(f, b, theFilter.getProperty(), theFilter.getValue());
                break;
            }
            case IN: {
                this.addLoincFilterParentChildIn(f, b, theFilter);
                break;
            }
            default: {
                throw new InvalidRequestException("Don't know how to handle op=" + theFilter.getOp() + " on property " + theFilter.getProperty());
            }
        }
    }

    private void addLoincFilterParentChildIn(SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        String[] values = theFilter.getValue().split(",");
        ArrayList<Term> terms = new ArrayList<Term>();
        for (String value : values) {
            this.logFilteringValueOnProperty(value, theFilter.getProperty());
            terms.add(this.getPropertyTerm(theFilter.getProperty(), value));
        }
        b.must(f.bool(innerB -> terms.forEach(term -> innerB.should((PredicateFinalStep)f.match().field(term.field()).matching((Object)term.text())))));
    }

    private void addLoincFilterParentChildEqual(SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, String theProperty, String theValue) {
        this.logFilteringValueOnProperty(theValue, theProperty);
        b.must((PredicateFinalStep)f.match().field("PROP" + theProperty).matching((Object)theValue));
    }

    private void handleFilterConceptAndCode(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        TermConcept code = this.findCode(theSystem, theFilter.getValue()).orElseThrow(() -> new InvalidRequestException("Invalid filter criteria - code does not exist: {" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "}" + theFilter.getValue()));
        if (theFilter.getOp() != ValueSet.FilterOperator.ISA) {
            throw new InvalidRequestException("Don't know how to handle op=" + theFilter.getOp() + " on property " + theFilter.getProperty());
        }
        ourLog.debug(" * Filtering on codes with a parent of {}/{}/{}", new Object[]{code.getId(), code.getCode(), code.getDisplay()});
        b.must((PredicateFinalStep)f.match().field("myParentPids").matching((Object)("" + code.getId())));
    }

    private void isCodeSystemLoincOrThrowInvalidRequestException(String theSystemIdentifier, String theProperty) {
        String systemUrl = this.getUrlFromIdentifier(theSystemIdentifier);
        if (!this.isCodeSystemLoinc(systemUrl)) {
            throw new InvalidRequestException("Invalid filter, property " + theProperty + " is LOINC-specific and cannot be used with system: " + systemUrl);
        }
    }

    private boolean isCodeSystemLoinc(String theSystem) {
        return "http://loinc.org".equals(theSystem);
    }

    private void handleFilterDisplay(SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        if (theFilter.getProperty().equals("display:exact") && theFilter.getOp() == ValueSet.FilterOperator.EQUAL) {
            this.addDisplayFilterExact(f, b, theFilter);
        } else if (theFilter.getProperty().equals("display") && theFilter.getOp() == ValueSet.FilterOperator.EQUAL) {
            if (theFilter.getValue().trim().contains(" ")) {
                this.addDisplayFilterExact(f, b, theFilter);
            } else {
                this.addDisplayFilterInexact(f, b, theFilter);
            }
        }
    }

    private void addDisplayFilterExact(SearchPredicateFactory f, BooleanPredicateClausesStep<?> bool, ValueSet.ConceptSetFilterComponent nextFilter) {
        bool.must((PredicateFinalStep)f.phrase().field("myDisplay").matching(nextFilter.getValue()));
    }

    private void addDisplayFilterInexact(SearchPredicateFactory f, BooleanPredicateClausesStep<?> bool, ValueSet.ConceptSetFilterComponent nextFilter) {
        bool.must((PredicateFinalStep)((PhrasePredicateFieldMoreStep)((PhrasePredicateFieldMoreStep)((PhrasePredicateFieldMoreStep)f.phrase().field("myDisplay").boost(4.0f)).field("myDisplayWordEdgeNGram").boost(1.0f)).field("myDisplayEdgeNGram").boost(1.0f)).matching(nextFilter.getValue().toLowerCase()).slop(2));
    }

    private Term getPropertyTerm(String theProperty, String theValue) {
        return new Term("PROP" + theProperty, theValue);
    }

    private List<Term> getAncestorTerms(String theSystem, String theProperty, String theValue) {
        ArrayList<Term> retVal = new ArrayList<Term>();
        TermConcept code = this.findCode(theSystem, theValue).orElseThrow(() -> new InvalidRequestException("Invalid filter criteria - code does not exist: {" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "}" + theValue));
        retVal.add(new Term("myParentPids", "" + code.getId()));
        this.logFilteringValueOnProperty(theValue, theProperty);
        return retVal;
    }

    private void handleFilterLoincDescendant(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        switch (theFilter.getOp()) {
            case EQUAL: {
                this.addLoincFilterDescendantEqual(theSystem, f, b, theFilter);
                break;
            }
            case IN: {
                this.addLoincFilterDescendantIn(theSystem, f, b, theFilter);
                break;
            }
            default: {
                throw new InvalidRequestException("Don't know how to handle op=" + theFilter.getOp() + " on property " + theFilter.getProperty());
            }
        }
    }

    private void addLoincFilterDescendantEqual(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        this.addLoincFilterDescendantEqual(theSystem, f, b, theFilter.getProperty(), theFilter.getValue());
    }

    private void addLoincFilterDescendantIn(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, ValueSet.ConceptSetFilterComponent theFilter) {
        String[] values = theFilter.getValue().split(",");
        ArrayList<Term> terms = new ArrayList<Term>();
        for (String value : values) {
            terms.addAll(this.getDescendantTerms(theSystem, theFilter.getProperty(), value));
        }
        this.searchByParentPids(f, b, terms);
    }

    private void addLoincFilterDescendantEqual(String theSystem, SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, String theProperty, String theValue) {
        List<Term> terms = this.getDescendantTerms(theSystem, theProperty, theValue);
        this.searchByParentPids(f, b, terms);
    }

    private void searchByParentPids(SearchPredicateFactory f, BooleanPredicateClausesStep<?> b, List<Term> theTerms) {
        List<Long> parentPids = this.convertTermsToParentPids(theTerms);
        b.must(f.bool(innerB -> parentPids.forEach(pid -> innerB.should((PredicateFinalStep)f.match().field(((Term)theTerms.get(0)).field()).matching(pid)))));
    }

    private List<Long> convertTermsToParentPids(List<Term> theTerms) {
        return theTerms.stream().map(Term::text).map(Long::valueOf).collect(Collectors.toList());
    }

    private List<Term> getDescendantTerms(String theSystem, String theProperty, String theValue) {
        String[] parentPids;
        ArrayList<Term> retVal = new ArrayList<Term>();
        TermConcept code = this.findCode(theSystem, theValue).orElseThrow(() -> new InvalidRequestException("Invalid filter criteria - code does not exist: {" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "}" + theValue));
        for (String parentPid : parentPids = code.getParentPidsAsString().split(" ")) {
            if (StringUtils.equals((CharSequence)parentPid, (CharSequence)"NONE")) continue;
            retVal.add(new Term("myId", parentPid));
        }
        this.logFilteringValueOnProperty(theValue, theProperty);
        return retVal;
    }

    private void logFilteringValueOnProperty(String theValue, String theProperty) {
        ourLog.debug(" * Filtering with value={} on property {}", (Object)theValue, (Object)theProperty);
    }

    private void throwInvalidRequestForOpOnProperty(ValueSet.FilterOperator theOp, String theProperty) {
        throw new InvalidRequestException("Don't know how to handle op=" + theOp + " on property " + theProperty);
    }

    private void throwInvalidRequestForValueOnProperty(String theValue, String theProperty) {
        throw new InvalidRequestException("Don't know how to handle value=" + theValue + " on property " + theProperty);
    }

    private void expandWithoutHibernateSearch(IValueSetConceptAccumulator theValueSetCodeAccumulator, TermCodeSystemVersion theVersion, Set<String> theAddedCodes, ValueSet.ConceptSetComponent theInclude, String theSystem, boolean theAdd) {
        ourLog.trace("Hibernate search is not enabled");
        if (theValueSetCodeAccumulator instanceof ValueSetExpansionComponentWithConceptAccumulator) {
            Validate.isTrue((boolean)((ValueSetExpansionComponentWithConceptAccumulator)theValueSetCodeAccumulator).getParameter().isEmpty(), (String)"Can not expand ValueSet with parameters - Hibernate Search is not enabled on this server.", (Object[])new Object[0]);
        }
        Validate.isTrue((boolean)theInclude.getFilter().isEmpty(), (String)"Can not expand ValueSet with filters - Hibernate Search is not enabled on this server.", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)theSystem), (String)"Can not expand ValueSet without explicit system - Hibernate Search is not enabled on this server.", (Object[])new Object[0]);
        if (theInclude.getConcept().isEmpty()) {
            for (TermConcept next : theVersion.getConcepts()) {
                this.addCodeIfNotAlreadyAdded(theValueSetCodeAccumulator, theAddedCodes, theAdd, theSystem, theInclude.getVersion(), next.getCode(), next.getDisplay(), next.getId(), next.getParentPidsAsString());
            }
        }
        for (TermConcept next : theInclude.getConcept()) {
            if (!theSystem.equals(theInclude.getSystem()) && StringUtils.isNotBlank((CharSequence)theSystem)) continue;
            this.addCodeIfNotAlreadyAdded(theValueSetCodeAccumulator, theAddedCodes, theAdd, theSystem, theInclude.getVersion(), next.getCode(), next.getDisplay(), null, null);
        }
    }

    @Override
    public boolean isValueSetPreExpandedForCodeValidation(ValueSet theValueSet) {
        ResourcePersistentId valueSetResourcePid = this.myConceptStorageSvc.getValueSetResourcePid((IIdType)theValueSet.getIdElement());
        Optional<TermValueSet> optionalTermValueSet = this.myValueSetDao.findByResourcePid(valueSetResourcePid.getIdAsLong());
        if (!optionalTermValueSet.isPresent()) {
            ourLog.warn("ValueSet is not present in terminology tables. Will perform in-memory code validation. {}", (Object)this.getValueSetInfo(theValueSet));
            return false;
        }
        TermValueSet termValueSet = optionalTermValueSet.get();
        if (termValueSet.getExpansionStatus() != TermValueSetPreExpansionStatusEnum.EXPANDED) {
            ourLog.warn("{} is present in terminology tables but not ready for persistence-backed invocation of operation $validation-code. Will perform in-memory code validation. Current status: {} | {}", new Object[]{this.getValueSetInfo(theValueSet), termValueSet.getExpansionStatus().name(), termValueSet.getExpansionStatus().getDescription()});
            return false;
        }
        return true;
    }

    protected IValidationSupport.CodeValidationResult validateCodeIsInPreExpandedValueSet(ConceptValidationOptions theValidationOptions, ValueSet theValueSet, String theSystem, String theCode, String theDisplay, Coding theCoding, CodeableConcept theCodeableConcept) {
        ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)theValueSet.hasId(), (String)"ValueSet.id is required", (Object[])new Object[0]);
        ResourcePersistentId valueSetResourcePid = this.myConceptStorageSvc.getValueSetResourcePid((IIdType)theValueSet.getIdElement());
        ArrayList<TermValueSetConcept> concepts = new ArrayList<TermValueSetConcept>();
        if (StringUtils.isNotBlank((CharSequence)theCode)) {
            if (theValidationOptions.isInferSystem()) {
                concepts.addAll(this.myValueSetConceptDao.findByValueSetResourcePidAndCode(valueSetResourcePid.getIdAsLong(), theCode));
            } else if (StringUtils.isNotBlank((CharSequence)theSystem)) {
                concepts.addAll(this.findByValueSetResourcePidSystemAndCode(valueSetResourcePid, theSystem, theCode));
            }
        } else if (theCoding != null) {
            if (theCoding.hasSystem() && theCoding.hasCode()) {
                concepts.addAll(this.findByValueSetResourcePidSystemAndCode(valueSetResourcePid, theCoding.getSystem(), theCoding.getCode()));
            }
        } else if (theCodeableConcept != null) {
            for (Coding coding : theCodeableConcept.getCoding()) {
                if (!coding.hasSystem() || !coding.hasCode()) continue;
                concepts.addAll(this.findByValueSetResourcePidSystemAndCode(valueSetResourcePid, coding.getSystem(), coding.getCode()));
                if (concepts.isEmpty()) continue;
                break;
            }
        } else {
            return null;
        }
        if (theValidationOptions.isValidateDisplay() && concepts.size() > 0) {
            for (TermValueSetConcept concept : concepts) {
                if (!StringUtils.isBlank((CharSequence)theDisplay) && !StringUtils.isBlank((CharSequence)concept.getDisplay()) && !theDisplay.equals(concept.getDisplay())) continue;
                return new IValidationSupport.CodeValidationResult().setCode(concept.getCode()).setDisplay(concept.getDisplay());
            }
            return this.createFailureCodeValidationResult(theSystem, theCode, " - Concept Display \"" + theDisplay + "\" does not match expected \"" + ((TermValueSetConcept)concepts.get(0)).getDisplay() + "\"").setDisplay(((TermValueSetConcept)concepts.get(0)).getDisplay());
        }
        if (!concepts.isEmpty()) {
            return new IValidationSupport.CodeValidationResult().setCode(((TermValueSetConcept)concepts.get(0)).getCode()).setDisplay(((TermValueSetConcept)concepts.get(0)).getDisplay());
        }
        return this.createFailureCodeValidationResult(theSystem, theCode);
    }

    private IValidationSupport.CodeValidationResult createFailureCodeValidationResult(String theSystem, String theCode) {
        String append = "";
        return this.createFailureCodeValidationResult(theSystem, theCode, append);
    }

    private IValidationSupport.CodeValidationResult createFailureCodeValidationResult(String theSystem, String theCode, String theAppend) {
        return new IValidationSupport.CodeValidationResult().setSeverity(IValidationSupport.IssueSeverity.ERROR).setMessage("Unknown code {" + theSystem + "}" + theCode + theAppend);
    }

    private List<TermValueSetConcept> findByValueSetResourcePidSystemAndCode(ResourcePersistentId theResourcePid, String theSystem, String theCode) {
        Optional<TermValueSetConcept> optionalTermValueSetConcept;
        ArrayList<TermValueSetConcept> retVal = new ArrayList<TermValueSetConcept>();
        int versionIndex = theSystem.indexOf("|");
        if (versionIndex >= 0) {
            String systemUrl = theSystem.substring(0, versionIndex);
            String systemVersion = theSystem.substring(versionIndex + 1);
            optionalTermValueSetConcept = this.myValueSetConceptDao.findByValueSetResourcePidSystemAndCodeWithVersion(theResourcePid.getIdAsLong(), systemUrl, systemVersion, theCode);
        } else {
            optionalTermValueSetConcept = this.myValueSetConceptDao.findByValueSetResourcePidSystemAndCode(theResourcePid.getIdAsLong(), theSystem, theCode);
        }
        optionalTermValueSetConcept.ifPresent(retVal::add);
        return retVal;
    }

    private void fetchChildren(TermConcept theConcept, Set<TermConcept> theSetToPopulate) {
        for (TermConceptParentChildLink nextChildLink : theConcept.getChildren()) {
            TermConcept nextChild = nextChildLink.getChild();
            if (!this.addToSet(theSetToPopulate, nextChild)) continue;
            this.fetchChildren(nextChild, theSetToPopulate);
        }
    }

    private Optional<TermConcept> fetchLoadedCode(Long theCodeSystemResourcePid, String theCode) {
        TermCodeSystemVersion codeSystem = this.myCodeSystemVersionDao.findCurrentVersionForCodeSystemResourcePid(theCodeSystemResourcePid);
        return this.myConceptDao.findByCodeSystemAndCode(codeSystem, theCode);
    }

    private void fetchParents(TermConcept theConcept, Set<TermConcept> theSetToPopulate) {
        for (TermConceptParentChildLink nextChildLink : theConcept.getParents()) {
            TermConcept nextChild = nextChildLink.getParent();
            if (!this.addToSet(theSetToPopulate, nextChild)) continue;
            this.fetchParents(nextChild, theSetToPopulate);
        }
    }

    private CodeSystem.ConceptDefinitionComponent findCode(List<CodeSystem.ConceptDefinitionComponent> theConcepts, String theCode) {
        for (CodeSystem.ConceptDefinitionComponent next : theConcepts) {
            if (theCode.equals(next.getCode())) {
                return next;
            }
            CodeSystem.ConceptDefinitionComponent val = this.findCode(next.getConcept(), theCode);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Override
    public Optional<TermConcept> findCode(String theCodeSystem, String theCode) {
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTransactionManager);
        txTemplate.setPropagationBehavior(2);
        return (Optional)txTemplate.execute(t -> {
            TermCodeSystemVersion csv = this.getCurrentCodeSystemVersion(theCodeSystem);
            if (csv == null) {
                return Optional.empty();
            }
            return this.myConceptDao.findByCodeSystemAndCode(csv, theCode);
        });
    }

    @Nullable
    private TermCodeSystemVersion getCurrentCodeSystemVersion(String theCodeSystemIdentifier) {
        String version = this.getVersionFromIdentifier(theCodeSystemIdentifier);
        TermCodeSystemVersion retVal = (TermCodeSystemVersion)this.myCodeSystemCurrentVersionCache.get((Object)theCodeSystemIdentifier, t -> (TermCodeSystemVersion)this.myTxTemplate.execute(tx -> {
            TermCodeSystemVersion csv = null;
            TermCodeSystem cs = this.myCodeSystemDao.findByCodeSystemUri(this.getUrlFromIdentifier(theCodeSystemIdentifier));
            if (cs != null) {
                if (version != null) {
                    csv = this.myCodeSystemVersionDao.findByCodeSystemPidAndVersion(cs.getPid(), version);
                } else if (cs.getCurrentVersion() != null) {
                    csv = cs.getCurrentVersion();
                }
            }
            if (csv != null) {
                return csv;
            }
            return NO_CURRENT_VERSION;
        }));
        if (retVal == NO_CURRENT_VERSION) {
            return null;
        }
        return retVal;
    }

    private String getVersionFromIdentifier(String theUri) {
        int versionSeparator;
        String retVal = null;
        if (StringUtils.isNotEmpty((CharSequence)theUri) && (versionSeparator = theUri.lastIndexOf(124)) != -1) {
            retVal = theUri.substring(versionSeparator + 1);
        }
        return retVal;
    }

    private String getUrlFromIdentifier(String theUri) {
        int versionSeparator;
        String retVal = theUri;
        if (StringUtils.isNotEmpty((CharSequence)theUri) && (versionSeparator = theUri.lastIndexOf(124)) != -1) {
            retVal = theUri.substring(0, versionSeparator);
        }
        return retVal;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Set<TermConcept> findCodesAbove(Long theCodeSystemResourcePid, Long theCodeSystemVersionPid, String theCode) {
        StopWatch stopwatch = new StopWatch();
        Optional<TermConcept> concept = this.fetchLoadedCode(theCodeSystemResourcePid, theCode);
        if (!concept.isPresent()) {
            return Collections.emptySet();
        }
        HashSet<TermConcept> retVal = new HashSet<TermConcept>();
        retVal.add(concept.get());
        this.fetchParents(concept.get(), retVal);
        ourLog.debug("Fetched {} codes above code {} in {}ms", new Object[]{retVal.size(), theCode, stopwatch.getMillis()});
        return retVal;
    }

    @Override
    @Transactional
    public List<FhirVersionIndependentConcept> findCodesAbove(String theSystem, String theCode) {
        TermCodeSystem cs = this.getCodeSystem(theSystem);
        if (cs == null) {
            return this.findCodesAboveUsingBuiltInSystems(theSystem, theCode);
        }
        TermCodeSystemVersion csv = cs.getCurrentVersion();
        Set<TermConcept> codes = this.findCodesAbove(cs.getResource().getId(), csv.getPid(), theCode);
        return this.toVersionIndependentConcepts(theSystem, codes);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Set<TermConcept> findCodesBelow(Long theCodeSystemResourcePid, Long theCodeSystemVersionPid, String theCode) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Optional<TermConcept> concept = this.fetchLoadedCode(theCodeSystemResourcePid, theCode);
        if (!concept.isPresent()) {
            return Collections.emptySet();
        }
        HashSet<TermConcept> retVal = new HashSet<TermConcept>();
        retVal.add(concept.get());
        this.fetchChildren(concept.get(), retVal);
        ourLog.debug("Fetched {} codes below code {} in {}ms", new Object[]{retVal.size(), theCode, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return retVal;
    }

    @Override
    @Transactional
    public List<FhirVersionIndependentConcept> findCodesBelow(String theSystem, String theCode) {
        TermCodeSystem cs = this.getCodeSystem(theSystem);
        if (cs == null) {
            return this.findCodesBelowUsingBuiltInSystems(theSystem, theCode);
        }
        TermCodeSystemVersion csv = cs.getCurrentVersion();
        Set<TermConcept> codes = this.findCodesBelow(cs.getResource().getId(), csv.getPid(), theCode);
        return this.toVersionIndependentConcepts(theSystem, codes);
    }

    private TermCodeSystem getCodeSystem(String theSystem) {
        return this.myCodeSystemDao.findByCodeSystemUri(theSystem);
    }

    @PostConstruct
    public void start() {
        RuleBasedTransactionAttribute rules = new RuleBasedTransactionAttribute();
        rules.getRollbackRules().add(new NoRollbackRuleAttribute(ExpansionTooCostlyException.class));
        this.myTxTemplate = new TransactionTemplate(this.myTransactionManager, (TransactionDefinition)rules);
        this.scheduleJob();
    }

    public void scheduleJob() {
        ScheduledJobDefinition vsJobDefinition = new ScheduledJobDefinition();
        vsJobDefinition.setId(this.getClass().getName());
        vsJobDefinition.setJobClass(Job.class);
        this.mySchedulerService.scheduleClusteredJob(600000L, vsJobDefinition);
    }

    @Override
    public synchronized void preExpandDeferredValueSetsToTerminologyTables() {
        if (!this.myDaoConfig.isEnableTaskPreExpandValueSets()) {
            return;
        }
        if (this.isNotSafeToPreExpandValueSets()) {
            ourLog.info("Skipping scheduled pre-expansion of ValueSets while deferred entities are being loaded.");
            return;
        }
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTxManager);
        while (true) {
            StopWatch sw = new StopWatch();
            TermValueSet valueSetToExpand = (TermValueSet)txTemplate.execute(t -> {
                Optional<TermValueSet> optionalTermValueSet = this.getNextTermValueSetNotExpanded();
                if (!optionalTermValueSet.isPresent()) {
                    return null;
                }
                TermValueSet termValueSet = optionalTermValueSet.get();
                termValueSet.setExpansionStatus(TermValueSetPreExpansionStatusEnum.EXPANSION_IN_PROGRESS);
                return (TermValueSet)this.myValueSetDao.saveAndFlush(termValueSet);
            });
            if (valueSetToExpand == null) {
                return;
            }
            try {
                ValueSet valueSet = (ValueSet)txTemplate.execute(t -> {
                    TermValueSet refreshedValueSetToExpand = (TermValueSet)this.myValueSetDao.findById(valueSetToExpand.getId()).orElseThrow(() -> new IllegalStateException("Unknown VS ID: " + valueSetToExpand.getId()));
                    return this.getValueSetFromResourceTable(refreshedValueSetToExpand.getResource());
                });
                assert (valueSet != null);
                ValueSetConceptAccumulator accumulator = new ValueSetConceptAccumulator(valueSetToExpand, this.myValueSetDao, this.myValueSetConceptDao, this.myValueSetConceptDesignationDao);
                this.expandValueSet(null, valueSet, (IValueSetConceptAccumulator)accumulator);
                txTemplate.execute(t -> {
                    valueSetToExpand.setExpansionStatus(TermValueSetPreExpansionStatusEnum.EXPANDED);
                    this.myValueSetDao.saveAndFlush(valueSetToExpand);
                    return null;
                });
                ourLog.info("Pre-expanded ValueSet[{}] with URL[{}] - Saved {} concepts in {}", new Object[]{valueSet.getId(), valueSet.getUrl(), accumulator.getConceptsSaved(), sw});
                continue;
            }
            catch (Exception e) {
                ourLog.error("Failed to pre-expand ValueSet: " + e.getMessage(), (Throwable)e);
                txTemplate.execute(t -> {
                    valueSetToExpand.setExpansionStatus(TermValueSetPreExpansionStatusEnum.FAILED_TO_EXPAND);
                    this.myValueSetDao.saveAndFlush(valueSetToExpand);
                    return null;
                });
                continue;
            }
            break;
        }
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCode(ConceptValidationOptions theOptions, IIdType theValueSetId, String theValueSetIdentifier, String theCodeSystemIdentifierToValidate, String theCodeToValidate, String theDisplayToValidate, IBaseDatatype theCodingToValidate, IBaseDatatype theCodeableConceptToValidate) {
        String valueSetIdentifier;
        boolean haveCode;
        CodeableConcept codeableConcept = this.toCanonicalCodeableConcept(theCodeableConceptToValidate);
        boolean haveCodeableConcept = codeableConcept != null && codeableConcept.getCoding().size() > 0;
        Coding canonicalCodingToValidate = this.toCanonicalCoding(theCodingToValidate);
        boolean haveCoding = canonicalCodingToValidate != null && !canonicalCodingToValidate.isEmpty();
        boolean bl = haveCode = theCodeToValidate != null && !theCodeToValidate.isEmpty();
        if (!(haveCodeableConcept || haveCoding || haveCode)) {
            throw new InvalidRequestException("No code, coding, or codeableConcept provided to validate");
        }
        if (!LogicUtil.multiXor(haveCodeableConcept, haveCoding, haveCode)) {
            throw new InvalidRequestException("$validate-code can only validate (system AND code) OR (coding) OR (codeableConcept)");
        }
        boolean haveIdentifierParam = StringUtils.isNotBlank((CharSequence)theValueSetIdentifier);
        if (theValueSetId != null) {
            IBaseResource valueSet = this.myDaoRegistry.getResourceDao("ValueSet").read(theValueSetId);
            StringBuilder valueSetIdentifierBuilder = new StringBuilder(CommonCodeSystemsTerminologyService.getValueSetUrl((IBaseResource)valueSet));
            String valueSetVersion = CommonCodeSystemsTerminologyService.getValueSetVersion((IBaseResource)valueSet);
            if (valueSetVersion != null) {
                valueSetIdentifierBuilder.append("|").append(valueSetVersion);
            }
            valueSetIdentifier = valueSetIdentifierBuilder.toString();
        } else if (haveIdentifierParam) {
            valueSetIdentifier = theValueSetIdentifier;
        } else {
            throw new InvalidRequestException("Either ValueSet ID or ValueSet identifier or system and code must be provided. Unable to validate.");
        }
        ValidationSupportContext validationContext = new ValidationSupportContext(this.provideValidationSupport());
        String codeValueToValidate = theCodeToValidate;
        String codeSystemIdentifierValueToValidate = theCodeSystemIdentifierToValidate;
        String codeDisplayValueToValidate = theDisplayToValidate;
        if (haveCodeableConcept) {
            for (int i = 0; i < codeableConcept.getCoding().size(); ++i) {
                Coding nextCoding = (Coding)codeableConcept.getCoding().get(i);
                String codeSystemIdentifier = nextCoding.hasVersion() ? nextCoding.getSystem() + "|" + nextCoding.getVersion() : nextCoding.getSystem();
                IValidationSupport.CodeValidationResult nextValidation = this.validateCode(validationContext, theOptions, codeSystemIdentifier, nextCoding.getCode(), nextCoding.getDisplay(), valueSetIdentifier);
                if (!nextValidation.isOk() && i != codeableConcept.getCoding().size() - 1) continue;
                return nextValidation;
            }
        } else if (haveCoding) {
            codeSystemIdentifierValueToValidate = canonicalCodingToValidate.hasVersion() ? canonicalCodingToValidate.getSystem() + "|" + canonicalCodingToValidate.getVersion() : canonicalCodingToValidate.getSystem();
            codeValueToValidate = canonicalCodingToValidate.getCode();
            codeDisplayValueToValidate = canonicalCodingToValidate.getDisplay();
        }
        return this.validateCode(validationContext, theOptions, codeSystemIdentifierValueToValidate, codeValueToValidate, codeDisplayValueToValidate, valueSetIdentifier);
    }

    private boolean isNotSafeToPreExpandValueSets() {
        return this.myDeferredStorageSvc != null && !this.myDeferredStorageSvc.isStorageQueueEmpty();
    }

    protected abstract ValueSet getValueSetFromResourceTable(ResourceTable var1);

    private Optional<TermValueSet> getNextTermValueSetNotExpanded() {
        Optional<TermValueSet> retVal = Optional.empty();
        Slice<TermValueSet> page = this.myValueSetDao.findByExpansionStatus((Pageable)PageRequest.of((int)0, (int)1), TermValueSetPreExpansionStatusEnum.NOT_EXPANDED);
        if (!page.getContent().isEmpty()) {
            retVal = Optional.of((TermValueSet)page.getContent().get(0));
        }
        return retVal;
    }

    @Override
    @Transactional
    public void storeTermValueSet(ResourceTable theResourceTable, ValueSet theValueSet) {
        ValidateUtil.isTrueOrThrowInvalidRequest((theResourceTable != null ? 1 : 0) != 0, (String)"No resource supplied", (Object[])new Object[0]);
        if (BaseTermReadSvcImpl.isPlaceholder((DomainResource)theValueSet)) {
            ourLog.info("Not storing TermValueSet for placeholder {}", (Object)theValueSet.getIdElement().toVersionless().getValueAsString());
            return;
        }
        ValidateUtil.isNotBlankOrThrowUnprocessableEntity((String)theValueSet.getUrl(), (String)"ValueSet has no value for ValueSet.url");
        ourLog.info("Storing TermValueSet for {}", (Object)theValueSet.getIdElement().toVersionless().getValueAsString());
        TermValueSet termValueSet = new TermValueSet();
        termValueSet.setResource(theResourceTable);
        termValueSet.setUrl(theValueSet.getUrl());
        termValueSet.setVersion(theValueSet.getVersion());
        termValueSet.setName(theValueSet.hasName() ? theValueSet.getName() : null);
        this.deleteValueSetForResource(theResourceTable);
        String url = termValueSet.getUrl();
        String version = termValueSet.getVersion();
        Optional<TermValueSet> optionalExistingTermValueSetByUrl = version != null ? this.myValueSetDao.findTermValueSetByUrlAndVersion(url, version) : this.myValueSetDao.findTermValueSetByUrlAndNullVersion(url);
        if (optionalExistingTermValueSetByUrl.isPresent()) {
            TermValueSet existingTermValueSet = optionalExistingTermValueSetByUrl.get();
            String msg = version != null ? this.myContext.getLocalizer().getMessage(BaseTermReadSvcImpl.class, "cannotCreateDuplicateValueSetUrlAndVersion", new Object[]{url, version, existingTermValueSet.getResource().getIdDt().toUnqualifiedVersionless().getValue()}) : this.myContext.getLocalizer().getMessage(BaseTermReadSvcImpl.class, "cannotCreateDuplicateValueSetUrl", new Object[]{url, existingTermValueSet.getResource().getIdDt().toUnqualifiedVersionless().getValue()});
            throw new UnprocessableEntityException(msg);
        }
        this.myValueSetDao.save(termValueSet);
    }

    @Override
    @Transactional
    public IFhirResourceDaoCodeSystem.SubsumesResult subsumes(IPrimitiveType<String> theCodeA, IPrimitiveType<String> theCodeB, IPrimitiveType<String> theSystem, IBaseCoding theCodingA, IBaseCoding theCodingB) {
        FhirVersionIndependentConcept conceptA = this.toConcept(theCodeA, theSystem, theCodingA);
        FhirVersionIndependentConcept conceptB = this.toConcept(theCodeB, theSystem, theCodingB);
        if (!StringUtils.equals((CharSequence)conceptA.getSystem(), (CharSequence)conceptB.getSystem())) {
            throw new InvalidRequestException("Unable to test subsumption across different code systems");
        }
        if (!StringUtils.equals((CharSequence)conceptA.getSystemVersion(), (CharSequence)conceptB.getSystemVersion())) {
            throw new InvalidRequestException("Unable to test subsumption across different code system versions");
        }
        String codeASystemIdentifier = StringUtils.isNotEmpty((CharSequence)conceptA.getSystemVersion()) ? conceptA.getSystem() + "|" + conceptA.getSystemVersion() : conceptA.getSystem();
        TermConcept codeA = this.findCode(codeASystemIdentifier, conceptA.getCode()).orElseThrow(() -> new InvalidRequestException("Unknown code: " + conceptA));
        String codeBSystemIdentifier = StringUtils.isNotEmpty((CharSequence)conceptB.getSystemVersion()) ? conceptB.getSystem() + "|" + conceptB.getSystemVersion() : conceptB.getSystem();
        TermConcept codeB = this.findCode(codeBSystemIdentifier, conceptB.getCode()).orElseThrow(() -> new InvalidRequestException("Unknown code: " + conceptB));
        SearchSession searchSession = Search.session((EntityManager)this.myEntityManager);
        ConceptSubsumptionOutcome subsumes = this.testForSubsumption(searchSession, codeA, codeB, ConceptSubsumptionOutcome.SUBSUMES);
        if (subsumes == null) {
            subsumes = this.testForSubsumption(searchSession, codeB, codeA, ConceptSubsumptionOutcome.SUBSUMEDBY);
        }
        if (subsumes == null) {
            subsumes = ConceptSubsumptionOutcome.NOTSUBSUMED;
        }
        return new IFhirResourceDaoCodeSystem.SubsumesResult(subsumes);
    }

    protected abstract ValueSet toCanonicalValueSet(IBaseResource var1);

    protected IValidationSupport.LookupCodeResult lookupCode(String theSystem, String theCode) {
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTransactionManager);
        return (IValidationSupport.LookupCodeResult)txTemplate.execute(t -> {
            Optional<TermConcept> codeOpt = this.findCode(theSystem, theCode);
            if (codeOpt.isPresent()) {
                TermConcept code = codeOpt.get();
                IValidationSupport.LookupCodeResult result = new IValidationSupport.LookupCodeResult();
                result.setCodeSystemDisplayName(code.getCodeSystemVersion().getCodeSystemDisplayName());
                result.setCodeSystemVersion(code.getCodeSystemVersion().getCodeSystemVersionId());
                result.setSearchedForSystem(theSystem);
                result.setSearchedForCode(theCode);
                result.setFound(true);
                result.setCodeDisplay(code.getDisplay());
                for (TermConceptDesignation termConceptDesignation : code.getDesignations()) {
                    IValidationSupport.ConceptDesignation designation = new IValidationSupport.ConceptDesignation();
                    designation.setLanguage(termConceptDesignation.getLanguage());
                    designation.setUseSystem(termConceptDesignation.getUseSystem());
                    designation.setUseCode(termConceptDesignation.getUseCode());
                    designation.setUseDisplay(termConceptDesignation.getUseDisplay());
                    designation.setValue(termConceptDesignation.getValue());
                    result.getDesignations().add(designation);
                }
                for (TermConceptProperty termConceptProperty : code.getProperties()) {
                    IValidationSupport.CodingConceptProperty property;
                    if (termConceptProperty.getType() == TermConceptPropertyTypeEnum.CODING) {
                        property = new IValidationSupport.CodingConceptProperty(termConceptProperty.getKey(), termConceptProperty.getCodeSystem(), termConceptProperty.getValue(), termConceptProperty.getDisplay());
                        result.getProperties().add(property);
                        continue;
                    }
                    if (termConceptProperty.getType() == TermConceptPropertyTypeEnum.STRING) {
                        property = new IValidationSupport.StringConceptProperty(termConceptProperty.getKey(), termConceptProperty.getValue());
                        result.getProperties().add(property);
                        continue;
                    }
                    throw new InternalErrorException("Unknown type: " + (Object)((Object)termConceptProperty.getType()));
                }
                return result;
            }
            return null;
        });
    }

    @Nullable
    private ConceptSubsumptionOutcome testForSubsumption(SearchSession theSearchSession, TermConcept theLeft, TermConcept theRight, ConceptSubsumptionOutcome theOutput) {
        List fetch = theSearchSession.search(TermConcept.class).where(f -> f.bool().must((PredicateFinalStep)f.match().field("myId").matching((Object)theRight.getId())).must((PredicateFinalStep)f.match().field("myParentPids").matching((Object)Long.toString(theLeft.getId())))).fetchHits(Integer.valueOf(1));
        if (fetch.size() > 0) {
            return theOutput;
        }
        return null;
    }

    private ArrayList<FhirVersionIndependentConcept> toVersionIndependentConcepts(String theSystem, Set<TermConcept> codes) {
        ArrayList<FhirVersionIndependentConcept> retVal = new ArrayList<FhirVersionIndependentConcept>(codes.size());
        for (TermConcept next : codes) {
            retVal.add(new FhirVersionIndependentConcept(theSystem, next.getCode()));
        }
        return retVal;
    }

    @Transactional
    public IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, @Nonnull IBaseResource theValueSet) {
        BaseTermReadSvcImpl.invokeRunnableForUnitTest();
        IPrimitiveType urlPrimitive = (IPrimitiveType)this.myContext.newTerser().getSingleValueOrNull((IBase)theValueSet, "url", IPrimitiveType.class);
        String url = urlPrimitive.getValueAsString();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            return this.validateCode(theValidationSupportContext, theOptions, theCodeSystem, theCode, theDisplay, url);
        }
        return null;
    }

    @CoverageIgnore
    public IValidationSupport.CodeValidationResult validateCode(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        BaseTermReadSvcImpl.invokeRunnableForUnitTest();
        if (StringUtils.isNotBlank((CharSequence)theValueSetUrl)) {
            return this.validateCodeInValueSet(theValidationSupportContext, theOptions, theValueSetUrl, theCodeSystem, theCode, theDisplay);
        }
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTransactionManager);
        txTemplate.setPropagationBehavior(0);
        Optional codeOpt = (Optional)txTemplate.execute(t -> this.findCode(theCodeSystem, theCode).map(c -> new FhirVersionIndependentConcept(theCodeSystem, c.getCode())));
        if (codeOpt != null && codeOpt.isPresent()) {
            FhirVersionIndependentConcept code = (FhirVersionIndependentConcept)codeOpt.get();
            if (!theOptions.isValidateDisplay() || StringUtils.isNotBlank((CharSequence)code.getDisplay()) && StringUtils.isNotBlank((CharSequence)theDisplay) && code.getDisplay().equals(theDisplay)) {
                return new IValidationSupport.CodeValidationResult().setCode(code.getCode()).setDisplay(code.getDisplay());
            }
            return this.createFailureCodeValidationResult(theCodeSystem, theCode, " - Concept Display \"" + code.getDisplay() + "\" does not match expected \"" + code.getDisplay() + "\"").setDisplay(code.getDisplay());
        }
        return this.createFailureCodeValidationResult(theCodeSystem, theCode);
    }

    IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theValidationOptions, String theValueSetUrl, String theCodeSystem, String theCode, String theDisplay) {
        IValidationSupport.CodeValidationResult retVal;
        Long pid;
        IBaseResource valueSet = theValidationSupportContext.getRootValidationSupport().fetchValueSet(theValueSetUrl);
        if (valueSet instanceof IAnyResource && (pid = IDao.RESOURCE_PID.get((IAnyResource)valueSet)) != null && this.isValueSetPreExpandedForCodeValidation(valueSet)) {
            return this.validateCodeIsInPreExpandedValueSet(theValidationOptions, valueSet, theCodeSystem, theCode, null, null, null);
        }
        if (valueSet != null) {
            retVal = new InMemoryTerminologyServerValidationSupport(this.myContext).validateCodeInValueSet(theValidationSupportContext, theValidationOptions, theCodeSystem, theCode, theDisplay, valueSet);
        } else {
            String append = " - Unable to locate ValueSet[" + theValueSetUrl + "]";
            retVal = this.createFailureCodeValidationResult(theCodeSystem, theCode, append);
        }
        return retVal;
    }

    public IBaseResource fetchCodeSystem(String theSystem) {
        IValidationSupport jpaValidationSupport = this.provideJpaValidationSupport();
        return jpaValidationSupport.fetchCodeSystem(theSystem);
    }

    @Override
    public CodeSystem fetchCanonicalCodeSystemFromCompleteContext(String theSystem) {
        IValidationSupport validationSupport = this.provideValidationSupport();
        IBaseResource codeSystem = validationSupport.fetchCodeSystem(theSystem);
        if (codeSystem != null) {
            codeSystem = this.toCanonicalCodeSystem(codeSystem);
        }
        return (CodeSystem)codeSystem;
    }

    @Nonnull
    private IValidationSupport provideJpaValidationSupport() {
        IValidationSupport jpaValidationSupport = this.myJpaValidationSupport;
        if (jpaValidationSupport == null) {
            this.myJpaValidationSupport = jpaValidationSupport = (IValidationSupport)this.myApplicationContext.getBean("myJpaValidationSupport", IValidationSupport.class);
        }
        return jpaValidationSupport;
    }

    @Nonnull
    private IValidationSupport provideValidationSupport() {
        IValidationSupport validationSupport = this.myValidationSupport;
        if (validationSupport == null) {
            this.myValidationSupport = validationSupport = (IValidationSupport)this.myApplicationContext.getBean(IValidationSupport.class);
        }
        return validationSupport;
    }

    public ValueSet fetchCanonicalValueSetFromCompleteContext(String theSystem) {
        IValidationSupport validationSupport = this.provideValidationSupport();
        IBaseResource valueSet = validationSupport.fetchValueSet(theSystem);
        if (valueSet != null) {
            valueSet = this.toCanonicalValueSet(valueSet);
        }
        return (ValueSet)valueSet;
    }

    protected abstract CodeSystem toCanonicalCodeSystem(IBaseResource var1);

    public IBaseResource fetchValueSet(String theValueSetUrl) {
        return this.provideJpaValidationSupport().fetchValueSet(theValueSetUrl);
    }

    public FhirContext getFhirContext() {
        return this.myContext;
    }

    private void findCodesAbove(CodeSystem theSystem, String theSystemString, String theCode, List<FhirVersionIndependentConcept> theListToPopulate) {
        List conceptList = theSystem.getConcept();
        for (CodeSystem.ConceptDefinitionComponent next : conceptList) {
            this.addTreeIfItContainsCode(theSystemString, next, theCode, theListToPopulate);
        }
    }

    @Override
    public List<FhirVersionIndependentConcept> findCodesAboveUsingBuiltInSystems(String theSystem, String theCode) {
        ArrayList<FhirVersionIndependentConcept> retVal = new ArrayList<FhirVersionIndependentConcept>();
        CodeSystem system = this.fetchCanonicalCodeSystemFromCompleteContext(theSystem);
        if (system != null) {
            this.findCodesAbove(system, theSystem, theCode, retVal);
        }
        return retVal;
    }

    private void findCodesBelow(CodeSystem theSystem, String theSystemString, String theCode, List<FhirVersionIndependentConcept> theListToPopulate) {
        List conceptList = theSystem.getConcept();
        this.findCodesBelow(theSystemString, theCode, theListToPopulate, conceptList);
    }

    private void findCodesBelow(String theSystemString, String theCode, List<FhirVersionIndependentConcept> theListToPopulate, List<CodeSystem.ConceptDefinitionComponent> conceptList) {
        for (CodeSystem.ConceptDefinitionComponent next : conceptList) {
            if (theCode.equals(next.getCode())) {
                this.addAllChildren(theSystemString, next, theListToPopulate);
                continue;
            }
            this.findCodesBelow(theSystemString, theCode, theListToPopulate, next.getConcept());
        }
    }

    @Override
    public List<FhirVersionIndependentConcept> findCodesBelowUsingBuiltInSystems(String theSystem, String theCode) {
        ArrayList<FhirVersionIndependentConcept> retVal = new ArrayList<FhirVersionIndependentConcept>();
        CodeSystem system = this.fetchCanonicalCodeSystemFromCompleteContext(theSystem);
        if (system != null) {
            this.findCodesBelow(system, theSystem, theCode, retVal);
        }
        return retVal;
    }

    private void addAllChildren(String theSystemString, CodeSystem.ConceptDefinitionComponent theCode, List<FhirVersionIndependentConcept> theListToPopulate) {
        if (StringUtils.isNotBlank((CharSequence)theCode.getCode())) {
            theListToPopulate.add(new FhirVersionIndependentConcept(theSystemString, theCode.getCode()));
        }
        for (CodeSystem.ConceptDefinitionComponent nextChild : theCode.getConcept()) {
            this.addAllChildren(theSystemString, nextChild, theListToPopulate);
        }
    }

    private boolean addTreeIfItContainsCode(String theSystemString, CodeSystem.ConceptDefinitionComponent theNext, String theCode, List<FhirVersionIndependentConcept> theListToPopulate) {
        boolean foundCodeInChild = false;
        for (CodeSystem.ConceptDefinitionComponent nextChild : theNext.getConcept()) {
            foundCodeInChild |= this.addTreeIfItContainsCode(theSystemString, nextChild, theCode, theListToPopulate);
        }
        if (theCode.equals(theNext.getCode()) || foundCodeInChild) {
            theListToPopulate.add(new FhirVersionIndependentConcept(theSystemString, theNext.getCode()));
            return true;
        }
        return false;
    }

    @Nullable
    protected abstract Coding toCanonicalCoding(@Nullable IBaseDatatype var1);

    @Nullable
    protected abstract Coding toCanonicalCoding(@Nullable IBaseCoding var1);

    @Nullable
    protected abstract CodeableConcept toCanonicalCodeableConcept(@Nullable IBaseDatatype var1);

    @NotNull
    private FhirVersionIndependentConcept toConcept(IPrimitiveType<String> theCodeType, IPrimitiveType<String> theCodeSystemIdentifierType, IBaseCoding theCodingType) {
        String systemVersion;
        String code = theCodeType != null ? theCodeType.getValueAsString() : null;
        String system = theCodeSystemIdentifierType != null ? this.getUrlFromIdentifier(theCodeSystemIdentifierType.getValueAsString()) : null;
        String string = systemVersion = theCodeSystemIdentifierType != null ? this.getVersionFromIdentifier(theCodeSystemIdentifierType.getValueAsString()) : null;
        if (theCodingType != null) {
            Coding canonicalizedCoding = this.toCanonicalCoding(theCodingType);
            assert (canonicalizedCoding != null);
            code = canonicalizedCoding.getCode();
            system = canonicalizedCoding.getSystem();
            systemVersion = canonicalizedCoding.getVersion();
        }
        return new FhirVersionIndependentConcept(system, code, null, systemVersion);
    }

    @Override
    @Transactional
    public IValidationSupport.CodeValidationResult codeSystemValidateCode(IIdType theCodeSystemId, String theCodeSystemUrl, String theVersion, String theCode, String theDisplay, IBaseDatatype theCoding, IBaseDatatype theCodeableConcept) {
        String codeSystemUrl;
        boolean haveCode;
        CodeableConcept codeableConcept = this.toCanonicalCodeableConcept(theCodeableConcept);
        boolean haveCodeableConcept = codeableConcept != null && codeableConcept.getCoding().size() > 0;
        Coding coding = this.toCanonicalCoding(theCoding);
        boolean haveCoding = coding != null && !coding.isEmpty();
        boolean bl = haveCode = theCode != null && !theCode.isEmpty();
        if (!(haveCodeableConcept || haveCoding || haveCode)) {
            throw new InvalidRequestException("No code, coding, or codeableConcept provided to validate.");
        }
        if (!LogicUtil.multiXor(haveCodeableConcept, haveCoding, haveCode)) {
            throw new InvalidRequestException("$validate-code can only validate (code) OR (coding) OR (codeableConcept)");
        }
        boolean haveIdentifierParam = StringUtils.isNotBlank((CharSequence)theCodeSystemUrl);
        if (theCodeSystemId != null) {
            IBaseResource codeSystem = this.myDaoRegistry.getResourceDao("CodeSystem").read(theCodeSystemId);
            codeSystemUrl = CommonCodeSystemsTerminologyService.getCodeSystemUrl((IBaseResource)codeSystem);
        } else if (haveIdentifierParam) {
            codeSystemUrl = theCodeSystemUrl;
        } else {
            throw new InvalidRequestException("Either CodeSystem ID or CodeSystem identifier must be provided. Unable to validate.");
        }
        String code = theCode;
        String display = theDisplay;
        if (haveCodeableConcept) {
            for (int i = 0; i < codeableConcept.getCoding().size(); ++i) {
                IValidationSupport.CodeValidationResult nextValidation;
                Coding nextCoding = (Coding)codeableConcept.getCoding().get(i);
                if (nextCoding.hasSystem()) {
                    if (!codeSystemUrl.equalsIgnoreCase(nextCoding.getSystem())) {
                        throw new InvalidRequestException("Coding.system '" + nextCoding.getSystem() + "' does not equal with CodeSystem.url '" + theCodeSystemUrl + "'. Unable to validate.");
                    }
                    codeSystemUrl = nextCoding.getSystem();
                }
                if (!(nextValidation = this.codeSystemValidateCode(codeSystemUrl, theVersion, code = nextCoding.getCode(), display = nextCoding.getDisplay())).isOk() && i != codeableConcept.getCoding().size() - 1) continue;
                return nextValidation;
            }
        } else if (haveCoding) {
            if (coding.hasSystem()) {
                if (!codeSystemUrl.equalsIgnoreCase(coding.getSystem())) {
                    throw new InvalidRequestException("Coding.system '" + coding.getSystem() + "' does not equal with CodeSystem.url '" + theCodeSystemUrl + "'. Unable to validate.");
                }
                codeSystemUrl = coding.getSystem();
            }
            code = coding.getCode();
            display = coding.getDisplay();
        }
        return this.codeSystemValidateCode(codeSystemUrl, theVersion, code, display);
    }

    private IValidationSupport.CodeValidationResult codeSystemValidateCode(String theCodeSystemUrl, String theCodeSystemVersion, String theCode, String theDisplay) {
        CriteriaBuilder criteriaBuilder = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(TermConcept.class);
        Root root = query.from(TermConcept.class);
        Fetch systemVersionFetch = root.fetch("myCodeSystem", JoinType.INNER);
        Join systemVersionJoin = (Join)systemVersionFetch;
        Fetch systemFetch = systemVersionFetch.fetch("myCodeSystem", JoinType.INNER);
        Join systemJoin = (Join)systemFetch;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StringUtils.isNotBlank((CharSequence)theCode)) {
            predicates.add(criteriaBuilder.equal((Expression)root.get("myCode"), (Object)theCode));
        }
        if (StringUtils.isNotBlank((CharSequence)theDisplay)) {
            predicates.add(criteriaBuilder.equal((Expression)root.get("myDisplay"), (Object)theDisplay));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{theCodeSystemUrl})) {
            predicates.add(criteriaBuilder.equal((Expression)systemJoin.get("myCodeSystemUri"), (Object)theCodeSystemUrl));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{theCodeSystemVersion})) {
            predicates.add(criteriaBuilder.equal((Expression)systemVersionJoin.get("myCodeSystemVersionId"), (Object)theCodeSystemVersion));
        } else {
            query.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get("myUpdated"))});
        }
        Predicate outerPredicate = criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        query.where((Expression)outerPredicate);
        TypedQuery typedQuery = this.myEntityManager.createQuery(query.select((Selection)root));
        org.hibernate.query.Query hibernateQuery = (org.hibernate.query.Query)typedQuery;
        hibernateQuery.setFetchSize(1);
        List resultsList = hibernateQuery.getResultList();
        if (!resultsList.isEmpty()) {
            TermConcept concept = (TermConcept)resultsList.get(0);
            return new IValidationSupport.CodeValidationResult().setCode(concept.getCode()).setDisplay(concept.getDisplay());
        }
        if (StringUtils.isBlank((CharSequence)theDisplay)) {
            return this.createFailureCodeValidationResult(theCodeSystemUrl, theCode);
        }
        return this.createFailureCodeValidationResult(theCodeSystemUrl, theCode, " - Concept Display : " + theDisplay);
    }

    static boolean isPlaceholder(DomainResource theResource) {
        boolean retVal = false;
        Extension extension = theResource.getExtensionByUrl("http://hapifhir.io/fhir/StructureDefinition/resource-placeholder");
        if (extension != null && extension.hasValue() && extension.getValue() instanceof BooleanType) {
            retVal = ((BooleanType)extension.getValue()).booleanValue();
        }
        return retVal;
    }

    static void invokeRunnableForUnitTest() {
        if (myInvokeOnNextCallForUnitTest != null) {
            Runnable invokeOnNextCallForUnitTest = myInvokeOnNextCallForUnitTest;
            myInvokeOnNextCallForUnitTest = null;
            invokeOnNextCallForUnitTest.run();
        }
    }

    @VisibleForTesting
    public static void setInvokeOnNextCallForUnitTest(Runnable theInvokeOnNextCallForUnitTest) {
        myInvokeOnNextCallForUnitTest = theInvokeOnNextCallForUnitTest;
    }

    static List<TermConcept> toPersistedConcepts(List<CodeSystem.ConceptDefinitionComponent> theConcept, TermCodeSystemVersion theCodeSystemVersion) {
        ArrayList<TermConcept> retVal = new ArrayList<TermConcept>();
        for (CodeSystem.ConceptDefinitionComponent next : theConcept) {
            if (!StringUtils.isNotBlank((CharSequence)next.getCode())) continue;
            TermConcept termConcept = BaseTermReadSvcImpl.toTermConcept(next, theCodeSystemVersion);
            retVal.add(termConcept);
        }
        return retVal;
    }

    @Nonnull
    static TermConcept toTermConcept(CodeSystem.ConceptDefinitionComponent theConceptDefinition, TermCodeSystemVersion theCodeSystemVersion) {
        TermConcept termConcept = new TermConcept();
        termConcept.setCode(theConceptDefinition.getCode());
        termConcept.setCodeSystemVersion(theCodeSystemVersion);
        termConcept.setDisplay(theConceptDefinition.getDisplay());
        termConcept.addChildren(BaseTermReadSvcImpl.toPersistedConcepts(theConceptDefinition.getConcept(), theCodeSystemVersion), TermConceptParentChildLink.RelationshipTypeEnum.ISA);
        for (CodeSystem.ConceptDefinitionDesignationComponent designationComponent : theConceptDefinition.getDesignation()) {
            if (!StringUtils.isNotBlank((CharSequence)designationComponent.getValue())) continue;
            TermConceptDesignation designation = termConcept.addDesignation();
            designation.setLanguage(designationComponent.hasLanguage() ? designationComponent.getLanguage() : null);
            if (designationComponent.hasUse()) {
                designation.setUseSystem(designationComponent.getUse().hasSystem() ? designationComponent.getUse().getSystem() : null);
                designation.setUseCode(designationComponent.getUse().hasCode() ? designationComponent.getUse().getCode() : null);
                designation.setUseDisplay(designationComponent.getUse().hasDisplay() ? designationComponent.getUse().getDisplay() : null);
            }
            designation.setValue(designationComponent.getValue());
        }
        for (CodeSystem.ConceptPropertyComponent next : theConceptDefinition.getProperty()) {
            TermConceptProperty property = new TermConceptProperty();
            property.setKey(next.getCode());
            property.setConcept(termConcept);
            property.setCodeSystemVersion(theCodeSystemVersion);
            if (next.getValue() instanceof StringType) {
                property.setType(TermConceptPropertyTypeEnum.STRING);
                property.setValue((String)next.getValueStringType().getValue());
            } else if (next.getValue() instanceof Coding) {
                Coding nextCoding = next.getValueCoding();
                property.setType(TermConceptPropertyTypeEnum.CODING);
                property.setCodeSystem(nextCoding.getSystem());
                property.setValue(nextCoding.getCode());
                property.setDisplay(nextCoding.getDisplay());
            } else if (next.getValue() != null) {
                ourLog.warn("Don't know how to handle properties of type: " + next.getValue().getClass());
                continue;
            }
            termConcept.getProperties().add(property);
        }
        return termConcept;
    }

    private static /* synthetic */ PredicateFinalStep lambda$expandValueSetHandleIncludeOrExcludeUsingDatabase$8(PredicateFinalStep finishedQuery, SearchPredicateFactory f) {
        return finishedQuery;
    }

    private /* synthetic */ Boolean lambda$expandValueSet$2(ValueSetExpansionOptions theExpansionOptions, IValueSetConceptAccumulator theValueSetCodeAccumulator, Set addedCodes, ValueSet.ConceptSetComponent exclude, int queryIndex) {
        boolean add = false;
        ExpansionFilter expansionFilter = ExpansionFilter.NO_FILTER;
        return this.expandValueSetHandleIncludeOrExclude(theExpansionOptions, theValueSetCodeAccumulator, addedCodes, exclude, add, queryIndex, expansionFilter);
    }

    private /* synthetic */ Boolean lambda$expandValueSet$1(ValueSetExpansionOptions theExpansionOptions, IValueSetConceptAccumulator theValueSetCodeAccumulator, Set addedCodes, ValueSet.ConceptSetComponent include, int queryIndex, ExpansionFilter theExpansionFilter) {
        boolean add = true;
        return this.expandValueSetHandleIncludeOrExclude(theExpansionOptions, theValueSetCodeAccumulator, addedCodes, include, add, queryIndex, theExpansionFilter);
    }

    public static class Job
    implements HapiJob {
        @Autowired
        private ITermReadSvc myTerminologySvc;

        public void execute(JobExecutionContext theContext) {
            this.myTerminologySvc.preExpandDeferredValueSetsToTerminologyTables();
        }
    }
}

