/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.term.BaseTermReadSvcImpl;
import ca.uhn.fhir.jpa.term.IValueSetConceptAccumulator;
import ca.uhn.fhir.jpa.term.api.ITermReadSvcDstu3;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.ValidateUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_30_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_40;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class TermReadSvcDstu3
extends BaseTermReadSvcImpl
implements IValidationSupport,
ITermReadSvcDstu3 {
    @Autowired
    private PlatformTransactionManager myTransactionManager;

    public IValidationSupport.ValueSetExpansionOutcome expandValueSet(ValidationSupportContext theValidationSupportContext, ValueSetExpansionOptions theExpansionOptions, @Nonnull IBaseResource theValueSetToExpand) {
        try {
            org.hl7.fhir.r4.model.ValueSet valueSetToExpandR4 = this.toCanonicalValueSet(theValueSetToExpand);
            org.hl7.fhir.r4.model.ValueSet expandedR4 = super.expandValueSet(theExpansionOptions, valueSetToExpandR4);
            return new IValidationSupport.ValueSetExpansionOutcome((IBaseResource)VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.r4.model.Resource)expandedR4, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false))), null);
        }
        catch (FHIRException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    public IBaseResource expandValueSet(ValueSetExpansionOptions theExpansionOptions, IBaseResource theInput) {
        ValueSet valueSetToExpand = (ValueSet)theInput;
        try {
            org.hl7.fhir.r4.model.ValueSet valueSetToExpandR4 = this.toCanonicalValueSet((IBaseResource)valueSetToExpand);
            org.hl7.fhir.r4.model.ValueSet expandedR4 = super.expandValueSet(theExpansionOptions, valueSetToExpandR4);
            return VersionConvertorFactory_30_40.convertResource((org.hl7.fhir.r4.model.Resource)expandedR4, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
        }
        catch (FHIRException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    protected org.hl7.fhir.r4.model.ValueSet toCanonicalValueSet(IBaseResource theValueSet) throws FHIRException {
        org.hl7.fhir.r4.model.ValueSet valueSetToExpandR4 = (org.hl7.fhir.r4.model.ValueSet)VersionConvertorFactory_30_40.convertResource((Resource)((ValueSet)theValueSet), (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
        return valueSetToExpandR4;
    }

    @Override
    protected CodeSystem toCanonicalCodeSystem(IBaseResource theCodeSystem) {
        return (CodeSystem)VersionConvertorFactory_30_40.convertResource((Resource)((org.hl7.fhir.dstu3.model.CodeSystem)theCodeSystem), (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    protected Coding toCanonicalCoding(IBaseDatatype theCoding) {
        return (Coding)VersionConvertorFactory_30_40.convertType((Type)((org.hl7.fhir.dstu3.model.Coding)theCoding), (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    protected Coding toCanonicalCoding(IBaseCoding theCoding) {
        return (Coding)VersionConvertorFactory_30_40.convertType((Type)((org.hl7.fhir.dstu3.model.Coding)theCoding), (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
    }

    @Override
    @Nullable
    protected CodeableConcept toCanonicalCodeableConcept(IBaseDatatype theCoding) {
        return (CodeableConcept)VersionConvertorFactory_30_40.convertType((Type)((org.hl7.fhir.dstu3.model.CodeableConcept)theCoding), (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
    }

    @Override
    public void expandValueSet(ValueSetExpansionOptions theExpansionOptions, IBaseResource theValueSetToExpand, IValueSetConceptAccumulator theValueSetCodeAccumulator) {
        ValueSet valueSetToExpand = (ValueSet)theValueSetToExpand;
        try {
            org.hl7.fhir.r4.model.ValueSet valueSetToExpandR4 = this.toCanonicalValueSet((IBaseResource)valueSetToExpand);
            super.expandValueSet(theExpansionOptions, valueSetToExpandR4, theValueSetCodeAccumulator);
        }
        catch (FHIRException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    @Override
    protected org.hl7.fhir.r4.model.ValueSet getValueSetFromResourceTable(ResourceTable theResourceTable) {
        org.hl7.fhir.r4.model.ValueSet valueSetR4;
        ValueSet valueSet = (ValueSet)this.myDaoRegistry.getResourceDao("ValueSet").toResource(ValueSet.class, (IBaseResourceEntity)theResourceTable, null, false);
        try {
            valueSetR4 = this.toCanonicalValueSet((IBaseResource)valueSet);
        }
        catch (FHIRException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return valueSetR4;
    }

    public IValidationSupport.LookupCodeResult lookupCode(ValidationSupportContext theValidationSupportContext, String theSystem, String theCode) {
        return super.lookupCode(theSystem, theCode);
    }

    @Override
    public FhirContext getFhirContext() {
        return this.myContext;
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCodeIsInPreExpandedValueSet(ConceptValidationOptions theOptions, IBaseResource theValueSet, String theSystem, String theCode, String theDisplay, IBaseDatatype theCoding, IBaseDatatype theCodeableConcept) {
        ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)theValueSet, (String)"ValueSet must not be null", (Object[])new Object[0]);
        ValueSet valueSet = (ValueSet)theValueSet;
        org.hl7.fhir.r4.model.ValueSet valueSetR4 = (org.hl7.fhir.r4.model.ValueSet)VersionConvertorFactory_30_40.convertResource((Resource)valueSet, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
        org.hl7.fhir.dstu3.model.Coding coding = (org.hl7.fhir.dstu3.model.Coding)theCoding;
        Coding codingR4 = null;
        if (coding != null) {
            codingR4 = new Coding(coding.getSystem(), coding.getCode(), coding.getDisplay());
        }
        org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept = (org.hl7.fhir.dstu3.model.CodeableConcept)theCodeableConcept;
        CodeableConcept codeableConceptR4 = null;
        if (codeableConcept != null) {
            codeableConceptR4 = new CodeableConcept();
            for (org.hl7.fhir.dstu3.model.Coding nestedCoding : codeableConcept.getCoding()) {
                codeableConceptR4.addCoding(new Coding(nestedCoding.getSystem(), nestedCoding.getCode(), nestedCoding.getDisplay()));
            }
        }
        return super.validateCodeIsInPreExpandedValueSet(theOptions, valueSetR4, theSystem, theCode, theDisplay, codingR4, codeableConceptR4);
    }

    @Override
    public boolean isValueSetPreExpandedForCodeValidation(IBaseResource theValueSet) {
        ValidateUtil.isNotNullOrThrowUnprocessableEntity((Object)theValueSet, (String)"ValueSet must not be null", (Object[])new Object[0]);
        ValueSet valueSet = (ValueSet)theValueSet;
        org.hl7.fhir.r4.model.ValueSet valueSetR4 = (org.hl7.fhir.r4.model.ValueSet)VersionConvertorFactory_30_40.convertResource((Resource)valueSet, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
        return super.isValueSetPreExpandedForCodeValidation(valueSetR4);
    }
}

