/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.term.BaseTermVersionAdapterSvcImpl;
import ca.uhn.fhir.jpa.term.api.ITermVersionAdapterSvc;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.UrlUtil;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_30_40;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_40;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

public class TermVersionAdapterSvcDstu3
extends BaseTermVersionAdapterSvcImpl
implements ITermVersionAdapterSvc {
    private IFhirResourceDao<org.hl7.fhir.dstu3.model.ConceptMap> myConceptMapResourceDao;
    private IFhirResourceDao<org.hl7.fhir.dstu3.model.CodeSystem> myCodeSystemResourceDao;
    private IFhirResourceDao<ValueSet> myValueSetResourceDao;
    @Autowired
    private ApplicationContext myAppCtx;

    @EventListener
    public void start(ContextRefreshedEvent theEvent) {
        this.myCodeSystemResourceDao = (IFhirResourceDao)this.myAppCtx.getBean("myCodeSystemDaoDstu3");
        this.myValueSetResourceDao = (IFhirResourceDao)this.myAppCtx.getBean("myValueSetDaoDstu3");
        this.myConceptMapResourceDao = (IFhirResourceDao)this.myAppCtx.getBean("myConceptMapDaoDstu3");
    }

    @Override
    public IIdType createOrUpdateCodeSystem(CodeSystem theCodeSystemResource, RequestDetails theRequestDetails) {
        org.hl7.fhir.dstu3.model.CodeSystem resourceToStore;
        try {
            resourceToStore = (org.hl7.fhir.dstu3.model.CodeSystem)VersionConvertorFactory_30_40.convertResource((Resource)theCodeSystemResource, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
        }
        catch (FHIRException e) {
            throw new InternalErrorException((Throwable)e);
        }
        this.validateCodeSystemForStorage(theCodeSystemResource);
        if (StringUtils.isBlank((CharSequence)resourceToStore.getIdElement().getIdPart())) {
            String matchUrl = "CodeSystem?url=" + UrlUtil.escapeUrlParam((String)theCodeSystemResource.getUrl());
            return this.myCodeSystemResourceDao.update((IBaseResource)resourceToStore, matchUrl, theRequestDetails).getId();
        }
        return this.myCodeSystemResourceDao.update((IBaseResource)resourceToStore, theRequestDetails).getId();
    }

    @Override
    public void createOrUpdateConceptMap(ConceptMap theConceptMap) {
        org.hl7.fhir.dstu3.model.ConceptMap resourceToStore;
        try {
            resourceToStore = (org.hl7.fhir.dstu3.model.ConceptMap)VersionConvertorFactory_30_40.convertResource((Resource)theConceptMap, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
        }
        catch (FHIRException e) {
            throw new InternalErrorException((Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)resourceToStore.getIdElement().getIdPart())) {
            String matchUrl = "ConceptMap?url=" + UrlUtil.escapeUrlParam((String)theConceptMap.getUrl());
            this.myConceptMapResourceDao.update((IBaseResource)resourceToStore, matchUrl);
        } else {
            this.myConceptMapResourceDao.update((IBaseResource)resourceToStore);
        }
    }

    @Override
    public void createOrUpdateValueSet(org.hl7.fhir.r4.model.ValueSet theValueSet) {
        ValueSet valueSetDstu3;
        try {
            valueSetDstu3 = (ValueSet)VersionConvertorFactory_30_40.convertResource((Resource)theValueSet, (BaseAdvisor_30_40)new BaseAdvisor_30_40(Boolean.valueOf(false)));
        }
        catch (FHIRException e) {
            throw new InternalErrorException((Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)valueSetDstu3.getIdElement().getIdPart())) {
            String matchUrl = "ValueSet?url=" + UrlUtil.escapeUrlParam((String)theValueSet.getUrl());
            this.myValueSetResourceDao.update((IBaseResource)valueSetDstu3, matchUrl);
        } else {
            this.myValueSetResourceDao.update((IBaseResource)valueSetDstu3);
        }
    }
}

