/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.term.BaseTermVersionAdapterSvcImpl;
import ca.uhn.fhir.jpa.term.api.ITermVersionAdapterSvc;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.UrlUtil;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.convertors.advisors.impl.BaseAdvisor_40_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ValueSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

public class TermVersionAdapterSvcR5
extends BaseTermVersionAdapterSvcImpl
implements ITermVersionAdapterSvc {
    private IFhirResourceDao<org.hl7.fhir.r5.model.ConceptMap> myConceptMapResourceDao;
    private IFhirResourceDao<CodeSystem> myCodeSystemResourceDao;
    private IFhirResourceDao<ValueSet> myValueSetResourceDao;
    @Autowired
    private ApplicationContext myAppCtx;

    @EventListener
    public void start(ContextRefreshedEvent theEvent) {
        this.myCodeSystemResourceDao = (IFhirResourceDao)this.myAppCtx.getBean("myCodeSystemDaoR5");
        this.myValueSetResourceDao = (IFhirResourceDao)this.myAppCtx.getBean("myValueSetDaoR5");
        this.myConceptMapResourceDao = (IFhirResourceDao)this.myAppCtx.getBean("myConceptMapDaoR5");
    }

    @Override
    public IIdType createOrUpdateCodeSystem(org.hl7.fhir.r4.model.CodeSystem theCodeSystemResource, RequestDetails theRequestDetails) {
        this.validateCodeSystemForStorage(theCodeSystemResource);
        CodeSystem codeSystemR4 = (CodeSystem)VersionConvertorFactory_40_50.convertResource((Resource)theCodeSystemResource, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
        if (StringUtils.isBlank((CharSequence)theCodeSystemResource.getIdElement().getIdPart())) {
            String matchUrl = "CodeSystem?url=" + UrlUtil.escapeUrlParam((String)theCodeSystemResource.getUrl());
            return this.myCodeSystemResourceDao.update((IBaseResource)codeSystemR4, matchUrl, theRequestDetails).getId();
        }
        return this.myCodeSystemResourceDao.update((IBaseResource)codeSystemR4, theRequestDetails).getId();
    }

    @Override
    public void createOrUpdateConceptMap(ConceptMap theConceptMap) {
        org.hl7.fhir.r5.model.ConceptMap conceptMapR4 = (org.hl7.fhir.r5.model.ConceptMap)VersionConvertorFactory_40_50.convertResource((Resource)theConceptMap, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
        if (StringUtils.isBlank((CharSequence)theConceptMap.getIdElement().getIdPart())) {
            String matchUrl = "ConceptMap?url=" + UrlUtil.escapeUrlParam((String)theConceptMap.getUrl());
            this.myConceptMapResourceDao.update((IBaseResource)conceptMapR4, matchUrl);
        } else {
            this.myConceptMapResourceDao.update((IBaseResource)conceptMapR4);
        }
    }

    @Override
    public void createOrUpdateValueSet(org.hl7.fhir.r4.model.ValueSet theValueSet) {
        ValueSet valueSetR4 = (ValueSet)VersionConvertorFactory_40_50.convertResource((Resource)theValueSet, (BaseAdvisor_40_50)new BaseAdvisor_40_50(Boolean.valueOf(false)));
        if (StringUtils.isBlank((CharSequence)theValueSet.getIdElement().getIdPart())) {
            String matchUrl = "ValueSet?url=" + UrlUtil.escapeUrlParam((String)theValueSet.getUrl());
            this.myValueSetResourceDao.update((IBaseResource)valueSetR4, matchUrl);
        } else {
            this.myValueSetResourceDao.update((IBaseResource)valueSetR4);
        }
    }
}

