/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.custom;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptProperty;
import ca.uhn.fhir.jpa.term.LoadedFileDescriptors;
import ca.uhn.fhir.jpa.term.TermLoaderSvcImpl;
import ca.uhn.fhir.jpa.term.custom.ConceptHandler;
import ca.uhn.fhir.jpa.term.custom.HierarchyHandler;
import ca.uhn.fhir.jpa.term.custom.PropertyHandler;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.lang3.Validate;

public class CustomTerminologySet {
    private final int mySize;
    private final List<TermConcept> myRootConcepts;

    public CustomTerminologySet() {
        this(0, new ArrayList<TermConcept>());
    }

    private CustomTerminologySet(int theSize, List<TermConcept> theRootConcepts) {
        this.mySize = theSize;
        this.myRootConcepts = theRootConcepts;
    }

    public void addRootConcept(String theCode) {
        this.addRootConcept(theCode, null);
    }

    public TermConcept addRootConcept(String theCode, String theDisplay) {
        Validate.notBlank((CharSequence)theCode, (String)"theCode must not be blank", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.myRootConcepts.stream().noneMatch(t -> t.getCode().equals(theCode)), (String)"Already have code %s", (Object[])new Object[]{theCode});
        TermConcept retVal = new TermConcept();
        retVal.setCode(theCode);
        retVal.setDisplay(theDisplay);
        this.myRootConcepts.add(retVal);
        return retVal;
    }

    public int getSize() {
        return this.mySize;
    }

    public TermCodeSystemVersion toCodeSystemVersion() {
        TermCodeSystemVersion csv = new TermCodeSystemVersion();
        for (TermConcept next : this.myRootConcepts) {
            csv.getConcepts().add(next);
        }
        this.populateVersionToChildCodes(csv, this.myRootConcepts);
        return csv;
    }

    private void populateVersionToChildCodes(TermCodeSystemVersion theCsv, List<TermConcept> theConcepts) {
        for (TermConcept next : theConcepts) {
            next.setCodeSystemVersion(theCsv);
            this.populateVersionToChildCodes(theCsv, next.getChildCodes());
        }
    }

    public List<TermConcept> getRootConcepts() {
        return Collections.unmodifiableList(this.myRootConcepts);
    }

    public void validateNoCycleOrThrowInvalidRequest() {
        HashSet<String> codes = new HashSet<String>();
        this.validateNoCycleOrThrowInvalidRequest(codes, this.getRootConcepts());
    }

    private void validateNoCycleOrThrowInvalidRequest(Set<String> theCodes, List<TermConcept> theRootConcepts) {
        for (TermConcept next : theRootConcepts) {
            this.validateNoCycleOrThrowInvalidRequest(theCodes, next);
        }
    }

    private void validateNoCycleOrThrowInvalidRequest(Set<String> theCodes, TermConcept next) {
        if (!theCodes.add(next.getCode())) {
            throw new InvalidRequestException("Cycle detected around code " + next.getCode());
        }
        this.validateNoCycleOrThrowInvalidRequest(theCodes, next.getChildCodes());
    }

    public Set<String> getRootConceptCodes() {
        return this.getRootConcepts().stream().map(TermConcept::getCode).collect(Collectors.toSet());
    }

    @Nonnull
    public static CustomTerminologySet load(LoadedFileDescriptors theDescriptors, boolean theFlat) {
        LinkedHashMap<String, TermConcept> code2concept = new LinkedHashMap<String, TermConcept>();
        ConceptHandler conceptHandler = new ConceptHandler(code2concept);
        TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, "concepts.csv", conceptHandler, ',', QuoteMode.NON_NUMERIC, false);
        if (theDescriptors.hasFile("properties.csv")) {
            LinkedHashMap<String, List<TermConceptProperty>> theCode2property = new LinkedHashMap<String, List<TermConceptProperty>>();
            PropertyHandler propertyHandler = new PropertyHandler(theCode2property);
            TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, "properties.csv", propertyHandler, ',', QuoteMode.NON_NUMERIC, false);
            for (TermConcept termConcept : code2concept.values()) {
                if (theCode2property.isEmpty() || theCode2property.get(termConcept.getCode()) == null) continue;
                ((List)theCode2property.get(termConcept.getCode())).forEach(property -> termConcept.getProperties().add((TermConceptProperty)property));
            }
        }
        if (theFlat) {
            return new CustomTerminologySet(code2concept.size(), new ArrayList<TermConcept>(code2concept.values()));
        }
        if (theDescriptors.hasFile("hierarchy.csv")) {
            HierarchyHandler hierarchyHandler = new HierarchyHandler(code2concept);
            TermLoaderSvcImpl.iterateOverZipFileCsv(theDescriptors, "hierarchy.csv", hierarchyHandler, ',', QuoteMode.NON_NUMERIC, false);
        }
        HashMap<String, Integer> codesInOrder = new HashMap<String, Integer>();
        for (String nextCode : code2concept.keySet()) {
            codesInOrder.put(nextCode, codesInOrder.size());
        }
        ArrayList<TermConcept> rootConcepts = new ArrayList<TermConcept>();
        for (TermConcept nextConcept : code2concept.values()) {
            if (nextConcept.getParents().isEmpty()) {
                rootConcepts.add(nextConcept);
            }
            nextConcept.getChildren().sort((o1, o2) -> {
                String code1 = o1.getChild().getCode();
                String code2 = o2.getChild().getCode();
                int order1 = (Integer)codesInOrder.get(code1);
                int order2 = (Integer)codesInOrder.get(code2);
                return order1 - order2;
            });
        }
        return new CustomTerminologySet(code2concept.size(), rootConcepts);
    }
}

