/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.icd10cm;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.util.XmlUtil;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Icd10CmLoader {
    private final TermCodeSystemVersion myCodeSystemVersion;
    private int myConceptCount;

    public Icd10CmLoader(TermCodeSystemVersion theCodeSystemVersion) {
        this.myCodeSystemVersion = theCodeSystemVersion;
    }

    public void load(Reader theReader) throws IOException, SAXException {
        this.myConceptCount = 0;
        Document document = XmlUtil.parseDocument((Reader)theReader, (boolean)false);
        Element documentElement = document.getDocumentElement();
        for (Element nextVersion : XmlUtil.getChildrenByTagName((Element)documentElement, (String)"version")) {
            String versionId = nextVersion.getTextContent();
            if (!StringUtils.isNotBlank((CharSequence)versionId)) continue;
            this.myCodeSystemVersion.setCodeSystemVersionId(versionId);
        }
        for (Element nextChapter : XmlUtil.getChildrenByTagName((Element)documentElement, (String)"chapter")) {
            for (Element nextSection : XmlUtil.getChildrenByTagName((Element)nextChapter, (String)"section")) {
                for (Element nextDiag : XmlUtil.getChildrenByTagName((Element)nextSection, (String)"diag")) {
                    this.extractCode(nextDiag, null);
                }
            }
        }
    }

    private void extractCode(Element theDiagElement, TermConcept theParentConcept) {
        String code = theDiagElement.getElementsByTagName("name").item(0).getTextContent();
        String display = theDiagElement.getElementsByTagName("desc").item(0).getTextContent();
        TermConcept concept = theParentConcept == null ? this.myCodeSystemVersion.addConcept() : theParentConcept.addChild(TermConceptParentChildLink.RelationshipTypeEnum.ISA);
        concept.setCode(code);
        concept.setDisplay(display);
        for (Element nextChildDiag : XmlUtil.getChildrenByTagName((Element)theDiagElement, (String)"diag")) {
            this.extractCode(nextChildDiag, concept);
        }
        ++this.myConceptCount;
    }

    public int getConceptCount() {
        return this.myConceptCount;
    }
}

