/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.loinc.BaseLoincHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincUploadPropertiesEnum;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ValueSet;

public class LoincAnswerListHandler
extends BaseLoincHandler {
    private final Map<String, TermConcept> myCode2Concept;
    private final TermCodeSystemVersion myCodeSystemVersion;

    public LoincAnswerListHandler(TermCodeSystemVersion theCodeSystemVersion, Map<String, TermConcept> theCode2concept, List<ValueSet> theValueSets, List<ConceptMap> theConceptMaps, Properties theUploadProperties) {
        super(theCode2concept, theValueSets, theConceptMaps, theUploadProperties);
        this.myCodeSystemVersion = theCodeSystemVersion;
        this.myCode2Concept = theCode2concept;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String codeSystemVersionId;
        String valueSetId;
        ValueSet vs;
        String answerListId = StringUtils.trim((String)theRecord.get("AnswerListId"));
        String answerListName = StringUtils.trim((String)theRecord.get("AnswerListName"));
        String answerListOid = StringUtils.trim((String)theRecord.get("AnswerListOID"));
        String externallyDefined = StringUtils.trim((String)theRecord.get("ExtDefinedYN"));
        String extenrallyDefinedCs = StringUtils.trim((String)theRecord.get("ExtDefinedAnswerListCodeSystem"));
        String externallyDefinedLink = StringUtils.trim((String)theRecord.get("ExtDefinedAnswerListLink"));
        String answerString = StringUtils.trim((String)theRecord.get("AnswerStringId"));
        String sequenceNumber = StringUtils.trim((String)theRecord.get("SequenceNumber"));
        String displayText = StringUtils.trim((String)theRecord.get("DisplayText"));
        String extCodeId = StringUtils.trim((String)theRecord.get("ExtCodeId"));
        String extCodeDisplayName = StringUtils.trim((String)theRecord.get("ExtCodeDisplayName"));
        String extCodeSystem = StringUtils.trim((String)theRecord.get("ExtCodeSystem"));
        String extCodeSystemVersion = StringUtils.trim((String)theRecord.get("ExtCodeSystemVersion"));
        if (!this.myCode2Concept.containsKey(answerListId)) {
            TermConcept concept = new TermConcept(this.myCodeSystemVersion, answerListId);
            concept.setDisplay(answerListName);
            this.myCode2Concept.put(answerListId, concept);
        }
        if ((vs = this.getValueSet(valueSetId = (codeSystemVersionId = this.myUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode())) != null ? answerListId + "-" + codeSystemVersionId : answerListId, "http://loinc.org/vs/" + answerListId, answerListName, LoincUploadPropertiesEnum.LOINC_ANSWERLIST_VERSION.getCode())).getIdentifier().isEmpty()) {
            vs.addIdentifier().setSystem("urn:ietf:rfc:3986").setValue("urn:oid:" + answerListOid);
        }
        if (StringUtils.isNotBlank((CharSequence)answerString)) {
            if (!this.myCode2Concept.containsKey(answerString)) {
                TermConcept concept = new TermConcept(this.myCodeSystemVersion, answerString);
                concept.setDisplay(displayText);
                if (StringUtils.isNotBlank((CharSequence)sequenceNumber) && sequenceNumber.matches("^[0-9]$")) {
                    concept.setSequence(Integer.parseInt(sequenceNumber));
                }
                this.myCode2Concept.put(answerString, concept);
            }
            vs.getCompose().getIncludeFirstRep().setSystem("http://loinc.org").addConcept().setCode(answerString).setDisplay(displayText);
        }
    }
}

