/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.jpa.term.loinc.BaseLoincHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincUploadPropertiesEnum;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ValueSet;

public class LoincGroupFileHandler
extends BaseLoincHandler
implements IZipContentsHandlerCsv {
    public static final String VS_URI_PREFIX = "http://loinc.org/vs/";

    public LoincGroupFileHandler(Map<String, TermConcept> theCode2concept, List<ValueSet> theValueSets, List<ConceptMap> theConceptMaps, Properties theUploadProperties) {
        super(theCode2concept, theValueSets, theConceptMaps, theUploadProperties);
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String groupValueSetId;
        String parentGroupValueSetId;
        String parentGroupId = StringUtils.trim((String)theRecord.get("ParentGroupId"));
        String groupId = StringUtils.trim((String)theRecord.get("GroupId"));
        String groupName = StringUtils.trim((String)theRecord.get("Group"));
        String codeSystemVersionId = this.myUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode());
        if (codeSystemVersionId != null) {
            parentGroupValueSetId = parentGroupId + "-" + codeSystemVersionId;
            groupValueSetId = groupId + "-" + codeSystemVersionId;
        } else {
            parentGroupValueSetId = parentGroupId;
            groupValueSetId = groupId;
        }
        ValueSet parentValueSet = this.getValueSet(parentGroupValueSetId, VS_URI_PREFIX + parentGroupId, null, null);
        parentValueSet.getCompose().getIncludeFirstRep().addValueSet(VS_URI_PREFIX + groupId);
        this.getValueSet(groupValueSetId, VS_URI_PREFIX + groupId, groupName, null);
    }
}

