/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.jpa.term.loinc.BaseLoincHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincUploadPropertiesEnum;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ValueSet;

public class LoincGroupTermsFileHandler
extends BaseLoincHandler
implements IZipContentsHandlerCsv {
    public LoincGroupTermsFileHandler(Map<String, TermConcept> theCode2concept, List<ValueSet> theValueSets, List<ConceptMap> theConceptMaps, Properties theUploadProperties) {
        super(theCode2concept, theValueSets, theConceptMaps, theUploadProperties);
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String groupId = StringUtils.trim((String)theRecord.get("GroupId"));
        String codeSystemVersionId = this.myUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode());
        String valueSetId = codeSystemVersionId != null ? groupId + "-" + codeSystemVersionId : groupId;
        String loincNumber = StringUtils.trim((String)theRecord.get("LoincNumber"));
        ValueSet valueSet = this.getValueSet(valueSetId, "http://loinc.org/vs/" + groupId, null, null);
        this.addCodeAsIncludeToValueSet(valueSet, "http://loinc.org", loincNumber, null);
    }
}

