/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.jpa.term.TermLoaderSvcImpl;
import ca.uhn.fhir.jpa.term.loinc.PartTypeAndPartName;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.r4.model.CodeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoincHandler
implements IZipContentsHandlerCsv {
    private static final Logger ourLog = LoggerFactory.getLogger(LoincHandler.class);
    private final Map<String, TermConcept> myCode2Concept;
    private final TermCodeSystemVersion myCodeSystemVersion;
    private final Map<String, CodeSystem.PropertyType> myPropertyNames;
    private final Map<PartTypeAndPartName, String> myPartTypeAndPartNameToPartNumber;

    public LoincHandler(TermCodeSystemVersion theCodeSystemVersion, Map<String, TermConcept> theCode2concept, Map<String, CodeSystem.PropertyType> thePropertyNames, Map<PartTypeAndPartName, String> thePartTypeAndPartNameToPartNumber) {
        this.myCodeSystemVersion = theCodeSystemVersion;
        this.myCode2Concept = theCode2concept;
        this.myPropertyNames = thePropertyNames;
        this.myPartTypeAndPartNameToPartNumber = thePartTypeAndPartNameToPartNumber;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String code = StringUtils.trim((String)theRecord.get("LOINC_NUM"));
        if (StringUtils.isNotBlank((CharSequence)code)) {
            String longCommonName = StringUtils.trim((String)theRecord.get("LONG_COMMON_NAME"));
            String shortName = StringUtils.trim((String)theRecord.get("SHORTNAME"));
            String consumerName = StringUtils.trim((String)theRecord.get("CONSUMER_NAME"));
            String display = TermLoaderSvcImpl.firstNonBlank(longCommonName, shortName, consumerName);
            TermConcept concept = new TermConcept(this.myCodeSystemVersion, code);
            concept.setDisplay(display);
            if (StringUtils.isNotBlank((CharSequence)shortName) && !display.equalsIgnoreCase(shortName)) {
                concept.addDesignation().setUseDisplay("ShortName").setValue(shortName);
            }
            for (String nextPropertyName : this.myPropertyNames.keySet()) {
                if (!theRecord.toMap().containsKey(nextPropertyName)) continue;
                CodeSystem.PropertyType nextPropertyType = this.myPropertyNames.get(nextPropertyName);
                String nextPropertyValue = theRecord.get(nextPropertyName);
                if (!StringUtils.isNotBlank((CharSequence)nextPropertyValue)) continue;
                nextPropertyValue = StringUtils.trim((String)nextPropertyValue);
                switch (nextPropertyType) {
                    case STRING: {
                        concept.addPropertyString(nextPropertyName, nextPropertyValue);
                        break;
                    }
                    case CODING: {
                        break;
                    }
                    case DECIMAL: 
                    case CODE: 
                    case INTEGER: 
                    case BOOLEAN: 
                    case DATETIME: 
                    case NULL: {
                        throw new InternalErrorException("Don't know how to handle LOINC property of type: " + nextPropertyType);
                    }
                }
            }
            Validate.isTrue((!this.myCode2Concept.containsKey(code) ? 1 : 0) != 0, (String)"The code %s has appeared more than once", (Object[])new Object[]{code});
            this.myCode2Concept.put(code, concept);
        }
    }
}

