/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptParentChildLink;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import java.util.Map;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;

public class LoincHierarchyHandler
implements IZipContentsHandlerCsv {
    private Map<String, TermConcept> myCode2Concept;
    private TermCodeSystemVersion myCodeSystemVersion;

    public LoincHierarchyHandler(TermCodeSystemVersion theCodeSystemVersion, Map<String, TermConcept> theCode2concept) {
        this.myCodeSystemVersion = theCodeSystemVersion;
        this.myCode2Concept = theCode2concept;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String parentCode = StringUtils.trim((String)theRecord.get("IMMEDIATE_PARENT"));
        String childCode = StringUtils.trim((String)theRecord.get("CODE"));
        String childCodeText = StringUtils.trim((String)theRecord.get("CODE_TEXT"));
        if (StringUtils.isNotBlank((CharSequence)parentCode) && StringUtils.isNotBlank((CharSequence)childCode)) {
            TermConcept parent = this.getOrCreate(parentCode, "(unknown)");
            TermConcept child = this.getOrCreate(childCode, childCodeText);
            parent.addChild(child, TermConceptParentChildLink.RelationshipTypeEnum.ISA);
            parent.addPropertyCoding("child", "http://loinc.org", child.getCode(), child.getDisplay());
            child.addPropertyCoding("parent", "http://loinc.org", parent.getCode(), parent.getDisplay());
        }
    }

    private TermConcept getOrCreate(String theCode, String theDisplay) {
        TermConcept retVal = this.myCode2Concept.get(theCode);
        if (retVal == null) {
            retVal = new TermConcept();
            retVal.setCodeSystemVersion(this.myCodeSystemVersion);
            retVal.setCode(theCode);
            retVal.setDisplay(theDisplay);
            this.myCode2Concept.put(theCode, retVal);
        }
        return retVal;
    }
}

