/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.jpa.term.loinc.BaseLoincHandler;
import ca.uhn.fhir.jpa.term.loinc.LoincUploadPropertiesEnum;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ValueSet;

public class LoincImagingDocumentCodeHandler
extends BaseLoincHandler
implements IZipContentsHandlerCsv {
    public static final String VS_ID_BASE = "loinc-imaging-document-codes";
    public static final String VS_URI = "http://loinc.org/vs/loinc-imaging-document-codes";
    public static final String VS_NAME = "LOINC Imaging Document Codes";

    public LoincImagingDocumentCodeHandler(Map<String, TermConcept> theCode2concept, List<ValueSet> theValueSets, List<ConceptMap> theConceptMaps, Properties theUploadProperties) {
        super(theCode2concept, theValueSets, theConceptMaps, theUploadProperties);
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String loincNumber = StringUtils.trim((String)theRecord.get("LOINC_NUM"));
        String displayName = StringUtils.trim((String)theRecord.get("LONG_COMMON_NAME"));
        String codeSystemVersionId = this.myUploadProperties.getProperty(LoincUploadPropertiesEnum.LOINC_CODESYSTEM_VERSION.getCode());
        String valueSetId = codeSystemVersionId != null ? "loinc-imaging-document-codes-" + codeSystemVersionId : VS_ID_BASE;
        ValueSet valueSet = this.getValueSet(valueSetId, VS_URI, VS_NAME, null);
        this.addCodeAsIncludeToValueSet(valueSet, "http://loinc.org", loincNumber, displayName);
    }
}

