/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.loinc;

import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import ca.uhn.fhir.jpa.entity.TermConcept;
import ca.uhn.fhir.jpa.entity.TermConceptProperty;
import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.CodeSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoincPartLinkHandler
implements IZipContentsHandlerCsv {
    private static final Logger ourLog = LoggerFactory.getLogger(LoincPartLinkHandler.class);
    private final Map<String, TermConcept> myCode2Concept;
    private final TermCodeSystemVersion myCodeSystemVersion;
    private final Map<String, CodeSystem.PropertyType> myPropertyNames;
    private Long myPartCount;

    public LoincPartLinkHandler(TermCodeSystemVersion theCodeSystemVersion, Map<String, TermConcept> theCode2concept, Map<String, CodeSystem.PropertyType> thePropertyNames) {
        this.myCodeSystemVersion = theCodeSystemVersion;
        this.myCode2Concept = theCode2concept;
        this.myPropertyNames = thePropertyNames;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String expectedValue;
        String loincNumber = StringUtils.trim((String)theRecord.get("LoincNumber"));
        String property = StringUtils.trim((String)theRecord.get("Property"));
        String partName = StringUtils.trim((String)theRecord.get("PartName"));
        String partNumber = StringUtils.trim((String)theRecord.get("PartNumber"));
        int lastSlashIdx = property.lastIndexOf("/");
        String propertyPart = property.substring(lastSlashIdx + 1);
        TermConcept loincConcept = this.myCode2Concept.get(loincNumber);
        if (loincConcept == null) {
            throw new InternalErrorException("Unknown loinc code: " + loincNumber);
        }
        CodeSystem.PropertyType propertyType = this.myPropertyNames.get(propertyPart);
        if (propertyType == null) {
            return;
        }
        if (propertyType == CodeSystem.PropertyType.STRING) {
            expectedValue = partName;
        } else if (propertyType == CodeSystem.PropertyType.CODING) {
            expectedValue = partNumber;
        } else {
            throw new InternalErrorException("Don't know how to handle property of type: " + propertyType);
        }
        Optional<TermConceptProperty> existingProprty = loincConcept.getProperties().stream().filter(t -> t.getKey().equals(propertyPart)).filter(t -> t.getValue().equals(expectedValue)).findFirst();
        if (existingProprty.isPresent()) {
            return;
        }
        ourLog.debug("Adding new property {} = {}", (Object)propertyPart, (Object)partNumber);
        if (propertyType == CodeSystem.PropertyType.STRING) {
            loincConcept.addPropertyString(propertyPart, partName);
        } else {
            loincConcept.addPropertyCoding(propertyPart, "http://loinc.org", partNumber, partName);
        }
    }
}

