/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.term.snomedct;

import ca.uhn.fhir.jpa.term.IZipContentsHandlerCsv;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVRecord;

public final class SctHandlerConcept
implements IZipContentsHandlerCsv {
    private Set<String> myValidConceptIds;
    private Map<String, String> myConceptIdToMostRecentDate = new HashMap<String, String>();

    public SctHandlerConcept(Set<String> theValidConceptIds) {
        this.myValidConceptIds = theValidConceptIds;
    }

    @Override
    public void accept(CSVRecord theRecord) {
        String id = theRecord.get("id");
        String date = theRecord.get("effectiveTime");
        if (!this.myConceptIdToMostRecentDate.containsKey(id) || this.myConceptIdToMostRecentDate.get(id).compareTo(date) < 0) {
            boolean active = "1".equals(theRecord.get("active"));
            if (active) {
                this.myValidConceptIds.add(id);
            } else {
                this.myValidConceptIds.remove(id);
            }
            this.myConceptIdToMostRecentDate.put(id, date);
        }
    }
}

