/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ResourceCountCache {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceCountCache.class);
    private static Long ourNowForUnitTest;
    private final Callable<Map<String, Long>> myFetcher;
    private volatile long myCacheMillis;
    private AtomicReference<Map<String, Long>> myCapabilityStatement = new AtomicReference();
    private long myLastFetched;
    @Autowired
    private ISchedulerService mySchedulerService;

    public ResourceCountCache(Callable<Map<String, Long>> theFetcher) {
        this.myFetcher = theFetcher;
    }

    public synchronized void clear() {
        ourLog.info("Clearing cache");
        this.myCapabilityStatement.set(null);
        this.myLastFetched = 0L;
    }

    public synchronized Map<String, Long> get() {
        return this.myCapabilityStatement.get();
    }

    private Map<String, Long> refresh() {
        Map<String, Long> retVal;
        try {
            retVal = this.myFetcher.call();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        this.myCapabilityStatement.set(retVal);
        this.myLastFetched = ResourceCountCache.now();
        return retVal;
    }

    public void setCacheMillis(long theCacheMillis) {
        this.myCacheMillis = theCacheMillis;
    }

    public void update() {
        long now;
        long expiry;
        if (this.myCacheMillis > 0L && this.myLastFetched < (expiry = (now = ResourceCountCache.now()) - this.myCacheMillis)) {
            this.refresh();
        }
    }

    @PostConstruct
    public void scheduleJob() {
        ScheduledJobDefinition jobDetail = new ScheduledJobDefinition();
        jobDetail.setId(this.getClass().getName());
        jobDetail.setJobClass(Job.class);
        this.mySchedulerService.scheduleLocalJob(600000L, jobDetail);
    }

    private static long now() {
        if (ourNowForUnitTest != null) {
            return ourNowForUnitTest;
        }
        return System.currentTimeMillis();
    }

    @VisibleForTesting
    static void setNowForUnitTest(Long theNowForUnitTest) {
        ourNowForUnitTest = theNowForUnitTest;
    }

    public static class Job
    implements HapiJob {
        @Autowired
        private ResourceCountCache myTarget;

        public void execute(JobExecutionContext theContext) {
            this.myTarget.update();
        }
    }
}

