/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.util.UrlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.engine.jdbc.internal.BasicFormatterImpl;

public class SqlQuery {
    private final String myThreadName = Thread.currentThread().getName();
    private final String mySql;
    private final List<String> myParams;
    private final long myQueryTimestamp;
    private final long myElapsedTime;
    private final StackTraceElement[] myStackTrace;
    private final int mySize;
    private final LanguageEnum myLanguage;

    public SqlQuery(String theSql, List<String> theParams, long theQueryTimestamp, long theElapsedTime, StackTraceElement[] theStackTraceElements, int theSize) {
        this(theSql, theParams, theQueryTimestamp, theElapsedTime, theStackTraceElements, theSize, LanguageEnum.SQL);
    }

    public SqlQuery(String theSql, List<String> theParams, long theQueryTimestamp, long theElapsedTime, StackTraceElement[] theStackTraceElements, int theSize, LanguageEnum theLanguage) {
        Validate.notNull((Object)((Object)theLanguage), (String)"theLanguage must not be null", (Object[])new Object[0]);
        this.mySql = theSql;
        this.myParams = Collections.unmodifiableList(theParams);
        this.myQueryTimestamp = theQueryTimestamp;
        this.myElapsedTime = theElapsedTime;
        this.myStackTrace = theStackTraceElements;
        this.mySize = theSize;
        this.myLanguage = theLanguage;
    }

    public long getQueryTimestamp() {
        return this.myQueryTimestamp;
    }

    public long getElapsedTime() {
        return this.myElapsedTime;
    }

    public String getThreadName() {
        return this.myThreadName;
    }

    public String getSql(boolean theInlineParams, boolean theFormat) {
        return this.getSql(theInlineParams, theFormat, false);
    }

    public LanguageEnum getLanguage() {
        return this.myLanguage;
    }

    public String getSql(boolean theInlineParams, boolean theFormat, boolean theSanitizeParams) {
        String retVal = this.mySql;
        if (theFormat && this.getLanguage() == LanguageEnum.SQL) {
            retVal = new BasicFormatterImpl().format(retVal);
            while (retVal.startsWith("\n")) {
                retVal = retVal.substring(1);
            }
        }
        if (theInlineParams) {
            ArrayList<String> nextParams = new ArrayList<String>(this.myParams);
            int idx = 0;
            while (nextParams.size() > 0 && (idx = retVal.indexOf("?", idx)) != -1) {
                String nextParamValue = (String)nextParams.remove(0);
                if (theSanitizeParams) {
                    nextParamValue = UrlUtil.sanitizeUrlPart((CharSequence)nextParamValue);
                }
                String nextSubstitution = "'" + nextParamValue + "'";
                retVal = retVal.substring(0, idx) + nextSubstitution + retVal.substring(idx + 1);
                idx += nextSubstitution.length();
            }
        }
        return StringUtils.trim((String)retVal);
    }

    public StackTraceElement[] getStackTrace() {
        return this.myStackTrace;
    }

    public int getSize() {
        return this.mySize;
    }

    public String toString() {
        return this.getSql(true, true);
    }

    public static enum LanguageEnum {
        SQL,
        JSON;

    }
}

