/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.model.dstu2.valueset.ResourceTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.interceptor.ServerOperationInterceptorAdapter;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.Subscription;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class SubscriptionsRequireManualActivationInterceptorDstu3
extends ServerOperationInterceptorAdapter {
    @Autowired
    @Qualifier(value="mySubscriptionDaoDstu3")
    private IFhirResourceDao<Subscription> myDao;

    public void resourceCreated(RequestDetails theRequest, IBaseResource theResource) {
        if (this.myDao.getContext().getResourceType(theResource).equals(ResourceTypeEnum.SUBSCRIPTION.getCode())) {
            this.verifyStatusOk(RestOperationTypeEnum.CREATE, null, theResource);
        }
    }

    public void resourceUpdated(RequestDetails theRequest, IBaseResource theOldResource, IBaseResource theNewResource) {
        if (this.myDao.getContext().getResourceType(theNewResource).equals(ResourceTypeEnum.SUBSCRIPTION.getCode())) {
            this.verifyStatusOk(RestOperationTypeEnum.UPDATE, theOldResource, theNewResource);
        }
    }

    public void setDao(IFhirResourceDao<Subscription> theDao) {
        this.myDao = theDao;
    }

    private void verifyStatusOk(RestOperationTypeEnum theOperation, IBaseResource theOldResourceOrNull, IBaseResource theResource) {
        Subscription subscription = (Subscription)theResource;
        Subscription.SubscriptionStatus newStatus = (Subscription.SubscriptionStatus)subscription.getStatusElement().getValue();
        if (newStatus == Subscription.SubscriptionStatus.REQUESTED || newStatus == Subscription.SubscriptionStatus.OFF) {
            return;
        }
        if (newStatus == null) {
            String actualCode = subscription.getStatusElement().getValueAsString();
            throw new UnprocessableEntityException("Can not " + theOperation.getCode() + " resource: Subscription.status must be populated on this server" + (StringUtils.isNotBlank((CharSequence)actualCode) ? " (invalid value " + actualCode + ")" : ""));
        }
        if (theOldResourceOrNull != null) {
            try {
                Subscription existing = (Subscription)theOldResourceOrNull;
                Subscription.SubscriptionStatus existingStatus = (Subscription.SubscriptionStatus)existing.getStatusElement().getValue();
                if (existingStatus != newStatus) {
                    this.verifyActiveStatus(theOperation, subscription, newStatus, existingStatus);
                }
            }
            catch (ResourceNotFoundException e) {
                this.verifyActiveStatus(theOperation, subscription, newStatus, null);
            }
        } else {
            this.verifyActiveStatus(theOperation, subscription, newStatus, null);
        }
    }

    private void verifyActiveStatus(RestOperationTypeEnum theOperation, Subscription theSubscription, Subscription.SubscriptionStatus newStatus, Subscription.SubscriptionStatus theExistingStatus) {
        Subscription.SubscriptionChannelType channelType = (Subscription.SubscriptionChannelType)theSubscription.getChannel().getTypeElement().getValue();
        if (channelType == null) {
            throw new UnprocessableEntityException("Subscription.channel.type must be populated");
        }
        if (channelType == Subscription.SubscriptionChannelType.WEBSOCKET) {
            return;
        }
        if (theExistingStatus != null) {
            throw new UnprocessableEntityException("Subscription.status can not be changed from " + this.describeStatus(theExistingStatus) + " to " + this.describeStatus(newStatus));
        }
        if (theSubscription.getStatus() == null) {
            throw new UnprocessableEntityException("Can not " + theOperation.getCode().toLowerCase() + " resource: Subscription.status must be populated on this server");
        }
        throw new UnprocessableEntityException("Subscription.status must be '" + Subscription.SubscriptionStatus.OFF.toCode() + "' or '" + Subscription.SubscriptionStatus.REQUESTED.toCode() + "' on a newly created subscription");
    }

    private String describeStatus(Subscription.SubscriptionStatus existingStatus) {
        String existingStatusString = existingStatus != null ? '\'' + existingStatus.toCode() + '\'' : "null";
        return existingStatusString;
    }
}

