create sequence SEQ_BLKEXCOL_PID start with 1 increment by 50;
create sequence SEQ_BLKEXCOLFILE_PID start with 1 increment by 50;
create sequence SEQ_BLKEXJOB_PID start with 1 increment by 50;
create sequence SEQ_BLKIMJOB_PID start with 1 increment by 50;
create sequence SEQ_BLKIMJOBFILE_PID start with 1 increment by 50;
create sequence SEQ_CNCPT_MAP_GRP_ELM_TGT_PID start with 1 increment by 50;
create sequence SEQ_CODESYSTEM_PID start with 1 increment by 50;
create sequence SEQ_CODESYSTEMVER_PID start with 1 increment by 50;
create sequence SEQ_CONCEPT_DESIG_PID start with 1 increment by 50;
create sequence SEQ_CONCEPT_MAP_GROUP_PID start with 1 increment by 50;
create sequence SEQ_CONCEPT_MAP_GRP_ELM_PID start with 1 increment by 50;
create sequence SEQ_CONCEPT_MAP_PID start with 1 increment by 50;
create sequence SEQ_CONCEPT_PC_PID start with 1 increment by 50;
create sequence SEQ_CONCEPT_PID start with 1 increment by 50;
create sequence SEQ_CONCEPT_PROP_PID start with 1 increment by 50;
create sequence SEQ_EMPI_LINK_ID start with 1 increment by 50;
create sequence SEQ_FORCEDID_ID start with 1 increment by 50;
create sequence SEQ_HISTORYTAG_ID start with 1 increment by 50;
create sequence SEQ_IDXCMBTOKNU_ID start with 1 increment by 50;
create sequence SEQ_IDXCMPSTRUNIQ_ID start with 1 increment by 50;
create sequence SEQ_NPM_PACK start with 1 increment by 50;
create sequence SEQ_NPM_PACKVER start with 1 increment by 50;
create sequence SEQ_NPM_PACKVERRES start with 1 increment by 50;
create sequence SEQ_RES_REINDEX_JOB start with 1 increment by 50;
create sequence SEQ_RESLINK_ID start with 1 increment by 50;
create sequence SEQ_RESOURCE_HISTORY_ID start with 1 increment by 50;
create sequence SEQ_RESOURCE_ID start with 1 increment by 50;
create sequence SEQ_RESPARMPRESENT_ID start with 1 increment by 50;
create sequence SEQ_RESTAG_ID start with 1 increment by 50;
create sequence SEQ_SEARCH start with 1 increment by 50;
create sequence SEQ_SEARCH_INC start with 1 increment by 50;
create sequence SEQ_SEARCH_RES start with 1 increment by 50;
create sequence SEQ_SPIDX_COORDS start with 1 increment by 50;
create sequence SEQ_SPIDX_DATE start with 1 increment by 50;
create sequence SEQ_SPIDX_NUMBER start with 1 increment by 50;
create sequence SEQ_SPIDX_QUANTITY start with 1 increment by 50;
create sequence SEQ_SPIDX_QUANTITY_NRML start with 1 increment by 50;
create sequence SEQ_SPIDX_STRING start with 1 increment by 50;
create sequence SEQ_SPIDX_TOKEN start with 1 increment by 50;
create sequence SEQ_SPIDX_URI start with 1 increment by 50;
create sequence SEQ_SUBSCRIPTION_ID start with 1 increment by 50;
create sequence SEQ_TAGDEF_ID start with 1 increment by 50;
create sequence SEQ_VALUESET_C_DSGNTN_PID start with 1 increment by 50;
create sequence SEQ_VALUESET_CONCEPT_PID start with 1 increment by 50;
create sequence SEQ_VALUESET_PID start with 1 increment by 50;

    create table HFJ_BINARY_STORAGE_BLOB (
       BLOB_ID varchar(200) not null,
        BLOB_DATA blob not null,
        CONTENT_TYPE varchar(100) not null,
        BLOB_HASH varchar(128),
        PUBLISHED_DATE timestamp not null,
        RESOURCE_ID varchar(100) not null,
        BLOB_SIZE integer,
        primary key (BLOB_ID)
    );

    create table HFJ_BLK_EXPORT_COLFILE (
       PID bigint not null,
        RES_ID varchar(100) not null,
        COLLECTION_PID bigint not null,
        primary key (PID)
    );

    create table HFJ_BLK_EXPORT_COLLECTION (
       PID bigint not null,
        TYPE_FILTER varchar(1000),
        RES_TYPE varchar(40) not null,
        OPTLOCK integer not null,
        JOB_PID bigint not null,
        primary key (PID)
    );

    create table HFJ_BLK_EXPORT_JOB (
       PID bigint not null,
        CREATED_TIME timestamp not null,
        EXP_TIME timestamp not null,
        JOB_ID varchar(36) not null,
        REQUEST varchar(1024) not null,
        EXP_SINCE timestamp,
        JOB_STATUS varchar(10) not null,
        STATUS_MESSAGE varchar(500),
        STATUS_TIME timestamp not null,
        OPTLOCK integer not null,
        primary key (PID)
    );

    create table HFJ_BLK_IMPORT_JOB (
       PID bigint not null,
        BATCH_SIZE integer not null,
        FILE_COUNT integer not null,
        JOB_DESC varchar(500),
        JOB_ID varchar(36) not null,
        ROW_PROCESSING_MODE varchar(20) not null,
        JOB_STATUS varchar(10) not null,
        STATUS_MESSAGE varchar(500),
        STATUS_TIME timestamp not null,
        OPTLOCK integer not null,
        primary key (PID)
    );

    create table HFJ_BLK_IMPORT_JOBFILE (
       PID bigint not null,
        JOB_CONTENTS blob not null,
        FILE_DESCRIPTION varchar(500),
        FILE_SEQ integer not null,
        TENANT_NAME varchar(200),
        JOB_PID bigint not null,
        primary key (PID)
    );

    create table HFJ_FORCED_ID (
       PID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        FORCED_ID varchar(100) not null,
        RESOURCE_PID bigint not null,
        RESOURCE_TYPE varchar(100) default '',
        primary key (PID)
    );

    create table HFJ_HISTORY_TAG (
       PID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        TAG_ID bigint,
        RES_VER_PID bigint not null,
        RES_ID bigint not null,
        RES_TYPE varchar(40) not null,
        primary key (PID)
    );

    create table HFJ_IDX_CMB_TOK_NU (
       PID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        HASH_COMPLETE bigint not null,
        IDX_STRING varchar(500) not null,
        RES_ID bigint,
        primary key (PID)
    );

    create table HFJ_IDX_CMP_STRING_UNIQ (
       PID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        IDX_STRING varchar(500) not null,
        RES_ID bigint,
        primary key (PID)
    );

    create table HFJ_PARTITION (
       PART_ID integer not null,
        PART_DESC varchar(200),
        PART_NAME varchar(200) not null,
        primary key (PART_ID)
    );

    create table HFJ_RES_LINK (
       PID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        SRC_PATH varchar(500) not null,
        SRC_RESOURCE_ID bigint not null,
        SOURCE_RESOURCE_TYPE varchar(40) not null,
        TARGET_RESOURCE_ID bigint,
        TARGET_RESOURCE_TYPE varchar(40) not null,
        TARGET_RESOURCE_URL varchar(200),
        TARGET_RESOURCE_VERSION bigint,
        SP_UPDATED timestamp,
        primary key (PID)
    );

    create table HFJ_RES_PARAM_PRESENT (
       PID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        HASH_PRESENCE bigint,
        SP_PRESENT boolean not null,
        RES_ID bigint not null,
        primary key (PID)
    );

    create table HFJ_RES_REINDEX_JOB (
       PID bigint not null,
        JOB_DELETED boolean not null,
        REINDEX_COUNT integer,
        RES_TYPE varchar(100),
        SUSPENDED_UNTIL timestamp,
        UPDATE_THRESHOLD_HIGH timestamp not null,
        UPDATE_THRESHOLD_LOW timestamp,
        primary key (PID)
    );

    create table HFJ_RES_TAG (
       PID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        TAG_ID bigint,
        RES_ID bigint,
        RES_TYPE varchar(40) not null,
        primary key (PID)
    );

    create table HFJ_RES_VER (
       PID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        RES_DELETED_AT timestamp,
        RES_VERSION varchar(7),
        HAS_TAGS boolean not null,
        RES_PUBLISHED timestamp not null,
        RES_UPDATED timestamp not null,
        RES_ENCODING varchar(5) not null,
        RES_TEXT blob,
        RES_ID bigint not null,
        RES_TYPE varchar(40) not null,
        RES_VER bigint not null,
        primary key (PID)
    );

    create table HFJ_RES_VER_PROV (
       RES_VER_PID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        REQUEST_ID varchar(16),
        SOURCE_URI varchar(100),
        RES_PID bigint not null,
        primary key (RES_VER_PID)
    );

    create table HFJ_RESOURCE (
       RES_ID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        RES_DELETED_AT timestamp,
        RES_VERSION varchar(7),
        HAS_TAGS boolean not null,
        RES_PUBLISHED timestamp not null,
        RES_UPDATED timestamp not null,
        SP_HAS_LINKS boolean,
        HASH_SHA256 varchar(64),
        SP_INDEX_STATUS bigint,
        RES_LANGUAGE varchar(20),
        SP_CMPSTR_UNIQ_PRESENT boolean,
        SP_CMPTOKS_PRESENT boolean,
        SP_COORDS_PRESENT boolean,
        SP_DATE_PRESENT boolean,
        SP_NUMBER_PRESENT boolean,
        SP_QUANTITY_NRML_PRESENT boolean,
        SP_QUANTITY_PRESENT boolean,
        SP_STRING_PRESENT boolean,
        SP_TOKEN_PRESENT boolean,
        SP_URI_PRESENT boolean,
        RES_TYPE varchar(40) not null,
        RES_VER bigint,
        primary key (RES_ID)
    );

    create table HFJ_SEARCH (
       PID bigint not null,
        CREATED timestamp not null,
        SEARCH_DELETED boolean,
        EXPIRY_OR_NULL timestamp,
        FAILURE_CODE integer,
        FAILURE_MESSAGE varchar(500),
        LAST_UPDATED_HIGH timestamp,
        LAST_UPDATED_LOW timestamp,
        NUM_BLOCKED integer,
        NUM_FOUND integer not null,
        PREFERRED_PAGE_SIZE integer,
        RESOURCE_ID bigint,
        RESOURCE_TYPE varchar(200),
        SEARCH_PARAM_MAP blob,
        SEARCH_QUERY_STRING clob,
        SEARCH_QUERY_STRING_HASH integer,
        SEARCH_TYPE integer not null,
        SEARCH_STATUS varchar(10) not null,
        TOTAL_COUNT integer,
        SEARCH_UUID varchar(36) not null,
        OPTLOCK_VERSION integer,
        primary key (PID)
    );

    create table HFJ_SEARCH_INCLUDE (
       PID bigint not null,
        SEARCH_INCLUDE varchar(200) not null,
        INC_RECURSE boolean not null,
        REVINCLUDE boolean not null,
        SEARCH_PID bigint not null,
        primary key (PID)
    );

    create table HFJ_SEARCH_RESULT (
       PID bigint not null,
        SEARCH_ORDER integer not null,
        RESOURCE_PID bigint not null,
        SEARCH_PID bigint not null,
        primary key (PID)
    );

    create table HFJ_SPIDX_COORDS (
       SP_ID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        SP_MISSING boolean not null,
        SP_NAME varchar(100) not null,
        RES_ID bigint not null,
        RES_TYPE varchar(100) not null,
        SP_UPDATED timestamp,
        HASH_IDENTITY bigint,
        SP_LATITUDE double,
        SP_LONGITUDE double,
        primary key (SP_ID)
    );

    create table HFJ_SPIDX_DATE (
       SP_ID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        SP_MISSING boolean not null,
        SP_NAME varchar(100) not null,
        RES_ID bigint not null,
        RES_TYPE varchar(100) not null,
        SP_UPDATED timestamp,
        HASH_IDENTITY bigint,
        SP_VALUE_HIGH timestamp,
        SP_VALUE_HIGH_DATE_ORDINAL integer,
        SP_VALUE_LOW timestamp,
        SP_VALUE_LOW_DATE_ORDINAL integer,
        primary key (SP_ID)
    );

    create table HFJ_SPIDX_NUMBER (
       SP_ID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        SP_MISSING boolean not null,
        SP_NAME varchar(100) not null,
        RES_ID bigint not null,
        RES_TYPE varchar(100) not null,
        SP_UPDATED timestamp,
        HASH_IDENTITY bigint,
        SP_VALUE decimal(19,2),
        primary key (SP_ID)
    );

    create table HFJ_SPIDX_QUANTITY (
       SP_ID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        SP_MISSING boolean not null,
        SP_NAME varchar(100) not null,
        RES_ID bigint not null,
        RES_TYPE varchar(100) not null,
        SP_UPDATED timestamp,
        HASH_IDENTITY bigint,
        HASH_IDENTITY_AND_UNITS bigint,
        HASH_IDENTITY_SYS_UNITS bigint,
        SP_SYSTEM varchar(200),
        SP_UNITS varchar(200),
        SP_VALUE double,
        primary key (SP_ID)
    );

    create table HFJ_SPIDX_QUANTITY_NRML (
       SP_ID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        SP_MISSING boolean not null,
        SP_NAME varchar(100) not null,
        RES_ID bigint not null,
        RES_TYPE varchar(100) not null,
        SP_UPDATED timestamp,
        HASH_IDENTITY bigint,
        HASH_IDENTITY_AND_UNITS bigint,
        HASH_IDENTITY_SYS_UNITS bigint,
        SP_SYSTEM varchar(200),
        SP_UNITS varchar(200),
        SP_VALUE double,
        primary key (SP_ID)
    );

    create table HFJ_SPIDX_STRING (
       SP_ID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        SP_MISSING boolean not null,
        SP_NAME varchar(100) not null,
        RES_ID bigint not null,
        RES_TYPE varchar(100) not null,
        SP_UPDATED timestamp,
        HASH_EXACT bigint,
        HASH_IDENTITY bigint,
        HASH_NORM_PREFIX bigint,
        SP_VALUE_EXACT varchar(200),
        SP_VALUE_NORMALIZED varchar(200),
        primary key (SP_ID)
    );

    create table HFJ_SPIDX_TOKEN (
       SP_ID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        SP_MISSING boolean not null,
        SP_NAME varchar(100) not null,
        RES_ID bigint not null,
        RES_TYPE varchar(100) not null,
        SP_UPDATED timestamp,
        HASH_IDENTITY bigint,
        HASH_SYS bigint,
        HASH_SYS_AND_VALUE bigint,
        HASH_VALUE bigint,
        SP_SYSTEM varchar(200),
        SP_VALUE varchar(200),
        primary key (SP_ID)
    );

    create table HFJ_SPIDX_URI (
       SP_ID bigint not null,
        PARTITION_DATE date,
        PARTITION_ID integer,
        SP_MISSING boolean not null,
        SP_NAME varchar(100) not null,
        RES_ID bigint not null,
        RES_TYPE varchar(100) not null,
        SP_UPDATED timestamp,
        HASH_IDENTITY bigint,
        HASH_URI bigint,
        SP_URI varchar(254),
        primary key (SP_ID)
    );

    create table HFJ_SUBSCRIPTION_STATS (
       PID bigint not null,
        CREATED_TIME timestamp not null,
        RES_ID bigint,
        primary key (PID)
    );

    create table HFJ_TAG_DEF (
       TAG_ID bigint not null,
        TAG_CODE varchar(200),
        TAG_DISPLAY varchar(200),
        TAG_SYSTEM varchar(200),
        TAG_TYPE integer not null,
        primary key (TAG_ID)
    );

    create table MPI_LINK (
       PID bigint not null,
        CREATED timestamp not null,
        EID_MATCH boolean,
        GOLDEN_RESOURCE_PID bigint not null,
        NEW_PERSON boolean,
        LINK_SOURCE integer not null,
        MATCH_RESULT integer not null,
        TARGET_TYPE varchar(40),
        PERSON_PID bigint not null,
        RULE_COUNT bigint,
        SCORE double,
        TARGET_PID bigint not null,
        UPDATED timestamp not null,
        VECTOR bigint,
        VERSION varchar(16) not null,
        primary key (PID)
    );

    create table NPM_PACKAGE (
       PID bigint not null,
        CUR_VERSION_ID varchar(200),
        PACKAGE_DESC varchar(200),
        PACKAGE_ID varchar(200) not null,
        UPDATED_TIME timestamp not null,
        primary key (PID)
    );

    create table NPM_PACKAGE_VER (
       PID bigint not null,
        CURRENT_VERSION boolean not null,
        PKG_DESC varchar(200),
        DESC_UPPER varchar(200),
        FHIR_VERSION varchar(10) not null,
        FHIR_VERSION_ID varchar(10) not null,
        PACKAGE_ID varchar(200) not null,
        PACKAGE_SIZE_BYTES bigint not null,
        SAVED_TIME timestamp not null,
        UPDATED_TIME timestamp not null,
        VERSION_ID varchar(200) not null,
        PACKAGE_PID bigint not null,
        BINARY_RES_ID bigint not null,
        primary key (PID)
    );

    create table NPM_PACKAGE_VER_RES (
       PID bigint not null,
        CANONICAL_URL varchar(200),
        CANONICAL_VERSION varchar(200),
        FILE_DIR varchar(200),
        FHIR_VERSION varchar(10) not null,
        FHIR_VERSION_ID varchar(10) not null,
        FILE_NAME varchar(200),
        RES_SIZE_BYTES bigint not null,
        RES_TYPE varchar(40) not null,
        UPDATED_TIME timestamp not null,
        PACKVER_PID bigint not null,
        BINARY_RES_ID bigint not null,
        primary key (PID)
    );

    create table TRM_CODESYSTEM (
       PID bigint not null,
        CODE_SYSTEM_URI varchar(200) not null,
        CURRENT_VERSION_PID bigint,
        CS_NAME varchar(200),
        RES_ID bigint,
        primary key (PID)
    );

    create table TRM_CODESYSTEM_VER (
       PID bigint not null,
        CS_DISPLAY varchar(200),
        CODESYSTEM_PID bigint,
        CS_VERSION_ID varchar(200),
        RES_ID bigint not null,
        primary key (PID)
    );

    create table TRM_CONCEPT (
       PID bigint not null,
        CODEVAL varchar(500) not null,
        CODESYSTEM_PID bigint,
        DISPLAY varchar(400),
        INDEX_STATUS bigint,
        PARENT_PIDS clob,
        CODE_SEQUENCE integer,
        CONCEPT_UPDATED timestamp,
        primary key (PID)
    );

    create table TRM_CONCEPT_DESIG (
       PID bigint not null,
        LANG varchar(500),
        USE_CODE varchar(500),
        USE_DISPLAY varchar(500),
        USE_SYSTEM varchar(500),
        VAL varchar(2000) not null,
        CS_VER_PID bigint,
        CONCEPT_PID bigint,
        primary key (PID)
    );

    create table TRM_CONCEPT_MAP (
       PID bigint not null,
        RES_ID bigint,
        SOURCE_URL varchar(200),
        TARGET_URL varchar(200),
        URL varchar(200) not null,
        VER varchar(200),
        primary key (PID)
    );

    create table TRM_CONCEPT_MAP_GROUP (
       PID bigint not null,
        CONCEPT_MAP_URL varchar(200),
        SOURCE_URL varchar(200) not null,
        SOURCE_VS varchar(200),
        SOURCE_VERSION varchar(200),
        TARGET_URL varchar(200) not null,
        TARGET_VS varchar(200),
        TARGET_VERSION varchar(200),
        CONCEPT_MAP_PID bigint not null,
        primary key (PID)
    );

    create table TRM_CONCEPT_MAP_GRP_ELEMENT (
       PID bigint not null,
        SOURCE_CODE varchar(500) not null,
        CONCEPT_MAP_URL varchar(200),
        SOURCE_DISPLAY varchar(500),
        SYSTEM_URL varchar(200),
        SYSTEM_VERSION varchar(200),
        VALUESET_URL varchar(200),
        CONCEPT_MAP_GROUP_PID bigint not null,
        primary key (PID)
    );

    create table TRM_CONCEPT_MAP_GRP_ELM_TGT (
       PID bigint not null,
        TARGET_CODE varchar(500) not null,
        CONCEPT_MAP_URL varchar(200),
        TARGET_DISPLAY varchar(500),
        TARGET_EQUIVALENCE varchar(50),
        SYSTEM_URL varchar(200),
        SYSTEM_VERSION varchar(200),
        VALUESET_URL varchar(200),
        CONCEPT_MAP_GRP_ELM_PID bigint not null,
        primary key (PID)
    );

    create table TRM_CONCEPT_PC_LINK (
       PID bigint not null,
        CHILD_PID bigint,
        CODESYSTEM_PID bigint not null,
        PARENT_PID bigint,
        REL_TYPE integer,
        primary key (PID)
    );

    create table TRM_CONCEPT_PROPERTY (
       PID bigint not null,
        PROP_CODESYSTEM varchar(500),
        PROP_DISPLAY varchar(500),
        PROP_KEY varchar(500) not null,
        PROP_TYPE integer not null,
        PROP_VAL varchar(500),
        PROP_VAL_LOB blob,
        CS_VER_PID bigint,
        CONCEPT_PID bigint,
        primary key (PID)
    );

    create table TRM_VALUESET (
       PID bigint not null,
        EXPANSION_STATUS varchar(50) not null,
        VSNAME varchar(200),
        RES_ID bigint,
        TOTAL_CONCEPT_DESIGNATIONS bigint default 0 not null,
        TOTAL_CONCEPTS bigint default 0 not null,
        URL varchar(200) not null,
        VER varchar(200),
        primary key (PID)
    );

    create table TRM_VALUESET_C_DESIGNATION (
       PID bigint not null,
        VALUESET_CONCEPT_PID bigint not null,
        LANG varchar(500),
        USE_CODE varchar(500),
        USE_DISPLAY varchar(500),
        USE_SYSTEM varchar(500),
        VAL varchar(2000) not null,
        VALUESET_PID bigint not null,
        primary key (PID)
    );

    create table TRM_VALUESET_CONCEPT (
       PID bigint not null,
        CODEVAL varchar(500) not null,
        DISPLAY varchar(400),
        INDEX_STATUS bigint,
        VALUESET_ORDER integer not null,
        SOURCE_DIRECT_PARENT_PIDS clob,
        SOURCE_PID bigint,
        SYSTEM_URL varchar(200) not null,
        SYSTEM_VER varchar(200),
        VALUESET_PID bigint not null,
        primary key (PID)
    );
create index IDX_BLKEX_EXPTIME on HFJ_BLK_EXPORT_JOB (EXP_TIME);

    alter table HFJ_BLK_EXPORT_JOB 
       add constraint IDX_BLKEX_JOB_ID unique (JOB_ID);

    alter table HFJ_BLK_IMPORT_JOB 
       add constraint IDX_BLKIM_JOB_ID unique (JOB_ID);
create index IDX_BLKIM_JOBFILE_JOBID on HFJ_BLK_IMPORT_JOBFILE (JOB_PID);
create index IDX_FORCEID_FID on HFJ_FORCED_ID (FORCED_ID);

    alter table HFJ_FORCED_ID 
       add constraint IDX_FORCEDID_RESID unique (RESOURCE_PID);

    alter table HFJ_FORCED_ID 
       add constraint IDX_FORCEDID_TYPE_FID unique (RESOURCE_TYPE, FORCED_ID);

    alter table HFJ_HISTORY_TAG 
       add constraint IDX_RESHISTTAG_TAGID unique (RES_VER_PID, TAG_ID);
create index IDX_IDXCMBTOKNU_STR on HFJ_IDX_CMB_TOK_NU (IDX_STRING);
create index IDX_IDXCMBTOKNU_RES on HFJ_IDX_CMB_TOK_NU (RES_ID);
create index IDX_IDXCMPSTRUNIQ_RESOURCE on HFJ_IDX_CMP_STRING_UNIQ (RES_ID);

    alter table HFJ_IDX_CMP_STRING_UNIQ 
       add constraint IDX_IDXCMPSTRUNIQ_STRING unique (IDX_STRING);

    alter table HFJ_PARTITION 
       add constraint IDX_PART_NAME unique (PART_NAME);
create index IDX_RL_TPATHRES on HFJ_RES_LINK (SRC_PATH, TARGET_RESOURCE_ID);
create index IDX_RL_SRC on HFJ_RES_LINK (SRC_RESOURCE_ID);
create index IDX_RL_DEST on HFJ_RES_LINK (TARGET_RESOURCE_ID);
create index IDX_RESPARMPRESENT_RESID on HFJ_RES_PARAM_PRESENT (RES_ID);
create index IDX_RESPARMPRESENT_HASHPRES on HFJ_RES_PARAM_PRESENT (HASH_PRESENCE);

    alter table HFJ_RES_TAG 
       add constraint IDX_RESTAG_TAGID unique (RES_ID, TAG_ID);
create index IDX_RESVER_TYPE_DATE on HFJ_RES_VER (RES_TYPE, RES_UPDATED);
create index IDX_RESVER_ID_DATE on HFJ_RES_VER (RES_ID, RES_UPDATED);
create index IDX_RESVER_DATE on HFJ_RES_VER (RES_UPDATED);

    alter table HFJ_RES_VER 
       add constraint IDX_RESVER_ID_VER unique (RES_ID, RES_VER);
create index IDX_RESVERPROV_SOURCEURI on HFJ_RES_VER_PROV (SOURCE_URI);
create index IDX_RESVERPROV_REQUESTID on HFJ_RES_VER_PROV (REQUEST_ID);
create index IDX_RES_DATE on HFJ_RESOURCE (RES_UPDATED);
create index IDX_RES_LANG on HFJ_RESOURCE (RES_TYPE, RES_LANGUAGE);
create index IDX_RES_TYPE on HFJ_RESOURCE (RES_TYPE);
create index IDX_INDEXSTATUS on HFJ_RESOURCE (SP_INDEX_STATUS);
create index IDX_SEARCH_RESTYPE_HASHS on HFJ_SEARCH (RESOURCE_TYPE, SEARCH_QUERY_STRING_HASH, CREATED);
create index IDX_SEARCH_CREATED on HFJ_SEARCH (CREATED);

    alter table HFJ_SEARCH 
       add constraint IDX_SEARCH_UUID unique (SEARCH_UUID);

    alter table HFJ_SEARCH_RESULT 
       add constraint IDX_SEARCHRES_ORDER unique (SEARCH_PID, SEARCH_ORDER);
create index IDX_SP_COORDS_HASH on HFJ_SPIDX_COORDS (HASH_IDENTITY, SP_LATITUDE, SP_LONGITUDE);
create index IDX_SP_COORDS_UPDATED on HFJ_SPIDX_COORDS (SP_UPDATED);
create index IDX_SP_COORDS_RESID on HFJ_SPIDX_COORDS (RES_ID);
create index IDX_SP_DATE_HASH on HFJ_SPIDX_DATE (HASH_IDENTITY, SP_VALUE_LOW, SP_VALUE_HIGH);
create index IDX_SP_DATE_HASH_LOW on HFJ_SPIDX_DATE (HASH_IDENTITY, SP_VALUE_LOW);
create index IDX_SP_DATE_HASH_HIGH on HFJ_SPIDX_DATE (HASH_IDENTITY, SP_VALUE_HIGH);
create index IDX_SP_DATE_ORD_HASH on HFJ_SPIDX_DATE (HASH_IDENTITY, SP_VALUE_LOW_DATE_ORDINAL, SP_VALUE_HIGH_DATE_ORDINAL);
create index IDX_SP_DATE_ORD_HASH_LOW on HFJ_SPIDX_DATE (HASH_IDENTITY, SP_VALUE_LOW_DATE_ORDINAL);
create index IDX_SP_DATE_RESID on HFJ_SPIDX_DATE (RES_ID);
create index IDX_SP_DATE_UPDATED on HFJ_SPIDX_DATE (SP_UPDATED);
create index IDX_SP_NUMBER_HASH_VAL on HFJ_SPIDX_NUMBER (HASH_IDENTITY, SP_VALUE);
create index IDX_SP_NUMBER_UPDATED on HFJ_SPIDX_NUMBER (SP_UPDATED);
create index IDX_SP_NUMBER_RESID on HFJ_SPIDX_NUMBER (RES_ID);
create index IDX_SP_QUANTITY_HASH on HFJ_SPIDX_QUANTITY (HASH_IDENTITY, SP_VALUE);
create index IDX_SP_QUANTITY_HASH_UN on HFJ_SPIDX_QUANTITY (HASH_IDENTITY_AND_UNITS, SP_VALUE);
create index IDX_SP_QUANTITY_HASH_SYSUN on HFJ_SPIDX_QUANTITY (HASH_IDENTITY_SYS_UNITS, SP_VALUE);
create index IDX_SP_QUANTITY_UPDATED on HFJ_SPIDX_QUANTITY (SP_UPDATED);
create index IDX_SP_QUANTITY_RESID on HFJ_SPIDX_QUANTITY (RES_ID);
create index IDX_SP_QNTY_NRML_HASH on HFJ_SPIDX_QUANTITY_NRML (HASH_IDENTITY, SP_VALUE);
create index IDX_SP_QNTY_NRML_HASH_UN on HFJ_SPIDX_QUANTITY_NRML (HASH_IDENTITY_AND_UNITS, SP_VALUE);
create index IDX_SP_QNTY_NRML_HASH_SYSUN on HFJ_SPIDX_QUANTITY_NRML (HASH_IDENTITY_SYS_UNITS, SP_VALUE);
create index IDX_SP_QNTY_NRML_UPDATED on HFJ_SPIDX_QUANTITY_NRML (SP_UPDATED);
create index IDX_SP_QNTY_NRML_RESID on HFJ_SPIDX_QUANTITY_NRML (RES_ID);
create index IDX_SP_STRING_HASH_IDENT on HFJ_SPIDX_STRING (HASH_IDENTITY);
create index IDX_SP_STRING_HASH_NRM on HFJ_SPIDX_STRING (HASH_NORM_PREFIX, SP_VALUE_NORMALIZED);
create index IDX_SP_STRING_HASH_EXCT on HFJ_SPIDX_STRING (HASH_EXACT);
create index IDX_SP_STRING_UPDATED on HFJ_SPIDX_STRING (SP_UPDATED);
create index IDX_SP_STRING_RESID on HFJ_SPIDX_STRING (RES_ID);
create index IDX_SP_TOKEN_HASH on HFJ_SPIDX_TOKEN (HASH_IDENTITY);
create index IDX_SP_TOKEN_HASH_S on HFJ_SPIDX_TOKEN (HASH_SYS);
create index IDX_SP_TOKEN_HASH_SV on HFJ_SPIDX_TOKEN (HASH_SYS_AND_VALUE);
create index IDX_SP_TOKEN_HASH_V on HFJ_SPIDX_TOKEN (HASH_VALUE);
create index IDX_SP_TOKEN_UPDATED on HFJ_SPIDX_TOKEN (SP_UPDATED);
create index IDX_SP_TOKEN_RESID on HFJ_SPIDX_TOKEN (RES_ID);
create index IDX_SP_URI on HFJ_SPIDX_URI (RES_TYPE, SP_NAME, SP_URI);
create index IDX_SP_URI_HASH_IDENTITY on HFJ_SPIDX_URI (HASH_IDENTITY, SP_URI);
create index IDX_SP_URI_HASH_URI on HFJ_SPIDX_URI (HASH_URI);
create index IDX_SP_URI_RESTYPE_NAME on HFJ_SPIDX_URI (RES_TYPE, SP_NAME);
create index IDX_SP_URI_UPDATED on HFJ_SPIDX_URI (SP_UPDATED);
create index IDX_SP_URI_COORDS on HFJ_SPIDX_URI (RES_ID);

    alter table HFJ_SUBSCRIPTION_STATS 
       add constraint IDX_SUBSC_RESID unique (RES_ID);

    alter table HFJ_TAG_DEF 
       add constraint IDX_TAGDEF_TYPESYSCODE unique (TAG_TYPE, TAG_SYSTEM, TAG_CODE);

    alter table MPI_LINK 
       add constraint IDX_EMPI_PERSON_TGT unique (PERSON_PID, TARGET_PID);

    alter table NPM_PACKAGE 
       add constraint IDX_PACK_ID unique (PACKAGE_ID);

    alter table NPM_PACKAGE_VER 
       add constraint IDX_PACKVER unique (PACKAGE_ID, VERSION_ID);
create index IDX_PACKVERRES_URL on NPM_PACKAGE_VER_RES (CANONICAL_URL);

    alter table TRM_CODESYSTEM 
       add constraint IDX_CS_CODESYSTEM unique (CODE_SYSTEM_URI);

    alter table TRM_CODESYSTEM_VER 
       add constraint IDX_CODESYSTEM_AND_VER unique (CODESYSTEM_PID, CS_VERSION_ID);
create index IDX_CONCEPT_INDEXSTATUS on TRM_CONCEPT (INDEX_STATUS);
create index IDX_CONCEPT_UPDATED on TRM_CONCEPT (CONCEPT_UPDATED);

    alter table TRM_CONCEPT 
       add constraint IDX_CONCEPT_CS_CODE unique (CODESYSTEM_PID, CODEVAL);

    alter table TRM_CONCEPT_MAP 
       add constraint IDX_CONCEPT_MAP_URL unique (URL, VER);
create index IDX_CNCPT_MAP_GRP_CD on TRM_CONCEPT_MAP_GRP_ELEMENT (SOURCE_CODE);
create index IDX_CNCPT_MP_GRP_ELM_TGT_CD on TRM_CONCEPT_MAP_GRP_ELM_TGT (TARGET_CODE);

    alter table TRM_VALUESET 
       add constraint IDX_VALUESET_URL unique (URL, VER);

    alter table TRM_VALUESET_CONCEPT 
       add constraint IDX_VS_CONCEPT_CSCD unique (VALUESET_PID, SYSTEM_URL, CODEVAL);

    alter table TRM_VALUESET_CONCEPT 
       add constraint IDX_VS_CONCEPT_ORDER unique (VALUESET_PID, VALUESET_ORDER);

    alter table HFJ_BLK_EXPORT_COLFILE 
       add constraint FK_BLKEXCOLFILE_COLLECT 
       foreign key (COLLECTION_PID) 
       references HFJ_BLK_EXPORT_COLLECTION;

    alter table HFJ_BLK_EXPORT_COLLECTION 
       add constraint FK_BLKEXCOL_JOB 
       foreign key (JOB_PID) 
       references HFJ_BLK_EXPORT_JOB;

    alter table HFJ_BLK_IMPORT_JOBFILE 
       add constraint FK_BLKIMJOBFILE_JOB 
       foreign key (JOB_PID) 
       references HFJ_BLK_IMPORT_JOB;

    alter table HFJ_FORCED_ID 
       add constraint FK_FORCEDID_RESOURCE 
       foreign key (RESOURCE_PID) 
       references HFJ_RESOURCE;

    alter table HFJ_HISTORY_TAG 
       add constraint FKtderym7awj6q8iq5c51xv4ndw 
       foreign key (TAG_ID) 
       references HFJ_TAG_DEF;

    alter table HFJ_HISTORY_TAG 
       add constraint FK_HISTORYTAG_HISTORY 
       foreign key (RES_VER_PID) 
       references HFJ_RES_VER;

    alter table HFJ_IDX_CMB_TOK_NU 
       add constraint FK_IDXCMBTOKNU_RES_ID 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_IDX_CMP_STRING_UNIQ 
       add constraint FK_IDXCMPSTRUNIQ_RES_ID 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_RES_LINK 
       add constraint FK_RESLINK_SOURCE 
       foreign key (SRC_RESOURCE_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_RES_LINK 
       add constraint FK_RESLINK_TARGET 
       foreign key (TARGET_RESOURCE_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_RES_PARAM_PRESENT 
       add constraint FK_RESPARMPRES_RESID 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_RES_TAG 
       add constraint FKbfcjbaftmiwr3rxkwsy23vneo 
       foreign key (TAG_ID) 
       references HFJ_TAG_DEF;

    alter table HFJ_RES_TAG 
       add constraint FK_RESTAG_RESOURCE 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_RES_VER 
       add constraint FK_RESOURCE_HISTORY_RESOURCE 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_RES_VER_PROV 
       add constraint FK_RESVERPROV_RES_PID 
       foreign key (RES_PID) 
       references HFJ_RESOURCE;

    alter table HFJ_RES_VER_PROV 
       add constraint FK_RESVERPROV_RESVER_PID 
       foreign key (RES_VER_PID) 
       references HFJ_RES_VER;

    alter table HFJ_SEARCH_INCLUDE 
       add constraint FK_SEARCHINC_SEARCH 
       foreign key (SEARCH_PID) 
       references HFJ_SEARCH;

    alter table HFJ_SPIDX_COORDS 
       add constraint FKc97mpk37okwu8qvtceg2nh9vn 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_SPIDX_DATE 
       add constraint FK17s70oa59rm9n61k9thjqrsqm 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_SPIDX_NUMBER 
       add constraint FKcltihnc5tgprj9bhpt7xi5otb 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_SPIDX_QUANTITY 
       add constraint FKn603wjjoi1a6asewxbbd78bi5 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_SPIDX_QUANTITY_NRML 
       add constraint FKrcjovmuh5kc0o6fvble319pyv 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_SPIDX_STRING 
       add constraint FK_SPIDXSTR_RESOURCE 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_SPIDX_TOKEN 
       add constraint FK7ulx3j1gg3v7maqrejgc7ybc4 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_SPIDX_URI 
       add constraint FKgxsreutymmfjuwdswv3y887do 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table HFJ_SUBSCRIPTION_STATS 
       add constraint FK_SUBSC_RESOURCE_ID 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table MPI_LINK 
       add constraint FK_EMPI_LINK_GOLDEN_RESOURCE 
       foreign key (GOLDEN_RESOURCE_PID) 
       references HFJ_RESOURCE;

    alter table MPI_LINK 
       add constraint FK_EMPI_LINK_PERSON 
       foreign key (PERSON_PID) 
       references HFJ_RESOURCE;

    alter table MPI_LINK 
       add constraint FK_EMPI_LINK_TARGET 
       foreign key (TARGET_PID) 
       references HFJ_RESOURCE;

    alter table NPM_PACKAGE_VER 
       add constraint FK_NPM_PKV_PKG 
       foreign key (PACKAGE_PID) 
       references NPM_PACKAGE;

    alter table NPM_PACKAGE_VER 
       add constraint FK_NPM_PKV_RESID 
       foreign key (BINARY_RES_ID) 
       references HFJ_RESOURCE;

    alter table NPM_PACKAGE_VER_RES 
       add constraint FK_NPM_PACKVERRES_PACKVER 
       foreign key (PACKVER_PID) 
       references NPM_PACKAGE_VER;

    alter table NPM_PACKAGE_VER_RES 
       add constraint FK_NPM_PKVR_RESID 
       foreign key (BINARY_RES_ID) 
       references HFJ_RESOURCE;

    alter table TRM_CODESYSTEM 
       add constraint FK_TRMCODESYSTEM_CURVER 
       foreign key (CURRENT_VERSION_PID) 
       references TRM_CODESYSTEM_VER;

    alter table TRM_CODESYSTEM 
       add constraint FK_TRMCODESYSTEM_RES 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table TRM_CODESYSTEM_VER 
       add constraint FK_CODESYSVER_CS_ID 
       foreign key (CODESYSTEM_PID) 
       references TRM_CODESYSTEM;

    alter table TRM_CODESYSTEM_VER 
       add constraint FK_CODESYSVER_RES_ID 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table TRM_CONCEPT 
       add constraint FK_CONCEPT_PID_CS_PID 
       foreign key (CODESYSTEM_PID) 
       references TRM_CODESYSTEM_VER;

    alter table TRM_CONCEPT_DESIG 
       add constraint FK_CONCEPTDESIG_CSV 
       foreign key (CS_VER_PID) 
       references TRM_CODESYSTEM_VER;

    alter table TRM_CONCEPT_DESIG 
       add constraint FK_CONCEPTDESIG_CONCEPT 
       foreign key (CONCEPT_PID) 
       references TRM_CONCEPT;

    alter table TRM_CONCEPT_MAP 
       add constraint FK_TRMCONCEPTMAP_RES 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table TRM_CONCEPT_MAP_GROUP 
       add constraint FK_TCMGROUP_CONCEPTMAP 
       foreign key (CONCEPT_MAP_PID) 
       references TRM_CONCEPT_MAP;

    alter table TRM_CONCEPT_MAP_GRP_ELEMENT 
       add constraint FK_TCMGELEMENT_GROUP 
       foreign key (CONCEPT_MAP_GROUP_PID) 
       references TRM_CONCEPT_MAP_GROUP;

    alter table TRM_CONCEPT_MAP_GRP_ELM_TGT 
       add constraint FK_TCMGETARGET_ELEMENT 
       foreign key (CONCEPT_MAP_GRP_ELM_PID) 
       references TRM_CONCEPT_MAP_GRP_ELEMENT;

    alter table TRM_CONCEPT_PC_LINK 
       add constraint FK_TERM_CONCEPTPC_CHILD 
       foreign key (CHILD_PID) 
       references TRM_CONCEPT;

    alter table TRM_CONCEPT_PC_LINK 
       add constraint FK_TERM_CONCEPTPC_CS 
       foreign key (CODESYSTEM_PID) 
       references TRM_CODESYSTEM_VER;

    alter table TRM_CONCEPT_PC_LINK 
       add constraint FK_TERM_CONCEPTPC_PARENT 
       foreign key (PARENT_PID) 
       references TRM_CONCEPT;

    alter table TRM_CONCEPT_PROPERTY 
       add constraint FK_CONCEPTPROP_CSV 
       foreign key (CS_VER_PID) 
       references TRM_CODESYSTEM_VER;

    alter table TRM_CONCEPT_PROPERTY 
       add constraint FK_CONCEPTPROP_CONCEPT 
       foreign key (CONCEPT_PID) 
       references TRM_CONCEPT;

    alter table TRM_VALUESET 
       add constraint FK_TRMVALUESET_RES 
       foreign key (RES_ID) 
       references HFJ_RESOURCE;

    alter table TRM_VALUESET_C_DESIGNATION 
       add constraint FK_TRM_VALUESET_CONCEPT_PID 
       foreign key (VALUESET_CONCEPT_PID) 
       references TRM_VALUESET_CONCEPT;

    alter table TRM_VALUESET_C_DESIGNATION 
       add constraint FK_TRM_VSCD_VS_PID 
       foreign key (VALUESET_PID) 
       references TRM_VALUESET;

    alter table TRM_VALUESET_CONCEPT 
       add constraint FK_TRM_VALUESET_PID 
       foreign key (VALUESET_PID) 
       references TRM_VALUESET;
