/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch2;

import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.api.JobOperationResultJson;
import ca.uhn.fhir.batch2.model.FetchJobInstancesRequest;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.batch2.model.WorkChunk;
import ca.uhn.fhir.batch2.model.WorkChunkCompletionEvent;
import ca.uhn.fhir.batch2.model.WorkChunkCreateEvent;
import ca.uhn.fhir.batch2.model.WorkChunkErrorEvent;
import ca.uhn.fhir.batch2.model.WorkChunkStatusEnum;
import ca.uhn.fhir.batch2.models.JobInstanceFetchRequest;
import ca.uhn.fhir.jpa.batch2.JobInstanceUtil;
import ca.uhn.fhir.jpa.dao.data.IBatch2JobInstanceRepository;
import ca.uhn.fhir.jpa.dao.data.IBatch2WorkChunkRepository;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.entity.Batch2JobInstanceEntity;
import ca.uhn.fhir.jpa.entity.Batch2WorkChunkEntity;
import ca.uhn.fhir.model.api.PagingIterator;
import ca.uhn.fhir.util.Logs;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JpaJobPersistenceImpl
implements IJobPersistence {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    public static final String CREATE_TIME = "myCreateTime";
    private final IBatch2JobInstanceRepository myJobInstanceRepository;
    private final IBatch2WorkChunkRepository myWorkChunkRepository;
    private final EntityManager myEntityManager;
    private final IHapiTransactionService myTransactionService;

    public JpaJobPersistenceImpl(IBatch2JobInstanceRepository theJobInstanceRepository, IBatch2WorkChunkRepository theWorkChunkRepository, IHapiTransactionService theTransactionService, EntityManager theEntityManager) {
        Validate.notNull((Object)theJobInstanceRepository);
        Validate.notNull((Object)theWorkChunkRepository);
        this.myJobInstanceRepository = theJobInstanceRepository;
        this.myWorkChunkRepository = theWorkChunkRepository;
        this.myTransactionService = theTransactionService;
        this.myEntityManager = theEntityManager;
    }

    public String onWorkChunkCreate(WorkChunkCreateEvent theBatchWorkChunk) {
        Batch2WorkChunkEntity entity = new Batch2WorkChunkEntity();
        entity.setId(UUID.randomUUID().toString());
        entity.setSequence(theBatchWorkChunk.sequence);
        entity.setJobDefinitionId(theBatchWorkChunk.jobDefinitionId);
        entity.setJobDefinitionVersion(theBatchWorkChunk.jobDefinitionVersion);
        entity.setTargetStepId(theBatchWorkChunk.targetStepId);
        entity.setInstanceId(theBatchWorkChunk.instanceId);
        entity.setSerializedData(theBatchWorkChunk.serializedData);
        entity.setCreateTime(new Date());
        entity.setStartTime(new Date());
        entity.setStatus(WorkChunkStatusEnum.QUEUED);
        ourLog.debug("Create work chunk {}/{}/{}", new Object[]{entity.getInstanceId(), entity.getId(), entity.getTargetStepId()});
        ourLog.trace("Create work chunk data {}/{}: {}", new Object[]{entity.getInstanceId(), entity.getId(), entity.getSerializedData()});
        this.myWorkChunkRepository.save(entity);
        return entity.getId();
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Optional<WorkChunk> onWorkChunkDequeue(String theChunkId) {
        List<WorkChunkStatusEnum> priorStates = List.of(WorkChunkStatusEnum.QUEUED, WorkChunkStatusEnum.ERRORED, WorkChunkStatusEnum.IN_PROGRESS);
        int rowsModified = this.myWorkChunkRepository.updateChunkStatusForStart(theChunkId, new Date(), WorkChunkStatusEnum.IN_PROGRESS, priorStates);
        if (rowsModified == 0) {
            ourLog.info("Attempting to start chunk {} but it was already started.", (Object)theChunkId);
            return Optional.empty();
        }
        Optional chunk = this.myWorkChunkRepository.findById(theChunkId);
        return chunk.map(this::toChunk);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public String storeNewInstance(JobInstance theInstance) {
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)theInstance.getInstanceId()));
        Batch2JobInstanceEntity entity = new Batch2JobInstanceEntity();
        entity.setId(UUID.randomUUID().toString());
        entity.setDefinitionId(theInstance.getJobDefinitionId());
        entity.setDefinitionVersion(theInstance.getJobDefinitionVersion());
        entity.setStatus(theInstance.getStatus());
        entity.setParams(theInstance.getParameters());
        entity.setCurrentGatedStepId(theInstance.getCurrentGatedStepId());
        entity.setFastTracking(theInstance.isFastTracking());
        entity.setCreateTime(new Date());
        entity.setStartTime(new Date());
        entity.setReport(theInstance.getReport());
        entity = (Batch2JobInstanceEntity)this.myJobInstanceRepository.save(entity);
        return entity.getId();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<JobInstance> fetchInstances(String theJobDefinitionId, Set<StatusEnum> theStatuses, Date theCutoff, Pageable thePageable) {
        return this.toInstanceList(this.myJobInstanceRepository.findInstancesByJobIdAndStatusAndExpiry(theJobDefinitionId, theStatuses, theCutoff, thePageable));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<JobInstance> fetchInstancesByJobDefinitionIdAndStatus(String theJobDefinitionId, Set<StatusEnum> theRequestedStatuses, int thePageSize, int thePageIndex) {
        PageRequest pageRequest = PageRequest.of((int)thePageIndex, (int)thePageSize, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{CREATE_TIME});
        return this.toInstanceList(this.myJobInstanceRepository.fetchInstancesByJobDefinitionIdAndStatus(theJobDefinitionId, theRequestedStatuses, (Pageable)pageRequest));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<JobInstance> fetchInstancesByJobDefinitionId(String theJobDefinitionId, int thePageSize, int thePageIndex) {
        PageRequest pageRequest = PageRequest.of((int)thePageIndex, (int)thePageSize, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{CREATE_TIME});
        return this.toInstanceList(this.myJobInstanceRepository.findInstancesByJobDefinitionId(theJobDefinitionId, (Pageable)pageRequest));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Page<JobInstance> fetchJobInstances(JobInstanceFetchRequest theRequest) {
        PageRequest pageRequest = PageRequest.of((int)theRequest.getPageStart(), (int)theRequest.getBatchSize(), (Sort)theRequest.getSort());
        String jobStatus = theRequest.getJobStatus();
        if (Objects.equals(jobStatus, "")) {
            Page pageOfEntities = this.myJobInstanceRepository.findAll((Pageable)pageRequest);
            return pageOfEntities.map(this::toInstance);
        }
        StatusEnum status = StatusEnum.valueOf((String)jobStatus);
        List<JobInstance> jobs = this.toInstanceList(this.myJobInstanceRepository.findInstancesByJobStatus(status, (Pageable)pageRequest));
        Integer jobsOfStatus = this.myJobInstanceRepository.findTotalJobsOfStatus(status);
        return new PageImpl(jobs, (Pageable)pageRequest, (long)jobsOfStatus.intValue());
    }

    private List<JobInstance> toInstanceList(List<Batch2JobInstanceEntity> theInstancesByJobDefinitionId) {
        return theInstancesByJobDefinitionId.stream().map(this::toInstance).collect(Collectors.toList());
    }

    @Nonnull
    public Optional<JobInstance> fetchInstance(String theInstanceId) {
        return (Optional)this.myTransactionService.withSystemRequest().execute(() -> this.myJobInstanceRepository.findById(theInstanceId).map(this::toInstance));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<JobInstance> fetchInstances(FetchJobInstancesRequest theRequest, int thePage, int theBatchSize) {
        List<Batch2JobInstanceEntity> instanceEntities;
        String definitionId = theRequest.getJobDefinition();
        String params = theRequest.getParameters();
        Set statuses = theRequest.getStatuses();
        PageRequest pageable = PageRequest.of((int)thePage, (int)theBatchSize);
        if (statuses != null && !statuses.isEmpty()) {
            if (definitionId.equals("BULK_EXPORT") && this.originalRequestUrlTruncation(params) != null) {
                params = this.originalRequestUrlTruncation(params);
            }
            instanceEntities = this.myJobInstanceRepository.findInstancesByJobIdParamsAndStatus(definitionId, params, statuses, (Pageable)pageable);
        } else {
            instanceEntities = this.myJobInstanceRepository.findInstancesByJobIdAndParams(definitionId, params, (Pageable)pageable);
        }
        return this.toInstanceList(instanceEntities);
    }

    private String originalRequestUrlTruncation(String theParams) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            JsonNode rootNode = mapper.readTree(theParams);
            String originalUrl = "originalRequestUrl";
            if (rootNode instanceof ObjectNode) {
                String url;
                ObjectNode objectNode = (ObjectNode)rootNode;
                if (objectNode.has(originalUrl) && (url = objectNode.get(originalUrl).asText()).contains("?")) {
                    objectNode.put(originalUrl, url.split("\\?")[0]);
                }
                return mapper.writeValueAsString((Object)objectNode);
            }
        }
        catch (Exception e) {
            ourLog.info("Error Truncating Original Request Url", (Throwable)e);
        }
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<JobInstance> fetchInstances(int thePageSize, int thePageIndex) {
        PageRequest pageRequest = PageRequest.of((int)thePageIndex, (int)thePageSize, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{CREATE_TIME});
        return this.myJobInstanceRepository.findAll((Pageable)pageRequest).stream().map(this::toInstance).collect(Collectors.toList());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<JobInstance> fetchRecentInstances(int thePageSize, int thePageIndex) {
        PageRequest pageRequest = PageRequest.of((int)thePageIndex, (int)thePageSize, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{CREATE_TIME});
        return this.myJobInstanceRepository.findAll((Pageable)pageRequest).stream().map(this::toInstance).collect(Collectors.toList());
    }

    private WorkChunk toChunk(Batch2WorkChunkEntity theEntity) {
        return JobInstanceUtil.fromEntityToWorkChunk(theEntity);
    }

    private JobInstance toInstance(Batch2JobInstanceEntity theEntity) {
        return JobInstanceUtil.fromEntityToInstance(theEntity);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public WorkChunkStatusEnum onWorkChunkError(WorkChunkErrorEvent theParameters) {
        String errorMessage;
        String chunkId = theParameters.getChunkId();
        int changeCount = this.myWorkChunkRepository.updateChunkStatusAndIncrementErrorCountForEndError(chunkId, new Date(), errorMessage = JpaJobPersistenceImpl.truncateErrorMessage(theParameters.getErrorMsg()), WorkChunkStatusEnum.ERRORED);
        Validate.isTrue((changeCount > 0 ? 1 : 0) != 0, (String)"changed chunk matching %s", (Object[])new Object[]{chunkId});
        Query query = this.myEntityManager.createQuery("update Batch2WorkChunkEntity set myStatus = :failed ,myErrorMessage = CONCAT('Too many errors: ', CAST(myErrorCount as string), '. Last error msg was ', myErrorMessage) where myId = :chunkId and myErrorCount > :maxCount");
        query.setParameter("chunkId", (Object)chunkId);
        query.setParameter("failed", (Object)WorkChunkStatusEnum.FAILED);
        query.setParameter("maxCount", (Object)3);
        int failChangeCount = query.executeUpdate();
        if (failChangeCount > 0) {
            return WorkChunkStatusEnum.FAILED;
        }
        return WorkChunkStatusEnum.ERRORED;
    }

    @Transactional
    public void onWorkChunkFailed(String theChunkId, String theErrorMessage) {
        ourLog.info("Marking chunk {} as failed with message: {}", (Object)theChunkId, (Object)theErrorMessage);
        String errorMessage = JpaJobPersistenceImpl.truncateErrorMessage(theErrorMessage);
        this.myWorkChunkRepository.updateChunkStatusAndIncrementErrorCountForEndError(theChunkId, new Date(), errorMessage, WorkChunkStatusEnum.FAILED);
    }

    @Transactional
    public void onWorkChunkCompletion(WorkChunkCompletionEvent theEvent) {
        this.myWorkChunkRepository.updateChunkStatusAndClearDataForEndSuccess(theEvent.getChunkId(), new Date(), theEvent.getRecordsProcessed(), theEvent.getRecoveredErrorCount(), WorkChunkStatusEnum.COMPLETED, theEvent.getRecoveredWarningMessage());
    }

    @Nullable
    private static String truncateErrorMessage(String theErrorMessage) {
        String errorMessage;
        if (theErrorMessage != null && theErrorMessage.length() > 500) {
            ourLog.warn("Truncating error message that is too long to store in database: {}", (Object)theErrorMessage);
            errorMessage = theErrorMessage.substring(0, 500);
        } else {
            errorMessage = theErrorMessage;
        }
        return errorMessage;
    }

    public void markWorkChunksWithStatusAndWipeData(String theInstanceId, List<String> theChunkIds, WorkChunkStatusEnum theStatus, String theErrorMessage) {
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        ourLog.debug("Marking all chunks for instance {} to status {}", (Object)theInstanceId, (Object)theStatus);
        String errorMessage = JpaJobPersistenceImpl.truncateErrorMessage(theErrorMessage);
        List listOfListOfIds = ListUtils.partition(theChunkIds, (int)100);
        for (List idList : listOfListOfIds) {
            this.myWorkChunkRepository.updateAllChunksForInstanceStatusClearDataAndSetError(idList, new Date(), theStatus, errorMessage);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public boolean canAdvanceInstanceToNextStep(String theInstanceId, String theCurrentStepId) {
        Optional instance = this.myJobInstanceRepository.findById(theInstanceId);
        if (instance.isEmpty()) {
            return false;
        }
        if (((Batch2JobInstanceEntity)instance.get()).getStatus().isEnded()) {
            return false;
        }
        Set<WorkChunkStatusEnum> statusesForStep = this.myWorkChunkRepository.getDistinctStatusesForStep(theInstanceId, theCurrentStepId);
        ourLog.debug("Checking whether gated job can advanced to next step. [instanceId={}, currentStepId={}, statusesForStep={}]", new Object[]{theInstanceId, theCurrentStepId, statusesForStep});
        return statusesForStep.isEmpty() || statusesForStep.equals(Set.of(WorkChunkStatusEnum.COMPLETED));
    }

    private void fetchChunks(String theInstanceId, boolean theIncludeData, int thePageSize, int thePageIndex, Consumer<WorkChunk> theConsumer) {
        this.myTransactionService.withSystemRequest().withPropagation(Propagation.REQUIRES_NEW).execute(() -> {
            List<Batch2WorkChunkEntity> chunks = theIncludeData ? this.myWorkChunkRepository.fetchChunks((Pageable)PageRequest.of((int)thePageIndex, (int)thePageSize), theInstanceId) : this.myWorkChunkRepository.fetchChunksNoData((Pageable)PageRequest.of((int)thePageIndex, (int)thePageSize), theInstanceId);
            for (Batch2WorkChunkEntity chunk : chunks) {
                theConsumer.accept(this.toChunk(chunk));
            }
        });
    }

    public List<String> fetchAllChunkIdsForStepWithStatus(String theInstanceId, String theStepId, WorkChunkStatusEnum theStatusEnum) {
        return (List)this.myTransactionService.withSystemRequest().withPropagation(Propagation.REQUIRES_NEW).execute(() -> this.myWorkChunkRepository.fetchAllChunkIdsForStepWithStatus(theInstanceId, theStepId, theStatusEnum));
    }

    public void updateInstanceUpdateTime(String theInstanceId) {
        this.myJobInstanceRepository.updateInstanceUpdateTime(theInstanceId, new Date());
    }

    public Iterator<WorkChunk> fetchAllWorkChunksIterator(String theInstanceId, boolean theWithData) {
        return new PagingIterator((thePageIndex, theBatchSize, theConsumer) -> this.fetchChunks(theInstanceId, theWithData, theBatchSize, thePageIndex, theConsumer));
    }

    public Stream<WorkChunk> fetchAllWorkChunksForStepStream(String theInstanceId, String theStepId) {
        return this.myWorkChunkRepository.fetchChunksForStep(theInstanceId, theStepId).map(this::toChunk);
    }

    public boolean updateInstance(String theInstanceId, IJobPersistence.JobInstanceUpdateCallback theModifier) {
        Batch2JobInstanceEntity instanceEntity = (Batch2JobInstanceEntity)this.myEntityManager.find(Batch2JobInstanceEntity.class, (Object)theInstanceId, LockModeType.PESSIMISTIC_WRITE);
        if (null == instanceEntity) {
            ourLog.error("No instance found with Id {}", (Object)theInstanceId);
            return false;
        }
        JobInstance jobInstance = JobInstanceUtil.fromEntityToInstance(instanceEntity);
        boolean wasModified = theModifier.doUpdate(jobInstance);
        if (wasModified) {
            JobInstanceUtil.fromInstanceToEntity(jobInstance, instanceEntity);
        }
        return wasModified;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void deleteInstanceAndChunks(String theInstanceId) {
        ourLog.info("Deleting instance and chunks: {}", (Object)theInstanceId);
        this.myWorkChunkRepository.deleteAllForInstance(theInstanceId);
        this.myJobInstanceRepository.deleteById(theInstanceId);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void deleteChunksAndMarkInstanceAsChunksPurged(String theInstanceId) {
        ourLog.info("Deleting all chunks for instance ID: {}", (Object)theInstanceId);
        int updateCount = this.myJobInstanceRepository.updateWorkChunksPurgedTrue(theInstanceId);
        int deleteCount = this.myWorkChunkRepository.deleteAllForInstance(theInstanceId);
        ourLog.debug("Purged {} chunks, and updated {} instance.", (Object)deleteCount, (Object)updateCount);
    }

    public boolean markInstanceAsStatusWhenStatusIn(String theInstanceId, StatusEnum theStatusEnum, Set<StatusEnum> thePriorStates) {
        int recordsChanged = this.myJobInstanceRepository.updateInstanceStatusIfIn(theInstanceId, theStatusEnum, thePriorStates);
        ourLog.debug("Update job {} to status {} if in status {}: {}", new Object[]{theInstanceId, theStatusEnum, thePriorStates, recordsChanged > 0});
        return recordsChanged > 0;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public JobOperationResultJson cancelInstance(String theInstanceId) {
        int recordsChanged = this.myJobInstanceRepository.updateInstanceCancelled(theInstanceId, true);
        String operationString = "Cancel job instance " + theInstanceId;
        String messagePrefix = "Job instance <" + theInstanceId + ">";
        if (recordsChanged > 0) {
            return JobOperationResultJson.newSuccess((String)operationString, (String)(messagePrefix + " successfully cancelled."));
        }
        Optional<JobInstance> instance = this.fetchInstance(theInstanceId);
        if (instance.isPresent()) {
            return JobOperationResultJson.newFailure((String)operationString, (String)(messagePrefix + " was already cancelled.  Nothing to do."));
        }
        return JobOperationResultJson.newFailure((String)operationString, (String)(messagePrefix + " not found."));
    }
}

