/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.svc;

import ca.uhn.fhir.batch2.api.IJobPersistence;
import ca.uhn.fhir.batch2.model.JobInstance;
import ca.uhn.fhir.batch2.model.StatusEnum;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.BulkExportJobResults;
import ca.uhn.fhir.jpa.bulk.export.api.IBulkDataExportJobSchedulingHelper;
import ca.uhn.fhir.jpa.bulk.export.svc.BulkExportHelperService;
import ca.uhn.fhir.jpa.model.sched.HapiJob;
import ca.uhn.fhir.jpa.model.sched.IHasScheduledJobs;
import ca.uhn.fhir.jpa.model.sched.ISchedulerService;
import ca.uhn.fhir.jpa.model.sched.ScheduledJobDefinition;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.util.JsonUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Binary;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

public class BulkDataExportJobSchedulingHelperImpl
implements IBulkDataExportJobSchedulingHelper,
IHasScheduledJobs {
    private static final Logger ourLog = LoggerFactory.getLogger(BulkDataExportJobSchedulingHelperImpl.class);
    private final DaoRegistry myDaoRegistry;
    private final PlatformTransactionManager myTxManager;
    private final JpaStorageSettings myDaoConfig;
    private final BulkExportHelperService myBulkExportHelperSvc;
    private final IJobPersistence myJpaJobPersistence;
    private TransactionTemplate myTxTemplate;

    public BulkDataExportJobSchedulingHelperImpl(DaoRegistry theDaoRegistry, PlatformTransactionManager theTxManager, JpaStorageSettings theDaoConfig, BulkExportHelperService theBulkExportHelperSvc, IJobPersistence theJpaJobPersistence, TransactionTemplate theTxTemplate) {
        this.myDaoRegistry = theDaoRegistry;
        this.myTxManager = theTxManager;
        this.myDaoConfig = theDaoConfig;
        this.myBulkExportHelperSvc = theBulkExportHelperSvc;
        this.myJpaJobPersistence = theJpaJobPersistence;
        this.myTxTemplate = theTxTemplate;
    }

    @PostConstruct
    public void start() {
        this.myTxTemplate = new TransactionTemplate(this.myTxManager);
    }

    public void scheduleJobs(ISchedulerService theSchedulerService) {
        ScheduledJobDefinition jobDetail = new ScheduledJobDefinition();
        jobDetail.setId(PurgeExpiredFilesJob.class.getName());
        jobDetail.setJobClass(PurgeExpiredFilesJob.class);
        theSchedulerService.scheduleClusteredJob(3600000L, jobDetail);
    }

    @Transactional(propagation=Propagation.NEVER)
    public synchronized void cancelAndPurgeAllJobs() {
    }

    @Transactional(propagation=Propagation.NEVER)
    public void purgeExpiredFiles() {
        if (!this.myDaoConfig.isEnableTaskBulkExportJobExecution()) {
            ourLog.debug("bulk export disabled:  doing nothing");
            return;
        }
        List jobInstancesToDelete = (List)this.myTxTemplate.execute(t -> this.myJpaJobPersistence.fetchInstances("BULK_EXPORT", StatusEnum.getEndedStatuses(), this.computeCutoffFromConfig(), (Pageable)PageRequest.of((int)0, (int)50)));
        if (jobInstancesToDelete == null || jobInstancesToDelete.isEmpty()) {
            ourLog.debug("No batch 2 bulk export jobs found!  Nothing to do!");
            ourLog.info("Finished bulk export job deletion with nothing to do");
            return;
        }
        for (JobInstance jobInstance : jobInstancesToDelete) {
            ourLog.info("Deleting batch 2 bulk export job: {}", (Object)jobInstance);
            this.myTxTemplate.execute(t -> {
                Optional optJobInstanceForInstanceId = this.myJpaJobPersistence.fetchInstance(jobInstance.getInstanceId());
                if (optJobInstanceForInstanceId.isEmpty()) {
                    ourLog.error("Can't find job instance for ID: {} despite having retrieved it in the first step", (Object)jobInstance.getInstanceId());
                    return null;
                }
                JobInstance jobInstanceForInstanceId = (JobInstance)optJobInstanceForInstanceId.get();
                ourLog.info("Deleting bulk export job: {}", (Object)jobInstanceForInstanceId);
                if (StatusEnum.FAILED == jobInstanceForInstanceId.getStatus()) {
                    ourLog.info("skipping because the status is FAILED for ID: {}" + jobInstanceForInstanceId.getInstanceId());
                    return null;
                }
                this.purgeBinariesIfNeeded(jobInstanceForInstanceId, jobInstanceForInstanceId.getReport());
                String batch2BulkExportJobInstanceId = jobInstanceForInstanceId.getInstanceId();
                ourLog.debug("*** About to delete batch 2 bulk export job with ID {}", (Object)batch2BulkExportJobInstanceId);
                this.myJpaJobPersistence.deleteInstanceAndChunks(batch2BulkExportJobInstanceId);
                ourLog.info("Finished deleting bulk export job: {}", (Object)jobInstance.getInstanceId());
                return null;
            });
            ourLog.info("Finished deleting bulk export jobs");
        }
    }

    private void purgeBinariesIfNeeded(JobInstance theJobInstanceForInstanceId, String theJobInstanceReportString) {
        Optional<BulkExportJobResults> optBulkExportJobResults = this.getBulkExportJobResults(theJobInstanceReportString);
        if (optBulkExportJobResults.isPresent()) {
            BulkExportJobResults bulkExportJobResults = optBulkExportJobResults.get();
            ourLog.debug("job: {} resource type to binary ID: {}", (Object)theJobInstanceForInstanceId.getInstanceId(), (Object)bulkExportJobResults.getResourceTypeToBinaryIds());
            Map resourceTypeToBinaryIds = bulkExportJobResults.getResourceTypeToBinaryIds();
            for (String resourceType : resourceTypeToBinaryIds.keySet()) {
                List binaryIds = (List)resourceTypeToBinaryIds.get(resourceType);
                for (String binaryId : binaryIds) {
                    ourLog.info("Purging batch 2 bulk export binary: {}", (Object)binaryId);
                    IIdType id = this.myBulkExportHelperSvc.toId(binaryId);
                    this.getBinaryDao().delete(id, (RequestDetails)new SystemRequestDetails());
                }
            }
        }
    }

    private IFhirResourceDao<IBaseBinary> getBinaryDao() {
        return this.myDaoRegistry.getResourceDao(Binary.class.getSimpleName());
    }

    @Nonnull
    private Optional<BulkExportJobResults> getBulkExportJobResults(String theJobInstanceReportString) {
        if (StringUtils.isBlank((CharSequence)theJobInstanceReportString)) {
            ourLog.error(String.format("Cannot parse job report string because it's null or blank: %s", theJobInstanceReportString));
            return Optional.empty();
        }
        try {
            return Optional.of((BulkExportJobResults)JsonUtil.deserialize((String)theJobInstanceReportString, BulkExportJobResults.class));
        }
        catch (Exception theException) {
            ourLog.error(String.format("Cannot parse job report string: %s", theJobInstanceReportString), (Throwable)theException);
            return Optional.empty();
        }
    }

    @Nonnull
    private Date computeCutoffFromConfig() {
        int bulkExportFileRetentionPeriodHours = this.myDaoConfig.getBulkExportFileRetentionPeriodHours();
        LocalDateTime cutoffLocalDateTime = LocalDateTime.now().minusHours(bulkExportFileRetentionPeriodHours);
        return Date.from(cutoffLocalDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static class PurgeExpiredFilesJob
    implements HapiJob {
        @Autowired
        private IBulkDataExportJobSchedulingHelper myTarget;

        public void execute(JobExecutionContext theContext) {
            this.myTarget.purgeExpiredFiles();
        }
    }
}

