/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config;

import ca.uhn.fhir.i18n.HapiLocalizer;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.system.HapiSystemProperties;
import javax.annotation.Nonnull;
import javax.persistence.PersistenceException;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.PessimisticLockException;
import org.hibernate.StaleStateException;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;

public class HapiFhirHibernateJpaDialect
extends HibernateJpaDialect {
    private static final Logger ourLog = LoggerFactory.getLogger(HapiFhirHibernateJpaDialect.class);
    static final String RESOURCE_VERSION_CONSTRAINT_FAILURE = "resourceVersionConstraintFailure";
    private final HapiLocalizer myLocalizer;

    public HapiFhirHibernateJpaDialect(HapiLocalizer theLocalizer) {
        this.myLocalizer = theLocalizer;
    }

    public RuntimeException translate(PersistenceException theException, String theMessageToPrepend) {
        if (theException.getCause() instanceof HibernateException) {
            return new PersistenceException((Throwable)this.convertHibernateAccessException((HibernateException)theException.getCause(), theMessageToPrepend));
        }
        return theException;
    }

    protected DataAccessException convertHibernateAccessException(@Nonnull HibernateException theException) {
        return this.convertHibernateAccessException(theException, null);
    }

    private DataAccessException convertHibernateAccessException(HibernateException theException, String theMessageToPrepend) {
        PessimisticLockException ex;
        String sql;
        String constraintName;
        Object messageToPrepend = "";
        if (StringUtils.isNotBlank((CharSequence)theMessageToPrepend)) {
            messageToPrepend = theMessageToPrepend + " - ";
        }
        if (HapiSystemProperties.isUnitTestModeEnabled()) {
            ourLog.error("Hibernate exception", (Throwable)theException);
        }
        if (theException instanceof ConstraintViolationException && StringUtils.isNotBlank((CharSequence)(constraintName = ((ConstraintViolationException)theException).getConstraintName()))) {
            if ((constraintName = constraintName.toUpperCase()).contains("IDX_RESVER_ID_VER")) {
                throw new ResourceVersionConflictException(Msg.code((int)823) + this.makeErrorMessage((String)messageToPrepend, RESOURCE_VERSION_CONSTRAINT_FAILURE));
            }
            if (constraintName.contains("IDX_IDXCMPSTRUNIQ_STRING")) {
                throw new ResourceVersionConflictException(Msg.code((int)824) + this.makeErrorMessage((String)messageToPrepend, "resourceIndexedCompositeStringUniqueConstraintFailure"));
            }
            if (constraintName.contains("IDX_RES_TYPE_FHIR_ID")) {
                throw new ResourceVersionConflictException(Msg.code((int)825) + this.makeErrorMessage((String)messageToPrepend, "forcedIdConstraintFailure"));
            }
            if (constraintName.contains("RES_SEARCH_URL")) {
                throw super.convertHibernateAccessException(theException);
            }
        }
        if (theException instanceof StaleStateException) {
            throw new ResourceVersionConflictException(Msg.code((int)826) + this.makeErrorMessage((String)messageToPrepend, RESOURCE_VERSION_CONSTRAINT_FAILURE));
        }
        if (theException instanceof PessimisticLockException && (sql = StringUtils.defaultString((String)(ex = (PessimisticLockException)theException).getSQL()).toUpperCase()).contains("HFJ_RES_VER")) {
            throw new ResourceVersionConflictException(Msg.code((int)827) + this.makeErrorMessage((String)messageToPrepend, RESOURCE_VERSION_CONSTRAINT_FAILURE));
        }
        DataAccessException retVal = super.convertHibernateAccessException(theException);
        return retVal;
    }

    @Nonnull
    private String makeErrorMessage(String thePrefix, String theMessageKey) {
        return thePrefix + this.myLocalizer.getMessage(HapiFhirHibernateJpaDialect.class, theMessageKey, new Object[0]);
    }
}

