/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.api.svc.ISearchCoordinatorSvc;
import ca.uhn.fhir.jpa.config.HapiFhirLocalContainerEntityManagerFactoryBean;
import ca.uhn.fhir.jpa.config.HibernatePropertiesProvider;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.dao.data.IResourceSearchViewDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTagDao;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.search.ExceptionService;
import ca.uhn.fhir.jpa.search.ISynchronousSearchSvc;
import ca.uhn.fhir.jpa.search.PersistedJpaBundleProviderFactory;
import ca.uhn.fhir.jpa.search.SearchCoordinatorSvcImpl;
import ca.uhn.fhir.jpa.search.SearchStrategyFactory;
import ca.uhn.fhir.jpa.search.builder.SearchBuilder;
import ca.uhn.fhir.jpa.search.builder.sql.SqlObjectFactory;
import ca.uhn.fhir.jpa.search.builder.tasks.SearchContinuationTask;
import ca.uhn.fhir.jpa.search.builder.tasks.SearchTask;
import ca.uhn.fhir.jpa.search.builder.tasks.SearchTaskParameters;
import ca.uhn.fhir.jpa.search.cache.ISearchCacheSvc;
import ca.uhn.fhir.jpa.search.cache.ISearchResultCacheSvc;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class SearchConfig {
    public static final String SEARCH_TASK = "searchTask";
    public static final String CONTINUE_TASK = "continueTask";
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private HapiFhirLocalContainerEntityManagerFactoryBean myEntityManagerFactory;
    @Autowired
    private SqlObjectFactory mySqlBuilderFactory;
    @Autowired
    private HibernatePropertiesProvider myDialectProvider;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired
    protected IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    protected IResourceTagDao myResourceTagDao;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IResourceSearchViewDao myResourceSearchViewDao;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private IIdHelperService myIdHelperService;
    @Autowired
    private PlatformTransactionManager myManagedTxManager;
    @Autowired
    private SearchStrategyFactory mySearchStrategyFactory;
    @Autowired
    private SearchBuilderFactory mySearchBuilderFactory;
    @Autowired
    private ISearchResultCacheSvc mySearchResultCacheSvc;
    @Autowired
    private ISearchCacheSvc mySearchCacheSvc;
    @Autowired
    private IPagingProvider myPagingProvider;
    @Autowired
    private BeanFactory myBeanFactory;
    @Autowired
    private ISynchronousSearchSvc mySynchronousSearchSvc;
    @Autowired
    private PersistedJpaBundleProviderFactory myPersistedJpaBundleProviderFactory;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperService;
    @Autowired
    private HapiTransactionService myHapiTransactionService;

    @Bean
    public ISearchCoordinatorSvc searchCoordinatorSvc() {
        return new SearchCoordinatorSvcImpl(this.myContext, this.myStorageSettings, this.myInterceptorBroadcaster, this.myHapiTransactionService, this.mySearchCacheSvc, this.mySearchResultCacheSvc, this.myDaoRegistry, (SearchBuilderFactory<JpaPid>)this.mySearchBuilderFactory, this.mySynchronousSearchSvc, this.myPersistedJpaBundleProviderFactory, this.mySearchParamRegistry, this.mySearchStrategyFactory, this.exceptionService(), this.myBeanFactory);
    }

    @Bean
    public ExceptionService exceptionService() {
        return new ExceptionService(this.myContext);
    }

    @Bean(name={"SearchBuilder"})
    @Scope(value="prototype")
    public ISearchBuilder newSearchBuilder(IDao theDao, String theResourceName, Class<? extends IBaseResource> theResourceType) {
        return new SearchBuilder(theDao, theResourceName, this.myStorageSettings, this.myEntityManagerFactory, this.mySqlBuilderFactory, this.myDialectProvider, this.mySearchParamRegistry, this.myPartitionSettings, this.myInterceptorBroadcaster, this.myResourceTagDao, this.myDaoRegistry, this.myResourceSearchViewDao, this.myContext, this.myIdHelperService, theResourceType);
    }

    @Bean(name={"searchTask"})
    @Scope(value="prototype")
    public SearchTask createSearchTask(SearchTaskParameters theParams) {
        return new SearchTask(theParams, this.myHapiTransactionService, this.myContext, this.myInterceptorBroadcaster, this.mySearchBuilderFactory, this.mySearchResultCacheSvc, this.myStorageSettings, this.mySearchCacheSvc, this.myPagingProvider);
    }

    @Bean(name={"continueTask"})
    @Scope(value="prototype")
    public SearchContinuationTask createSearchContinuationTask(SearchTaskParameters theParams) {
        return new SearchContinuationTask(theParams, this.myHapiTransactionService, this.myContext, this.myInterceptorBroadcaster, this.mySearchBuilderFactory, this.mySearchResultCacheSvc, this.myStorageSettings, this.mySearchCacheSvc, this.myPagingProvider, this.exceptionService());
    }
}

