/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config.r4b;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.jpa.api.IDaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.config.GeneratedDaoAndResourceProviderConfigR4B;
import ca.uhn.fhir.jpa.config.JpaConfig;
import ca.uhn.fhir.jpa.config.r4b.FhirContextR4BConfig;
import ca.uhn.fhir.jpa.dao.ITransactionProcessorVersionAdapter;
import ca.uhn.fhir.jpa.dao.r4b.FhirSystemDaoR4B;
import ca.uhn.fhir.jpa.dao.r4b.TransactionProcessorVersionAdapterR4B;
import ca.uhn.fhir.jpa.graphql.GraphQLProvider;
import ca.uhn.fhir.jpa.graphql.GraphQLProviderWithIntrospection;
import ca.uhn.fhir.jpa.provider.JpaSystemProvider;
import ca.uhn.fhir.jpa.term.TermLoaderSvcImpl;
import ca.uhn.fhir.jpa.term.TermVersionAdapterSvcR4B;
import ca.uhn.fhir.jpa.term.api.ITermCodeSystemStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermDeferredStorageSvc;
import ca.uhn.fhir.jpa.term.api.ITermLoaderSvc;
import ca.uhn.fhir.jpa.term.api.ITermVersionAdapterSvc;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import org.hl7.fhir.r4b.model.Bundle;
import org.hl7.fhir.r4b.model.Meta;
import org.hl7.fhir.utilities.graphql.IGraphQLStorageServices;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@Import(value={FhirContextR4BConfig.class, GeneratedDaoAndResourceProviderConfigR4B.class, JpaConfig.class})
public class JpaR4BConfig {
    @Bean
    public ITermVersionAdapterSvc terminologyVersionAdapterSvc() {
        return new TermVersionAdapterSvcR4B();
    }

    @Bean
    public ITransactionProcessorVersionAdapter transactionProcessorVersionFacade() {
        return new TransactionProcessorVersionAdapterR4B();
    }

    @Bean(name={"myGraphQLProvider"})
    @Lazy
    public GraphQLProvider graphQLProvider(FhirContext theFhirContext, IGraphQLStorageServices theGraphqlStorageServices, IValidationSupport theValidationSupport, ISearchParamRegistry theSearchParamRegistry, IDaoRegistry theDaoRegistry) {
        return new GraphQLProviderWithIntrospection(theFhirContext, theValidationSupport, theGraphqlStorageServices, theSearchParamRegistry, theDaoRegistry);
    }

    @Bean(name={"mySystemDaoR4B"})
    public IFhirSystemDao<Bundle, Meta> systemDaoR4() {
        FhirSystemDaoR4B retVal = new FhirSystemDaoR4B();
        return retVal;
    }

    @Bean(name={"mySystemProviderR4B"})
    public JpaSystemProvider<Bundle, Meta> systemProviderR4(FhirContext theFhirContext) {
        JpaSystemProvider<Bundle, Meta> retVal = new JpaSystemProvider<Bundle, Meta>();
        retVal.setContext(theFhirContext);
        retVal.setDao(this.systemDaoR4());
        return retVal;
    }

    @Bean
    public ITermLoaderSvc termLoaderService(ITermDeferredStorageSvc theDeferredStorageSvc, ITermCodeSystemStorageSvc theCodeSystemStorageSvc) {
        return new TermLoaderSvcImpl(theDeferredStorageSvc, theCodeSystemStorageSvc);
    }
}

