/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.config.util;

import ca.uhn.fhir.jpa.config.util.BasicDataSourceConnectionPoolInfoProvider;
import ca.uhn.fhir.jpa.config.util.IConnectionPoolInfoProvider;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.support.ProxyDataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPoolInfoProvider
implements IConnectionPoolInfoProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(ConnectionPoolInfoProvider.class);
    private IConnectionPoolInfoProvider myProvider;

    public ConnectionPoolInfoProvider(DataSource theDataSource) {
        if (theDataSource.getClass().isAssignableFrom(BasicDataSource.class)) {
            this.myProvider = new BasicDataSourceConnectionPoolInfoProvider((BasicDataSource)theDataSource);
            return;
        }
        if (theDataSource.getClass().isAssignableFrom(ProxyDataSource.class)) {
            try {
                boolean basiDataSourceWrapped = theDataSource.isWrapperFor(BasicDataSource.class);
                if (basiDataSourceWrapped) {
                    BasicDataSource basicDataSource = theDataSource.unwrap(BasicDataSource.class);
                    this.myProvider = new BasicDataSourceConnectionPoolInfoProvider(basicDataSource);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public Optional<Integer> getTotalConnectionSize() {
        return this.myProvider == null ? Optional.empty() : this.myProvider.getTotalConnectionSize();
    }

    @Override
    public Optional<Integer> getActiveConnections() {
        return this.myProvider == null ? Optional.empty() : this.myProvider.getActiveConnections();
    }

    @Override
    public Optional<Long> getMaxWaitMillis() {
        return this.myProvider == null ? Optional.empty() : this.myProvider.getMaxWaitMillis();
    }
}

