/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.batch2.api.IJobCoordinator;
import ca.uhn.fhir.batch2.jobs.parameters.UrlPartitioner;
import ca.uhn.fhir.batch2.jobs.reindex.ReindexJobParameters;
import ca.uhn.fhir.batch2.model.JobInstanceStartRequest;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.api.dao.ReindexOutcome;
import ca.uhn.fhir.jpa.api.dao.ReindexParameters;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.api.model.DeleteConflictList;
import ca.uhn.fhir.jpa.api.model.DeleteMethodOutcome;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.jpa.api.model.LazyDaoMethodOutcome;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirDao;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.IFulltextSearchSvc;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.IStorageResourceParser;
import ca.uhn.fhir.jpa.dao.MatchResourceUrlService;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.jpa.dao.index.IdHelperService;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.delete.DeleteConflictUtil;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.cross.IResourceLookup;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.BaseTag;
import ca.uhn.fhir.jpa.model.entity.ForcedId;
import ca.uhn.fhir.jpa.model.entity.IBaseResourceEntity;
import ca.uhn.fhir.jpa.model.entity.PartitionablePartitionId;
import ca.uhn.fhir.jpa.model.entity.ResourceEncodingEnum;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import ca.uhn.fhir.jpa.model.search.SearchRuntimeDetails;
import ca.uhn.fhir.jpa.model.util.JpaConstants;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.search.PersistedJpaBundleProvider;
import ca.uhn.fhir.jpa.search.PersistedJpaBundleProviderFactory;
import ca.uhn.fhir.jpa.search.ResourceSearchUrlSvc;
import ca.uhn.fhir.jpa.search.cache.SearchCacheStatusEnum;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.ResourceSearch;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.util.MemoryCacheService;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.api.StorageResponseCodeEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.InterceptorInvocationTimingEnum;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.ValidationModeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IDeleteExpungeJobSubmitter;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.param.HasParam;
import ca.uhn.fhir.rest.param.HistorySearchDateRangeParam;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IRestfulServerDefaults;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.ReflectionUtil;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.UrlUtil;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IInstanceValidatorModule;
import ca.uhn.fhir.validation.IValidationContext;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.ValidationOptions;
import ca.uhn.fhir.validation.ValidationResult;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class BaseHapiFhirResourceDao<T extends IBaseResource>
extends BaseHapiFhirDao<T>
implements IFhirResourceDao<T> {
    public static final String BASE_RESOURCE_NAME = "resource";
    private static final Logger ourLog = LoggerFactory.getLogger(BaseHapiFhirResourceDao.class);
    @Autowired
    protected IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    protected PlatformTransactionManager myPlatformTransactionManager;
    @Autowired(required=false)
    protected IFulltextSearchSvc mySearchDao;
    @Autowired
    protected HapiTransactionService myTransactionService;
    @Autowired
    private MatchResourceUrlService<JpaPid> myMatchResourceUrlService;
    @Autowired
    private SearchBuilderFactory<JpaPid> mySearchBuilderFactory;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperService;
    @Autowired
    private MatchUrlService myMatchUrlService;
    @Autowired
    private IDeleteExpungeJobSubmitter myDeleteExpungeJobSubmitter;
    @Autowired
    private IJobCoordinator myJobCoordinator;
    private IInstanceValidatorModule myInstanceValidator;
    private String myResourceName;
    private Class<T> myResourceType;
    @Autowired
    private PersistedJpaBundleProviderFactory myPersistedJpaBundleProviderFactory;
    @Autowired
    private MemoryCacheService myMemoryCacheService;
    private TransactionTemplate myTxTemplate;
    @Autowired
    private UrlPartitioner myUrlPartitioner;
    @Autowired
    private ResourceSearchUrlSvc myResourceSearchUrlSvc;
    @Autowired
    private IFhirSystemDao<?, ?> mySystemDao;

    public static <T extends IBaseResource> T invokeStoragePreShowResources(IInterceptorBroadcaster theInterceptorBroadcaster, RequestDetails theRequest, T retVal) {
        if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.STORAGE_PRESHOW_RESOURCES, (IInterceptorBroadcaster)theInterceptorBroadcaster, (RequestDetails)theRequest)) {
            SimplePreResourceShowDetails showDetails = new SimplePreResourceShowDetails(retVal);
            HookParams params = new HookParams().add(IPreResourceShowDetails.class, (Object)showDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)theInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PRESHOW_RESOURCES, (HookParams)params);
            retVal = showDetails.getResource(0);
            return retVal;
        }
        return retVal;
    }

    public static void invokeStoragePreAccessResources(IInterceptorBroadcaster theInterceptorBroadcaster, RequestDetails theRequest, IIdType theId, IBaseResource theResource) {
        if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (IInterceptorBroadcaster)theInterceptorBroadcaster, (RequestDetails)theRequest)) {
            SimplePreResourceAccessDetails accessDetails = new SimplePreResourceAccessDetails(theResource);
            HookParams params = new HookParams().add(IPreResourceAccessDetails.class, (Object)accessDetails).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)theInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PREACCESS_RESOURCES, (HookParams)params);
            if (accessDetails.isDontReturnResourceAtIndex(0)) {
                throw new ResourceNotFoundException(Msg.code((int)1995) + "Resource " + theId + " is not known");
            }
        }
    }

    protected HapiTransactionService getTransactionService() {
        return this.myTransactionService;
    }

    @VisibleForTesting
    public void setTransactionService(HapiTransactionService theTransactionService) {
        this.myTransactionService = theTransactionService;
    }

    protected MatchResourceUrlService getMatchResourceUrlService() {
        return this.myMatchResourceUrlService;
    }

    protected IStorageResourceParser getStorageResourceParser() {
        return this.myJpaStorageResourceParser;
    }

    protected IDeleteExpungeJobSubmitter getDeleteExpungeJobSubmitter() {
        return this.myDeleteExpungeJobSubmitter;
    }

    public DaoMethodOutcome create(T theResource) {
        return this.create(theResource, null, true, null, new TransactionDetails());
    }

    public DaoMethodOutcome create(T theResource, RequestDetails theRequestDetails) {
        return this.create(theResource, null, true, theRequestDetails, new TransactionDetails());
    }

    public DaoMethodOutcome create(T theResource, String theIfNoneExist) {
        return this.create(theResource, theIfNoneExist, null);
    }

    public DaoMethodOutcome create(T theResource, String theIfNoneExist, RequestDetails theRequestDetails) {
        return this.create(theResource, theIfNoneExist, true, theRequestDetails, new TransactionDetails());
    }

    public DaoMethodOutcome create(T theResource, String theIfNoneExist, boolean thePerformIndexing, RequestDetails theRequestDetails, @Nonnull TransactionDetails theTransactionDetails) {
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineCreatePartitionForRequest(theRequestDetails, theResource, this.getResourceName());
        return (DaoMethodOutcome)this.myTransactionService.withRequest(theRequestDetails).withTransactionDetails(theTransactionDetails).withRequestPartitionId(requestPartitionId).execute(tx -> this.doCreateForPost(theResource, theIfNoneExist, thePerformIndexing, theTransactionDetails, theRequestDetails, requestPartitionId));
    }

    @VisibleForTesting
    public void setRequestPartitionHelperService(IRequestPartitionHelperSvc theRequestPartitionHelperService) {
        this.myRequestPartitionHelperService = theRequestPartitionHelperService;
    }

    protected DaoMethodOutcome doCreateForPost(T theResource, String theIfNoneExist, boolean thePerformIndexing, TransactionDetails theTransactionDetails, RequestDetails theRequestDetails, RequestPartitionId theRequestPartitionId) {
        if (theResource == null) {
            String msg = this.getContext().getLocalizer().getMessage(BaseStorageDao.class, "missingBody", new Object[0]);
            throw new InvalidRequestException(Msg.code((int)956) + msg);
        }
        if (StringUtils.isNotBlank((CharSequence)theResource.getIdElement().getIdPart())) {
            if (this.getContext().getVersion().getVersion().isOlderThan(FhirVersionEnum.DSTU3)) {
                String message = this.getMessageSanitized("failedToCreateWithClientAssignedId", theResource.getIdElement().getIdPart());
                throw new InvalidRequestException(Msg.code((int)957) + message, this.createErrorOperationOutcome(message, "processing"));
            }
            theResource.setId("");
        }
        if (this.getStorageSettings().getResourceServerIdStrategy() == JpaStorageSettings.IdStrategyEnum.UUID) {
            theResource.setId(UUID.randomUUID().toString());
            theResource.setUserData(JpaConstants.RESOURCE_ID_SERVER_ASSIGNED, (Object)Boolean.TRUE);
        }
        return this.doCreateForPostOrPut(theRequestDetails, theResource, theIfNoneExist, true, thePerformIndexing, theRequestPartitionId, RestOperationTypeEnum.CREATE, theTransactionDetails);
    }

    private DaoMethodOutcome doCreateForPostOrPut(RequestDetails theRequest, T theResource, String theMatchUrl, boolean theProcessMatchUrl, boolean thePerformIndexing, RequestPartitionId theRequestPartitionId, RestOperationTypeEnum theOperationType, TransactionDetails theTransactionDetails) {
        boolean createForPureNumericIds;
        HookParams hookParams;
        boolean resourceIdWasServerAssigned;
        StopWatch w = new StopWatch();
        this.preProcessResourceForStorage((IBaseResource)theResource);
        this.preProcessResourceForStorage((IBaseResource)theResource, theRequest, theTransactionDetails, thePerformIndexing);
        ResourceTable entity = new ResourceTable();
        entity.setResourceType(this.toResourceName((IBaseResource)theResource));
        entity.setPartitionId(PartitionablePartitionId.toStoragePartition((RequestPartitionId)theRequestPartitionId, (PartitionSettings)this.myPartitionSettings));
        entity.setCreatedByMatchUrl(theMatchUrl);
        entity.initializeVersion();
        if (StringUtils.isNotBlank((CharSequence)theMatchUrl) && theProcessMatchUrl) {
            Set match = this.myMatchResourceUrlService.processMatchUrl(theMatchUrl, this.myResourceType, theTransactionDetails, theRequest);
            if (match.size() > 1) {
                String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "transactionOperationWithMultipleMatchFailure", new Object[]{"CREATE", theMatchUrl, match.size()});
                throw new PreconditionFailedException(Msg.code((int)958) + msg);
            }
            if (match.size() == 1) {
                JpaPid pid = (JpaPid)match.iterator().next();
                if (theTransactionDetails.getDeletedResourceIds().contains(pid)) {
                    this.myMatchResourceUrlService.unresolveMatchUrl(theTransactionDetails, this.getResourceName(), theMatchUrl);
                } else {
                    Supplier<LazyDaoMethodOutcome.EntityAndResource> entitySupplier = () -> (LazyDaoMethodOutcome.EntityAndResource)this.myTxTemplate.execute(tx -> {
                        ResourceTable foundEntity = (ResourceTable)this.myEntityManager.find(ResourceTable.class, (Object)pid.getId());
                        IBaseResource resource = this.myJpaStorageResourceParser.toResource((IBasePersistedResource)foundEntity, false);
                        theResource.setId(resource.getIdElement().getValue());
                        return new LazyDaoMethodOutcome.EntityAndResource((IBasePersistedResource)foundEntity, resource);
                    });
                    Supplier<IIdType> idSupplier = () -> (IIdType)this.myTxTemplate.execute(tx -> {
                        IIdType retVal = this.myIdHelperService.translatePidIdToForcedId(this.myFhirContext, this.myResourceName, (IResourcePersistentId)pid);
                        if (!retVal.hasVersionIdPart()) {
                            Long version = (Long)this.myMemoryCacheService.getIfPresent(MemoryCacheService.CacheEnum.RESOURCE_CONDITIONAL_CREATE_VERSION, (Object)pid.getId());
                            if (version == null && (version = this.myResourceTableDao.findCurrentVersionByPid(pid.getId())) != null) {
                                this.myMemoryCacheService.putAfterCommit(MemoryCacheService.CacheEnum.RESOURCE_CONDITIONAL_CREATE_VERSION, (Object)pid.getId(), (Object)version);
                            }
                            if (version != null) {
                                retVal = this.myFhirContext.getVersion().newIdType().setParts(retVal.getBaseUrl(), retVal.getResourceType(), retVal.getIdPart(), Long.toString(version));
                            }
                        }
                        return retVal;
                    });
                    DaoMethodOutcome outcome = this.toMethodOutcomeLazy(theRequest, (IResourcePersistentId)pid, entitySupplier, idSupplier).setCreated(Boolean.valueOf(false)).setNop(true);
                    StorageResponseCodeEnum responseCode = StorageResponseCodeEnum.SUCCESSFUL_CREATE_WITH_CONDITIONAL_MATCH;
                    String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulCreateConditionalWithMatch", new Object[]{w.getMillisAndRestart(), UrlUtil.sanitizeUrlPart((CharSequence)theMatchUrl)});
                    outcome.setOperationOutcome(this.createInfoOperationOutcome(msg, responseCode));
                    return outcome;
                }
            }
        }
        String resourceIdBeforeStorage = theResource.getIdElement().getIdPart();
        boolean resourceHadIdBeforeStorage = StringUtils.isNotBlank((CharSequence)resourceIdBeforeStorage);
        boolean bl = resourceIdWasServerAssigned = theResource.getUserData(JpaConstants.RESOURCE_ID_SERVER_ASSIGNED) == Boolean.TRUE;
        if (resourceHadIdBeforeStorage) {
            entity.setFhirId(resourceIdBeforeStorage);
        }
        if (!resourceIdWasServerAssigned && resourceHadIdBeforeStorage) {
            hookParams = new HookParams().add(IBaseResource.class, theResource).add(RequestDetails.class, (Object)theRequest);
            this.doCallHooks(theTransactionDetails, theRequest, Pointcut.STORAGE_PRESTORAGE_CLIENT_ASSIGNED_ID, hookParams);
        }
        hookParams = new HookParams().add(IBaseResource.class, theResource).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(RequestPartitionId.class, (Object)theRequestPartitionId).add(TransactionDetails.class, (Object)theTransactionDetails);
        this.doCallHooks(theTransactionDetails, theRequest, Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED, hookParams);
        if (resourceHadIdBeforeStorage && !resourceIdWasServerAssigned) {
            this.validateResourceIdCreation(theResource, theRequest);
        }
        if (theMatchUrl != null) {
            entity.setSearchUrlPresent(true);
        }
        ResourceTable updatedEntity = this.updateEntity(theRequest, (IBaseResource)theResource, (IBasePersistedResource)entity, null, thePerformIndexing, false, theTransactionDetails, false, thePerformIndexing);
        JpaPid jpaPid = JpaPid.fromId((Long)updatedEntity.getResourceId());
        if (resourceHadIdBeforeStorage) {
            if (resourceIdWasServerAssigned) {
                createForPureNumericIds = true;
                this.createForcedIdIfNeeded(entity, resourceIdBeforeStorage, createForPureNumericIds);
            } else {
                createForPureNumericIds = this.getStorageSettings().getResourceClientIdStrategy() != JpaStorageSettings.ClientIdStrategyEnum.ALPHANUMERIC;
                this.createForcedIdIfNeeded(entity, resourceIdBeforeStorage, createForPureNumericIds);
            }
        } else {
            switch (this.getStorageSettings().getResourceClientIdStrategy()) {
                case NOT_ALLOWED: 
                case ALPHANUMERIC: {
                    break;
                }
                case ANY: {
                    createForPureNumericIds = true;
                    this.createForcedIdIfNeeded(updatedEntity, theResource.getIdElement().getIdPart(), createForPureNumericIds);
                    assert (updatedEntity.getTransientForcedId() != null);
                    break;
                }
            }
        }
        theResource.setId((IIdType)entity.getIdDt());
        jpaPid.setAssociatedResourceId(entity.getIdType(this.myFhirContext));
        this.myIdHelperService.addResolvedPidToForcedId((IResourcePersistentId)jpaPid, theRequestPartitionId, this.getResourceName(), entity.getTransientForcedId(), null);
        theTransactionDetails.addResolvedResourceId(jpaPid.getAssociatedResourceId(), (IResourcePersistentId)jpaPid);
        theTransactionDetails.addResolvedResource(jpaPid.getAssociatedResourceId(), theResource);
        if (theMatchUrl != null) {
            this.myResourceSearchUrlSvc.enforceMatchUrlResourceUniqueness(this.getResourceName(), theMatchUrl, jpaPid);
            this.myMatchResourceUrlService.matchUrlResolved(theTransactionDetails, this.getResourceName(), theMatchUrl, (IResourcePersistentId)jpaPid);
        }
        this.myJpaStorageResourceParser.updateResourceMetadata((IBaseResourceEntity)entity, (IBaseResource)theResource);
        this.addPidToResource((IResourceLookup<JpaPid>)entity, (IBaseResource)theResource);
        if (!updatedEntity.isUnchangedInCurrentOperation()) {
            hookParams = new HookParams().add(IBaseResource.class, theResource).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(TransactionDetails.class, (Object)theTransactionDetails).add(InterceptorInvocationTimingEnum.class, (Object)theTransactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED));
            this.doCallHooks(theTransactionDetails, theRequest, Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED, hookParams);
        }
        DaoMethodOutcome outcome = this.toMethodOutcome(theRequest, (IBasePersistedResource)entity, (IBaseResource)theResource, theMatchUrl, theOperationType).setCreated(Boolean.valueOf(true));
        if (!thePerformIndexing) {
            outcome.setId(theResource.getIdElement());
        }
        this.populateOperationOutcomeForUpdate(w, outcome, theMatchUrl, theOperationType);
        return outcome;
    }

    private void createForcedIdIfNeeded(ResourceTable theEntity, String theResourceId, boolean theCreateForPureNumericIds) {
        if (StringUtils.isNotBlank((CharSequence)theResourceId) && theEntity.getForcedId() == null && (theCreateForPureNumericIds || !IdHelperService.isValidPid(theResourceId))) {
            ForcedId forcedId = new ForcedId();
            forcedId.setResourceType(theEntity.getResourceType());
            forcedId.setForcedId(theResourceId);
            forcedId.setResource(theEntity);
            forcedId.setPartitionId(theEntity.getPartitionId());
            theEntity.setTransientForcedId(forcedId.getForcedId());
            this.myForcedIdDao.save(forcedId);
        }
    }

    void validateResourceIdCreation(T theResource, RequestDetails theRequest) {
        JpaStorageSettings.ClientIdStrategyEnum strategy = this.getStorageSettings().getResourceClientIdStrategy();
        if (strategy == JpaStorageSettings.ClientIdStrategyEnum.NOT_ALLOWED && !this.isSystemRequest(theRequest)) {
            throw new ResourceNotFoundException(Msg.code((int)959) + this.getMessageSanitized("failedToCreateWithClientAssignedIdNotAllowed", theResource.getIdElement().getIdPart()));
        }
        if (strategy == JpaStorageSettings.ClientIdStrategyEnum.ALPHANUMERIC && theResource.getIdElement().isIdPartValidLong()) {
            throw new InvalidRequestException(Msg.code((int)960) + this.getMessageSanitized("failedToCreateWithClientAssignedNumericId", theResource.getIdElement().getIdPart()));
        }
    }

    protected String getMessageSanitized(String theKey, String theIdPart) {
        return this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, theKey, new Object[]{theIdPart});
    }

    private boolean isSystemRequest(RequestDetails theRequest) {
        return theRequest instanceof SystemRequestDetails;
    }

    private IInstanceValidatorModule getInstanceValidator() {
        return this.myInstanceValidator;
    }

    public DaoMethodOutcome delete(IIdType theId) {
        return this.delete(theId, null);
    }

    public DaoMethodOutcome delete(IIdType theId, RequestDetails theRequestDetails) {
        TransactionDetails transactionDetails = new TransactionDetails();
        this.validateIdPresentForDelete(theId);
        this.validateDeleteEnabled();
        return (DaoMethodOutcome)this.myTransactionService.execute(theRequestDetails, transactionDetails, tx -> {
            DeleteConflictList deleteConflicts = new DeleteConflictList();
            if (StringUtils.isNotBlank((CharSequence)theId.getValue())) {
                deleteConflicts.setResourceIdMarkedForDeletion(theId);
            }
            StopWatch w = new StopWatch();
            DaoMethodOutcome retVal = this.delete(theId, deleteConflicts, theRequestDetails, transactionDetails);
            DeleteConflictUtil.validateDeleteConflictsEmptyOrThrowException((FhirContext)this.getContext(), (DeleteConflictList)deleteConflicts);
            ourLog.debug("Processed delete on {} in {}ms", (Object)theId.getValue(), (Object)w.getMillisAndRestart());
            return retVal;
        });
    }

    public DaoMethodOutcome delete(IIdType theId, DeleteConflictList theDeleteConflicts, RequestDetails theRequestDetails, @Nonnull TransactionDetails theTransactionDetails) {
        ResourceTable entity;
        this.validateIdPresentForDelete(theId);
        this.validateDeleteEnabled();
        try {
            entity = this.readEntityLatestVersion(theId, theRequestDetails, theTransactionDetails);
        }
        catch (ResourceNotFoundException ex) {
            return this.createMethodOutcomeForResourceId(theId.getValue(), "deleteResourceNotExisting", StorageResponseCodeEnum.SUCCESSFUL_DELETE_NOT_FOUND);
        }
        if (theId.hasVersionIdPart() && Long.parseLong(theId.getVersionIdPart()) != entity.getVersion()) {
            throw new ResourceVersionConflictException(Msg.code((int)961) + "Trying to delete " + theId + " but this is not the current version");
        }
        JpaPid persistentId = JpaPid.fromId((Long)entity.getResourceId());
        theTransactionDetails.addDeletedResourceId((IResourcePersistentId)persistentId);
        if (this.isDeleted((BaseHasResource)entity)) {
            DaoMethodOutcome outcome = this.createMethodOutcomeForResourceId(entity.getIdDt().getValue(), "deleteResourceAlreadyDeleted", StorageResponseCodeEnum.SUCCESSFUL_DELETE_ALREADY_DELETED);
            outcome.setPersistentId((IResourcePersistentId)persistentId);
            outcome.setEntity((IBasePersistedResource)entity);
            return outcome;
        }
        StopWatch w = new StopWatch();
        T resourceToDelete = this.myJpaStorageResourceParser.toResource(this.myResourceType, (IBaseResourceEntity)entity, null, false);
        theDeleteConflicts.setResourceIdMarkedForDeletion(theId);
        HookParams hook = new HookParams().add(IBaseResource.class, resourceToDelete).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)theTransactionDetails);
        this.doCallHooks(theTransactionDetails, theRequestDetails, Pointcut.STORAGE_PRESTORAGE_RESOURCE_DELETED, hook);
        this.myDeleteConflictService.validateOkToDelete(theDeleteConflicts, entity, false, theRequestDetails, theTransactionDetails);
        this.preDelete(resourceToDelete, entity, theRequestDetails);
        ResourceTable savedEntity = this.updateEntityForDelete(theRequestDetails, theTransactionDetails, entity);
        resourceToDelete.setId((IIdType)entity.getIdDt());
        HookParams hookParams = new HookParams().add(IBaseResource.class, resourceToDelete).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)theTransactionDetails).add(InterceptorInvocationTimingEnum.class, (Object)theTransactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_DELETED));
        this.doCallHooks(theTransactionDetails, theRequestDetails, Pointcut.STORAGE_PRECOMMIT_RESOURCE_DELETED, hookParams);
        DaoMethodOutcome outcome = this.toMethodOutcome(theRequestDetails, (IBasePersistedResource)savedEntity, (IBaseResource)resourceToDelete, null, RestOperationTypeEnum.DELETE).setCreated(Boolean.valueOf(true));
        Object msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulDeletes", new Object[]{1});
        msg = (String)msg + " " + this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulTimingSuffix", new Object[]{w.getMillis()});
        outcome.setOperationOutcome(this.createInfoOperationOutcome((String)msg, StorageResponseCodeEnum.SUCCESSFUL_DELETE));
        return outcome;
    }

    public DeleteMethodOutcome deleteByUrl(String theUrl, RequestDetails theRequest) {
        this.validateDeleteEnabled();
        TransactionDetails transactionDetails = new TransactionDetails();
        ResourceSearch resourceSearch = this.myMatchUrlService.getResourceSearch(theUrl);
        if (resourceSearch.isDeleteExpunge()) {
            return this.deleteExpunge(theUrl, theRequest);
        }
        return (DeleteMethodOutcome)this.myTransactionService.execute(theRequest, transactionDetails, tx -> {
            DeleteConflictList deleteConflicts = new DeleteConflictList();
            DeleteMethodOutcome outcome = this.deleteByUrl(theUrl, deleteConflicts, theRequest, transactionDetails);
            DeleteConflictUtil.validateDeleteConflictsEmptyOrThrowException((FhirContext)this.getContext(), (DeleteConflictList)deleteConflicts);
            return outcome;
        });
    }

    public DeleteMethodOutcome deleteByUrl(String theUrl, DeleteConflictList deleteConflicts, RequestDetails theRequestDetails, @Nonnull TransactionDetails theTransactionDetails) {
        this.validateDeleteEnabled();
        return (DeleteMethodOutcome)this.myTransactionService.execute(theRequestDetails, theTransactionDetails, tx -> this.doDeleteByUrl(theUrl, deleteConflicts, theTransactionDetails, theRequestDetails));
    }

    @Nonnull
    private DeleteMethodOutcome doDeleteByUrl(String theUrl, DeleteConflictList deleteConflicts, TransactionDetails theTransactionDetails, RequestDetails theRequestDetails) {
        ResourceSearch resourceSearch = this.myMatchUrlService.getResourceSearch(theUrl);
        SearchParameterMap paramMap = resourceSearch.getSearchParameterMap();
        paramMap.setLoadSynchronous(true);
        Set resourceIds = this.myMatchResourceUrlService.search(paramMap, this.myResourceType, theRequestDetails, null);
        if (resourceIds.size() > 1 && !this.getStorageSettings().isAllowMultipleDelete()) {
            throw new PreconditionFailedException(Msg.code((int)962) + this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "transactionOperationWithMultipleMatchFailure", new Object[]{"DELETE", theUrl, resourceIds.size()}));
        }
        return this.deletePidList(theUrl, resourceIds, deleteConflicts, theRequestDetails, theTransactionDetails);
    }

    public <P extends IResourcePersistentId> void expunge(Collection<P> theResourceIds, RequestDetails theRequest) {
        ExpungeOptions options = new ExpungeOptions();
        options.setExpungeDeletedResources(true);
        for (IResourcePersistentId pid : theResourceIds) {
            if (pid instanceof JpaPid) {
                ResourceTable entity = (ResourceTable)this.myEntityManager.find(ResourceTable.class, pid.getId());
                this.forceExpungeInExistingTransaction((IIdType)entity.getIdDt().toVersionless(), options, theRequest);
                continue;
            }
            ourLog.warn("Unable to process expunge on resource {}", (Object)pid);
            return;
        }
    }

    @Nonnull
    public <P extends IResourcePersistentId> DeleteMethodOutcome deletePidList(String theUrl, Collection<P> theResourceIds, DeleteConflictList theDeleteConflicts, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        IBaseOperationOutcome oo;
        Object msg;
        StopWatch w = new StopWatch();
        TransactionDetails transactionDetails = new TransactionDetails();
        ArrayList<ResourceTable> deletedResources = new ArrayList<ResourceTable>();
        List resolvedIds = theResourceIds.stream().map(t -> t).collect(Collectors.toList());
        this.mySystemDao.preFetchResources(resolvedIds, false);
        for (IResourcePersistentId pid : theResourceIds) {
            JpaPid jpaPid = (JpaPid)pid;
            ResourceTable entity = (ResourceTable)this.myEntityManager.find(ResourceTable.class, (Object)jpaPid.getId());
            deletedResources.add(entity);
            T resourceToDelete = this.myJpaStorageResourceParser.toResource(this.myResourceType, (IBaseResourceEntity)entity, null, false);
            HookParams hooks = new HookParams().add(IBaseResource.class, resourceToDelete).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)transactionDetails);
            this.doCallHooks(transactionDetails, theRequestDetails, Pointcut.STORAGE_PRESTORAGE_RESOURCE_DELETED, hooks);
            this.myDeleteConflictService.validateOkToDelete(theDeleteConflicts, entity, false, theRequestDetails, transactionDetails);
            this.preDelete(resourceToDelete, entity, theRequestDetails);
            this.updateEntityForDelete(theRequestDetails, transactionDetails, entity);
            resourceToDelete.setId((IIdType)entity.getIdDt());
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){
                final /* synthetic */ IBaseResource val$resourceToDelete;
                final /* synthetic */ RequestDetails val$theRequestDetails;
                final /* synthetic */ TransactionDetails val$transactionDetails;
                {
                    this.val$resourceToDelete = iBaseResource;
                    this.val$theRequestDetails = requestDetails;
                    this.val$transactionDetails = transactionDetails;
                }

                public void beforeCommit(boolean readOnly) {
                    HookParams hookParams = new HookParams().add(IBaseResource.class, (Object)this.val$resourceToDelete).add(RequestDetails.class, (Object)this.val$theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)this.val$theRequestDetails).add(TransactionDetails.class, (Object)this.val$transactionDetails).add(InterceptorInvocationTimingEnum.class, (Object)this.val$transactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_DELETED));
                    BaseHapiFhirResourceDao.this.doCallHooks(this.val$transactionDetails, this.val$theRequestDetails, Pointcut.STORAGE_PRECOMMIT_RESOURCE_DELETED, hookParams);
                }
            });
        }
        if (deletedResources.isEmpty()) {
            msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "unableToDeleteNotFound", new Object[]{theUrl});
            oo = this.createOperationOutcome("warning", (String)msg, "not-found", StorageResponseCodeEnum.SUCCESSFUL_DELETE_NOT_FOUND);
        } else {
            msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulDeletes", new Object[]{deletedResources.size()});
            msg = (String)msg + " " + this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "successfulTimingSuffix", new Object[]{w.getMillis()});
            oo = this.createInfoOperationOutcome((String)msg, StorageResponseCodeEnum.SUCCESSFUL_DELETE);
        }
        ourLog.debug("Processed delete on {} (matched {} resource(s)) in {}ms", new Object[]{theUrl, deletedResources.size(), w.getMillis()});
        theTransactionDetails.addDeletedResourceIds(theResourceIds);
        DeleteMethodOutcome retVal = new DeleteMethodOutcome();
        retVal.setDeletedEntities(deletedResources);
        retVal.setOperationOutcome(oo);
        return retVal;
    }

    protected ResourceTable updateEntityForDelete(RequestDetails theRequest, TransactionDetails theTransactionDetails, ResourceTable theEntity) {
        this.myResourceSearchUrlSvc.deleteByResId(theEntity.getId());
        Date updateTime = new Date();
        return this.updateEntity(theRequest, null, (IBasePersistedResource)theEntity, updateTime, true, true, theTransactionDetails, false, true);
    }

    private void validateDeleteEnabled() {
        if (!this.getStorageSettings().isDeleteEnabled()) {
            String msg = this.getContext().getLocalizer().getMessage(BaseStorageDao.class, "deleteBlockedBecauseDisabled", new Object[0]);
            throw new PreconditionFailedException(Msg.code((int)966) + msg);
        }
    }

    private void validateIdPresentForDelete(IIdType theId) {
        if (theId == null || !theId.hasIdPart()) {
            throw new InvalidRequestException(Msg.code((int)967) + "Can not perform delete, no ID provided");
        }
    }

    private <MT extends IBaseMetaType> void doMetaAdd(MT theMetaAdd, BaseHasResource theEntity, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        IBaseResource oldVersion = this.myJpaStorageResourceParser.toResource((IBasePersistedResource)theEntity, false);
        ArrayList<TagDefinition> tags = this.toTagList(theMetaAdd);
        for (TagDefinition nextDef : tags) {
            BaseTag newEntity;
            boolean hasTag = false;
            for (BaseTag next : new ArrayList(theEntity.getTags())) {
                if (!Objects.equals(next.getTag().getTagType(), nextDef.getTagType()) || !Objects.equals(next.getTag().getSystem(), nextDef.getSystem()) || !Objects.equals(next.getTag().getCode(), nextDef.getCode()) || !Objects.equals(next.getTag().getVersion(), nextDef.getVersion()) || !Objects.equals(next.getTag().getUserSelected(), nextDef.getUserSelected())) continue;
                hasTag = true;
                break;
            }
            if (hasTag) continue;
            theEntity.setHasTags(true);
            TagDefinition def = this.getTagOrNull(theTransactionDetails, nextDef.getTagType(), nextDef.getSystem(), nextDef.getCode(), nextDef.getDisplay(), nextDef.getVersion(), nextDef.getUserSelected());
            if (def == null || (newEntity = theEntity.addTag(def)).getTagId() != null) continue;
            this.myEntityManager.persist((Object)newEntity);
        }
        this.validateMetaCount(theEntity.getTags().size());
        this.myEntityManager.merge((Object)theEntity);
        IBaseResource newVersion = this.myJpaStorageResourceParser.toResource((IBasePersistedResource)theEntity, false);
        HookParams preStorageParams = new HookParams().add(IBaseResource.class, (Object)oldVersion).add(IBaseResource.class, (Object)newVersion).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)theTransactionDetails);
        this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED, preStorageParams);
        HookParams preCommitParams = new HookParams().add(IBaseResource.class, (Object)oldVersion).add(IBaseResource.class, (Object)newVersion).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)theTransactionDetails).add(InterceptorInvocationTimingEnum.class, (Object)theTransactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED));
        this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED, preCommitParams);
    }

    private <MT extends IBaseMetaType> void doMetaDelete(MT theMetaDel, BaseHasResource theEntity, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        IBaseResource oldVersion = this.myJpaStorageResourceParser.toResource((IBasePersistedResource)theEntity, false);
        ArrayList<TagDefinition> tags = this.toTagList(theMetaDel);
        for (TagDefinition nextDef : tags) {
            for (BaseTag next : new ArrayList(theEntity.getTags())) {
                if (!Objects.equals(next.getTag().getTagType(), nextDef.getTagType()) || !Objects.equals(next.getTag().getSystem(), nextDef.getSystem()) || !Objects.equals(next.getTag().getCode(), nextDef.getCode())) continue;
                this.myEntityManager.remove((Object)next);
                theEntity.getTags().remove(next);
            }
        }
        if (theEntity.getTags().isEmpty()) {
            theEntity.setHasTags(false);
        }
        theEntity = (BaseHasResource)this.myEntityManager.merge((Object)theEntity);
        IBaseResource newVersion = this.myJpaStorageResourceParser.toResource((IBasePersistedResource)theEntity, false);
        HookParams preStorageParams = new HookParams().add(IBaseResource.class, (Object)oldVersion).add(IBaseResource.class, (Object)newVersion).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)theTransactionDetails);
        this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED, preStorageParams);
        HookParams preCommitParams = new HookParams().add(IBaseResource.class, (Object)oldVersion).add(IBaseResource.class, (Object)newVersion).add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(TransactionDetails.class, (Object)theTransactionDetails).add(InterceptorInvocationTimingEnum.class, (Object)theTransactionDetails.getInvocationTiming(Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED));
        this.myInterceptorBroadcaster.callHooks((IPointcut)Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED, preCommitParams);
    }

    @Transactional(propagation=Propagation.NEVER)
    public ExpungeOutcome expunge(IIdType theId, ExpungeOptions theExpungeOptions, RequestDetails theRequest) {
        this.validateExpungeEnabled();
        return this.forceExpungeInExistingTransaction(theId, theExpungeOptions, theRequest);
    }

    @Transactional(propagation=Propagation.NEVER)
    public ExpungeOutcome expunge(ExpungeOptions theExpungeOptions, RequestDetails theRequestDetails) {
        ourLog.info("Beginning TYPE[{}] expunge operation", (Object)this.getResourceName());
        this.validateExpungeEnabled();
        return this.myExpungeService.expunge(this.getResourceName(), null, theExpungeOptions, theRequestDetails);
    }

    private void validateExpungeEnabled() {
        if (!this.getStorageSettings().isExpungeEnabled()) {
            throw new MethodNotAllowedException(Msg.code((int)968) + "$expunge is not enabled on this server");
        }
    }

    public ExpungeOutcome forceExpungeInExistingTransaction(IIdType theId, ExpungeOptions theExpungeOptions, RequestDetails theRequest) {
        TransactionTemplate txTemplate = new TransactionTemplate(this.myPlatformTransactionManager);
        BaseHasResource entity = (BaseHasResource)txTemplate.execute(t -> this.readEntity(theId, theRequest));
        Validate.notNull((Object)entity, (String)"Resource with ID %s not found in database", (Object[])new Object[]{theId});
        if (theId.hasVersionIdPart()) {
            BaseHasResource currentVersion = (BaseHasResource)txTemplate.execute(t -> this.readEntity(theId.toVersionless(), theRequest));
            Validate.notNull((Object)currentVersion, (String)"Current version of resource with ID %s not found in database", (Object[])new Object[]{theId.toVersionless()});
            if (entity.getVersion() == currentVersion.getVersion()) {
                throw new PreconditionFailedException(Msg.code((int)969) + "Can not perform version-specific expunge of resource " + theId.toUnqualified().getValue() + " as this is the current version");
            }
            return this.myExpungeService.expunge(this.getResourceName(), (IResourcePersistentId)JpaPid.fromIdAndVersion((Long)entity.getResourceId(), (Long)entity.getVersion()), theExpungeOptions, theRequest);
        }
        return this.myExpungeService.expunge(this.getResourceName(), (IResourcePersistentId)JpaPid.fromId((Long)entity.getResourceId()), theExpungeOptions, theRequest);
    }

    @Nonnull
    public String getResourceName() {
        return this.myResourceName;
    }

    public Class<T> getResourceType() {
        return this.myResourceType;
    }

    @Required
    public void setResourceType(Class<? extends IBaseResource> theTableType) {
        this.myResourceType = theTableType;
    }

    public IBundleProvider history(Date theSince, Date theUntil, Integer theOffset, RequestDetails theRequestDetails) {
        StopWatch w = new StopWatch();
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forHistory((String)this.myResourceName, null);
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequest(theRequestDetails, details);
        IBundleProvider retVal = (IBundleProvider)this.myTransactionService.withRequest(theRequestDetails).withRequestPartitionId(requestPartitionId).execute(() -> this.myPersistedJpaBundleProviderFactory.history(theRequestDetails, this.myResourceName, null, theSince, theUntil, theOffset, requestPartitionId));
        ourLog.debug("Processed history on {} in {}ms", (Object)this.myResourceName, (Object)w.getMillisAndRestart());
        return retVal;
    }

    public IBundleProvider history(IIdType theId, Date theSince, Date theUntil, Integer theOffset, RequestDetails theRequest) {
        StopWatch w = new StopWatch();
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forHistory((String)this.myResourceName, (IIdType)theId);
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequest(theRequest, details);
        IBundleProvider retVal = (IBundleProvider)this.myTransactionService.withRequest(theRequest).withRequestPartitionId(requestPartitionId).execute(() -> {
            IIdType id = theId.withResourceType(this.myResourceName).toUnqualifiedVersionless();
            BaseHasResource entity = this.readEntity(id, true, theRequest, requestPartitionId);
            return this.myPersistedJpaBundleProviderFactory.history(theRequest, this.myResourceName, entity.getId(), theSince, theUntil, theOffset, requestPartitionId);
        });
        ourLog.debug("Processed history on {} in {}ms", (Object)theId, (Object)w.getMillisAndRestart());
        return retVal;
    }

    public IBundleProvider history(IIdType theId, HistorySearchDateRangeParam theHistorySearchDateRangeParam, RequestDetails theRequest) {
        StopWatch w = new StopWatch();
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forHistory((String)this.myResourceName, (IIdType)theId);
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequest(theRequest, details);
        IBundleProvider retVal = (IBundleProvider)this.myTransactionService.withRequest(theRequest).withRequestPartitionId(requestPartitionId).execute(() -> {
            IIdType id = theId.withResourceType(this.myResourceName).toUnqualifiedVersionless();
            BaseHasResource entity = this.readEntity(id, true, theRequest, requestPartitionId);
            return this.myPersistedJpaBundleProviderFactory.history(theRequest, this.myResourceName, entity.getId(), theHistorySearchDateRangeParam.getLowerBoundAsInstant(), theHistorySearchDateRangeParam.getUpperBoundAsInstant(), theHistorySearchDateRangeParam.getOffset(), theHistorySearchDateRangeParam.getHistorySearchType(), requestPartitionId);
        });
        ourLog.debug("Processed history on {} in {}ms", (Object)theId, (Object)w.getMillisAndRestart());
        return retVal;
    }

    protected boolean isPagingProviderDatabaseBacked(RequestDetails theRequestDetails) {
        if (theRequestDetails == null || theRequestDetails.getServer() == null) {
            return false;
        }
        IRestfulServerDefaults server = theRequestDetails.getServer();
        IPagingProvider pagingProvider = server.getPagingProvider();
        return pagingProvider != null;
    }

    protected void requestReindexForRelatedResources(Boolean theCurrentlyReindexing, List<String> theBase, RequestDetails theRequestDetails) {
        if (Boolean.TRUE.equals(theCurrentlyReindexing) || this.shouldSkipReindex(theRequestDetails)) {
            return;
        }
        if (this.getStorageSettings().isMarkResourcesForReindexingUponSearchParameterChange()) {
            ReindexJobParameters params = new ReindexJobParameters();
            if (!this.isCommonSearchParam(theBase)) {
                this.addAllResourcesTypesToReindex(theBase, theRequestDetails, params);
            }
            ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forOperation(null, null, (String)"$reindex");
            RequestPartitionId requestPartition = this.myRequestPartitionHelperService.determineReadPartitionForRequest(theRequestDetails, details);
            params.setRequestPartitionId(requestPartition);
            JobInstanceStartRequest request = new JobInstanceStartRequest();
            request.setJobDefinitionId("REINDEX");
            request.setParameters((IModelJson)params);
            this.myJobCoordinator.startInstance(theRequestDetails, request);
            ourLog.debug("Started reindex job with parameters {}", (Object)params);
        }
        this.mySearchParamRegistry.requestRefresh();
    }

    protected final boolean shouldSkipReindex(RequestDetails theRequestDetails) {
        if (theRequestDetails == null) {
            return false;
        }
        Boolean shouldSkip = theRequestDetails.getUserData().getOrDefault("SKIP-REINDEX-ON-UPDATE", false);
        return Boolean.parseBoolean(((Object)shouldSkip).toString());
    }

    private void addAllResourcesTypesToReindex(List<String> theBase, RequestDetails theRequestDetails, ReindexJobParameters params) {
        theBase.stream().map(t -> t + "?").map(url -> this.myUrlPartitioner.partitionUrl(url, theRequestDetails)).forEach(arg_0 -> ((ReindexJobParameters)params).addPartitionedUrl(arg_0));
    }

    private boolean isCommonSearchParam(List<String> theBase) {
        return theBase.stream().map(String::toLowerCase).anyMatch(BASE_RESOURCE_NAME::equals);
    }

    @Transactional
    public <MT extends IBaseMetaType> MT metaAddOperation(IIdType theResourceId, MT theMetaAdd, RequestDetails theRequest) {
        TransactionDetails transactionDetails = new TransactionDetails();
        StopWatch w = new StopWatch();
        BaseHasResource entity = this.readEntity(theResourceId, theRequest);
        if (entity == null) {
            throw new ResourceNotFoundException(Msg.code((int)1993) + theResourceId);
        }
        ResourceTable latestVersion = this.readEntityLatestVersion(theResourceId, theRequest, transactionDetails);
        if (latestVersion.getVersion() != entity.getVersion()) {
            this.doMetaAdd(theMetaAdd, entity, theRequest, transactionDetails);
        } else {
            this.doMetaAdd(theMetaAdd, (BaseHasResource)latestVersion, theRequest, transactionDetails);
            ResourceHistoryTable history = this.myResourceHistoryTableDao.findForIdAndVersionAndFetchProvenance(entity.getId(), entity.getVersion());
            this.doMetaAdd(theMetaAdd, (BaseHasResource)history, theRequest, transactionDetails);
        }
        ourLog.debug("Processed metaAddOperation on {} in {}ms", (Object)theResourceId, (Object)w.getMillisAndRestart());
        Object retVal = this.metaGetOperation(theMetaAdd.getClass(), theResourceId, theRequest);
        return (MT)retVal;
    }

    @Transactional
    public <MT extends IBaseMetaType> MT metaDeleteOperation(IIdType theResourceId, MT theMetaDel, RequestDetails theRequest) {
        boolean nonVersionedTags;
        TransactionDetails transactionDetails = new TransactionDetails();
        StopWatch w = new StopWatch();
        BaseHasResource entity = this.readEntity(theResourceId, theRequest);
        if (entity == null) {
            throw new ResourceNotFoundException(Msg.code((int)1994) + theResourceId);
        }
        ResourceTable latestVersion = this.readEntityLatestVersion(theResourceId, theRequest, transactionDetails);
        boolean bl = nonVersionedTags = this.myStorageSettings.getTagStorageMode() != JpaStorageSettings.TagStorageModeEnum.VERSIONED;
        if (latestVersion.getVersion() != entity.getVersion() || nonVersionedTags) {
            this.doMetaDelete(theMetaDel, entity, theRequest, transactionDetails);
        } else {
            this.doMetaDelete(theMetaDel, (BaseHasResource)latestVersion, theRequest, transactionDetails);
            ResourceHistoryTable history = this.myResourceHistoryTableDao.findForIdAndVersionAndFetchProvenance(entity.getId(), entity.getVersion());
            this.doMetaDelete(theMetaDel, (BaseHasResource)history, theRequest, transactionDetails);
        }
        ourLog.debug("Processed metaDeleteOperation on {} in {}ms", (Object)theResourceId.getValue(), (Object)w.getMillisAndRestart());
        Object retVal = this.metaGetOperation(theMetaDel.getClass(), theResourceId, theRequest);
        return (MT)retVal;
    }

    @Transactional
    public <MT extends IBaseMetaType> MT metaGetOperation(Class<MT> theType, IIdType theId, RequestDetails theRequest) {
        HashSet<TagDefinition> tagDefs = new HashSet<TagDefinition>();
        BaseHasResource entity = this.readEntity(theId, theRequest);
        for (BaseTag next : entity.getTags()) {
            tagDefs.add(next.getTag());
        }
        MT retVal = this.toMetaDt(theType, tagDefs);
        retVal.setLastUpdated(entity.getUpdatedDate());
        retVal.setVersionId(Long.toString(entity.getVersion()));
        return retVal;
    }

    @Transactional
    public <MT extends IBaseMetaType> MT metaGetOperation(Class<MT> theType, RequestDetails theRequestDetails) {
        String sql = "SELECT d FROM TagDefinition d WHERE d.myId IN (SELECT DISTINCT t.myTagId FROM ResourceTag t WHERE t.myResourceType = :res_type)";
        TypedQuery q = this.myEntityManager.createQuery(sql, TagDefinition.class);
        q.setParameter("res_type", (Object)this.myResourceName);
        List tagDefinitions = q.getResultList();
        return this.toMetaDt(theType, tagDefinitions);
    }

    private boolean isDeleted(BaseHasResource entityToUpdate) {
        return entityToUpdate.getDeleted() != null;
    }

    @Override
    @PostConstruct
    public void start() {
        assert (this.getStorageSettings() != null);
        RuntimeResourceDefinition def = this.getContext().getResourceDefinition(this.myResourceType);
        this.myResourceName = def.getName();
        if (this.mySearchDao != null && this.mySearchDao.isDisabled()) {
            this.mySearchDao = null;
        }
        ourLog.debug("Starting resource DAO for type: {}", (Object)this.getResourceName());
        this.myInstanceValidator = (IInstanceValidatorModule)this.getApplicationContext().getBean(IInstanceValidatorModule.class);
        this.myTxTemplate = new TransactionTemplate(this.myPlatformTransactionManager);
        super.start();
    }

    protected void preDelete(T theResourceToDelete, ResourceTable theEntityToDelete, RequestDetails theRequestDetails) {
    }

    @Transactional
    public T readByPid(IResourcePersistentId thePid) {
        return this.readByPid(thePid, false);
    }

    @Transactional
    public T readByPid(IResourcePersistentId thePid, boolean theDeletedOk) {
        StopWatch w = new StopWatch();
        JpaPid jpaPid = (JpaPid)thePid;
        Optional entity = this.myResourceTableDao.findById(jpaPid.getId());
        if (entity.isEmpty()) {
            throw new ResourceNotFoundException(Msg.code((int)975) + "No resource found with PID " + jpaPid);
        }
        if (this.isDeleted((BaseHasResource)entity.get()) && !theDeletedOk) {
            throw this.createResourceGoneException((IBasePersistedResource)entity.get());
        }
        T retVal = this.myJpaStorageResourceParser.toResource(this.myResourceType, (IBaseResourceEntity)entity.get(), null, false);
        ourLog.debug("Processed read on {} in {}ms", (Object)jpaPid, (Object)w.getMillis());
        return retVal;
    }

    public T read(IIdType theId) {
        return this.read(theId, null);
    }

    public T read(IIdType theId, RequestDetails theRequestDetails) {
        return this.read(theId, theRequestDetails, false);
    }

    public T read(IIdType theId, RequestDetails theRequest, boolean theDeletedOk) {
        this.validateResourceTypeAndThrowInvalidRequestException(theId);
        TransactionDetails transactionDetails = new TransactionDetails();
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForRead(theRequest, this.myResourceName, theId);
        return (T)((IBaseResource)this.myTransactionService.withRequest(theRequest).withTransactionDetails(transactionDetails).withRequestPartitionId(requestPartitionId).execute(() -> this.doReadInTransaction(theId, theRequest, theDeletedOk, requestPartitionId)));
    }

    private T doReadInTransaction(IIdType theId, RequestDetails theRequest, boolean theDeletedOk, RequestPartitionId theRequestPartitionId) {
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        StopWatch w = new StopWatch();
        BaseHasResource entity = this.readEntity(theId, true, theRequest, theRequestPartitionId);
        this.validateResourceType(entity);
        T retVal = this.myJpaStorageResourceParser.toResource(this.myResourceType, (IBaseResourceEntity)entity, null, false);
        if (!theDeletedOk && this.isDeleted(entity)) {
            throw this.createResourceGoneException((IBasePersistedResource)entity);
        }
        if (retVal != null) {
            this.invokeStoragePreAccessResources(theId, theRequest, retVal);
            retVal = this.invokeStoragePreShowResources(theRequest, retVal);
        }
        ourLog.debug("Processed read on {} in {}ms", (Object)theId.getValue(), (Object)w.getMillisAndRestart());
        return retVal;
    }

    private T invokeStoragePreShowResources(RequestDetails theRequest, T retVal) {
        retVal = BaseHapiFhirResourceDao.invokeStoragePreShowResources(this.myInterceptorBroadcaster, theRequest, retVal);
        return retVal;
    }

    private void invokeStoragePreAccessResources(IIdType theId, RequestDetails theRequest, T theResource) {
        BaseHapiFhirResourceDao.invokeStoragePreAccessResources(this.myInterceptorBroadcaster, theRequest, theId, theResource);
    }

    @Override
    public BaseHasResource readEntity(IIdType theId, RequestDetails theRequest) {
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForRead(theRequest, this.myResourceName, theId);
        return (BaseHasResource)this.myTransactionService.withRequest(theRequest).withRequestPartitionId(requestPartitionId).execute(() -> this.readEntity(theId, true, theRequest, requestPartitionId));
    }

    public ReindexOutcome reindex(IResourcePersistentId thePid, ReindexParameters theReindexParameters, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        ReindexOutcome retVal = new ReindexOutcome();
        JpaPid jpaPid = (JpaPid)thePid;
        ResourceTable entity = theReindexParameters.isOptimisticLock() ? (ResourceTable)this.myEntityManager.find(ResourceTable.class, (Object)jpaPid.getId(), LockModeType.OPTIMISTIC) : (ResourceTable)this.myEntityManager.find(ResourceTable.class, (Object)jpaPid.getId());
        if (entity == null) {
            retVal.addWarning("Unable to find entity with PID: " + jpaPid.getId());
            return retVal;
        }
        if (theReindexParameters.getReindexSearchParameters() == ReindexParameters.ReindexSearchParametersEnum.ALL) {
            this.reindexSearchParameters(entity, retVal, theTransactionDetails);
        }
        if (theReindexParameters.getOptimizeStorage() != ReindexParameters.OptimizeStorageModeEnum.NONE) {
            this.reindexOptimizeStorage(entity, theReindexParameters.getOptimizeStorage());
        }
        return retVal;
    }

    private void reindexSearchParameters(ResourceTable entity, ReindexOutcome theReindexOutcome, TransactionDetails theTransactionDetails) {
        try {
            IBaseResource resource = this.myJpaStorageResourceParser.toResource((IBasePersistedResource)entity, false);
            this.reindexSearchParameters(resource, (IBasePersistedResource)entity, theTransactionDetails);
        }
        catch (Exception e) {
            theReindexOutcome.addWarning("Failed to reindex resource " + entity.getIdDt() + ": " + e);
            this.myResourceTableDao.updateIndexStatus(entity.getId(), 2L);
        }
    }

    @Deprecated
    public void reindex(T theResource, IBasePersistedResource theEntity) {
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        ResourceTable entity = (ResourceTable)theEntity;
        TransactionDetails transactionDetails = new TransactionDetails(entity.getUpdatedDate());
        this.reindexSearchParameters(theResource, theEntity, transactionDetails);
    }

    private void reindexSearchParameters(T theResource, IBasePersistedResource theEntity, TransactionDetails transactionDetails) {
        ourLog.debug("Indexing resource {} - PID {}", (Object)theEntity.getIdDt().getValue(), (Object)theEntity.getPersistentId());
        if (theResource != null) {
            CURRENTLY_REINDEXING.put(theResource, (Object)Boolean.TRUE);
        }
        this.updateEntity(null, (IBaseResource)theResource, theEntity, theEntity.getDeleted(), true, false, transactionDetails, true, false);
        if (theResource != null) {
            CURRENTLY_REINDEXING.put(theResource, null);
        }
    }

    private void reindexOptimizeStorage(ResourceTable entity, ReindexParameters.OptimizeStorageModeEnum theOptimizeStorageMode) {
        ResourceHistoryTable historyEntity = entity.getCurrentVersionEntity();
        if (historyEntity != null) {
            this.reindexOptimizeStorageHistoryEntity(entity, historyEntity);
            if (theOptimizeStorageMode == ReindexParameters.OptimizeStorageModeEnum.ALL_VERSIONS) {
                int pageSize = 100;
                int page = 0;
                while ((long)page * (long)pageSize < entity.getVersion()) {
                    Slice<ResourceHistoryTable> historyEntities = this.myResourceHistoryTableDao.findForResourceIdAndReturnEntitiesAndFetchProvenance((Pageable)PageRequest.of((int)page, (int)pageSize), entity.getId(), historyEntity.getVersion());
                    for (ResourceHistoryTable next : historyEntities) {
                        this.reindexOptimizeStorageHistoryEntity(entity, next);
                    }
                    ++page;
                }
            }
        }
    }

    private void reindexOptimizeStorageHistoryEntity(ResourceTable entity, ResourceHistoryTable historyEntity) {
        byte[] resourceBytes;
        boolean changed = false;
        if ((historyEntity.getEncoding() == ResourceEncodingEnum.JSONC || historyEntity.getEncoding() == ResourceEncodingEnum.JSON) && (resourceBytes = historyEntity.getResource()) != null) {
            String resourceText = BaseHapiFhirResourceDao.decodeResource(resourceBytes, historyEntity.getEncoding());
            if (this.myStorageSettings.getInlineResourceTextBelowSize() > 0 && resourceText.length() < this.myStorageSettings.getInlineResourceTextBelowSize()) {
                ourLog.debug("Storing text of resource {} version {} as inline VARCHAR", (Object)entity.getResourceId(), (Object)historyEntity.getVersion());
                historyEntity.setResourceTextVc(resourceText);
                historyEntity.setResource(null);
                historyEntity.setEncoding(ResourceEncodingEnum.JSON);
                changed = true;
            }
        }
        if (StringUtils.isBlank((CharSequence)historyEntity.getSourceUri()) && StringUtils.isBlank((CharSequence)historyEntity.getRequestId()) && historyEntity.getProvenance() != null) {
            historyEntity.setSourceUri(historyEntity.getProvenance().getSourceUri());
            historyEntity.setRequestId(historyEntity.getProvenance().getRequestId());
            changed = true;
        }
        if (changed) {
            this.myResourceHistoryTableDao.save(historyEntity);
        }
    }

    private BaseHasResource readEntity(IIdType theId, boolean theCheckForForcedId, RequestDetails theRequest, RequestPartitionId requestPartitionId) {
        BaseHasResource entity;
        this.validateResourceTypeAndThrowInvalidRequestException(theId);
        JpaPid pid = (JpaPid)this.myIdHelperService.resolveResourcePersistentIds(requestPartitionId, this.getResourceName(), theId.getIdPart());
        Set readPartitions = null;
        if (requestPartitionId.isAllPartitions()) {
            entity = (BaseHasResource)this.myEntityManager.find(ResourceTable.class, (Object)pid.getId());
        } else {
            readPartitions = this.myRequestPartitionHelperService.toReadPartitions(requestPartitionId);
            if (readPartitions.size() == 1) {
                entity = readPartitions.contains(null) ? (BaseHasResource)this.myResourceTableDao.readByPartitionIdNull(pid.getId()).orElse(null) : (BaseHasResource)this.myResourceTableDao.readByPartitionId((Integer)readPartitions.iterator().next(), pid.getId()).orElse(null);
            } else if (readPartitions.contains(null)) {
                List<Integer> readPartitionsWithoutNull = readPartitions.stream().filter(Objects::nonNull).collect(Collectors.toList());
                entity = this.myResourceTableDao.readByPartitionIdsOrNull(readPartitionsWithoutNull, pid.getId()).orElse(null);
            } else {
                entity = this.myResourceTableDao.readByPartitionIds(readPartitions, pid.getId()).orElse(null);
            }
        }
        if (entity != null && readPartitions != null && entity.getPartitionId() != null && !readPartitions.contains(entity.getPartitionId().getPartitionId())) {
            ourLog.debug("Performing a read for PartitionId={} but entity has partition: {}", (Object)requestPartitionId, (Object)entity.getPartitionId());
            entity = null;
        }
        if (entity == null) {
            throw new ResourceNotFoundException(Msg.code((int)1996) + "Resource " + theId + " is not known");
        }
        if (theId.hasVersionIdPart()) {
            if (!theId.isVersionIdPartValidLong()) {
                throw new ResourceNotFoundException(Msg.code((int)978) + this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidVersion", new Object[]{theId.getVersionIdPart(), theId.toUnqualifiedVersionless()}));
            }
            if (entity.getVersion() != theId.getVersionIdPartAsLong().longValue()) {
                entity = null;
            }
        }
        if (entity == null && theId.hasVersionIdPart()) {
            TypedQuery q = this.myEntityManager.createQuery("SELECT t from ResourceHistoryTable t WHERE t.myResourceId = :RID AND t.myResourceType = :RTYP AND t.myResourceVersion = :RVER", ResourceHistoryTable.class);
            q.setParameter("RID", (Object)pid.getId());
            q.setParameter("RTYP", (Object)this.myResourceName);
            q.setParameter("RVER", (Object)theId.getVersionIdPartAsLong());
            try {
                entity = (BaseHasResource)q.getSingleResult();
            }
            catch (NoResultException e) {
                throw new ResourceNotFoundException(Msg.code((int)979) + this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidVersion", new Object[]{theId.getVersionIdPart(), theId.toUnqualifiedVersionless()}));
            }
        }
        Validate.notNull((Object)entity);
        this.validateResourceType(entity);
        if (theCheckForForcedId) {
            this.validateGivenIdIsAppropriateToRetrieveResource(theId, entity);
        }
        return entity;
    }

    protected IBasePersistedResource readEntityLatestVersion(IResourcePersistentId thePersistentId, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        JpaPid jpaPid = (JpaPid)thePersistentId;
        return (IBasePersistedResource)this.myEntityManager.find(ResourceTable.class, (Object)jpaPid.getId());
    }

    @Nonnull
    protected ResourceTable readEntityLatestVersion(IIdType theId, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForRead(theRequestDetails, this.getResourceName(), theId);
        return this.readEntityLatestVersion(theId, requestPartitionId, theTransactionDetails);
    }

    @Nonnull
    private ResourceTable readEntityLatestVersion(IIdType theId, @Nonnull RequestPartitionId theRequestPartitionId, TransactionDetails theTransactionDetails) {
        ResourceTable entity;
        this.validateResourceTypeAndThrowInvalidRequestException(theId);
        JpaPid persistentId = null;
        if (theTransactionDetails != null) {
            if (theTransactionDetails.isResolvedResourceIdEmpty(theId.toUnqualifiedVersionless())) {
                throw new ResourceNotFoundException(Msg.code((int)1997) + theId);
            }
            if (theTransactionDetails.hasResolvedResourceIds()) {
                persistentId = (JpaPid)theTransactionDetails.getResolvedResourceId(theId);
            }
        }
        if (persistentId == null) {
            persistentId = (JpaPid)this.myIdHelperService.resolveResourcePersistentIds(theRequestPartitionId, this.getResourceName(), theId.getIdPart());
        }
        if ((entity = (ResourceTable)this.myEntityManager.find(ResourceTable.class, (Object)persistentId.getId())) == null) {
            throw new ResourceNotFoundException(Msg.code((int)1998) + theId);
        }
        this.validateGivenIdIsAppropriateToRetrieveResource(theId, (BaseHasResource)entity);
        entity.setTransientForcedId(theId.getIdPart());
        return entity;
    }

    @Transactional
    public void removeTag(IIdType theId, TagTypeEnum theTagType, String theScheme, String theTerm) {
        this.removeTag(theId, theTagType, theScheme, theTerm, null);
    }

    @Transactional
    public void removeTag(IIdType theId, TagTypeEnum theTagType, String theScheme, String theTerm, RequestDetails theRequest) {
        StopWatch w = new StopWatch();
        BaseHasResource entity = this.readEntity(theId, theRequest);
        if (entity == null) {
            throw new ResourceNotFoundException(Msg.code((int)1999) + theId);
        }
        for (BaseTag next : new ArrayList(entity.getTags())) {
            if (!Objects.equals(next.getTag().getTagType(), theTagType) || !Objects.equals(next.getTag().getSystem(), theScheme) || !Objects.equals(next.getTag().getCode(), theTerm)) continue;
            this.myEntityManager.remove((Object)next);
            entity.getTags().remove(next);
        }
        if (entity.getTags().isEmpty()) {
            entity.setHasTags(false);
        }
        this.myEntityManager.merge((Object)entity);
        ourLog.debug("Processed remove tag {}/{} on {} in {}ms", new Object[]{theScheme, theTerm, theId.getValue(), w.getMillisAndRestart()});
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public IBundleProvider search(SearchParameterMap theParams) {
        return this.search(theParams, null);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public IBundleProvider search(SearchParameterMap theParams, RequestDetails theRequest) {
        return this.search(theParams, theRequest, null);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public IBundleProvider search(SearchParameterMap theParams, RequestDetails theRequest, HttpServletResponse theServletResponse) {
        if (theParams.getSearchContainedMode() == SearchContainedModeEnum.BOTH) {
            throw new MethodNotAllowedException(Msg.code((int)983) + "Contained mode 'both' is not currently supported");
        }
        if (theParams.getSearchContainedMode() != SearchContainedModeEnum.FALSE && !this.myStorageSettings.isIndexOnContainedResources()) {
            throw new MethodNotAllowedException(Msg.code((int)984) + "Searching with _contained mode enabled is not enabled on this server");
        }
        this.translateListSearchParams(theParams);
        this.setOffsetAndCount(theParams, theRequest);
        CacheControlDirective cacheControlDirective = new CacheControlDirective();
        if (theRequest != null) {
            cacheControlDirective.parse(theRequest.getHeaders("Cache-Control"));
        }
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForSearchType(theRequest, this.getResourceName(), theParams, null);
        IBundleProvider retVal = this.mySearchCoordinatorSvc.registerSearch((IFhirResourceDao)this, theParams, this.getResourceName(), cacheControlDirective, theRequest, requestPartitionId);
        if (retVal instanceof PersistedJpaBundleProvider) {
            PersistedJpaBundleProvider provider = (PersistedJpaBundleProvider)retVal;
            provider.setRequestPartitionId(requestPartitionId);
            if (provider.getCacheStatus() == SearchCacheStatusEnum.HIT && theServletResponse != null && theRequest != null) {
                String value = "HIT from " + theRequest.getFhirServerBase();
                theServletResponse.addHeader("X-Cache", value);
            }
        }
        return retVal;
    }

    private void translateListSearchParams(SearchParameterMap theParams) {
        for (String key : theParams.keySet()) {
            if (!"_list".equals(key)) continue;
            List andOrValues = theParams.get(key);
            theParams.remove(key);
            ArrayList hasParamValues = new ArrayList();
            for (List orValues : andOrValues) {
                ArrayList<HasParam> orList = new ArrayList<HasParam>();
                for (IQueryParameterType value : orValues) {
                    orList.add(new HasParam("List", "item", "_id", value.getValueAsQueryToken(null)));
                }
                hasParamValues.add(orList);
            }
            theParams.put("_has", hasParamValues);
        }
    }

    protected void setOffsetAndCount(SearchParameterMap theParams, RequestDetails theRequest) {
        if (theRequest != null) {
            Integer count;
            Integer offset;
            Integer max;
            if (theRequest.isSubRequest() && (max = this.getStorageSettings().getMaximumSearchResultCountInTransaction()) != null) {
                Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)max.intValue(), (String)"Maximum search result count in transaction must be a positive integer");
                theParams.setLoadSynchronousUpTo(this.getStorageSettings().getMaximumSearchResultCountInTransaction());
            }
            if ((offset = RestfulServerUtils.extractOffsetParameter((RequestDetails)theRequest)) != null || !this.isPagingProviderDatabaseBacked(theRequest)) {
                theParams.setLoadSynchronous(true);
                if (offset != null) {
                    Validate.inclusiveBetween((long)0L, (long)Integer.MAX_VALUE, (long)offset.intValue(), (String)"Offset must be a positive integer");
                }
                theParams.setOffset(offset);
            }
            if ((count = RestfulServerUtils.extractCountParameter((RequestDetails)theRequest)) != null) {
                Integer maxPageSize = theRequest.getServer().getMaximumPageSize();
                if (maxPageSize != null && count > maxPageSize) {
                    ourLog.info("Reducing {} from {} to {} which is the maximum allowable page size.", new Object[]{"_count", count, maxPageSize});
                    count = maxPageSize;
                }
                theParams.setCount(count);
            } else if (theRequest.getServer().getDefaultPageSize() != null) {
                theParams.setCount(theRequest.getServer().getDefaultPageSize());
            }
        }
    }

    public List<JpaPid> searchForIds(SearchParameterMap theParams, RequestDetails theRequest, @Nullable IBaseResource theConditionalOperationTargetOrNull) {
        TransactionDetails transactionDetails = new TransactionDetails();
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForSearchType(theRequest, this.myResourceName, theParams, theConditionalOperationTargetOrNull);
        return (List)this.myTransactionService.withRequest(theRequest).withTransactionDetails(transactionDetails).withRequestPartitionId(requestPartitionId).execute(() -> {
            if (Objects.isNull(theParams.getLoadSynchronousUpTo())) {
                theParams.setLoadSynchronousUpTo(this.myStorageSettings.getInternalSynchronousSearchSize());
            }
            ISearchBuilder builder = this.mySearchBuilderFactory.newSearchBuilder((IDao)this, this.getResourceName(), this.getResourceType());
            ArrayList<JpaPid> ids = new ArrayList<JpaPid>();
            String uuid = UUID.randomUUID().toString();
            SearchRuntimeDetails searchRuntimeDetails = new SearchRuntimeDetails(theRequest, uuid);
            try (IResultIterator iter = builder.createQuery(theParams, searchRuntimeDetails, theRequest, requestPartitionId);){
                while (iter.hasNext()) {
                    ids.add((JpaPid)iter.next());
                }
            }
            catch (IOException e) {
                ourLog.error("IO failure during database access", (Throwable)e);
            }
            return ids;
        });
    }

    protected <MT extends IBaseMetaType> MT toMetaDt(Class<MT> theType, Collection<TagDefinition> tagDefinitions) {
        IBaseMetaType retVal = (IBaseMetaType)ReflectionUtil.newInstance(theType);
        for (TagDefinition next : tagDefinitions) {
            switch (next.getTagType()) {
                case PROFILE: {
                    retVal.addProfile(next.getCode());
                    break;
                }
                case SECURITY_LABEL: {
                    retVal.addSecurity().setSystem(next.getSystem()).setCode(next.getCode()).setDisplay(next.getDisplay());
                    break;
                }
                case TAG: {
                    retVal.addTag().setSystem(next.getSystem()).setCode(next.getCode()).setDisplay(next.getDisplay());
                }
            }
        }
        this.myMetaTagSorter.sort(retVal);
        return (MT)retVal;
    }

    private ArrayList<TagDefinition> toTagList(IBaseMetaType theMeta) {
        ArrayList<TagDefinition> retVal = new ArrayList<TagDefinition>();
        for (IBaseCoding next : theMeta.getTag()) {
            retVal.add(new TagDefinition(TagTypeEnum.TAG, next.getSystem(), next.getCode(), next.getDisplay()));
        }
        for (IBaseCoding next : theMeta.getSecurity()) {
            retVal.add(new TagDefinition(TagTypeEnum.SECURITY_LABEL, next.getSystem(), next.getCode(), next.getDisplay()));
        }
        for (IBaseCoding next : theMeta.getProfile()) {
            retVal.add(new TagDefinition(TagTypeEnum.PROFILE, "https://github.com/hapifhir/hapi-fhir/ns/jpa/profile", (String)next.getValue(), null));
        }
        return retVal;
    }

    public DaoMethodOutcome update(T theResource) {
        return this.update(theResource, null, null);
    }

    public DaoMethodOutcome update(T theResource, RequestDetails theRequestDetails) {
        return this.update(theResource, null, theRequestDetails);
    }

    public DaoMethodOutcome update(T theResource, String theMatchUrl) {
        return this.update(theResource, theMatchUrl, null);
    }

    public DaoMethodOutcome update(T theResource, String theMatchUrl, RequestDetails theRequestDetails) {
        return this.update(theResource, theMatchUrl, true, theRequestDetails);
    }

    public DaoMethodOutcome update(T theResource, String theMatchUrl, boolean thePerformIndexing, RequestDetails theRequestDetails) {
        return this.update(theResource, theMatchUrl, thePerformIndexing, false, theRequestDetails, new TransactionDetails());
    }

    public DaoMethodOutcome update(T theResource, String theMatchUrl, boolean thePerformIndexing, boolean theForceUpdateVersion, RequestDetails theRequest, @Nonnull TransactionDetails theTransactionDetails) {
        if (theResource == null) {
            String msg = this.getContext().getLocalizer().getMessage(BaseStorageDao.class, "missingBody", new Object[0]);
            throw new InvalidRequestException(Msg.code((int)986) + msg);
        }
        if (!theResource.getIdElement().hasIdPart() && StringUtils.isBlank((CharSequence)theMatchUrl)) {
            String type = this.myFhirContext.getResourceType(theResource);
            String msg = this.myFhirContext.getLocalizer().getMessage(BaseStorageDao.class, "updateWithNoId", new Object[]{type});
            throw new InvalidRequestException(Msg.code((int)987) + msg);
        }
        String id = theResource.getIdElement().getValue();
        Runnable onRollback = () -> theResource.getIdElement().setValue(id);
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineCreatePartitionForRequest(theRequest, theResource, this.getResourceName());
        Callable<DaoMethodOutcome> updateCallback = this.myStorageSettings.isUpdateWithHistoryRewriteEnabled() && theRequest != null && theRequest.isRewriteHistory() ? () -> this.doUpdateWithHistoryRewrite(theResource, theRequest, theTransactionDetails, requestPartitionId) : () -> this.doUpdate(theResource, theMatchUrl, thePerformIndexing, theForceUpdateVersion, theRequest, theTransactionDetails, requestPartitionId);
        return (DaoMethodOutcome)this.myTransactionService.withRequest(theRequest).withTransactionDetails(theTransactionDetails).withRequestPartitionId(requestPartitionId).onRollback(onRollback).execute(updateCallback);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DaoMethodOutcome doUpdate(T theResource, String theMatchUrl, boolean thePerformIndexing, boolean theForceUpdateVersion, RequestDetails theRequest, TransactionDetails theTransactionDetails, RequestPartitionId theRequestPartitionId) {
        String existenceCheck;
        IIdType resourceId;
        this.preProcessResourceForStorage((IBaseResource)theResource);
        this.preProcessResourceForStorage((IBaseResource)theResource, theRequest, theTransactionDetails, thePerformIndexing);
        ResourceTable entity = null;
        RestOperationTypeEnum update = RestOperationTypeEnum.UPDATE;
        if (StringUtils.isNotBlank((CharSequence)theMatchUrl)) {
            DaoMethodOutcome outcome;
            Set match = this.myMatchResourceUrlService.processMatchUrl(theMatchUrl, this.myResourceType, theTransactionDetails, theRequest, theResource);
            if (match.size() > 1) {
                String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "transactionOperationWithMultipleMatchFailure", new Object[]{"UPDATE", theMatchUrl, match.size()});
                throw new PreconditionFailedException(Msg.code((int)988) + msg);
            }
            if (match.size() == 1) {
                JpaPid pid = (JpaPid)match.iterator().next();
                entity = (ResourceTable)this.myEntityManager.find(ResourceTable.class, (Object)pid.getId());
                resourceId = entity.getIdDt();
                if (!this.myFhirContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R4) || theResource.getIdElement().getIdPart() == null || Objects.equals(theResource.getIdElement().getIdPart(), resourceId.getIdPart())) return this.doUpdateForUpdateOrPatch(theRequest, resourceId, theMatchUrl, thePerformIndexing, theForceUpdateVersion, theResource, (IBasePersistedResource)entity, update, theTransactionDetails);
                String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "transactionOperationWithIdNotMatchFailure", new Object[]{"UPDATE", theMatchUrl});
                throw new InvalidRequestException(Msg.code((int)2279) + msg);
            }
            if (!theResource.getIdElement().hasIdPart() && this.getStorageSettings().getResourceServerIdStrategy() == JpaStorageSettings.IdStrategyEnum.UUID) {
                theResource.setId(UUID.randomUUID().toString());
                theResource.setUserData(JpaConstants.RESOURCE_ID_SERVER_ASSIGNED, (Object)Boolean.TRUE);
            }
            if ((outcome = this.doCreateForPostOrPut(theRequest, theResource, theMatchUrl, false, thePerformIndexing, theRequestPartitionId, update, theTransactionDetails)).getPersistentId() == null) return outcome;
            this.myMatchResourceUrlService.matchUrlResolved(theTransactionDetails, this.getResourceName(), theMatchUrl, (IResourcePersistentId)((JpaPid)outcome.getPersistentId()));
            return outcome;
        }
        resourceId = theResource.getIdElement();
        assert (resourceId != null);
        assert (resourceId.hasIdPart());
        boolean create = false;
        if (theRequest != null && "disabled".equals(existenceCheck = theRequest.getHeader("X-Upsert-Extistence-Check"))) {
            create = true;
        }
        if (!create) {
            try {
                entity = this.readEntityLatestVersion(resourceId, theRequestPartitionId, theTransactionDetails);
            }
            catch (ResourceNotFoundException e) {
                create = true;
            }
        }
        if (!create) return this.doUpdateForUpdateOrPatch(theRequest, resourceId, theMatchUrl, thePerformIndexing, theForceUpdateVersion, theResource, (IBasePersistedResource)entity, update, theTransactionDetails);
        return this.doCreateForPostOrPut(theRequest, theResource, null, false, thePerformIndexing, theRequestPartitionId, update, theTransactionDetails);
    }

    protected DaoMethodOutcome doUpdateForUpdateOrPatch(RequestDetails theRequest, IIdType theResourceId, String theMatchUrl, boolean thePerformIndexing, boolean theForceUpdateVersion, T theResource, IBasePersistedResource theEntity, RestOperationTypeEnum theOperationType, TransactionDetails theTransactionDetails) {
        ResourceTable entity = (ResourceTable)theEntity;
        if (entity.isSearchUrlPresent() && thePerformIndexing) {
            this.myResourceSearchUrlSvc.deleteByResId((Long)theEntity.getPersistentId().getId());
            entity.setSearchUrlPresent(false);
        }
        return super.doUpdateForUpdateOrPatch(theRequest, theResourceId, theMatchUrl, thePerformIndexing, theForceUpdateVersion, theResource, theEntity, theOperationType, theTransactionDetails);
    }

    private DaoMethodOutcome doUpdateWithHistoryRewrite(T theResource, RequestDetails theRequest, TransactionDetails theTransactionDetails, RequestPartitionId theRequestPartitionId) {
        BaseHasResource entity;
        ResourceTable currentEntity;
        StopWatch w = new StopWatch();
        this.preProcessResourceForStorage((IBaseResource)theResource, theRequest, theTransactionDetails, false);
        IIdType resourceId = theResource.getIdElement();
        assert (resourceId != null);
        assert (resourceId.hasIdPart());
        try {
            currentEntity = this.readEntityLatestVersion(resourceId.toVersionless(), theRequestPartitionId, theTransactionDetails);
            if (!resourceId.hasVersionIdPart()) {
                throw new InvalidRequestException(Msg.code((int)2093) + "Invalid resource ID, ID must contain a history version");
            }
            entity = this.readEntity(resourceId, theRequest);
            this.validateResourceType(entity);
        }
        catch (ResourceNotFoundException e) {
            throw new ResourceNotFoundException(Msg.code((int)2087) + "Resource not found [" + resourceId + "] - Doesn't exist");
        }
        if (resourceId.hasResourceType() && !resourceId.getResourceType().equals(this.getResourceName())) {
            throw new UnprocessableEntityException(Msg.code((int)2088) + "Invalid resource ID[" + entity.getIdDt().toUnqualifiedVersionless() + "] of type[" + entity.getResourceType() + "] - Does not match expected [" + this.getResourceName() + "]");
        }
        assert (resourceId.hasVersionIdPart());
        boolean wasDeleted = this.isDeleted(entity);
        entity.setDeleted(null);
        boolean isUpdatingCurrent = resourceId.hasVersionIdPart() && Long.parseLong(resourceId.getVersionIdPart()) == currentEntity.getVersion();
        IBasePersistedResource savedEntity = this.updateHistoryEntity(theRequest, theResource, (IBasePersistedResource)currentEntity, (IBasePersistedResource)entity, resourceId, theTransactionDetails, isUpdatingCurrent);
        DaoMethodOutcome outcome = this.toMethodOutcome(theRequest, savedEntity, (IBaseResource)theResource, null, RestOperationTypeEnum.UPDATE).setCreated(Boolean.valueOf(wasDeleted));
        this.populateOperationOutcomeForUpdate(w, outcome, null, RestOperationTypeEnum.UPDATE);
        return outcome;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Transactional(propagation=Propagation.SUPPORTS)
    public MethodOutcome validate(T theResource, IIdType theId, String theRawResource, EncodingEnum theEncoding, ValidationModeEnum theMode, String theProfile, RequestDetails theRequest) {
        ValidationResult result;
        TransactionDetails transactionDetails = new TransactionDetails();
        if (theMode == ValidationModeEnum.DELETE) {
            if (theId == null || !theId.hasIdPart()) {
                throw new InvalidRequestException(Msg.code((int)991) + "No ID supplied. ID is required when validating with mode=DELETE");
            }
            ResourceTable entity = this.readEntityLatestVersion(theId, theRequest, transactionDetails);
            DeleteConflictList deleteConflicts = new DeleteConflictList();
            if (this.getStorageSettings().isEnforceReferentialIntegrityOnDelete()) {
                this.myDeleteConflictService.validateOkToDelete(deleteConflicts, entity, true, theRequest, new TransactionDetails());
            }
            DeleteConflictUtil.validateDeleteConflictsEmptyOrThrowException((FhirContext)this.getContext(), (DeleteConflictList)deleteConflicts);
            IBaseOperationOutcome oo = this.createInfoOperationOutcome("Ok to delete");
            return new MethodOutcome((IIdType)new IdDt(theId.getValue()), oo);
        }
        FhirValidator validator = this.getContext().newValidator();
        validator.setInterceptorBroadcaster(CompositeInterceptorBroadcaster.newCompositeBroadcaster((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest));
        validator.registerValidatorModule((IValidatorModule)this.getInstanceValidator());
        validator.registerValidatorModule((IValidatorModule)new IdChecker(theMode));
        IBaseResource resourceToValidateById = null;
        if (theId != null && theId.hasResourceType() && theId.hasIdPart()) {
            Class type = this.getContext().getResourceDefinition(theId.getResourceType()).getImplementingClass();
            IFhirResourceDao dao = this.myDaoRegistry.getResourceDaoOrNull(type);
            resourceToValidateById = dao.read(theId, theRequest);
        }
        ValidationOptions options = new ValidationOptions().addProfileIfNotBlank(theProfile);
        if (theResource == null) {
            if (resourceToValidateById == null) {
                String msg = this.getContext().getLocalizer().getMessage(BaseStorageDao.class, "cantValidateWithNoResource", new Object[0]);
                throw new InvalidRequestException(Msg.code((int)992) + msg);
            }
            result = validator.validateWithResult(resourceToValidateById, options);
        } else {
            result = StringUtils.isNotBlank((CharSequence)theRawResource) ? validator.validateWithResult(theRawResource, options) : validator.validateWithResult(theResource, options);
        }
        MethodOutcome retVal = new MethodOutcome();
        retVal.setOperationOutcome(result.toOperationOutcome());
        return retVal;
    }

    public RuntimeResourceDefinition validateCriteriaAndReturnResourceDefinition(String criteria) {
        if (criteria == null || criteria.trim().isEmpty()) {
            throw new IllegalArgumentException(Msg.code((int)994) + "Criteria cannot be empty");
        }
        String resourceName = criteria.contains("?") ? criteria.substring(0, criteria.indexOf("?")) : criteria;
        return this.getContext().getResourceDefinition(resourceName);
    }

    private void validateGivenIdIsAppropriateToRetrieveResource(IIdType theId, BaseHasResource entity) {
        if (entity.getForcedId() != null && this.getStorageSettings().getResourceClientIdStrategy() != JpaStorageSettings.ClientIdStrategyEnum.ANY && theId.isIdPartValidLong()) {
            throw new ResourceNotFoundException(Msg.code((int)2000) + theId);
        }
    }

    private void validateResourceType(BaseHasResource entity) {
        BaseHapiFhirResourceDao.validateResourceType((IBasePersistedResource)entity, (String)this.myResourceName);
    }

    private void validateResourceTypeAndThrowInvalidRequestException(IIdType theId) {
        if (theId.hasResourceType() && !theId.getResourceType().equals(this.myResourceName)) {
            throw new InvalidRequestException(Msg.code((int)996) + "Incorrect resource type (" + theId.getResourceType() + ") for this DAO, wanted: " + this.myResourceName);
        }
    }

    @VisibleForTesting
    public void setIdHelperSvcForUnitTest(IIdHelperService theIdHelperService) {
        this.myIdHelperService = theIdHelperService;
    }

    private static class IdChecker
    implements IValidatorModule {
        private final ValidationModeEnum myMode;

        IdChecker(ValidationModeEnum theMode) {
            this.myMode = theMode;
        }

        public void validateResource(IValidationContext<IBaseResource> theCtx) {
            IBaseResource resource = (IBaseResource)theCtx.getResource();
            if (resource instanceof Parameters) {
                List params = ((Parameters)resource).getParameter();
                params = params.stream().filter(param -> param.getName().contains(BaseHapiFhirResourceDao.BASE_RESOURCE_NAME)).collect(Collectors.toList());
                resource = ((Parameters.ParametersParameterComponent)params.get(0)).getResource();
            }
            boolean hasId = resource.getIdElement().hasIdPart();
            if (this.myMode == ValidationModeEnum.CREATE) {
                if (hasId) {
                    throw new UnprocessableEntityException(Msg.code((int)997) + "Resource has an ID - ID must not be populated for a FHIR create");
                }
            } else if (this.myMode == ValidationModeEnum.UPDATE && !hasId) {
                throw new UnprocessableEntityException(Msg.code((int)998) + "Resource has no ID - ID must be populated for a FHIR update");
            }
        }
    }
}

