/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.TransactionProcessor;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.dao.data.IResourceTagDao;
import ca.uhn.fhir.jpa.dao.expunge.ExpungeService;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.BaseHasResource;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.entity.StorageSettings;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.search.PersistedJpaBundleProviderFactory;
import ca.uhn.fhir.jpa.search.builder.SearchBuilder;
import ca.uhn.fhir.jpa.util.QueryChunker;
import ca.uhn.fhir.jpa.util.ResourceCountCache;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.util.StopWatch;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseHapiFhirSystemDao<T extends IBaseBundle, MT>
extends BaseStorageDao
implements IFhirSystemDao<T, MT> {
    public static final Predicate[] EMPTY_PREDICATE_ARRAY = new Predicate[0];
    private static final Logger ourLog = LoggerFactory.getLogger(BaseHapiFhirSystemDao.class);
    public ResourceCountCache myResourceCountsCache;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    private TransactionProcessor myTransactionProcessor;
    @Autowired
    private ApplicationContext myApplicationContext;
    @Autowired
    private ExpungeService myExpungeService;
    @Autowired
    private IResourceTableDao myResourceTableDao;
    @Autowired
    private PersistedJpaBundleProviderFactory myPersistedJpaBundleProviderFactory;
    @Autowired
    private IResourceTagDao myResourceTagDao;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperService;
    @Autowired
    private IHapiTransactionService myTransactionService;

    @VisibleForTesting
    public void setTransactionProcessorForUnitTest(TransactionProcessor theTransactionProcessor) {
        this.myTransactionProcessor = theTransactionProcessor;
    }

    @Transactional(propagation=Propagation.NEVER)
    public ExpungeOutcome expunge(ExpungeOptions theExpungeOptions, RequestDetails theRequestDetails) {
        this.validateExpungeEnabled(theExpungeOptions);
        return this.myExpungeService.expunge(null, null, theExpungeOptions, theRequestDetails);
    }

    private void validateExpungeEnabled(ExpungeOptions theExpungeOptions) {
        if (!this.getStorageSettings().isExpungeEnabled()) {
            throw new MethodNotAllowedException(Msg.code((int)2080) + "$expunge is not enabled on this server");
        }
        if (theExpungeOptions.isExpungeEverything() && !this.getStorageSettings().isAllowMultipleDelete()) {
            throw new MethodNotAllowedException(Msg.code((int)2081) + "Multiple delete is not enabled on this server");
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, Long> getResourceCounts() {
        HashMap<String, Long> retVal = new HashMap<String, Long>();
        List<Map<?, ?>> counts = this.myResourceTableDao.getResourceCounts();
        for (Map<?, ?> next : counts) {
            retVal.put(next.get("type").toString(), Long.parseLong(next.get("count").toString()));
        }
        return retVal;
    }

    @Nullable
    public Map<String, Long> getResourceCountsFromCache() {
        if (this.myResourceCountsCache == null) {
            this.myResourceCountsCache = (ResourceCountCache)this.myApplicationContext.getBean("myResourceCountsCache", ResourceCountCache.class);
        }
        return this.myResourceCountsCache.get();
    }

    public IBundleProvider history(Date theSince, Date theUntil, Integer theOffset, RequestDetails theRequestDetails) {
        StopWatch w = new StopWatch();
        ReadPartitionIdRequestDetails details = ReadPartitionIdRequestDetails.forHistory(null, null);
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequest(theRequestDetails, details);
        IBundleProvider retVal = (IBundleProvider)this.myTransactionService.withRequest(theRequestDetails).withRequestPartitionId(requestPartitionId).execute(() -> this.myPersistedJpaBundleProviderFactory.history(theRequestDetails, null, null, theSince, theUntil, theOffset, requestPartitionId));
        ourLog.info("Processed global history in {}ms", (Object)w.getMillisAndRestart());
        return retVal;
    }

    public T transaction(RequestDetails theRequestDetails, T theRequest) {
        HapiTransactionService.noTransactionAllowed();
        return (T)this.myTransactionProcessor.transaction(theRequestDetails, (IBaseBundle)theRequest, false);
    }

    public T transactionNested(RequestDetails theRequestDetails, T theRequest) {
        HapiTransactionService.requireTransaction();
        return (T)this.myTransactionProcessor.transaction(theRequestDetails, (IBaseBundle)theRequest, true);
    }

    public <P extends IResourcePersistentId> void preFetchResources(List<P> theResolvedIds, boolean thePreFetchIndexes) {
        HapiTransactionService.requireTransaction();
        List pids = theResolvedIds.stream().map(t -> ((JpaPid)t).getId()).collect(Collectors.toList());
        new QueryChunker().chunk(pids, ids -> {
            if (ids.size() >= 2) {
                ArrayList<ResourceTable> loadedResourceTableEntries = new ArrayList<ResourceTable>();
                this.preFetchIndexes((List<Long>)ids, "forcedId", "myForcedId", (List<ResourceTable>)loadedResourceTableEntries);
                if (thePreFetchIndexes) {
                    List<Long> entityIds = loadedResourceTableEntries.stream().filter(ResourceTable::isParamsStringPopulated).map(ResourceTable::getId).collect(Collectors.toList());
                    if (entityIds.size() > 0) {
                        this.preFetchIndexes(entityIds, "string", "myParamsString", null);
                    }
                    if ((entityIds = loadedResourceTableEntries.stream().filter(ResourceTable::isParamsTokenPopulated).map(ResourceTable::getId).collect(Collectors.toList())).size() > 0) {
                        this.preFetchIndexes(entityIds, "token", "myParamsToken", null);
                    }
                    if ((entityIds = loadedResourceTableEntries.stream().filter(ResourceTable::isParamsDatePopulated).map(ResourceTable::getId).collect(Collectors.toList())).size() > 0) {
                        this.preFetchIndexes(entityIds, "date", "myParamsDate", null);
                    }
                    if ((entityIds = loadedResourceTableEntries.stream().filter(ResourceTable::isParamsQuantityPopulated).map(ResourceTable::getId).collect(Collectors.toList())).size() > 0) {
                        this.preFetchIndexes(entityIds, "quantity", "myParamsQuantity", null);
                    }
                    if ((entityIds = loadedResourceTableEntries.stream().filter(ResourceTable::isHasLinks).map(ResourceTable::getId).collect(Collectors.toList())).size() > 0) {
                        this.preFetchIndexes(entityIds, "resourceLinks", "myResourceLinks", null);
                    }
                    if ((entityIds = loadedResourceTableEntries.stream().filter(BaseHasResource::isHasTags).map(ResourceTable::getId).collect(Collectors.toList())).size() > 0) {
                        this.myResourceTagDao.findByResourceIds(entityIds);
                        this.preFetchIndexes(entityIds, "tags", "myTags", null);
                    }
                    entityIds = loadedResourceTableEntries.stream().map(ResourceTable::getId).collect(Collectors.toList());
                    if (this.myStorageSettings.getIndexMissingFields() == StorageSettings.IndexEnabledEnum.ENABLED) {
                        this.preFetchIndexes(entityIds, "searchParamPresence", "mySearchParamPresents", null);
                    }
                }
                new QueryChunker().chunk(loadedResourceTableEntries, SearchBuilder.getMaximumPageSize() / 2, entries -> {
                    Map<Long, ResourceTable> entities = entries.stream().collect(Collectors.toMap(ResourceTable::getId, t -> t));
                    CriteriaBuilder b = this.myEntityManager.getCriteriaBuilder();
                    CriteriaQuery q = b.createQuery(ResourceHistoryTable.class);
                    Root from = q.from(ResourceHistoryTable.class);
                    from.fetch("myProvenance", JoinType.LEFT);
                    ArrayList<Predicate> orPredicates = new ArrayList<Predicate>();
                    for (ResourceTable next : entries) {
                        Predicate resId = b.equal((Expression)from.get("myResourceId"), (Object)next.getId());
                        Predicate resVer = b.equal((Expression)from.get("myResourceVersion"), (Object)next.getVersion());
                        orPredicates.add(b.and((Expression)resId, (Expression)resVer));
                    }
                    q.where((Expression)b.or(orPredicates.toArray(EMPTY_PREDICATE_ARRAY)));
                    List resultList = this.myEntityManager.createQuery(q).getResultList();
                    for (ResourceHistoryTable next : resultList) {
                        ResourceTable nextEntity = entities.get(next.getResourceId());
                        if (nextEntity == null) continue;
                        nextEntity.setCurrentVersionEntity(next);
                    }
                });
            }
        });
    }

    private void preFetchIndexes(List<Long> theIds, String typeDesc, String fieldName, @Nullable List<ResourceTable> theEntityListToPopulate) {
        new QueryChunker<Long>().chunk(theIds, ids -> {
            TypedQuery query = this.myEntityManager.createQuery("FROM ResourceTable r LEFT JOIN FETCH r." + fieldName + " WHERE r.myId IN ( :IDS )", ResourceTable.class);
            query.setParameter("IDS", ids);
            List indexFetchOutcome = query.getResultList();
            ourLog.debug("Pre-fetched {} {}} indexes", (Object)indexFetchOutcome.size(), (Object)typeDesc);
            if (theEntityListToPopulate != null) {
                theEntityListToPopulate.addAll(indexFetchOutcome);
            }
        });
    }

    @Nullable
    protected String getResourceName() {
        return null;
    }

    protected IInterceptorBroadcaster getInterceptorBroadcaster() {
        return this.myInterceptorBroadcaster;
    }

    protected JpaStorageSettings getStorageSettings() {
        return this.myStorageSettings;
    }

    public FhirContext getContext() {
        return this.myFhirContext;
    }

    @VisibleForTesting
    public void setStorageSettingsForUnitTest(JpaStorageSettings theStorageSettings) {
        this.myStorageSettings = theStorageSettings;
    }
}

