/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.jpa.dao.BaseHapiFhirSystemDao;
import ca.uhn.fhir.jpa.dao.JpaResourceDao;
import ca.uhn.fhir.jpa.model.entity.TagDefinition;
import ca.uhn.fhir.model.dstu2.composite.MetaDt;
import ca.uhn.fhir.model.dstu2.resource.Bundle;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.Collection;
import java.util.List;
import javax.persistence.TypedQuery;
import org.hl7.fhir.instance.model.api.IBaseBundle;

public class FhirSystemDaoDstu2
extends BaseHapiFhirSystemDao<Bundle, MetaDt> {
    public MetaDt metaGetOperation(RequestDetails theRequestDetails) {
        String sql = "SELECT d FROM TagDefinition d WHERE d.myId IN (SELECT DISTINCT t.myTagId FROM ResourceTag t)";
        TypedQuery q = this.myEntityManager.createQuery(sql, TagDefinition.class);
        List tagDefinitions = q.getResultList();
        MetaDt retVal = this.toMetaDt(tagDefinitions);
        return retVal;
    }

    protected MetaDt toMetaDt(Collection<TagDefinition> tagDefinitions) {
        MetaDt retVal = new MetaDt();
        for (TagDefinition next : tagDefinitions) {
            switch (next.getTagType()) {
                case PROFILE: {
                    retVal.addProfile(next.getCode());
                    break;
                }
                case SECURITY_LABEL: {
                    retVal.addSecurity().setSystem(next.getSystem()).setCode(next.getCode()).setDisplay(next.getDisplay());
                    break;
                }
                case TAG: {
                    retVal.addTag().setSystem(next.getSystem()).setCode(next.getCode()).setDisplay(next.getDisplay());
                }
            }
        }
        return retVal;
    }

    public IBaseBundle processMessage(RequestDetails theRequestDetails, IBaseBundle theMessage) {
        return JpaResourceDao.throwProcessMessageNotImplemented();
    }
}

