/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.model.PersistentIdToForcedIdMap;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.ResourceHistoryTable;
import ca.uhn.fhir.jpa.util.QueryParameterUtils;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.param.HistorySearchStyleEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HistoryBuilder {
    private static final Logger ourLog = LoggerFactory.getLogger(HistoryBuilder.class);
    private final String myResourceType;
    private final Long myResourceId;
    private final Date myRangeStartInclusive;
    private final Date myRangeEndInclusive;
    @Autowired
    protected IInterceptorBroadcaster myInterceptorBroadcaster;
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    private PartitionSettings myPartitionSettings;
    @Autowired
    private FhirContext myCtx;
    @Autowired
    private IIdHelperService myIdHelperService;

    public HistoryBuilder(@Nullable String theResourceType, @Nullable Long theResourceId, @Nullable Date theRangeStartInclusive, @Nullable Date theRangeEndInclusive) {
        this.myResourceType = theResourceType;
        this.myResourceId = theResourceId;
        this.myRangeStartInclusive = theRangeStartInclusive;
        this.myRangeEndInclusive = theRangeEndInclusive;
    }

    public Long fetchCount(RequestPartitionId thePartitionId) {
        CriteriaBuilder cb = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createQuery(Long.class);
        Root from = criteriaQuery.from(ResourceHistoryTable.class);
        criteriaQuery.select((Selection)cb.count((Expression)from));
        this.addPredicatesToQuery(cb, thePartitionId, criteriaQuery, (Root<ResourceHistoryTable>)from, null);
        TypedQuery query = this.myEntityManager.createQuery(criteriaQuery);
        return (Long)query.getSingleResult();
    }

    public List<ResourceHistoryTable> fetchEntities(RequestPartitionId thePartitionId, Integer theOffset, int theFromIndex, int theToIndex, HistorySearchStyleEnum theHistorySearchStyle) {
        CriteriaBuilder cb = this.myEntityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = cb.createQuery(ResourceHistoryTable.class);
        Root from = criteriaQuery.from(ResourceHistoryTable.class);
        this.addPredicatesToQuery(cb, thePartitionId, criteriaQuery, (Root<ResourceHistoryTable>)from, theHistorySearchStyle);
        from.fetch("myProvenance", JoinType.LEFT);
        criteriaQuery.orderBy(new Order[]{cb.desc((Expression)from.get("myUpdated"))});
        TypedQuery query = this.myEntityManager.createQuery(criteriaQuery);
        int startIndex = theFromIndex;
        if (theOffset != null) {
            startIndex += theOffset.intValue();
        }
        query.setFirstResult(startIndex);
        query.setMaxResults(theToIndex - theFromIndex);
        List tables = query.getResultList();
        if (tables.size() > 0) {
            ImmutableListMultimap resourceIdToHistoryEntries = Multimaps.index((Iterable)tables, ResourceHistoryTable::getResourceId);
            Set pids = resourceIdToHistoryEntries.keySet().stream().map(JpaPid::fromId).collect(Collectors.toSet());
            PersistentIdToForcedIdMap pidToForcedId = this.myIdHelperService.translatePidsToForcedIds(pids);
            ourLog.trace("Translated IDs: {}", (Object)pidToForcedId.getResourcePersistentIdOptionalMap());
            for (Long nextResourceId : resourceIdToHistoryEntries.keySet()) {
                ImmutableList historyTables = resourceIdToHistoryEntries.get((Object)nextResourceId);
                Optional forcedId = pidToForcedId.get((IResourcePersistentId)JpaPid.fromId((Long)nextResourceId));
                String resourceId = forcedId.isPresent() ? (String)forcedId.get() : nextResourceId.toString();
                for (ResourceHistoryTable nextHistoryTable : historyTables) {
                    nextHistoryTable.setTransientForcedId(resourceId);
                }
            }
        }
        return tables;
    }

    private void addPredicatesToQuery(CriteriaBuilder theCriteriaBuilder, RequestPartitionId thePartitionId, CriteriaQuery<?> theQuery, Root<ResourceHistoryTable> theFrom, HistorySearchStyleEnum theHistorySearchStyle) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!thePartitionId.isAllPartitions()) {
            if (thePartitionId.isDefaultPartition()) {
                predicates.add(theCriteriaBuilder.isNull(theFrom.get("myPartitionIdValue").as(Integer.class)));
            } else if (thePartitionId.hasDefaultPartitionId()) {
                predicates.add(theCriteriaBuilder.or((Expression)theCriteriaBuilder.isNull(theFrom.get("myPartitionIdValue").as(Integer.class)), (Expression)theFrom.get("myPartitionIdValue").as(Integer.class).in((Collection)thePartitionId.getPartitionIdsWithoutDefault())));
            } else {
                predicates.add(theFrom.get("myPartitionIdValue").as(Integer.class).in((Collection)thePartitionId.getPartitionIds()));
            }
        }
        if (this.myResourceId != null) {
            predicates.add(theCriteriaBuilder.equal((Expression)theFrom.get("myResourceId"), (Object)this.myResourceId));
        } else if (this.myResourceType != null) {
            this.validateNotSearchingAllPartitions(thePartitionId);
            predicates.add(theCriteriaBuilder.equal((Expression)theFrom.get("myResourceType"), (Object)this.myResourceType));
        } else {
            this.validateNotSearchingAllPartitions(thePartitionId);
        }
        if (this.myRangeStartInclusive != null) {
            if (HistorySearchStyleEnum.AT == theHistorySearchStyle && this.myResourceId != null) {
                this.addPredicateForAtQueryParameter(theCriteriaBuilder, theQuery, theFrom, predicates);
            } else {
                predicates.add(theCriteriaBuilder.greaterThanOrEqualTo(theFrom.get("myUpdated").as(Date.class), (Comparable)this.myRangeStartInclusive));
            }
        }
        if (this.myRangeEndInclusive != null) {
            predicates.add(theCriteriaBuilder.lessThanOrEqualTo(theFrom.get("myUpdated").as(Date.class), (Comparable)this.myRangeEndInclusive));
        }
        if (predicates.size() > 0) {
            theQuery.where(QueryParameterUtils.toPredicateArray(predicates));
        }
    }

    private void addPredicateForAtQueryParameter(CriteriaBuilder theCriteriaBuilder, CriteriaQuery<?> theQuery, Root<ResourceHistoryTable> theFrom, List<Predicate> thePredicates) {
        Subquery pastDateSubQuery = theQuery.subquery(Date.class);
        Root subQueryResourceHistory = pastDateSubQuery.from(ResourceHistoryTable.class);
        Expression myUpdatedMostRecent = theCriteriaBuilder.max((Expression)subQueryResourceHistory.get("myUpdated")).as(Date.class);
        Expression myUpdatedMostRecentOrDefault = theCriteriaBuilder.coalesce(myUpdatedMostRecent, theCriteriaBuilder.literal((Object)this.myRangeStartInclusive));
        pastDateSubQuery.select(myUpdatedMostRecentOrDefault).where(new Predicate[]{theCriteriaBuilder.lessThanOrEqualTo(subQueryResourceHistory.get("myUpdated").as(Date.class), (Comparable)this.myRangeStartInclusive), theCriteriaBuilder.equal((Expression)subQueryResourceHistory.get("myResourceId"), (Object)this.myResourceId)});
        Predicate updatedDatePredicate = theCriteriaBuilder.greaterThanOrEqualTo(theFrom.get("myUpdated").as(Date.class), (Expression)pastDateSubQuery);
        thePredicates.add(updatedDatePredicate);
    }

    private void validateNotSearchingAllPartitions(RequestPartitionId thePartitionId) {
        if (this.myPartitionSettings.isPartitioningEnabled() && thePartitionId.isAllPartitions()) {
            String msg = this.myCtx.getLocalizer().getMessage(HistoryBuilder.class, "noSystemOrTypeHistoryForPartitionAwareServer", new Object[0]);
            throw new InvalidRequestException(Msg.code((int)953) + msg);
        }
    }
}

