/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.TranslateConceptResults;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoConceptMap;
import ca.uhn.fhir.jpa.api.model.TranslationRequest;
import ca.uhn.fhir.jpa.dao.JpaResourceDao;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.term.api.ITermConceptMappingSvc;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import java.util.Date;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.ConceptMap;
import org.springframework.beans.factory.annotation.Autowired;

public class JpaResourceDaoConceptMap<T extends IBaseResource>
extends JpaResourceDao<T>
implements IFhirResourceDaoConceptMap<T> {
    @Autowired
    private ITermConceptMappingSvc myTermConceptMappingSvc;
    @Autowired
    private IValidationSupport myValidationSupport;
    @Autowired
    private VersionCanonicalizer myVersionCanonicalizer;

    public TranslateConceptResults translate(TranslationRequest theTranslationRequest, RequestDetails theRequestDetails) {
        IValidationSupport.TranslateCodeRequest translateCodeRequest = theTranslationRequest.asTranslateCodeRequest();
        return this.myValidationSupport.translateConcept(translateCodeRequest);
    }

    @Override
    public ResourceTable updateEntity(RequestDetails theRequestDetails, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        boolean shouldProcessUpdate;
        ResourceTable retVal = super.updateEntity(theRequestDetails, theResource, theEntity, theDeletedTimestampOrNull, thePerformIndexing, theUpdateVersion, theTransactionDetails, theForceUpdate, theCreateNewHistoryEntry);
        boolean entityWasSaved = !retVal.isUnchangedInCurrentOperation();
        boolean bl = shouldProcessUpdate = entityWasSaved && thePerformIndexing;
        if (shouldProcessUpdate) {
            if (retVal.getDeleted() == null) {
                ConceptMap conceptMap = this.myVersionCanonicalizer.conceptMapToCanonical(theResource);
                this.myTermConceptMappingSvc.storeTermConceptMapAndChildren(retVal, conceptMap);
            } else {
                this.myTermConceptMappingSvc.deleteConceptMapAndChildren(retVal);
            }
        }
        return retVal;
    }
}

