/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoObservation;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.ObservationLastNIndexPersistSvc;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.dao.JpaPid;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.param.ReferenceOrListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionTemplate;

public class JpaResourceDaoObservation<T extends IBaseResource>
extends BaseHapiFhirResourceDao<T>
implements IFhirResourceDaoObservation<T> {
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    protected EntityManager myEntityManager;
    @Autowired
    ObservationLastNIndexPersistSvc myObservationLastNIndexPersistSvc;
    @Autowired
    private IRequestPartitionHelperSvc myRequestPartitionHelperService;

    public IBundleProvider observationsLastN(SearchParameterMap theSearchParameterMap, RequestDetails theRequestDetails, HttpServletResponse theServletResponse) {
        this.updateSearchParamsForLastn(theSearchParameterMap, theRequestDetails);
        RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForSearchType(theRequestDetails, this.getResourceName(), theSearchParameterMap, null);
        return this.mySearchCoordinatorSvc.registerSearch((IFhirResourceDao)this, theSearchParameterMap, this.getResourceName(), new CacheControlDirective().parse(theRequestDetails.getHeaders("Cache-Control")), theRequestDetails, requestPartitionId);
    }

    private String getEffectiveParamName() {
        return "date";
    }

    private String getCodeParamName() {
        return "code";
    }

    private String getSubjectParamName() {
        return "subject";
    }

    private String getPatientParamName() {
        return "patient";
    }

    @Override
    public ResourceTable updateEntity(RequestDetails theRequest, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        return this.updateObservationEntity(theRequest, theResource, theEntity, theDeletedTimestampOrNull, thePerformIndexing, theUpdateVersion, theTransactionDetails, theForceUpdate, theCreateNewHistoryEntry);
    }

    protected ResourceTable updateObservationEntity(RequestDetails theRequest, IBaseResource theResource, IBasePersistedResource theEntity, Date theDeletedTimestampOrNull, boolean thePerformIndexing, boolean theUpdateVersion, TransactionDetails theTransactionDetails, boolean theForceUpdate, boolean theCreateNewHistoryEntry) {
        ResourceTable retVal = super.updateEntity(theRequest, theResource, theEntity, theDeletedTimestampOrNull, thePerformIndexing, theUpdateVersion, theTransactionDetails, theForceUpdate, theCreateNewHistoryEntry);
        if (this.getStorageSettings().isLastNEnabled() && !retVal.isUnchangedInCurrentOperation()) {
            if (retVal.getDeleted() == null) {
                this.myObservationLastNIndexPersistSvc.indexObservation(theResource);
            } else {
                this.myObservationLastNIndexPersistSvc.deleteObservationIndex(theEntity);
            }
        }
        return retVal;
    }

    protected void updateSearchParamsForLastn(SearchParameterMap theSearchParameterMap, RequestDetails theRequestDetails) {
        if (!this.isPagingProviderDatabaseBacked(theRequestDetails)) {
            theSearchParameterMap.setLoadSynchronous(true);
        }
        theSearchParameterMap.setLastN(true);
        SortSpec effectiveDtm = new SortSpec(this.getEffectiveParamName()).setOrder(SortOrderEnum.DESC);
        SortSpec observationCode = new SortSpec(this.getCodeParamName()).setOrder(SortOrderEnum.ASC).setChain(effectiveDtm);
        if (theSearchParameterMap.containsKey(this.getSubjectParamName()) || theSearchParameterMap.containsKey(this.getPatientParamName())) {
            new TransactionTemplate(this.myPlatformTransactionManager).executeWithoutResult(tx -> this.fixSubjectParamsOrderForLastn(theSearchParameterMap, theRequestDetails));
            theSearchParameterMap.setSort(new SortSpec(this.getSubjectParamName()).setOrder(SortOrderEnum.ASC).setChain(observationCode));
        } else {
            theSearchParameterMap.setSort(observationCode);
        }
    }

    private void fixSubjectParamsOrderForLastn(SearchParameterMap theSearchParameterMap, RequestDetails theRequestDetails) {
        TreeMap<Long, IQueryParameterType> orderedSubjectReferenceMap = new TreeMap<Long, IQueryParameterType>();
        if (theSearchParameterMap.containsKey(this.getSubjectParamName())) {
            RequestPartitionId requestPartitionId = this.myRequestPartitionHelperService.determineReadPartitionForRequestForSearchType(theRequestDetails, this.getResourceName(), theSearchParameterMap, null);
            ArrayList patientParams = new ArrayList();
            if (theSearchParameterMap.get(this.getPatientParamName()) != null) {
                patientParams.addAll(theSearchParameterMap.get(this.getPatientParamName()));
            }
            if (theSearchParameterMap.get(this.getSubjectParamName()) != null) {
                patientParams.addAll(theSearchParameterMap.get(this.getSubjectParamName()));
            }
            for (List nextPatientList : patientParams) {
                for (IQueryParameterType nextOr : nextPatientList) {
                    if (nextOr instanceof ReferenceParam) {
                        ReferenceParam ref = (ReferenceParam)nextOr;
                        JpaPid pid = (JpaPid)this.myIdHelperService.resolveResourcePersistentIds(requestPartitionId, ref.getResourceType(), ref.getIdPart());
                        orderedSubjectReferenceMap.put(pid.getId(), nextOr);
                        continue;
                    }
                    throw new IllegalArgumentException(Msg.code((int)942) + "Invalid token type (expecting ReferenceParam): " + nextOr.getClass());
                }
            }
            theSearchParameterMap.remove(this.getSubjectParamName());
            theSearchParameterMap.remove(this.getPatientParamName());
            ReferenceOrListParam orList = new ReferenceOrListParam();
            orderedSubjectReferenceMap.keySet().forEach(key -> orList.addOr((ReferenceParam)orderedSubjectReferenceMap.get(key)));
            theSearchParameterMap.add(this.getSubjectParamName(), (IQueryParameterOr)orList);
        }
    }
}

