/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDaoSearchParameter;
import ca.uhn.fhir.jpa.dao.BaseHapiFhirResourceDao;
import ca.uhn.fhir.jpa.dao.validation.SearchParameterDaoValidator;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.hapi.converters.canonical.VersionCanonicalizer;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.SearchParameter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JpaResourceDaoSearchParameter<T extends IBaseResource>
extends BaseHapiFhirResourceDao<T>
implements IFhirResourceDaoSearchParameter<T> {
    private final AtomicBoolean myCacheReloadTriggered = new AtomicBoolean(false);
    @Autowired
    private VersionCanonicalizer myVersionCanonicalizer;
    @Autowired
    private SearchParameterDaoValidator mySearchParameterDaoValidator;

    protected void reindexAffectedResources(T theResource, RequestDetails theRequestDetails) {
        if (!this.shouldSkipReindex(theRequestDetails) && !this.myCacheReloadTriggered.getAndSet(true)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    JpaResourceDaoSearchParameter.this.myCacheReloadTriggered.set(false);
                    JpaResourceDaoSearchParameter.this.mySearchParamRegistry.forceRefresh();
                }
            });
        }
        Boolean reindex = theResource != null ? (Boolean)CURRENTLY_REINDEXING.get(theResource) : null;
        SearchParameter searchParameter = this.myVersionCanonicalizer.searchParameterToCanonical(theResource);
        List base = theResource != null ? searchParameter.getBase().stream().map(Enumeration::getCode).collect(Collectors.toList()) : null;
        this.requestReindexForRelatedResources(reindex, base, theRequestDetails);
    }

    @Override
    protected void postPersist(ResourceTable theEntity, T theResource, RequestDetails theRequestDetails) {
        super.postPersist(theEntity, theResource, theRequestDetails);
        this.reindexAffectedResources(theResource, theRequestDetails);
    }

    @Override
    protected void postUpdate(ResourceTable theEntity, T theResource, RequestDetails theRequestDetails) {
        super.postUpdate(theEntity, theResource, theRequestDetails);
        this.reindexAffectedResources(theResource, theRequestDetails);
    }

    @Override
    protected void preDelete(T theResourceToDelete, ResourceTable theEntityToDelete, RequestDetails theRequestDetails) {
        super.preDelete(theResourceToDelete, theEntityToDelete, theRequestDetails);
        this.reindexAffectedResources(theResourceToDelete, theRequestDetails);
    }

    @Override
    protected void validateResourceForStorage(T theResource, ResourceTable theEntityToSave) {
        super.validateResourceForStorage(theResource, theEntityToSave);
        this.validateSearchParam((IBaseResource)theResource);
    }

    public void validateSearchParam(IBaseResource theResource) {
        SearchParameter searchParameter = this.myVersionCanonicalizer.searchParameterToCanonical(theResource);
        this.mySearchParameterDaoValidator.validate(searchParameter);
    }

    @VisibleForTesting
    void setVersionCanonicalizerForUnitTest(VersionCanonicalizer theVersionCanonicalizer) {
        this.myVersionCanonicalizer = theVersionCanonicalizer;
    }

    @VisibleForTesting
    public void setSearchParameterDaoValidatorForUnitTest(SearchParameterDaoValidator theSearchParameterDaoValidator) {
        this.mySearchParameterDaoValidator = theSearchParameterDaoValidator;
    }
}

