/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.jpa.dao.data.IHapiFhirJpaRepository;
import ca.uhn.fhir.jpa.entity.SearchResult;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ISearchResultDao
extends JpaRepository<SearchResult, Long>,
IHapiFhirJpaRepository {
    @Query(value="SELECT r.myResourcePid FROM SearchResult r WHERE r.mySearchPid = :search ORDER BY r.myOrder ASC")
    public Slice<Long> findWithSearchPid(@Param(value="search") Long var1, Pageable var2);

    @Query(value="SELECT r.myResourcePid FROM SearchResult r WHERE r.mySearchPid = :search")
    public List<Long> findWithSearchPidOrderIndependent(@Param(value="search") Long var1);

    @Modifying
    @Query(value="DELETE FROM SearchResult s WHERE s.mySearchPid IN :searchIds")
    @CanIgnoreReturnValue
    public int deleteBySearchIds(@Param(value="searchIds") Collection<Long> var1);

    @Modifying
    @Query(value="DELETE FROM SearchResult s WHERE s.mySearchPid = :searchId and s.myOrder >= :rangeStart and s.myOrder <= :rangeEnd")
    @CanIgnoreReturnValue
    public int deleteBySearchIdInRange(@Param(value="searchId") Long var1, @Param(value="rangeStart") int var2, @Param(value="rangeEnd") int var3);

    @Query(value="SELECT count(r) FROM SearchResult r WHERE r.mySearchPid = :search")
    public int countForSearch(@Param(value="search") Long var1);
}

