/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.data;

import ca.uhn.fhir.jpa.dao.data.IHapiFhirJpaRepository;
import ca.uhn.fhir.jpa.entity.TermCodeSystem;
import ca.uhn.fhir.jpa.entity.TermCodeSystemVersion;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ITermCodeSystemVersionDao
extends JpaRepository<TermCodeSystemVersion, Long>,
IHapiFhirJpaRepository {
    @Modifying
    @Query(value="DELETE FROM TermCodeSystemVersion csv WHERE csv.myCodeSystem = :cs")
    public void deleteForCodeSystem(@Param(value="cs") TermCodeSystem var1);

    @Query(value="SELECT myId FROM TermCodeSystemVersion WHERE myCodeSystemPid = :codesystem_pid order by myId")
    public List<Long> findSortedPidsByCodeSystemPid(@Param(value="codesystem_pid") Long var1);

    @Query(value="SELECT cs FROM TermCodeSystemVersion cs WHERE cs.myCodeSystemPid = :codesystem_pid AND cs.myCodeSystemVersionId = :codesystem_version_id")
    public TermCodeSystemVersion findByCodeSystemPidAndVersion(@Param(value="codesystem_pid") Long var1, @Param(value="codesystem_version_id") String var2);

    @Query(value="SELECT tcsv FROM TermCodeSystemVersion tcsv INNER JOIN FETCH TermCodeSystem tcs on tcs.myPid = tcsv.myCodeSystemPid WHERE tcs.myCodeSystemUri = :code_system_uri AND tcsv.myCodeSystemVersionId = :codesystem_version_id")
    public TermCodeSystemVersion findByCodeSystemUriAndVersion(@Param(value="code_system_uri") String var1, @Param(value="codesystem_version_id") String var2);

    @Query(value="SELECT cs FROM TermCodeSystemVersion cs WHERE cs.myCodeSystemPid = :codesystem_pid AND cs.myCodeSystemVersionId IS NULL")
    public TermCodeSystemVersion findByCodeSystemPidVersionIsNull(@Param(value="codesystem_pid") Long var1);

    @Query(value="SELECT cs FROM TermCodeSystemVersion cs WHERE cs.myResourcePid = :resource_id")
    public List<TermCodeSystemVersion> findByCodeSystemResourcePid(@Param(value="resource_id") Long var1);

    @Query(value="SELECT cs FROM TermCodeSystemVersion cs WHERE cs.myCodeSystemHavingThisVersionAsCurrentVersionIfAny.myResource.myId = :resource_id")
    public TermCodeSystemVersion findCurrentVersionForCodeSystemResourcePid(@Param(value="resource_id") Long var1);
}

